/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cache;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import sun.plugin.cache.Cache;
import sun.plugin.cache.CacheFile;
import sun.plugin.cache.FileCache;
import sun.plugin.cache.JarCache;
import sun.plugin.util.UserProfile;

public class CleanupThread
extends Thread {
    private boolean cleanupRequested = false;
    private Thread thisThread = null;
    private long timeToWait = 0L;
    private long prevCacheSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanCache() {
        int n;
        Object[] objectArray = this.getFilesInCache();
        int n2 = objectArray.length;
        long l = 0L;
        long l2 = 0L;
        for (n = 0; n < n2; ++n) {
            l2 += ((CacheFile)objectArray[n]).getSize();
        }
        l = Cache.deleteThresholdSize;
        n = 0;
        while (l2 > l && n < n2) {
            Cache.msgPrintln("cache.size", new Object[]{new Long(l2)});
            l2 -= ((CacheFile)objectArray[n++]).delete();
        }
        CleanupThread cleanupThread = this;
        synchronized (cleanupThread) {
            this.prevCacheSize = l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.thisThread = Thread.currentThread();
        try {
            while (true) {
                CleanupThread cleanupThread = this;
                synchronized (cleanupThread) {
                    if (this.cleanupRequested) {
                        this.cleanupRequested = false;
                        if (this.prevCacheSize > Cache.threadThresholdSize) {
                            Cache.msgPrintln("cache.cleanup", new Object[]{new Long(this.prevCacheSize).toString()});
                            this.cleanCache();
                        }
                    } else {
                        this.wait(this.timeToWait);
                        this.cleanupRequested = true;
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            this.thisThread = null;
            return;
        }
    }

    private void setCacheSize() {
        File file;
        File[] fileArray;
        long l = 0L;
        long l2 = 0L;
        File file2 = new File(UserProfile.getJarCacheDirectory());
        if (file2.exists()) {
            fileArray = file2.listFiles();
            l2 = 0L;
            for (int i = 0; i < fileArray.length; ++i) {
                l2 += fileArray[i].length();
            }
        }
        if ((file = new File(UserProfile.getFileCacheDirectory())).exists()) {
            fileArray = file.listFiles();
            l = 0L;
            for (int i = 0; i < fileArray.length; ++i) {
                l += fileArray[i].length();
            }
        }
        this.prevCacheSize = l + l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trigger() {
        if (this.thisThread != null) {
            CleanupThread cleanupThread = this;
            synchronized (cleanupThread) {
                this.cleanupRequested = true;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addedFile(long l) {
        CleanupThread cleanupThread = this;
        synchronized (cleanupThread) {
            this.prevCacheSize += l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addedJar(long l) {
        CleanupThread cleanupThread = this;
        synchronized (cleanupThread) {
            this.prevCacheSize += l;
        }
    }

    private Object[] getFilesInCache() {
        CacheFile cacheFile;
        String string;
        String string2;
        String string3;
        int n;
        HashMap<String, CacheFile> hashMap = new HashMap<String, CacheFile>();
        File[] fileArray = null;
        fileArray = FileCache.directory.listFiles();
        for (n = 0; n < fileArray.length; ++n) {
            string3 = fileArray[n].getName();
            string2 = Cache.getFileExtension(string3);
            string = string3.substring(0, string3.length() - string2.length()).toLowerCase();
            cacheFile = (CacheFile)hashMap.get(string);
            if (cacheFile == null) {
                cacheFile = new CacheFile(string);
                hashMap.put(string, cacheFile);
            }
            cacheFile.addFile(fileArray[n], string2);
        }
        fileArray = JarCache.directory.listFiles();
        for (n = 0; n < fileArray.length; ++n) {
            string3 = fileArray[n].getName();
            string2 = Cache.getFileExtension(string3);
            string = string3.substring(0, string3.length() - string2.length()).toLowerCase();
            cacheFile = (CacheFile)hashMap.get(string);
            if (cacheFile == null) {
                cacheFile = new CacheFile(string);
                hashMap.put(string, cacheFile);
            }
            cacheFile.addFile(fileArray[n], string2);
        }
        Object[] objectArray = hashMap.values().toArray();
        Arrays.sort(objectArray, new Comparator(this){
            private final CleanupThread this$0;
            {
                this.this$0 = cleanupThread;
            }

            public int compare(Object object, Object object2) {
                CacheFile cacheFile = (CacheFile)object;
                CacheFile cacheFile2 = (CacheFile)object2;
                if (cacheFile.before(cacheFile2)) {
                    return -1;
                }
                if (cacheFile2.before(cacheFile)) {
                    return 1;
                }
                return 0;
            }
        });
        return objectArray;
    }

    public CleanupThread(ThreadGroup threadGroup) {
        this(threadGroup, 600000L);
    }

    public CleanupThread(ThreadGroup threadGroup, long l) {
        super(threadGroup, "Cache Cleanup Thread");
        this.setPriority(4);
        this.timeToWait = l;
        this.setCacheSize();
    }
}

