/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.util.DefaultActionListener;
import sun.plugin.util.PluginSysAction;
import sun.plugin.util.PluginSysUtil;
import sun.plugin.util.PluginUIManager;
import sun.plugin.util.Trace;

public class DialogFactory {
    public static final int ERROR_MESSAGE = 1;
    public static final int INFORMATION_MESSAGE = 2;
    public static final int WARNING_MESSAGE = 3;
    public static final int QUESTION_MESSAGE = 4;
    public static final int PLAIN_MESSAGE = 5;
    private static String confirmDialogTitle;
    private static String inputDialogTitle;
    private static String messageDialogTitle;
    private static String exceptionDialogTitle;
    private static String optionDialogTitle;
    private static String aboutDialogTitle;
    private static String javaHomeLink;
    private static final String LEGAL_NOTE_BASE = "sun/plugin/util/legal";
    static final boolean $assertionsDisabled;
    static Class class$sun$plugin$util$DialogFactory;

    static {
        $assertionsDisabled = !(class$sun$plugin$util$DialogFactory == null ? (class$sun$plugin$util$DialogFactory = DialogFactory.class$("sun.plugin.util.DialogFactory")) : class$sun$plugin$util$DialogFactory).desiredAssertionStatus();
        confirmDialogTitle = ResourceHandler.getMessage("usability.confirmDialogTitle");
        inputDialogTitle = ResourceHandler.getMessage("usability.inputDialogTitle");
        messageDialogTitle = ResourceHandler.getMessage("usability.messageDialogTitle");
        exceptionDialogTitle = ResourceHandler.getMessage("usability.exceptionDialogTitle");
        optionDialogTitle = ResourceHandler.getMessage("usability.optionDialogTitle");
        aboutDialogTitle = ResourceHandler.getMessage("usability.aboutDialogTitle");
        javaHomeLink = ResourceHandler.getMessage("usability.java.home.link");
    }

    static void access$000() {
        DialogFactory.showAboutPluginDialogImpl();
    }

    public static void showAboutPluginDialog() {
        block2: {
            try {
                PluginSysUtil.execute(new PluginSysAction(){

                    public Object execute() throws Exception {
                        DialogFactory.access$000();
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    private static void showAboutPluginDialogImpl() {
        AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                LookAndFeel lookAndFeel = null;
                try {
                    lookAndFeel = PluginUIManager.setTheme();
                    JOptionPane jOptionPane = new JOptionPane();
                    jOptionPane.setMessageType(-1);
                    JButton jButton = new JButton(ResourceHandler.getMessage("about.option.close"));
                    jButton.setMnemonic(67);
                    jOptionPane.setOptions(new Object[]{jButton});
                    jOptionPane.setWantsInput(false);
                    jOptionPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
                    jOptionPane.setInitialValue(jButton);
                    jOptionPane.updateUI();
                    DialogFactory.access$300(jOptionPane, null, DialogFactory.access$100(), DialogFactory.access$200(), false);
                    Object var4_4 = null;
                    return var4_4;
                }
                finally {
                    PluginUIManager.restoreTheme(lookAndFeel);
                }
            }
        });
    }

    public static int showConfirmDialog(Object object) {
        return DialogFactory.showConfirmDialog(null, object, confirmDialogTitle);
    }

    static void access$1000(Object object) {
        DialogFactory.fixSwingLayoutBug(object);
    }

    private static void fixSwingLayoutBug(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof JTextArea) {
            JTextArea jTextArea = (JTextArea)object;
            jTextArea.getUI().getPreferredSize(jTextArea);
            return;
        }
        if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                DialogFactory.fixSwingLayoutBug(Array.get(object, i));
            }
        }
    }

    public static void showInformationDialog(Object object) {
        DialogFactory.showInformationDialog(null, object, messageDialogTitle);
    }

    static String access$100() {
        return aboutDialogTitle;
    }

    static void access$400(String string) {
        DialogFactory.launchLink(string);
    }

    private static native void launchLink(String var0);

    public static void showErrorDialog(String string) {
        DialogFactory.showErrorDialog(null, string, messageDialogTitle);
    }

    public static void showExceptionDialog(Throwable throwable) {
        DialogFactory.showExceptionDialog(null, throwable, throwable.toString(), exceptionDialogTitle);
    }

    public static Icon loadIcon() {
        Icon icon = null;
        try {
            icon = (Icon)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    URL uRL = ClassLoader.getSystemResource("sun/plugin/util/logo.png");
                    ImageIcon imageIcon = new ImageIcon(uRL);
                    return imageIcon;
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return icon;
    }

    static JPanel access$200() {
        return DialogFactory.createInfoPane();
    }

    private static JPanel createInfoPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setForeground(Color.WHITE);
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        try {
            URL uRL = ClassLoader.getSystemResource("sun/plugin/util/aboutjava.png");
            ImageIcon imageIcon = new ImageIcon(uRL);
            JLabel jLabel = new JLabel(imageIcon);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setForeground(Color.WHITE);
            jPanel2.setBackground(Color.WHITE);
            jPanel2.add((Component)jLabel, "Center");
            jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jPanel.add("North", jPanel2);
            int n = imageIcon.getIconWidth() - 8;
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 1));
            jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 8, 4, 8));
            jPanel3.setForeground(Color.WHITE);
            jPanel3.setBackground(Color.WHITE);
            String string = MessageFormat.format(ResourceHandler.getMessage("about.java.version"), System.getProperty("java.version"), System.getProperty("java.runtime.version")) + '\n' + ResourceHandler.getMessage("about.legal.note");
            JTextArea jTextArea = new JTextArea();
            jTextArea.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
            jTextArea.setEditable(false);
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setText(string);
            Font font = jTextArea.getFont();
            FontMetrics fontMetrics = jTextArea.getFontMetrics(font);
            int n2 = fontMetrics.stringWidth(ResourceHandler.getMessage("about.legal.note"));
            int n3 = n2 / (n - 8) + 2;
            jTextArea.setRows(n3);
            jPanel3.add(jTextArea);
            jPanel3.add(Box.createVerticalStrut(30));
            String string2 = ResourceHandler.getMessage("about.prompt.info");
            String string3 = ResourceHandler.getMessage("about.home.link");
            String string4 = "<font face=" + font.getFamily() + " size=-1>" + string2 + " <a style='color:blue' href=" + string3 + '>' + string3 + "</a></font>";
            JEditorPane jEditorPane = new JEditorPane("text/html", string4);
            Insets insets = jEditorPane.getMargin();
            fontMetrics = jEditorPane.getFontMetrics(font);
            n2 = fontMetrics.stringWidth(string2 + ' ' + string3);
            n3 = n2 / (n - insets.left - insets.right) + 1;
            Dimension dimension = new Dimension(n, n3 * (fontMetrics.getHeight() + fontMetrics.getMaxDescent()) + insets.top + insets.bottom);
            jEditorPane.setPreferredSize(dimension);
            jEditorPane.setEditable(false);
            jEditorPane.addHyperlinkListener(new HyperlinkListener(jEditorPane, string4){
                private final JEditorPane val$editPane;
                private final String val$text;

                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        DialogFactory.access$400(hyperlinkEvent.getURL().toString());
                    } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                        this.val$editPane.setText(this.val$text.replaceFirst("'color:blue'", "'color:red'"));
                    } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
                        this.val$editPane.setText(this.val$text);
                    }
                }
                {
                    this.val$editPane = jEditorPane;
                    this.val$text = string;
                }
            });
            jPanel3.add(jEditorPane);
            jPanel.add((Component)jPanel3, "Center");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jPanel;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public static int showConfirmDialog(Component component, Object object) {
        return DialogFactory.showConfirmDialog(component, object, confirmDialogTitle);
    }

    public static void showInformationDialog(Component component, Object object) {
        DialogFactory.showInformationDialog(component, object, messageDialogTitle);
    }

    public static void showErrorDialog(Component component, String string) {
        DialogFactory.showErrorDialog(component, string, messageDialogTitle);
    }

    private static void showMessageDialog(int n, Object object, String string, boolean bl) {
        DialogFactory.showMessageDialog(null, n, object, string, bl);
    }

    public static String showInputDialog(Object object) {
        return DialogFactory.showInputDialog(null, object, inputDialogTitle);
    }

    public static int showConfirmDialog(Object object, String string) {
        return DialogFactory.showConfirmDialog(null, object, string);
    }

    public static void showInformationDialog(Object object, String string) {
        DialogFactory.showInformationDialog(null, object, string);
    }

    public static void showErrorDialog(String string, String string2) {
        DialogFactory.showErrorDialog(null, string, string2);
    }

    public static void showExceptionDialog(Throwable throwable, String string) {
        DialogFactory.showExceptionDialog(throwable, string, exceptionDialogTitle);
    }

    public static void showExceptionDialog(Component component, Throwable throwable) {
        DialogFactory.showExceptionDialog(component, throwable, throwable.toString(), exceptionDialogTitle);
    }

    private static Object extractMessage(JOptionPane jOptionPane, Object object) {
        if (object instanceof Object[]) {
            return DialogFactory.extractMessage(jOptionPane, (Object[])object);
        }
        if (object instanceof String) {
            return DialogFactory.extractMessage(jOptionPane, (String)object);
        }
        if (object instanceof Exception) {
            return DialogFactory.extractMessage(jOptionPane, (Exception)object);
        }
        return object;
    }

    private static Object extractMessage(JOptionPane jOptionPane, Object[] objectArray) {
        Object[] objectArray2 = null;
        if (objectArray != null) {
            objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = DialogFactory.extractMessage(jOptionPane, objectArray[i]);
            }
        }
        return objectArray2;
    }

    private static Object extractMessage(JOptionPane jOptionPane, String string) {
        return DialogFactory.formatStringMessage(jOptionPane, string);
    }

    private static Object formatStringMessage(JOptionPane jOptionPane, String string) {
        int n;
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (string == null) {
            string = "null";
        }
        if ((n = string.indexOf("</html>")) == -1) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setColumns(40);
            jTextArea.setAutoscrolls(true);
            jTextArea.setEditable(false);
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setBackground(jOptionPane.getBackground());
            jTextArea.setText(string);
            return jTextArea;
        }
        if (n + 7 == string.length()) {
            return new JLabel(string);
        }
        Object[] objectArray = new Object[]{new JLabel(string.substring(0, n + 7)), DialogFactory.formatStringMessage(jOptionPane, string.substring(n + 7))};
        return objectArray;
    }

    private static Object extractMessage(JOptionPane jOptionPane, Throwable throwable) {
        return DialogFactory.formatExceptionMessage(jOptionPane, throwable);
    }

    private static Object formatExceptionMessage(JOptionPane jOptionPane, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        JTextArea jTextArea = new JTextArea("" + stringWriter.toString());
        jTextArea.setColumns(40);
        jTextArea.setRows(10);
        jTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jTextArea.setBackground(jOptionPane.getBackground());
        return jScrollPane;
    }

    static void access$800(Component component, int n, Object object, String string, boolean bl) {
        DialogFactory.showMessageDialogImpl(component, n, object, string, bl);
    }

    private static void showMessageDialog(Component component, int n, Object object, String string, boolean bl) {
        block2: {
            try {
                PluginSysUtil.execute(new PluginSysAction(component, n, object, string, bl){
                    private final Component val$parentComponent;
                    private final int val$messageType;
                    private final Object val$message;
                    private final String val$title;
                    private final boolean val$fModal;

                    public Object execute() throws Exception {
                        DialogFactory.access$800(this.val$parentComponent, this.val$messageType, this.val$message, this.val$title, this.val$fModal);
                        return null;
                    }
                    {
                        this.val$parentComponent = component;
                        this.val$messageType = n;
                        this.val$message = object;
                        this.val$title = string;
                        this.val$fModal = bl;
                    }
                });
            }
            catch (Exception exception) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void showMessageDialogImpl(Component component, int n, Object object, String string, boolean bl) {
        LookAndFeel lookAndFeel = null;
        try {
            lookAndFeel = PluginUIManager.setTheme();
            JOptionPane jOptionPane = new JOptionPane();
            switch (n) {
                case 1: {
                    jOptionPane.setMessageType(0);
                    break;
                }
                case 2: {
                    jOptionPane.setMessageType(1);
                    break;
                }
                case 3: {
                    jOptionPane.setMessageType(2);
                    break;
                }
                case 4: {
                    jOptionPane.setMessageType(3);
                    break;
                }
            }
            jOptionPane.setOptionType(-1);
            jOptionPane.setWantsInput(false);
            Object object2 = DialogFactory.extractMessage(jOptionPane, object);
            if (string == null) {
                string = messageDialogTitle;
            }
            DialogFactory.showDialog(jOptionPane, component, string, object2, bl);
        }
        finally {
            PluginUIManager.restoreTheme(lookAndFeel);
        }
    }

    public static String showInputDialog(Component component, Object object) {
        return DialogFactory.showInputDialog(component, object, inputDialogTitle);
    }

    static int access$500(Component component, Object object, String string) {
        return DialogFactory.showConfirmDialogImpl(component, object, string);
    }

    public static int showConfirmDialog(Component component, Object object, String string) {
        try {
            return (Integer)PluginSysUtil.execute(new PluginSysAction(component, object, string){
                private final Component val$parentComponent;
                private final Object val$message;
                private final String val$title;

                public Object execute() throws Exception {
                    return new Integer(DialogFactory.access$500(this.val$parentComponent, this.val$message, this.val$title));
                }
                {
                    this.val$parentComponent = component;
                    this.val$message = object;
                    this.val$title = string;
                }
            });
        }
        catch (Exception exception) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int showConfirmDialogImpl(Component component, Object object, String string) {
        LookAndFeel lookAndFeel = null;
        try {
            lookAndFeel = PluginUIManager.setTheme();
            JButton jButton = new JButton(ResourceHandler.getMessage("usability.confirm.yes"));
            JButton jButton2 = new JButton(ResourceHandler.getMessage("usability.confirm.no"));
            jButton.setMnemonic(ResourceHandler.getAcceleratorKey("usability.confirm.yes"));
            jButton2.setMnemonic(ResourceHandler.getAcceleratorKey("usability.confirm.no"));
            Object[] objectArray = new Object[]{jButton, jButton2};
            if (string == null) {
                string = confirmDialogTitle;
            }
            int n = DialogFactory.showOptionDialog(component, 4, object, string, objectArray, objectArray[0]);
            return n;
        }
        finally {
            PluginUIManager.restoreTheme(lookAndFeel);
        }
    }

    public static void showInformationDialog(Component component, Object object, String string) {
        DialogFactory.showMessageDialog(component, 2, object, string, true);
    }

    public static void showErrorDialog(Component component, String string, String string2) {
        DialogFactory.showMessageDialog(component, 1, string, string2, true);
    }

    public static String showInputDialog(Object object, String string) {
        return DialogFactory.showInputDialog(null, object, string);
    }

    public static void showExceptionDialog(Throwable throwable, String string, String string2) {
        DialogFactory.showExceptionDialog(null, throwable, string, string2);
    }

    public static void showExceptionDialog(Component component, Throwable throwable, String string) {
        DialogFactory.showExceptionDialog(component, throwable, string, exceptionDialogTitle);
    }

    public static int showOptionDialog(int n, Object object, String string, Object[] objectArray, Object object2) {
        return DialogFactory.showOptionDialog(null, n, object, string, objectArray, object2);
    }

    public static void preLoadDialog(int n, Object object, String string, Object[] objectArray, Object object2) {
        DialogFactory.showOptionDialogImpl(null, n, object, string, objectArray, objectArray[0], true);
    }

    public static int showOptionDialog(Object object, String string, Object[] objectArray, Object object2) {
        return DialogFactory.showOptionDialog(null, object, string, objectArray, object2);
    }

    private static boolean showDialog(JOptionPane jOptionPane, Component component, String string, Object object) {
        return DialogFactory.showDialog(jOptionPane, component, string, object, true, false);
    }

    static boolean access$300(JOptionPane jOptionPane, Component component, String string, Object object, boolean bl) {
        return DialogFactory.showDialog(jOptionPane, component, string, object, bl);
    }

    private static boolean showDialog(JOptionPane jOptionPane, Component component, String string, Object object, boolean bl) {
        return DialogFactory.showDialog(jOptionPane, component, string, object, bl, false);
    }

    private static boolean showDialog(JOptionPane jOptionPane, Component component, String string, Object object, boolean bl, boolean bl2) {
        boolean bl3 = true;
        try {
            jOptionPane.setValue(null);
            Runnable runnable = new Runnable(jOptionPane, component, string, object, bl, bl2){
                private final JOptionPane val$pane;
                private final Component val$parentComponent;
                private final String val$title;
                private final Object val$msg;
                private final boolean val$fModal;
                private final boolean val$preload;

                public void run() {
                    Serializable serializable;
                    Object object;
                    JDialog jDialog = this.val$pane.createDialog(this.val$parentComponent, this.val$title);
                    Object[] objectArray = this.val$pane.getOptions();
                    if (null != objectArray) {
                        object = new DefaultActionListener(jDialog, this.val$pane);
                        for (int i = 0; i < objectArray.length; ++i) {
                            if (!(objectArray[i] instanceof JButton)) continue;
                            serializable = (JButton)objectArray[i];
                            ActionListener[] actionListenerArray = ((AbstractButton)serializable).getActionListeners();
                            for (int j = 0; j < actionListenerArray.length; ++j) {
                                if (!(actionListenerArray[j] instanceof DefaultActionListener)) continue;
                                ((AbstractButton)serializable).removeActionListener((DefaultActionListener)actionListenerArray[j]);
                            }
                            if (((AbstractButton)serializable).getActionListeners().length != 0) continue;
                            ((AbstractButton)serializable).addActionListener((ActionListener)object);
                        }
                    }
                    this.val$pane.setMessage(this.val$msg);
                    jDialog.pack();
                    DialogFactory.access$1000(this.val$msg);
                    jDialog.pack();
                    jDialog.setResizable(false);
                    jDialog.setModal(this.val$fModal);
                    object = jDialog.getSize();
                    serializable = Toolkit.getDefaultToolkit().getScreenSize();
                    ((Dimension)object).width += 30;
                    jDialog.setLocation((((Dimension)serializable).width - ((Dimension)object).width) / 2, (((Dimension)serializable).height - ((Dimension)object).height) / 2);
                    if (!this.val$preload) {
                        jDialog.show();
                        jDialog.pack();
                        jDialog.toFront();
                    }
                }
                {
                    this.val$pane = jOptionPane;
                    this.val$parentComponent = component;
                    this.val$title = string;
                    this.val$msg = object;
                    this.val$fModal = bl;
                    this.val$preload = bl2;
                }
            };
            if (bl2 || SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else if (bl) {
                SwingUtilities.invokeAndWait(runnable);
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl3 = false;
        }
        return bl3;
    }

    static String access$700(Component component, Object object, String string) {
        return DialogFactory.showInputDialogImpl(component, object, string);
    }

    public static String showInputDialog(Component component, Object object, String string) {
        try {
            return (String)PluginSysUtil.execute(new PluginSysAction(component, object, string){
                private final Component val$parentComponent;
                private final Object val$message;
                private final String val$title;

                public Object execute() throws Exception {
                    return DialogFactory.access$700(this.val$parentComponent, this.val$message, this.val$title);
                }
                {
                    this.val$parentComponent = component;
                    this.val$message = object;
                    this.val$title = string;
                }
            });
        }
        catch (Exception exception) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String showInputDialogImpl(Component component, Object object, String string) {
        LookAndFeel lookAndFeel = null;
        try {
            Object object2;
            lookAndFeel = PluginUIManager.setTheme();
            Object object3 = null;
            JOptionPane jOptionPane = new JOptionPane();
            jOptionPane.setMessageType(3);
            jOptionPane.setOptionType(2);
            jOptionPane.setWantsInput(true);
            Object object4 = DialogFactory.extractMessage(jOptionPane, object);
            if (string == null) {
                string = inputDialogTitle;
            }
            if (DialogFactory.showDialog(jOptionPane, component, string, object4) && (object2 = jOptionPane.getInputValue()) != null) {
                if (object2 instanceof String) {
                    object3 = object2.toString();
                }
                Trace.msgPrintln("dialogfactory.user.typed", new Object[]{object3});
            }
            object2 = object3;
            return object2;
        }
        finally {
            PluginUIManager.restoreTheme(lookAndFeel);
        }
    }

    static void access$900(Component component, Throwable throwable, String string, String string2) {
        DialogFactory.showExceptionDialogImpl(component, throwable, string, string2);
    }

    public static void showExceptionDialog(Component component, Throwable throwable, String string, String string2) {
        block2: {
            try {
                PluginSysUtil.execute(new PluginSysAction(component, throwable, string, string2){
                    private final Component val$parentComponent;
                    private final Throwable val$e;
                    private final String val$message;
                    private final String val$title;

                    public Object execute() throws Exception {
                        DialogFactory.access$900(this.val$parentComponent, this.val$e, this.val$message, this.val$title);
                        return null;
                    }
                    {
                        this.val$parentComponent = component;
                        this.val$e = throwable;
                        this.val$message = string;
                        this.val$title = string2;
                    }
                });
            }
            catch (Exception exception) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void showExceptionDialogImpl(Component component, Throwable throwable, String string, String string2) {
        LookAndFeel lookAndFeel = null;
        try {
            lookAndFeel = PluginUIManager.setTheme();
            JOptionPane jOptionPane = new JOptionPane();
            jOptionPane.setMessageType(0);
            jOptionPane.setOptionType(-1);
            jOptionPane.setWantsInput(false);
            Component component2 = (Component)DialogFactory.extractMessage(jOptionPane, throwable);
            JPanel jPanel = new JPanel();
            JButton jButton = new JButton(ResourceHandler.getMessage("usability.moreInfo"));
            jButton.setMnemonic(ResourceHandler.getAcceleratorKey("usability.moreInfo"));
            jPanel.setLayout(new FlowLayout(2));
            jPanel.add(jButton);
            JPanel jPanel2 = new JPanel();
            JButton jButton2 = new JButton(ResourceHandler.getMessage("usability.lessInfo"));
            jButton2.setMnemonic(ResourceHandler.getAcceleratorKey("usability.lessInfo"));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new FlowLayout(2));
            jPanel3.add(jButton2);
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)jPanel3, "Center");
            jPanel2.add(component2, "South");
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BorderLayout());
            jPanel4.add((Component)jPanel, "Center");
            jButton.addActionListener(new ActionListener(jPanel4, jPanel, jPanel2){
                private final JPanel val$containerPanel;
                private final JPanel val$morePanel;
                private final JPanel val$lessPanel;

                public void actionPerformed(ActionEvent actionEvent) {
                    Component component = (Component)actionEvent.getSource();
                    Dialog dialog = null;
                    while (component.getParent() != null) {
                        if (component instanceof JDialog) {
                            dialog = (JDialog)component;
                        }
                        component = component.getParent();
                    }
                    if (dialog != null) {
                        dialog.setVisible(false);
                        dialog.setResizable(true);
                        this.val$containerPanel.remove(this.val$morePanel);
                        this.val$containerPanel.add((Component)this.val$lessPanel, "Center");
                        dialog.doLayout();
                        dialog.pack();
                        dialog.setResizable(false);
                        dialog.setVisible(true);
                    }
                }
                {
                    this.val$containerPanel = jPanel;
                    this.val$morePanel = jPanel2;
                    this.val$lessPanel = jPanel3;
                }
            });
            jButton2.addActionListener(new ActionListener(jPanel4, jPanel2, jPanel){
                private final JPanel val$containerPanel;
                private final JPanel val$lessPanel;
                private final JPanel val$morePanel;

                public void actionPerformed(ActionEvent actionEvent) {
                    Component component = (Component)actionEvent.getSource();
                    Dialog dialog = null;
                    while (component.getParent() != null) {
                        if (component instanceof JDialog) {
                            dialog = (JDialog)component;
                        }
                        component = component.getParent();
                    }
                    if (dialog != null) {
                        dialog.setVisible(false);
                        dialog.setResizable(true);
                        this.val$containerPanel.remove(this.val$lessPanel);
                        this.val$containerPanel.add((Component)this.val$morePanel, "Center");
                        dialog.doLayout();
                        dialog.pack();
                        dialog.setResizable(false);
                        dialog.setVisible(true);
                    }
                }
                {
                    this.val$containerPanel = jPanel;
                    this.val$lessPanel = jPanel2;
                    this.val$morePanel = jPanel3;
                }
            });
            Object[] objectArray = new Object[]{DialogFactory.extractMessage(jOptionPane, string), jPanel4};
            if (string2 == null) {
                string2 = exceptionDialogTitle;
            }
            DialogFactory.showDialog(jOptionPane, component, string2, objectArray);
        }
        finally {
            PluginUIManager.restoreTheme(lookAndFeel);
        }
    }

    public static int showOptionDialog(Component component, int n, Object object, String string, Object[] objectArray, Object object2) {
        try {
            return (Integer)PluginSysUtil.execute(new PluginSysAction(component, n, object, string, objectArray, object2){
                private final Component val$parentComponent;
                private final int val$messageType;
                private final Object val$message;
                private final String val$title;
                private final Object[] val$options;
                private final Object val$initValue;

                public Object execute() throws Exception {
                    return new Integer(DialogFactory.access$600(this.val$parentComponent, this.val$messageType, this.val$message, this.val$title, this.val$options, this.val$initValue, false));
                }
                {
                    this.val$parentComponent = component;
                    this.val$messageType = n;
                    this.val$message = object;
                    this.val$title = string;
                    this.val$options = objectArray;
                    this.val$initValue = object2;
                }
            });
        }
        catch (Exception exception) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return 0;
        }
    }

    static int access$600(Component component, int n, Object object, String string, Object[] objectArray, Object object2, boolean bl) {
        return DialogFactory.showOptionDialogImpl(component, n, object, string, objectArray, object2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int showOptionDialogImpl(Component component, int n, Object object, String string, Object[] objectArray, Object object2, boolean bl) {
        LookAndFeel lookAndFeel = null;
        try {
            Object object3;
            lookAndFeel = PluginUIManager.setTheme();
            int n2 = -1;
            JOptionPane jOptionPane = new JOptionPane();
            switch (n) {
                case 1: {
                    jOptionPane.setMessageType(0);
                    break;
                }
                case 2: {
                    jOptionPane.setMessageType(1);
                    break;
                }
                case 3: {
                    jOptionPane.setMessageType(2);
                    break;
                }
                case 4: {
                    jOptionPane.setMessageType(3);
                    break;
                }
            }
            jOptionPane.setOptions(objectArray);
            jOptionPane.setInitialValue(object2);
            jOptionPane.setWantsInput(false);
            Object object4 = DialogFactory.extractMessage(jOptionPane, object);
            if (string == null) {
                string = optionDialogTitle;
            }
            if (DialogFactory.showDialog(jOptionPane, component, string, object4, true, bl) && (object3 = jOptionPane.getValue()) != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!objectArray[i].equals(object3)) continue;
                    n2 = i;
                    break;
                }
                Trace.msgPrintln("dialogfactory.user.selected", new Object[]{new Integer(n2)});
            }
            int n3 = n2;
            return n3;
        }
        finally {
            PluginUIManager.restoreTheme(lookAndFeel);
        }
    }

    public static int showOptionDialog(Component component, Object object, String string, Object[] objectArray, Object object2) {
        return DialogFactory.showOptionDialog(component, 5, object, string, objectArray, object2);
    }
}

