/*
 * Decompiled with CFR 0.152.
 */
package com.imagedecoder;

import com.imagedecoder.codec.SeekableStream;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.IOException;

public class ImageHotspots {
    protected int inWidth;
    protected int inHeight;
    protected int outWidth;
    protected int outHeight;
    protected int dispWidth;
    protected int dispHeight;
    protected int offsetx;
    protected int offsety;
    protected int Shape = 1;
    protected int PickWidth = 2;
    protected int MoveWidth = 2;
    protected int nHotspots = 0;
    protected Rectangle[] HotspotRect = null;
    protected Rectangle[] ScaledHotspotRect = null;
    protected String[] HotspotKey = null;
    protected String[] HotspotSim = null;
    protected byte[] HotspotKennzeichen = null;
    private boolean isBigEndian = false;
    protected Color PickColor;
    protected Color MoveColor;
    protected Color XorColor;
    protected String selectHsStr = "";
    protected int activeHsNr = -1;

    void ReadHotspots(int n, SeekableStream seekableStream, boolean bl) {
        this.nHotspots = n;
        this.isBigEndian = bl;
        this.HotspotRect = new Rectangle[n];
        this.HotspotKey = new String[n];
        this.HotspotSim = new String[n];
        this.HotspotKennzeichen = new byte[n];
        this.ScaledHotspotRect = new Rectangle[n];
        for (int i = 0; i < n; ++i) {
            this.ReadHotspot(i, seekableStream);
        }
    }

    void ReadHotspot(int n, SeekableStream seekableStream) {
        try {
            int n2;
            int n3;
            int n4 = this.readUnsignedShort(seekableStream);
            int n5 = this.readUnsignedShort(seekableStream);
            int n6 = this.readUnsignedShort(seekableStream);
            int n7 = this.readUnsignedShort(seekableStream);
            int n8 = this.readUnsignedShort(seekableStream);
            this.HotspotRect[n] = new Rectangle(n5, n6, n7, n8);
            byte[] byArray = new byte[35];
            byArray[0] = 0;
            byte[] byArray2 = new byte[28];
            byArray2[0] = 0;
            byte by = seekableStream.readByte();
            if (by > 33 || by < 0) {
                by = 0;
            }
            if (by > 0) {
                for (n3 = 0; n3 < by; ++n3) {
                    byArray[n3] = seekableStream.readByte();
                }
                byArray[by] = 0;
            }
            if ((n3 = seekableStream.readByte()) > 26 || n3 < 0) {
                n3 = 0;
            }
            if (n3 > 0) {
                for (n2 = 0; n2 < n3; ++n2) {
                    byArray2[n2] = seekableStream.readByte();
                }
                byArray2[n3] = 0;
            }
            this.HotspotKey[n] = new String(byArray, 0, (int)by);
            this.HotspotSim[n] = new String(byArray2, 0, n3);
            n2 = seekableStream.readByte();
            this.HotspotKennzeichen[n] = n2 = (int)((byte)(n2 & 3));
            seekableStream.readByte();
            System.out.println("Hotspot " + Integer.toString(n) + ": Key " + this.HotspotKey[n] + " | " + Integer.toString(this.HotspotRect[n].x) + "," + Integer.toString(this.HotspotRect[n].y) + "," + Integer.toString(this.HotspotRect[n].width) + "," + Integer.toString(this.HotspotRect[n].height));
        }
        catch (IOException iOException) {
            System.out.println("IO Exception " + iOException.getMessage());
        }
    }

    public void setCurrentSize(int n, int n2, int n3, int n4) {
        this.outWidth = n;
        this.outHeight = n2;
        this.dispWidth = n3;
        this.dispHeight = n4;
        this.offsetx = (this.dispWidth - this.outWidth) / 2;
        this.offsety = (this.dispHeight - this.outHeight) / 2;
        if (this.inWidth == 0 || this.inHeight == 0) {
            return;
        }
        double d = (double)this.outWidth / (double)this.inWidth;
        double d2 = (double)this.outHeight / (double)this.inHeight;
        for (int i = 0; i < this.nHotspots; ++i) {
            int n5 = (int)((double)this.HotspotRect[i].x * d + 0.5);
            int n6 = (int)((double)this.HotspotRect[i].y * d2 + 0.5);
            int n7 = (int)((double)this.HotspotRect[i].width * d + 0.5);
            int n8 = (int)((double)this.HotspotRect[i].height * d2 + 0.5);
            this.ScaledHotspotRect[i] = new Rectangle(n5, n6, n7, n8);
        }
    }

    public void setImageSize(int n, int n2) {
        this.inWidth = n;
        this.inHeight = n2;
    }

    public void setShapeAndColors(int n, Color color, Color color2, Color color3) {
        this.Shape = n;
        this.PickColor = color;
        this.MoveColor = color2;
        this.XorColor = color3;
    }

    public void drawHotspots(Graphics graphics) {
        int n;
        Color color = graphics.getColor();
        graphics.setColor(this.PickColor);
        for (n = 0; n < this.nHotspots; ++n) {
            if (!this.HotspotKey[n].equals(this.selectHsStr)) continue;
            this.drawHotspot(graphics, this.ScaledHotspotRect[n], this.PickWidth, false);
        }
        graphics.setColor(color);
        for (n = 0; n < this.nHotspots; ++n) {
            if (n != this.activeHsNr) continue;
            if (this.HotspotKey[n].equals(this.selectHsStr)) {
                graphics.setXORMode(this.XorColor);
            } else {
                graphics.setXORMode(this.MoveColor);
            }
            this.drawHotspot(graphics, this.ScaledHotspotRect[n], this.MoveWidth, true);
            graphics.setPaintMode();
        }
    }

    void drawHotspot(Graphics graphics, Rectangle rectangle, int n, boolean bl) {
        Rectangle rectangle2 = rectangle;
        if (this.outWidth < 300 && this.outHeight < 300) {
            n = 1;
        }
        for (int i = 0; i < n; ++i) {
            if (this.Shape == 0) {
                graphics.drawRect(rectangle2.x + this.offsetx, rectangle2.y + this.offsety, rectangle2.width, rectangle2.height);
            } else if (this.Shape == 1) {
                int n2 = rectangle2.width;
                int n3 = rectangle2.height;
                int n4 = rectangle2.x + this.offsetx + n2 / 2;
                int n5 = rectangle2.y + this.offsety + n3 / 2;
                int n6 = (n2 + n3) / 2;
                int n7 = n6 / 2;
                graphics.drawOval(n4 - n7, n5 - n7, n6, n6);
            } else if (this.Shape == 2) {
                graphics.drawOval(rectangle2.x + this.offsetx, rectangle2.y + this.offsety, rectangle2.width, rectangle2.height);
            }
            if (i >= n - 1) continue;
            rectangle2 = this.RectInflate(rectangle2);
        }
    }

    public Rectangle RectInflate(Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        return new Rectangle(--n, --n2, n3 += 2, n4 += 2);
    }

    public boolean mouseMove(int n, int n2, Graphics graphics) {
        int n3;
        int n4 = this.activeHsNr;
        this.activeHsNr = this.ActiveHotspot(n, n2);
        if (n4 == this.activeHsNr) {
            return false;
        }
        if (n4 != -1) {
            if (this.HotspotKey[n4].equals(this.selectHsStr)) {
                graphics.setXORMode(this.XorColor);
            } else {
                graphics.setXORMode(this.MoveColor);
            }
            n3 = n4;
            this.drawHotspot(graphics, this.ScaledHotspotRect[n3], this.MoveWidth, true);
            graphics.setPaintMode();
        }
        if (this.activeHsNr != -1) {
            if (this.HotspotKey[this.activeHsNr].equals(this.selectHsStr)) {
                graphics.setXORMode(this.XorColor);
            } else {
                graphics.setXORMode(this.MoveColor);
            }
            n3 = this.activeHsNr;
            this.drawHotspot(graphics, this.ScaledHotspotRect[n3], this.MoveWidth, true);
            graphics.setPaintMode();
        }
        return true;
    }

    public boolean mouseExited(int n, int n2, Graphics graphics) {
        int n3 = this.activeHsNr;
        this.activeHsNr = -1;
        if (n3 == this.activeHsNr) {
            return false;
        }
        if (n3 != -1) {
            if (this.HotspotKey[n3].equals(this.selectHsStr)) {
                graphics.setXORMode(this.XorColor);
            } else {
                graphics.setXORMode(this.MoveColor);
            }
            int n4 = n3;
            this.drawHotspot(graphics, this.ScaledHotspotRect[n4], this.MoveWidth, true);
            graphics.setPaintMode();
        }
        return true;
    }

    public boolean setHotspot(String string, Applet applet) {
        if (this.selectHsStr == string) {
            return false;
        }
        String string2 = this.selectHsStr;
        this.selectHsStr = string;
        if (!string2.equals("")) {
            this.repaint(string2, applet);
        }
        if (!this.selectHsStr.equals("")) {
            this.repaint(this.selectHsStr, applet);
        }
        return true;
    }

    public boolean mouseClicked(int n, int n2, Graphics graphics, Applet applet) {
        String string = this.selectHsStr;
        int n3 = this.ActiveHotspot(n, n2);
        this.selectHsStr = n3 == -1 ? "" : this.HotspotKey[n3];
        if (string.equals(this.selectHsStr)) {
            return false;
        }
        if (!string.equals("")) {
            this.repaint(string, applet);
        }
        if (!this.selectHsStr.equals("")) {
            this.repaint(this.selectHsStr, applet);
        }
        return true;
    }

    public void repaint(String string, Applet applet) {
        for (int i = 0; i < this.nHotspots; ++i) {
            int n;
            int n2;
            if (!this.HotspotKey[i].equals(string)) continue;
            int n3 = this.ScaledHotspotRect[i].x;
            int n4 = this.ScaledHotspotRect[i].y;
            int n5 = this.ScaledHotspotRect[i].width;
            int n6 = this.ScaledHotspotRect[i].height;
            int n7 = n3 + this.offsetx + n5 / 2;
            int n8 = n4 + this.offsety + n6 / 2;
            if (this.Shape == 1) {
                n2 = (n5 + n6) / 2;
                n = (n2 += this.PickWidth * 2) / 2;
                applet.repaint(n7 - n, n8 - n, n2, n2);
                continue;
            }
            n2 = n5 / 2 + this.PickWidth;
            n = n6 / 2 + this.PickWidth;
            applet.repaint(n7 - n2, n8 - n, n2 * 2, n * 2);
        }
    }

    public int ActiveHotspot(int n, int n2) {
        int n3;
        int n4 = -1;
        int n5 = 0;
        for (n3 = 0; n3 < this.nHotspots; ++n3) {
            if (!this.PtInHotspot(n3, n, n2)) continue;
            ++n5;
        }
        if (n5 != 0) {
            int n6 = 5000;
            for (n3 = 0; n3 < this.nHotspots; ++n3) {
                if (!this.PtInHotspot(n3, n, n2)) continue;
                int n7 = this.GetDistance(n3, n, n2);
                if (n4 != -1 && n7 >= n6) continue;
                n4 = n3;
                n6 = n7;
            }
        }
        return n4;
    }

    public boolean PtInHotspot(int n, int n2, int n3) {
        int n4 = this.ScaledHotspotRect[n].x;
        int n5 = this.ScaledHotspotRect[n].y;
        int n6 = this.ScaledHotspotRect[n].width;
        int n7 = this.ScaledHotspotRect[n].height;
        double d = n2 - (n4 + this.offsetx + n6 / 2);
        double d2 = n3 - (n5 + this.offsety + n7 / 2);
        if (this.Shape == 1) {
            int n8 = (n6 + n7) / 2;
            double d3 = n8 / 2;
            return (d /= d3) * d + (d2 /= d3) * d2 <= 1.0;
        }
        if (this.Shape == 2) {
            double d4 = n6 / 2;
            double d5 = n7 / 2;
            return (d /= d4) * d + (d2 /= d5) * d2 <= 1.0;
        }
        if (d < 0.0) {
            d = -d;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        return d <= (double)(n6 / 2) && d2 <= (double)(n7 / 2);
    }

    public int GetDistance(int n, int n2, int n3) {
        int n4 = this.ScaledHotspotRect[n].x + this.offsetx + this.ScaledHotspotRect[n].width / 2;
        int n5 = this.ScaledHotspotRect[n].y + this.offsety + this.ScaledHotspotRect[n].height / 2;
        int n6 = n4 - n2;
        int n7 = n5 - n3;
        return n6 * n6 + n7 * n7;
    }

    private int readUnsignedShort(SeekableStream seekableStream) throws IOException {
        if (this.isBigEndian) {
            return seekableStream.readUnsignedShort();
        }
        return seekableStream.readUnsignedShortLE();
    }

    private long readUnsignedInt(SeekableStream seekableStream) throws IOException {
        if (this.isBigEndian) {
            return seekableStream.readUnsignedInt();
        }
        return seekableStream.readUnsignedIntLE();
    }

    public Rectangle getHotspotRect(int n) {
        if (n < 0 || n >= this.nHotspots) {
            return null;
        }
        return this.HotspotRect[n];
    }

    public String getHotspotKey(int n) {
        if (n < 0 || n >= this.nHotspots) {
            return "";
        }
        return this.HotspotKey[n];
    }

    public String getHotspotSim(int n) {
        if (n < 0 || n >= this.nHotspots) {
            return "";
        }
        return this.HotspotSim[n];
    }

    public byte getHotspotKennzeichen(int n) {
        if (n < 0 || n >= this.nHotspots) {
            return 0;
        }
        return this.HotspotKennzeichen[n];
    }

    public int getNumHotspots() {
        return this.nHotspots;
    }
}

