/*
 * Decompiled with CFR 0.152.
 */
package com.imagedecoder;

import com.imagedecoder.ImageHotspots;
import com.imagedecoder.codec.SeekableStream;
import com.imagedecoder.codec.tiff.TIFFDirectory;
import com.imagedecoder.codec.tiff.TIFFFaxDecoder;
import com.imagedecoder.codec.tiff.TIFFField;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public class TIFFImageProducer
implements ImageProducer {
    protected byte[] bdata;
    protected int inWidth;
    protected int inHeight;
    public ImageHotspots imageHotspots = new ImageHotspots();
    boolean isBigEndian = false;
    private ImageConsumer consumer;
    public boolean loadError = false;
    protected Hashtable props = new Hashtable();
    protected URL imageurl = null;
    private static int TIFFHints = 30;

    public TIFFImageProducer(URL uRL) {
        this.imageurl = uRL;
    }

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        block2: {
            this.consumer = imageConsumer;
            try {
                this.produce();
            }
            catch (Exception exception) {
                if (this.consumer == null) break block2;
                this.consumer.imageComplete(1);
            }
        }
        this.consumer = null;
    }

    public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        return imageConsumer == this.consumer;
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        if (this.consumer == imageConsumer) {
            this.consumer = null;
        }
    }

    public void readImage(URL uRL) {
        this.loadError = false;
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            this.loadError = true;
            System.out.println("IO Exception " + iOException.getMessage());
            return;
        }
        if (inputStream == null) {
            System.out.println("tiffViewer: no InputStream for url (could not open file)");
            return;
        }
        this.readImage(inputStream);
    }

    public void startProduction(ImageConsumer imageConsumer) {
        System.out.println("startProduction");
        if (this.imageurl == null) {
            this.addConsumer(imageConsumer);
            return;
        }
        this.readImage(this.imageurl);
        this.addConsumer(imageConsumer);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    private void produce() {
        System.out.println("produce");
        byte[] byArray = new byte[]{-1, 0};
        IndexColorModel indexColorModel = new IndexColorModel(1, 2, byArray, byArray, byArray);
        if (this.consumer != null) {
            if (this.loadError) {
                this.consumer.imageComplete(1);
            } else {
                this.consumer.setDimensions(this.inWidth, this.inHeight);
                this.props.put("HotspotRects", this.imageHotspots.HotspotRect);
                this.props.put("HotspotKeys", this.imageHotspots.HotspotKey);
                this.props.put("BilevelData", this.bdata);
                this.consumer.setProperties(this.props);
                this.consumer.setColorModel(indexColorModel);
                this.consumer.setHints(TIFFHints);
                int n = (this.inWidth + 7) / 8 * 8;
                int[] nArray = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
                int n2 = 0;
                int n3 = 7;
                int[] nArray2 = new int[n];
                for (int i = 0; i < this.inHeight; ++i) {
                    for (int j = 0; j < this.inWidth; ++j) {
                        int n4 = this.bdata[n2] & nArray[n3];
                        nArray2[j] = n4 > 0 ? 1 : 0;
                        if (--n3 == -1) {
                            n3 = 7;
                            ++n2;
                            continue;
                        }
                        if (j != this.inWidth - 1) continue;
                        n3 = 7;
                        ++n2;
                    }
                    this.consumer.setPixels(0, i, this.inWidth, 1, (ColorModel)indexColorModel, nArray2, 0, n);
                }
                this.consumer.imageComplete(3);
            }
        }
    }

    public void readImage(byte[] byArray) {
        this.readImage(new ByteArrayInputStream(byArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void readImage(InputStream inputStream) {
        long l;
        block21: {
            System.out.println("readImage");
            l = System.currentTimeMillis();
            SeekableStream seekableStream = SeekableStream.wrapInputStream(inputStream, true);
            if (seekableStream == null) {
                System.out.println("No stream for file");
            }
            TIFFDirectory tIFFDirectory = new TIFFDirectory(seekableStream, 0);
            long l2 = tIFFDirectory.getIFDOffset();
            block10: while (l2 != 0L) {
                tIFFDirectory = new TIFFDirectory(seekableStream, l2, 0);
                l2 = tIFFDirectory.getNextIFDOffset();
                long l3 = tIFFDirectory.getFieldAsLong(257);
                long l4 = tIFFDirectory.getFieldAsLong(256);
                long l5 = tIFFDirectory.getFieldAsLong(273);
                long l6 = tIFFDirectory.getFieldAsLong(279);
                int n = (int)l4;
                int n2 = (int)l3;
                System.out.println("Image: w=" + Long.toString(l4) + ", h=" + Long.toString(l3));
                boolean bl = false;
                if (tIFFDirectory.isTagPresent(266)) {
                    bl = tIFFDirectory.getFieldAsLong(266) == 2L;
                }
                int n3 = (int)tIFFDirectory.getFieldAsLong(259);
                TIFFField tIFFField = tIFFDirectory.getField(266);
                int n4 = tIFFField != null ? tIFFField.getAsInt(0) : 1;
                System.out.println("fillOrder: " + Integer.toString(n4));
                TIFFField tIFFField2 = tIFFDirectory.getField(293);
                long l7 = tIFFField2 != null ? tIFFField2.getAsLong(0) : 0L;
                System.out.println("tiffT6Options: " + Long.toString(l7));
                TIFFField tIFFField3 = tIFFDirectory.getField(273);
                if (tIFFField3 == null) {
                    throw new RuntimeException("TIFFImage5");
                }
                long[] lArray = this.getFieldAsLongs(tIFFField3);
                TIFFField tIFFField4 = tIFFDirectory.getField(279);
                if (tIFFField4 == null) {
                    throw new RuntimeException("TIFFImage6");
                }
                long[] lArray2 = this.getFieldAsLongs(tIFFField4);
                int n5 = 0;
                int n6 = 0;
                int n7 = 1;
                boolean bl2 = true;
                int n8 = (int)lArray2[n6 * n7 + n5];
                System.out.println("byteCount: " + Integer.toString(n8));
                byte[] byArray = new byte[n8];
                System.out.println("tileOffset: " + Long.toString(lArray[n6 * n7 + n5]));
                seekableStream.seek(lArray[n6 * n7 + n5]);
                seekableStream.readFully(byArray, 0, n8);
                System.out.println("width: " + Integer.toString(n));
                System.out.println("height: " + Integer.toString(n2));
                this.bdata = new byte[n2 * ((n + 7) / 8)];
                TIFFFaxDecoder tIFFFaxDecoder = new TIFFFaxDecoder(n4, n, n2);
                tIFFFaxDecoder.decodeT6(this.bdata, byArray, 0, n2, l7);
                System.out.println("Decoded in " + (System.currentTimeMillis() - l) + " ms");
                this.inWidth = n;
                this.inHeight = n2;
                this.imageHotspots.setImageSize(this.inWidth, this.inHeight);
                int n9 = 65024;
                if (!tIFFDirectory.isTagPresent(n9)) continue;
                seekableStream.seek(tIFFDirectory.getIFDOffset());
                int n10 = this.readUnsignedShort(seekableStream);
                for (int i = 0; i < n10; ++i) {
                    int n11 = this.readUnsignedShort(seekableStream);
                    int n12 = this.readUnsignedShort(seekableStream);
                    int n13 = (int)this.readUnsignedInt(seekableStream);
                    long l8 = seekableStream.getFilePointer() + 4L;
                    if (n11 == n9) {
                        long l9 = this.readUnsignedInt(seekableStream);
                        System.out.println("Hotspots: " + Integer.toString(n13));
                        System.out.println("FileOffset: " + Long.toString(l9) + ", 0x" + Long.toHexString(l9));
                        this.isBigEndian = tIFFDirectory.isBigEndian();
                        seekableStream.seek(l9);
                        this.imageHotspots.ReadHotspots(n13, seekableStream, this.isBigEndian);
                        continue block10;
                    }
                    seekableStream.seek(l8);
                }
            }
            Object var47_39 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                break block21;
            }
            catch (IOException iOException) {
                System.out.println("IO Exception " + iOException.getMessage());
            }
            break block21;
            {
                catch (IOException iOException) {
                    this.loadError = true;
                    System.out.println("IO Exception " + iOException.getMessage());
                    Object var47_40 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block21;
                    }
                    catch (IOException iOException2) {
                        System.out.println("IO Exception " + iOException2.getMessage());
                    }
                    break block21;
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.loadError = true;
                    System.out.println("No Such Element Exception " + noSuchElementException.getMessage());
                    Object var47_41 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block21;
                    }
                    catch (IOException iOException) {
                        System.out.println("IO Exception " + iOException.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var47_42 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    System.out.println("IO Exception " + iOException.getMessage());
                }
                throw throwable;
            }
        }
        System.out.println("Done in " + (System.currentTimeMillis() - l) + " ms");
    }

    private final long[] getFieldAsLongs(TIFFField tIFFField) {
        long[] lArray = null;
        if (tIFFField.getType() == 3) {
            char[] cArray = tIFFField.getAsChars();
            lArray = new long[cArray.length];
            for (int i = 0; i < cArray.length; ++i) {
                lArray[i] = cArray[i] & 0xFFFF;
            }
        } else if (tIFFField.getType() == 4) {
            lArray = tIFFField.getAsLongs();
        } else {
            throw new RuntimeException();
        }
        return lArray;
    }

    private int readUnsignedShort(SeekableStream seekableStream) throws IOException {
        if (this.isBigEndian) {
            return seekableStream.readUnsignedShort();
        }
        return seekableStream.readUnsignedShortLE();
    }

    private long readUnsignedInt(SeekableStream seekableStream) throws IOException {
        if (this.isBigEndian) {
            return seekableStream.readUnsignedInt();
        }
        return seekableStream.readUnsignedIntLE();
    }

    public int getHeight() {
        return this.inHeight;
    }

    public int getWidth() {
        return this.inWidth;
    }

    public byte[] getBdata() {
        return this.bdata;
    }

    public void setBdata(byte[] byArray) {
        this.bdata = byArray;
    }
}

