/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.IndexDescriptor;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.FormatableHashtable;

public class IndexDescriptorImpl
implements IndexDescriptor,
Formatable {
    private boolean isUnique;
    private int[] baseColumnPositions;
    private boolean[] isAscending;
    private int numberOfOrderedColumns;
    private String indexType;

    public boolean isUnique() {
        return this.isUnique;
    }

    public int[] baseColumnPositions() {
        return this.baseColumnPositions;
    }

    public Integer getKeyColumnPosition(Integer n) {
        return new Integer(this.getKeyColumnPosition((int)n));
    }

    public int getKeyColumnPosition(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.baseColumnPositions.length) {
            if (this.baseColumnPositions[n3] == n) {
                n2 = n3 + 1;
                break;
            }
            ++n3;
        }
        return n2;
    }

    public int numberOfOrderedColumns() {
        return this.numberOfOrderedColumns;
    }

    public String indexType() {
        return this.indexType;
    }

    public boolean isAscending(Integer n) {
        int n2 = n - 1;
        if (n2 < 0 || n2 >= this.baseColumnPositions.length) {
            return false;
        }
        return this.isAscending[n2];
    }

    public boolean isDescending(Integer n) {
        int n2 = n - 1;
        if (n2 < 0 || n2 >= this.baseColumnPositions.length) {
            return false;
        }
        return !this.isAscending[n2];
    }

    public boolean[] isAscending() {
        return this.isAscending;
    }

    public void setBaseColumnPositions(int[] nArray) {
        this.baseColumnPositions = nArray;
    }

    public void setIsAscending(boolean[] blArray) {
        this.isAscending = blArray;
    }

    public void setNumberOfOrderedColumns(int n) {
        this.numberOfOrderedColumns = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(60);
        if (this.isUnique) {
            stringBuffer.append("UNIQUE ");
        }
        stringBuffer.append(this.indexType);
        stringBuffer.append(" (");
        int n = 0;
        while (n < this.baseColumnPositions.length) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.baseColumnPositions[n]);
            if (!this.isAscending[n]) {
                stringBuffer.append(" DESC");
            }
            ++n;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        FormatableHashtable formatableHashtable = (FormatableHashtable)objectInput.readObject();
        this.isUnique = formatableHashtable.getBoolean("isUnique");
        int n = formatableHashtable.getInt("keyLength");
        this.baseColumnPositions = new int[n];
        this.isAscending = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            this.baseColumnPositions[n2] = formatableHashtable.getInt("bcp" + n2);
            this.isAscending[n2] = formatableHashtable.getBoolean("isAsc" + n2);
            ++n2;
        }
        this.numberOfOrderedColumns = formatableHashtable.getInt("orderedColumns");
        this.indexType = (String)formatableHashtable.get("indexType");
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        FormatableHashtable formatableHashtable = new FormatableHashtable();
        formatableHashtable.putBoolean("isUnique", this.isUnique);
        formatableHashtable.putInt("keyLength", this.baseColumnPositions.length);
        int n = 0;
        while (n < this.baseColumnPositions.length) {
            formatableHashtable.putInt("bcp" + n, this.baseColumnPositions[n]);
            formatableHashtable.putBoolean("isAsc" + n, this.isAscending[n]);
            ++n;
        }
        formatableHashtable.putInt("orderedColumns", this.numberOfOrderedColumns);
        formatableHashtable.put("indexType", this.indexType);
        objectOutput.writeObject(formatableHashtable);
    }

    public int getTypeFormatId() {
        return 387;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof IndexDescriptorImpl) {
            IndexDescriptorImpl indexDescriptorImpl = (IndexDescriptorImpl)object;
            if (indexDescriptorImpl.isUnique == this.isUnique && indexDescriptorImpl.baseColumnPositions.length == this.baseColumnPositions.length && indexDescriptorImpl.numberOfOrderedColumns == this.numberOfOrderedColumns && indexDescriptorImpl.indexType.equals(this.indexType)) {
                bl = true;
                int n = 0;
                while (n < this.baseColumnPositions.length) {
                    if (indexDescriptorImpl.baseColumnPositions[n] != this.baseColumnPositions[n] || indexDescriptorImpl.isAscending[n] != this.isAscending[n]) {
                        bl = false;
                        break;
                    }
                    ++n;
                }
            }
        }
        return bl;
    }

    public int hashCode() {
        int n = this.isUnique ? 1 : 2;
        n *= this.numberOfOrderedColumns;
        int n2 = 0;
        while (n2 < this.baseColumnPositions.length) {
            n *= this.baseColumnPositions[n2];
            ++n2;
        }
        return n *= this.indexType.hashCode();
    }

    public IndexDescriptorImpl(String string, boolean bl, int[] nArray, boolean[] blArray, int n) {
        this.indexType = string;
        this.isUnique = bl;
        this.baseColumnPositions = nArray;
        this.isAscending = blArray;
        this.numberOfOrderedColumns = n;
    }

    public IndexDescriptorImpl() {
    }
}

