/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class ArrayUtil {
    public static void writeArrayLength(ObjectOutput objectOutput, Object[] objectArray) throws IOException {
        objectOutput.writeInt(objectArray.length);
    }

    public static void writeArrayItems(ObjectOutput objectOutput, Object[] objectArray) throws IOException {
        if (objectArray == null) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            objectOutput.writeObject(objectArray[n]);
            ++n;
        }
    }

    public static void writeArray(ObjectOutput objectOutput, Object[] objectArray) throws IOException {
        if (objectArray == null) {
            objectOutput.writeInt(0);
            return;
        }
        objectOutput.writeInt(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            objectOutput.writeObject(objectArray[n]);
            ++n;
        }
    }

    public static void readArrayItems(ObjectInput objectInput, Object[] objectArray) throws IOException, ClassNotFoundException {
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = objectInput.readObject();
            ++n;
        }
    }

    public static int readArrayLength(ObjectInput objectInput) throws IOException {
        return objectInput.readInt();
    }

    public static Object[] readObjectArray(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        if (n == 0) {
            return null;
        }
        Object[] objectArray = new Object[n];
        ArrayUtil.readArrayItems(objectInput, objectArray);
        return objectArray;
    }

    public static void writeIntArray(ObjectOutput objectOutput, int[] nArray) throws IOException {
        if (nArray == null) {
            objectOutput.writeInt(0);
        } else {
            objectOutput.writeInt(nArray.length);
            int n = 0;
            while (n < nArray.length) {
                objectOutput.writeInt(nArray[n]);
                ++n;
            }
        }
    }

    public static int[] readIntArray(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = objectInput.readInt();
            ++n2;
        }
        return nArray;
    }

    public static void writeInts(ObjectOutput objectOutput, int[][] nArray) throws IOException {
        if (nArray == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            int n = nArray.length;
            objectOutput.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                ArrayUtil.writeIntArray(objectOutput, nArray[n2]);
                ++n2;
            }
        }
    }

    public static int[][] readInts(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int[][] nArray = null;
        if (objectInput.readBoolean()) {
            int n = objectInput.readInt();
            nArray = new int[n][];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = ArrayUtil.readIntArray(objectInput);
                ++n2;
            }
        }
        return nArray;
    }

    public static void writeLongArray(ObjectOutput objectOutput, long[] lArray) throws IOException {
        if (lArray == null) {
            objectOutput.writeInt(0);
        } else {
            objectOutput.writeInt(lArray.length);
            int n = 0;
            while (n < lArray.length) {
                objectOutput.writeLong(lArray[n]);
                ++n;
            }
        }
    }

    public static long[] readLongArray(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        long[] lArray = new long[n];
        int n2 = 0;
        while (n2 < n) {
            lArray[n2] = objectInput.readLong();
            ++n2;
        }
        return lArray;
    }

    public static String[] readStringArray(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object[] objectArray = ArrayUtil.readObjectArray(objectInput);
        int n = 0;
        if (objectArray == null) {
            return null;
        }
        n = objectArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)objectArray[n2];
            ++n2;
        }
        return stringArray;
    }

    public static void writeBooleanArray(ObjectOutput objectOutput, boolean[] blArray) throws IOException {
        if (blArray == null) {
            objectOutput.writeInt(0);
        } else {
            objectOutput.writeInt(blArray.length);
            int n = 0;
            while (n < blArray.length) {
                objectOutput.writeBoolean(blArray[n]);
                ++n;
            }
        }
    }

    public static boolean[] readBooleanArray(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            blArray[n2] = objectInput.readBoolean();
            ++n2;
        }
        return blArray;
    }
}

