/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.IOException;
import java.io.Reader;
import org.apache.derby.iapi.services.io.Limit;

public class LimitReader
extends Reader
implements Limit {
    protected int remainingBytes;
    protected boolean limitInPlace;
    private Reader reader;

    public int read() throws IOException {
        if (!this.limitInPlace) {
            return this.reader.read();
        }
        if (this.remainingBytes == 0) {
            return -1;
        }
        int n = this.reader.read();
        if (n >= 0) {
            --this.remainingBytes;
        }
        return n;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (!this.limitInPlace) {
            return this.reader.read(cArray, n, n2);
        }
        if (this.remainingBytes == 0) {
            return -1;
        }
        if (this.remainingBytes < n2) {
            n2 = this.remainingBytes;
        }
        if ((n2 = this.reader.read(cArray, n, n2)) >= 0) {
            this.remainingBytes -= n2;
        }
        return n2;
    }

    public long skip(long l) throws IOException {
        if (!this.limitInPlace) {
            return this.reader.skip(l);
        }
        if (this.remainingBytes == 0) {
            return 0L;
        }
        if ((long)this.remainingBytes < l) {
            l = this.remainingBytes;
        }
        l = this.reader.skip(l);
        this.remainingBytes = (int)((long)this.remainingBytes - l);
        return l;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public void setLimit(int n) {
        this.remainingBytes = n;
        this.limitInPlace = true;
    }

    public int clearLimit() {
        int n = this.remainingBytes;
        this.limitInPlace = false;
        this.remainingBytes = -1;
        return n;
    }

    public LimitReader(Reader reader) {
        this.reader = reader;
        this.clearLimit();
    }
}

