/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.store.raw;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.store.raw.ContainerKey;

public class PageKey {
    private final ContainerKey container;
    private final long pageNumber;

    public long getPageNumber() {
        return this.pageNumber;
    }

    public ContainerKey getContainerId() {
        return this.container;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.container.writeExternal(objectOutput);
        CompressedNumber.writeLong(objectOutput, this.pageNumber);
    }

    public static PageKey read(ObjectInput objectInput) throws IOException {
        ContainerKey containerKey = ContainerKey.read(objectInput);
        long l = CompressedNumber.readLong(objectInput);
        return new PageKey(containerKey, l);
    }

    public boolean equals(Object object) {
        if (object instanceof PageKey) {
            PageKey pageKey = (PageKey)object;
            return this.pageNumber == pageKey.pageNumber && this.container.equals(pageKey.container);
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.pageNumber ^ (long)this.container.hashCode());
    }

    public String toString() {
        return "Page(" + this.pageNumber + "," + this.container.toString() + ")";
    }

    public PageKey(ContainerKey containerKey, long l) {
        this.container = containerKey;
        this.pageNumber = l;
    }
}

