/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import org.apache.derby.iapi.types.DataTypeDescriptor;

public abstract class DataTypeUtilities {
    public static int getPrecision(DataTypeDescriptor dataTypeDescriptor) {
        int n = dataTypeDescriptor.getTypeId().getJDBCTypeId();
        switch (n) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 2004: 
            case 2005: {
                return dataTypeDescriptor.getMaximumWidth();
            }
            case 5: {
                return 5;
            }
            case 91: {
                return 10;
            }
            case 16: {
                return 1;
            }
        }
        return dataTypeDescriptor.getPrecision();
    }

    public static int getDigitPrecision(DataTypeDescriptor dataTypeDescriptor) {
        int n = dataTypeDescriptor.getTypeId().getJDBCTypeId();
        switch (n) {
            case 6: 
            case 8: {
                return 15;
            }
            case 7: {
                return 7;
            }
        }
        return DataTypeUtilities.getPrecision(dataTypeDescriptor);
    }

    public static boolean isCurrency(DataTypeDescriptor dataTypeDescriptor) {
        int n = dataTypeDescriptor.getTypeId().getJDBCTypeId();
        return n == 3 || n == 2;
    }

    public static boolean isCaseSensitive(DataTypeDescriptor dataTypeDescriptor) {
        int n = dataTypeDescriptor.getTypeId().getJDBCTypeId();
        return n == 1 || n == 12 || n == 2005 || n == -1;
    }

    public static int isNullable(DataTypeDescriptor dataTypeDescriptor) {
        return dataTypeDescriptor.isNullable() ? 1 : 0;
    }

    public static boolean isSigned(DataTypeDescriptor dataTypeDescriptor) {
        int n = dataTypeDescriptor.getTypeId().getJDBCTypeId();
        return n == 4 || n == 6 || n == 3 || n == 5 || n == -5 || n == -6 || n == 2 || n == 7 || n == 8;
    }

    public static int getColumnDisplaySize(DataTypeDescriptor dataTypeDescriptor) {
        int n = dataTypeDescriptor.getTypeId().getJDBCTypeId();
        int n2 = dataTypeDescriptor.getMaximumWidth();
        return DataTypeUtilities.getColumnDisplaySize(n, n2);
    }

    public static int getColumnDisplaySize(int n, int n2) {
        int n3;
        switch (n) {
            case 93: {
                n3 = 26;
                break;
            }
            case 91: {
                n3 = 10;
                break;
            }
            case 92: {
                n3 = 8;
                break;
            }
            case 4: {
                n3 = 11;
                break;
            }
            case 5: {
                n3 = 6;
                break;
            }
            case 6: 
            case 7: {
                n3 = 13;
                break;
            }
            case 8: {
                n3 = 22;
                break;
            }
            case -6: {
                n3 = 15;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                n3 = 2 * n2;
                if (n3 >= 0) break;
                n3 = Integer.MAX_VALUE;
                break;
            }
            case -5: {
                n3 = 20;
                break;
            }
            case -7: 
            case 16: {
                n3 = 5;
                break;
            }
            default: {
                int n4 = n2;
                n3 = n4 > 0 ? n4 : 15;
                break;
            }
        }
        return n3;
    }

    public static int computeMaxWidth(int n, int n2) {
        return n2 == 0 ? n + 1 : n + 3;
    }
}

