/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class ByteArray {
    private byte[] array;
    private int offset;
    private int length;

    public void setBytes(byte[] byArray) {
        this.array = byArray;
        this.offset = 0;
        this.length = byArray.length;
    }

    public void setBytes(byte[] byArray, int n) {
        this.array = byArray;
        this.offset = 0;
        this.length = n;
    }

    public void setBytes(byte[] byArray, int n, int n2) {
        this.array = byArray;
        this.offset = n;
        this.length = n2;
    }

    public boolean equals(Object object) {
        if (object instanceof ByteArray) {
            ByteArray byteArray = (ByteArray)object;
            return ByteArray.equals(this.array, this.offset, this.length, byteArray.array, byteArray.offset, byteArray.length);
        }
        return false;
    }

    public int hashCode() {
        byte[] byArray = this.array;
        int n = this.length;
        int n2 = 0;
        while (n2 < this.length) {
            n += byArray[n2 + this.offset];
            ++n2;
        }
        return n;
    }

    public final byte[] getArray() {
        return this.array;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final int getLength() {
        return this.length;
    }

    public final void setLength(int n) {
        this.length = n;
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        int n = this.length = objectInput.readInt();
        this.offset = 0;
        this.array = new byte[n];
        objectInput.readFully(this.array, 0, n);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.length);
        objectOutput.write(this.array, this.offset, this.length);
    }

    private static boolean equals(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if (n2 != n4) {
            return false;
        }
        int n5 = 0;
        while (n5 < n2) {
            if (byArray[n5 + n] != byArray2[n5 + n3]) {
                return false;
            }
            ++n5;
        }
        return true;
    }

    public ByteArray(byte[] byArray, int n, int n2) {
        this.array = byArray;
        this.offset = n;
        this.length = n2;
    }

    public ByteArray(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public ByteArray() {
    }
}

