/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.util;

import java.util.Locale;

public class StringUtil {
    private static char[] hex_table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static final String formatForPrint(String string) {
        if (string.length() > 60) {
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, 60));
            stringBuffer.append("&");
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String[] toStringArray(Object[] objectArray) {
        int n = objectArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = objectArray[n2].toString();
            ++n2;
        }
        return stringArray;
    }

    public static byte[] getAsciiBytes(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        int n = 0;
        while (n < cArray.length) {
            byArray[n] = (byte)(cArray[n] & 0x7F);
            ++n;
        }
        return byArray;
    }

    public static String trimTrailing(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        while (n > 0) {
            if (!Character.isWhitespace(string.charAt(n - 1))) break;
            --n;
        }
        return string.substring(0, n);
    }

    public static String truncate(String string, int n) {
        if (string != null && string.length() > n) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static String toHexString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2 * 2);
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            int n5 = (byArray[n4] & 0xF0) >>> 4;
            int n6 = byArray[n4] & 0xF;
            stringBuffer.append(hex_table[n5]);
            stringBuffer.append(hex_table[n6]);
            ++n4;
        }
        return stringBuffer.toString();
    }

    public static byte[] fromHexString(String string, int n, int n2) {
        if (n2 % 2 != 0) {
            return null;
        }
        byte[] byArray = new byte[n2 / 2];
        int n3 = 0;
        int n4 = n + n2;
        int n5 = n;
        while (n5 < n4) {
            int n6 = Character.digit(string.charAt(n5), 16);
            int n7 = Character.digit(string.charAt(n5 + 1), 16);
            if (n6 == -1 || n7 == -1) {
                return null;
            }
            byArray[n3++] = (byte)(n6 << 4 & 0xF0 | n7 & 0xF);
            n5 += 2;
        }
        return byArray;
    }

    public static String hexDump(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 3);
        stringBuffer.append("Hex dump:\n");
        int n = 0;
        while (n < byArray.length) {
            char c;
            String string = Integer.toHexString(n);
            int n2 = string.length();
            while (n2 < 8) {
                stringBuffer.append("0");
                ++n2;
            }
            stringBuffer.append(string);
            stringBuffer.append(":");
            n2 = 0;
            while (n2 < 16 && n + n2 < byArray.length) {
                byte by = byArray[n + n2];
                if (n2 % 2 == 0) {
                    stringBuffer.append(" ");
                }
                c = (char)((by & 0xF0) >>> 4);
                byte by2 = (byte)(by & 0xF);
                stringBuffer.append(hex_table[c]);
                stringBuffer.append(hex_table[by2]);
                ++n2;
            }
            stringBuffer.append("  ");
            n2 = 0;
            while (n2 < 16 && n + n2 < byArray.length) {
                c = (char)byArray[n + n2];
                if (Character.isLetterOrDigit(c)) {
                    stringBuffer.append(String.valueOf(c));
                } else {
                    stringBuffer.append(".");
                }
                ++n2;
            }
            stringBuffer.append("\n");
            n += 16;
        }
        return stringBuffer.toString();
    }

    public static String SQLToUpperCase(String string) {
        return string.toUpperCase(Locale.ENGLISH);
    }

    public static String SQLToLowerCase(String string) {
        return string.toLowerCase(Locale.ENGLISH);
    }

    public static boolean SQLEqualsIgnoreCase(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        return string.toUpperCase(Locale.ENGLISH).equals(string2.toUpperCase(Locale.ENGLISH));
    }
}

