/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.cache;

import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.cache.CacheableFactory;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.cache.SizedCacheable;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.util.Matchable;
import org.apache.derby.iapi.util.Operator;
import org.apache.derby.impl.services.cache.CacheStat;
import org.apache.derby.impl.services.cache.CachedItem;

final class Clock
extends Hashtable
implements CacheManager,
Serviceable {
    private static final int ITEM_OVERHEAD = ClassSize.estimateBaseFromCatalog(class$Lorg$apache$derby$impl$services$cache$CachedItem != null ? class$Lorg$apache$derby$impl$services$cache$CachedItem : (class$Lorg$apache$derby$impl$services$cache$CachedItem = Clock.class$("org.apache.derby.impl.services.cache.CachedItem"))) + ClassSize.getRefSize() + ClassSize.estimateHashEntrySize();
    public final CacheStat stat;
    private DaemonService cleaner;
    private final ArrayList holders;
    private int validItemCount = 0;
    private long maximumSize;
    private boolean useByteCount;
    private long currentByteCount = 0L;
    private final CacheableFactory holderFactory;
    private boolean active;
    private String name;
    private int clockHand;
    private int myClientNumber;
    private boolean wokenToClean;
    private boolean cleanerRunning;
    private boolean needService;
    private int trimRequests = 0;
    private static /* synthetic */ Class class$Lorg$apache$derby$impl$services$cache$CachedItem;

    public Cacheable find(Object object) throws StandardException {
        Object object2;
        while (true) {
            CachedItem cachedItem;
            boolean bl = false;
            Clock clock = this;
            synchronized (clock) {
                if (!this.active) {
                    Cacheable cacheable = null;
                    Object var5_9 = null;
                    return cacheable;
                }
                cachedItem = (CachedItem)this.get(object);
                if (cachedItem != null) {
                    cachedItem.keepAfterSearch();
                    ++this.stat.findHit;
                }
            }
            if (cachedItem == null) {
                cachedItem = this.findFreeItem();
                ++this.stat.findMiss;
                object2 = this;
                synchronized (object2) {
                    CachedItem cachedItem2 = (CachedItem)this.get(object);
                    if (cachedItem2 != null) {
                        cachedItem.unkeepForCreate();
                        cachedItem = cachedItem2;
                        cachedItem.keepAfterSearch();
                    } else {
                        this.put(object, cachedItem);
                        bl = true;
                    }
                }
            }
            if (bl) {
                ++this.stat.findFault;
                return this.addEntry(cachedItem, object, false, null);
            }
            object2 = cachedItem.use();
            if (object2 != null) break;
            Clock clock2 = this;
            synchronized (clock2) {
                cachedItem.unkeep();
            }
        }
        return object2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Cacheable findCached(Object object) throws StandardException {
        CachedItem cachedItem;
        Clock clock = this;
        synchronized (clock) {
            if (!this.active) {
                return null;
            }
            cachedItem = (CachedItem)this.get(object);
            if (cachedItem == null) {
                ++this.stat.findCachedMiss;
                return null;
            }
            ++this.stat.findCachedHit;
            cachedItem.keepAfterSearch();
        }
        Cacheable cacheable = cachedItem.use();
        if (cacheable != null) return cacheable;
        Clock clock2 = this;
        synchronized (clock2) {
            cachedItem.unkeep();
            return cacheable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setUsed(Object[] objectArray) {
        int n = 0;
        block3: while (n < objectArray.length) {
            Clock clock = this;
            synchronized (clock) {
                if (!this.active) {
                    return;
                }
                int n2 = n + 32;
                if (n2 > objectArray.length) {
                    n2 = objectArray.length;
                }
                while (true) {
                    if (n >= n2) {
                        continue block3;
                    }
                    if (objectArray[n] == null) {
                        return;
                    }
                    CachedItem cachedItem = (CachedItem)this.get(objectArray[n]);
                    if (cachedItem != null) {
                        cachedItem.setUsed(true);
                    }
                    ++n;
                }
            }
        }
    }

    public Cacheable create(Object object, Object object2) throws StandardException {
        CachedItem cachedItem = this.findFreeItem();
        ++this.stat.create;
        Clock clock = this;
        synchronized (clock) {
            if (!this.active) {
                Cacheable cacheable = null;
                Object var5_6 = null;
                return cacheable;
            }
            if (this.get(object) != null) {
                cachedItem.unkeepForCreate();
                throw StandardException.newException("XBCA0.S", this.name, object);
            }
            this.put(object, cachedItem);
        }
        Cacheable cacheable = this.addEntry(cachedItem, object, true, object2);
        return cacheable;
    }

    public void release(Cacheable cacheable) {
        boolean bl;
        CachedItem cachedItem;
        long l = 0L;
        Clock clock = this;
        synchronized (clock) {
            cachedItem = (CachedItem)this.get(cacheable.getIdentity());
            bl = cachedItem.unkeep();
            if (bl) {
                this.remove(cacheable.getIdentity());
                cachedItem.keepForClean();
            }
            if (this.cleaner == null) {
                l = this.shrinkSize(this.getCurrentSize());
            }
        }
        if (bl) {
            cachedItem.notifyRemover();
        }
        if (l > 0L) {
            this.performWork(true);
        }
    }

    protected void release(CachedItem cachedItem) {
        boolean bl;
        Clock clock = this;
        synchronized (clock) {
            bl = cachedItem.unkeep();
            if (bl) {
                this.remove(cachedItem.getEntry().getIdentity());
                cachedItem.keepForClean();
            }
        }
        if (bl) {
            cachedItem.notifyRemover();
        }
    }

    public void remove(Cacheable cacheable) throws StandardException {
        boolean bl;
        CachedItem cachedItem;
        long l = 0L;
        ++this.stat.remove;
        Clock clock = this;
        synchronized (clock) {
            cachedItem = (CachedItem)this.get(cacheable.getIdentity());
            if (this.useByteCount) {
                l = this.getItemSize(cachedItem);
            }
            cachedItem.setRemoveState();
            bl = cachedItem.unkeep();
            if (bl) {
                this.remove(cacheable.getIdentity());
                cachedItem.keepForClean();
            }
        }
        try {
            cachedItem.remove(bl);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            Clock clock2 = this;
            synchronized (clock2) {
                cachedItem.unkeep();
                cachedItem.setValidState(false);
                --this.validItemCount;
                cachedItem.getEntry().clearIdentity();
                if (this.useByteCount) {
                    this.currentByteCount += (long)this.getItemSize(cachedItem) - l;
                }
            }
            throw throwable;
        }
        Object var7_7 = null;
        Clock clock3 = this;
        synchronized (clock3) {
            cachedItem.unkeep();
            cachedItem.setValidState(false);
            --this.validItemCount;
            cachedItem.getEntry().clearIdentity();
            if (this.useByteCount) {
                this.currentByteCount += (long)this.getItemSize(cachedItem) - l;
            }
        }
    }

    public void cleanAll() throws StandardException {
        ++this.stat.cleanAll;
        this.cleanCache(null);
    }

    public void clean(Matchable matchable) throws StandardException {
        this.cleanCache(matchable);
    }

    public void ageOut() {
        ++this.stat.ageOut;
        Clock clock = this;
        synchronized (clock) {
            int n = this.holders.size();
            long l = this.shrinkSize(this.getCurrentSize());
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                CachedItem cachedItem = (CachedItem)this.holders.get(n2);
                if (!cachedItem.isKept() && cachedItem.isValid() && !cachedItem.getEntry().isDirty()) {
                    long l2 = this.removeIdentity(cachedItem);
                    if (l > 0L) {
                        l -= l2;
                        bl = true;
                    }
                }
                ++n2;
            }
            if (bl) {
                this.trimToSize();
            }
        }
    }

    public void shutdown() throws StandardException {
        if (this.cleaner != null) {
            this.cleaner.unsubscribe(this.myClientNumber);
            this.cleaner = null;
        }
        Clock clock = this;
        synchronized (clock) {
            this.active = false;
        }
        this.ageOut();
        this.cleanAll();
        this.ageOut();
    }

    public void useDaemonService(DaemonService daemonService) {
        if (this.cleaner != null) {
            this.cleaner.unsubscribe(this.myClientNumber);
        }
        this.cleaner = daemonService;
        this.myClientNumber = this.cleaner.subscribe(this, true);
    }

    public boolean discard(Matchable matchable) {
        boolean bl = true;
        Clock clock = this;
        synchronized (clock) {
            int n = this.holders.size();
            long l = this.shrinkSize(this.getCurrentSize());
            boolean bl2 = false;
            int n2 = 0;
            while (n2 < n) {
                CachedItem cachedItem = (CachedItem)this.holders.get(n2);
                if (cachedItem.isValid()) {
                    Object object = cachedItem.getEntry().getIdentity();
                    if (matchable == null || matchable.match(object)) {
                        if (cachedItem.isKept()) {
                            bl = false;
                        } else {
                            long l2 = this.removeIdentity(cachedItem);
                            if (l > 0L) {
                                l -= l2;
                                bl2 = true;
                            }
                        }
                    }
                }
                ++n2;
            }
            if (bl2) {
                this.trimToSize();
            }
        }
        return bl;
    }

    private Cacheable addEntry(CachedItem cachedItem, Object object, boolean bl, Object object2) throws StandardException {
        boolean bl2;
        Cacheable cacheable = null;
        long l = 0L;
        if (this.useByteCount) {
            l = this.getItemSize(cachedItem);
        }
        try {
            cacheable = cachedItem.takeOnIdentity(this, this.holderFactory, object, bl, object2);
        }
        catch (Throwable throwable) {
            boolean bl3;
            Object var9_8 = null;
            Clock clock = this;
            synchronized (clock) {
                Object v = this.remove(object);
                if (cacheable != null) {
                    this.put(cacheable.getIdentity(), cachedItem);
                    if (this.useByteCount) {
                        this.currentByteCount += (long)((SizedCacheable)cacheable).getSize() - l;
                    }
                    cachedItem.setValidState(true);
                    ++this.validItemCount;
                    bl3 = true;
                } else {
                    cachedItem.unkeep();
                    bl3 = cachedItem.isKept();
                }
            }
            if (bl3) {
                cachedItem.settingIdentityComplete();
            }
            throw throwable;
        }
        Object var9_7 = null;
        Clock clock = this;
        synchronized (clock) {
            Object v = this.remove(object);
            if (cacheable != null) {
                this.put(cacheable.getIdentity(), cachedItem);
                if (this.useByteCount) {
                    this.currentByteCount += (long)((SizedCacheable)cacheable).getSize() - l;
                }
                cachedItem.setValidState(true);
                ++this.validItemCount;
                bl2 = true;
            } else {
                cachedItem.unkeep();
                bl2 = cachedItem.isKept();
            }
        }
        if (bl2) {
            cachedItem.settingIdentityComplete();
        }
        return cacheable;
    }

    protected CachedItem findFreeItem() throws StandardException {
        Object object;
        long l = this.getCurrentSize();
        if (l >= this.maximumSize && (object = this.rotateClock(0.2f)) != null) {
            return object;
        }
        if (this.validItemCount < this.holders.size()) {
            object = this;
            synchronized (object) {
                int n = this.holders.size() - 1;
                while (n >= 0) {
                    CachedItem cachedItem = (CachedItem)this.holders.get(n);
                    if (!cachedItem.isKept() && !cachedItem.isValid()) {
                        cachedItem.keepForCreate();
                        CachedItem cachedItem2 = cachedItem;
                        Object var4_6 = null;
                        return cachedItem2;
                    }
                    --n;
                }
            }
        }
        return this.growCache();
    }

    /*
     * Exception decompiling
     */
    protected CachedItem rotateClock(float var1_1) throws StandardException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 9[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int incrClockHand() {
        if (++this.clockHand >= this.holders.size()) {
            this.clockHand = 0;
        }
        return this.clockHand;
    }

    public int performWork(ContextManager contextManager) {
        int n = this.performWork(false);
        Clock clock = this;
        synchronized (clock) {
            this.cleanerRunning = false;
        }
        return n;
    }

    public boolean serviceASAP() {
        return this.needService;
    }

    public boolean serviceImmediately() {
        return false;
    }

    public synchronized int getNumberInUse() {
        int n = this.holders.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            CachedItem cachedItem = (CachedItem)this.holders.get(n3);
            if (cachedItem.isValid()) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    private CachedItem growCache() {
        CachedItem cachedItem = new CachedItem();
        cachedItem.keepForCreate();
        Clock clock = this;
        synchronized (clock) {
            this.holders.add(cachedItem);
        }
        return cachedItem;
    }

    protected long removeIdentity(CachedItem cachedItem) {
        long l = 1L;
        if (this.useByteCount) {
            l = ((SizedCacheable)cachedItem.getEntry()).getSize();
        }
        this.remove(cachedItem.getEntry().getIdentity());
        cachedItem.setValidState(false);
        --this.validItemCount;
        cachedItem.getEntry().clearIdentity();
        if (this.useByteCount) {
            this.currentByteCount -= (l -= (long)((SizedCacheable)cachedItem.getEntry()).getSize());
        }
        return l;
    }

    protected void cleanCache(Matchable matchable) throws StandardException {
        int n;
        Clock clock = this;
        synchronized (clock) {
            n = this.holders.size() - 1;
        }
        while (true) {
            CachedItem cachedItem = null;
            Clock clock2 = this;
            synchronized (clock2) {
                int n2 = this.holders.size();
                if (n >= n2) {
                    n = n2 - 1;
                }
                while (n >= 0) {
                    Object object;
                    cachedItem = (CachedItem)this.holders.get(n);
                    if (cachedItem.isValid() && cachedItem.getEntry().isDirty() && (matchable == null || matchable.match(object = cachedItem.getEntry().getIdentity()))) {
                        cachedItem.keepForClean();
                        break;
                    }
                    --n;
                    cachedItem = null;
                }
            }
            if (n < 0) {
                return;
            }
            try {
                cachedItem.clean(false);
            }
            finally {
                Object var7_7 = null;
                this.release(cachedItem);
            }
            --n;
        }
    }

    protected long shrinkSize(long l) {
        long l2 = this.getMaximumSize();
        long l3 = l - l2;
        if (l3 <= 0L) {
            return 0L;
        }
        long l4 = l2 / 10L;
        if (l4 == 0L) {
            l4 = 2L;
        }
        if (l3 < l4) {
            return l3;
        }
        return l4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int performWork(boolean bl) {
        block28: {
            int n;
            long l;
            long l2;
            long l3;
            Clock clock = this;
            synchronized (clock) {
                if (!this.active) {
                    this.needService = false;
                    return 1;
                }
                l3 = this.getCurrentSize();
                l2 = l3 / 20L;
                long l4 = l = this.wokenToClean ? 0L : this.shrinkSize(l3);
                if (l2 == 0L) {
                    this.wokenToClean = false;
                    this.needService = false;
                    return 1;
                }
                if (!this.wokenToClean && l <= 0L) {
                    this.needService = false;
                    return 1;
                }
                n = this.useByteCount ? this.holders.size() / 10 : (int)(l2 * 2L);
            }
            l3 = 0L;
            boolean bl2 = false;
            CachedItem cachedItem = null;
            int n2 = 0;
            Object var15_22 = null;
            clock = this;
            synchronized (clock) {
                int n3 = this.holders.size();
                n2 = this.clockHand;
                boolean bl3 = false;
                long l5 = this.getCurrentSize();
                while (true) {
                    boolean bl4 = bl ? l5 > this.maximumSize && l > 0L : l3 < l2;
                    if (!bl4) break;
                    if (++n2 >= n3) {
                        if (n3 == 0) break;
                        n2 = 0;
                    }
                    if (n-- <= 0) break;
                    cachedItem = (CachedItem)this.holders.get(n2);
                    if (!cachedItem.isKept()) {
                        if (!cachedItem.isValid()) {
                            if (l > 0L) {
                                l -= l5;
                                this.holders.remove(n2);
                                if (this.useByteCount) {
                                    this.currentByteCount -= (long)this.getItemSize(cachedItem);
                                }
                                l5 = this.getCurrentSize();
                                l += l5;
                                --n3;
                                --n2;
                                bl3 = true;
                            }
                        } else if (!cachedItem.recentlyUsed()) {
                            int n4 = this.getItemSize(cachedItem);
                            l3 += (long)n4;
                            if (!cachedItem.getEntry().isDirty()) {
                                if (l > 0L) {
                                    l -= l5;
                                    this.removeIdentity(cachedItem);
                                    this.holders.remove(n2);
                                    if (this.useByteCount) {
                                        this.currentByteCount -= (long)this.getItemSize(cachedItem);
                                    }
                                    l5 = this.getCurrentSize();
                                    l += l5;
                                    --n3;
                                    bl3 = true;
                                    --n2;
                                }
                            } else if (!bl) {
                                cachedItem.keepForClean();
                                break;
                            }
                        }
                    }
                    cachedItem = null;
                }
                if (bl3) {
                    this.trimToSize();
                }
                if (cachedItem == null) {
                    this.wokenToClean = false;
                    this.needService = false;
                    return 1;
                }
            }
            try {
                try {
                    cachedItem.clean(false);
                }
                catch (StandardException standardException) {
                    Object var8_13 = null;
                    this.release(cachedItem);
                    cachedItem = null;
                    break block28;
                }
                Object var8_12 = null;
                this.release(cachedItem);
                cachedItem = null;
            }
            catch (Throwable throwable) {
                Object var8_14 = null;
                this.release(cachedItem);
                cachedItem = null;
                throw throwable;
            }
        }
        this.needService = true;
        return 2;
    }

    private int getItemSize(CachedItem cachedItem) {
        if (!this.useByteCount) {
            return 1;
        }
        SizedCacheable sizedCacheable = (SizedCacheable)cachedItem.getEntry();
        if (sizedCacheable == null) {
            return 0;
        }
        return sizedCacheable.getSize();
    }

    public synchronized long[] getCacheStats() {
        this.stat.currentSize = this.getCurrentSize();
        return this.stat.getStats();
    }

    public void resetCacheStats() {
        this.stat.reset();
    }

    public synchronized long getMaximumSize() {
        return this.maximumSize;
    }

    public void resize(long l) throws StandardException {
        boolean bl;
        Clock clock = this;
        synchronized (clock) {
            this.stat.maxSize = this.maximumSize = l;
            bl = this.shrinkSize(this.getCurrentSize()) > 0L;
        }
        if (bl) {
            CachedItem cachedItem;
            this.performWork(true);
            if (this.shrinkSize(this.getCurrentSize()) > 0L && (cachedItem = this.rotateClock(2.0f)) != null) {
                cachedItem.unkeepForCreate();
            }
        }
    }

    private synchronized long getCurrentSize() {
        if (!this.useByteCount) {
            return this.holders.size();
        }
        return this.currentByteCount + (long)(this.holders.size() * ITEM_OVERHEAD);
    }

    public void scan(Matchable matchable, Operator operator) {
        boolean bl = true;
        Cacheable cacheable = null;
        CachedItem cachedItem = null;
        int n = 0;
        while (true) {
            Clock clock = this;
            synchronized (clock) {
                if (cachedItem != null) {
                    this.release(cachedItem);
                    cachedItem = null;
                }
                while (n < this.holders.size()) {
                    block11: {
                        cachedItem = (CachedItem)this.holders.get(n);
                        if (cachedItem != null) {
                            try {
                                cacheable = cachedItem.use();
                            }
                            catch (StandardException standardException) {
                                break block11;
                            }
                            if (cacheable != null && (matchable == null || matchable.match(cacheable))) {
                                cachedItem.keepForClean();
                                break;
                            }
                        }
                    }
                    ++n;
                }
                if (n >= this.holders.size()) {
                    Object var8_9 = null;
                    return;
                }
            }
            operator.operate(cacheable);
            ++n;
        }
    }

    private void trimToSize() {
        int n = this.holders.size();
        ++this.trimRequests;
        if (this.trimRequests < n / 8) {
            return;
        }
        this.trimRequests = 0;
        int n2 = n - 1;
        int n3 = 0;
        int n4 = 0;
        while (n4 <= n2) {
            CachedItem cachedItem = (CachedItem)this.holders.get(n4);
            if (!cachedItem.isKept() && !cachedItem.isValid()) {
                ++n3;
                while (n2 > n4) {
                    CachedItem cachedItem2 = (CachedItem)this.holders.get(n2);
                    if (cachedItem2.isValid()) {
                        this.holders.set(n4, cachedItem2);
                        this.holders.set(n2, cachedItem);
                        --n2;
                        break;
                    }
                    --n2;
                }
            }
            ++n4;
        }
        if (n < 32) {
            return;
        }
        n4 = n - n3;
        if (n4 > 3 * n / 4) {
            return;
        }
        int n5 = n4 + n4 / 10;
        if (n5 >= n) {
            return;
        }
        int n6 = n - 1;
        while (n6 > n5) {
            CachedItem cachedItem = (CachedItem)this.holders.get(n6);
            if (!cachedItem.isKept() && !cachedItem.isValid()) {
                if (this.useByteCount) {
                    this.currentByteCount -= (long)this.getItemSize(cachedItem);
                }
                this.holders.remove(n6);
            }
            --n6;
        }
        this.holders.trimToSize();
        this.clockHand = n4 + 1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    Clock(CacheableFactory cacheableFactory, String string, int n, long l, boolean bl) {
        super(n, 0.95f);
        this.maximumSize = l;
        this.holderFactory = cacheableFactory;
        this.useByteCount = bl;
        this.holders = new ArrayList(n);
        this.name = string;
        this.active = true;
        this.stat = new CacheStat();
        this.stat.initialSize = n;
        this.stat.maxSize = l;
    }
}

