/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.monitor;

import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.monitor.PersistentService;
import org.apache.derby.impl.services.monitor.BaseMonitor;
import org.apache.derby.impl.services.monitor.ModuleInstance;
import org.apache.derby.impl.services.monitor.ProtocolKey;

class TopService {
    protected ProtocolKey key;
    protected ModuleInstance topModule;
    protected Hashtable protocolTable;
    protected Vector moduleInstances;
    protected BaseMonitor monitor;
    protected boolean inShutdown;
    protected PersistentService serviceType;
    Locale serviceLocale;

    protected void setTopModule(Object object) {
        TopService topService = this;
        synchronized (topService) {
            int n = 0;
            while (n < this.moduleInstances.size()) {
                ModuleInstance moduleInstance = (ModuleInstance)this.moduleInstances.elementAt(n);
                if (moduleInstance.getInstance() == object) {
                    this.topModule = moduleInstance;
                    this.notifyAll();
                    break;
                }
                ++n;
            }
            if (this.getServiceType() != null) {
                ProtocolKey protocolKey = new ProtocolKey(this.key.getFactoryInterface(), this.monitor.getServiceName(object));
                this.addToProtocol(protocolKey, this.topModule);
            }
        }
    }

    protected Object getService() {
        return this.topModule.getInstance();
    }

    protected boolean isPotentialService(ProtocolKey protocolKey) {
        String string;
        if (this.serviceType == null) {
            string = protocolKey.getIdentifier();
        } else {
            string = this.serviceType.getCanonicalServiceName(protocolKey.getIdentifier());
            if (string == null) {
                return false;
            }
        }
        if (this.topModule != null) {
            return this.topModule.isTypeAndName(this.serviceType, this.key.getFactoryInterface(), string);
        }
        if (!protocolKey.getFactoryInterface().isAssignableFrom(this.key.getFactoryInterface())) {
            return false;
        }
        return this.serviceType.isSameService(this.key.getIdentifier(), string);
    }

    boolean isActiveService() {
        TopService topService = this;
        synchronized (topService) {
            boolean bl = this.topModule != null;
            Object var2_3 = null;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    boolean isActiveService(ProtocolKey protocolKey) {
        block11: {
            TopService topService = this;
            // MONITORENTER : topService
            if (this.inShutdown) {
                boolean bl = false;
                Object var3_9 = null;
                // MONITOREXIT : topService
                return bl;
            }
            if (!this.isPotentialService(protocolKey)) {
                boolean bl = false;
                Object var3_10 = null;
                // MONITOREXIT : topService
                return bl;
            }
            if (this.topModule != null) {
                boolean bl = true;
                Object var3_11 = null;
                // MONITOREXIT : topService
                return bl;
            }
            while (true) {
                if (this.inShutdown || this.topModule != null) {
                    if (this.inShutdown) {
                        break;
                    }
                    break block11;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    boolean bl = false;
                    Object var3_12 = null;
                    // MONITOREXIT : topService
                    return bl;
                }
            }
            boolean bl = false;
            Object var3_13 = null;
            // MONITOREXIT : topService
            return bl;
        }
        boolean bl = true;
        Object var3_14 = null;
        // MONITOREXIT : topService
        return bl;
    }

    protected synchronized Object findModule(ProtocolKey protocolKey, boolean bl, Properties properties) {
        ModuleInstance moduleInstance = (ModuleInstance)this.protocolTable.get(protocolKey);
        if (moduleInstance == null) {
            return null;
        }
        Object object = moduleInstance.getInstance();
        if (bl || BaseMonitor.canSupport(object, properties)) {
            return object;
        }
        return null;
    }

    Object bootModule(boolean bl, Object object, ProtocolKey protocolKey, Properties properties) throws StandardException {
        TopService topService = this;
        synchronized (topService) {
            if (this.inShutdown) {
                throw StandardException.newException("08006.D", this.getKey().getIdentifier());
            }
        }
        Object object2 = this.findModule(protocolKey, false, properties);
        if (object2 != null) {
            return object2;
        }
        if (this.monitor.reportOn) {
            this.monitor.report("Booting Module   " + protocolKey.toString() + " create = " + bl);
        }
        topService = this;
        synchronized (topService) {
            int n = 0;
            while (n < this.moduleInstances.size()) {
                ModuleInstance moduleInstance = (ModuleInstance)this.moduleInstances.elementAt(n);
                if (moduleInstance.isTypeAndName(null, protocolKey.getFactoryInterface(), protocolKey.getIdentifier()) && BaseMonitor.canSupport(object2 = moduleInstance.getInstance(), properties) && this.addToProtocol(protocolKey, moduleInstance)) {
                    if (this.monitor.reportOn) {
                        this.monitor.report("Started Module   " + protocolKey.toString());
                        this.monitor.report("  Implementation " + object2.getClass().getName());
                    }
                    Object object3 = object2;
                    Object var6_13 = null;
                    return object3;
                }
                ++n;
            }
        }
        object2 = this.monitor.loadInstance(protocolKey.getFactoryInterface(), properties);
        if (object2 == null) {
            throw Monitor.missingImplementation(protocolKey.getFactoryInterface().getName());
        }
        ModuleInstance moduleInstance = new ModuleInstance(object2, protocolKey.getIdentifier(), object, this.topModule == null ? null : this.topModule.getInstance());
        this.moduleInstances.addElement(moduleInstance);
        try {
            BaseMonitor.boot(object2, bl, properties);
        }
        catch (StandardException standardException) {
            this.moduleInstances.removeElement(moduleInstance);
            throw standardException;
        }
        topService = this;
        synchronized (topService) {
            if (this.addToProtocol(protocolKey, moduleInstance)) {
                if (this.monitor.reportOn) {
                    this.monitor.report("Started Module   " + protocolKey.toString());
                    this.monitor.report("  Implementation " + moduleInstance.getInstance().getClass().getName());
                }
                Object object4 = moduleInstance.getInstance();
                Object var6_14 = null;
                return object4;
            }
        }
        TopService.stop(object2);
        this.moduleInstances.removeElement(moduleInstance);
        return this.findModule(protocolKey, true, properties);
    }

    boolean shutdown() {
        TopService topService = this;
        synchronized (topService) {
            if (this.inShutdown) {
                boolean bl = false;
                Object var2_3 = null;
                return bl;
            }
            this.inShutdown = true;
            this.notifyAll();
        }
        while (true) {
            ModuleInstance moduleInstance;
            TopService topService2 = this;
            synchronized (topService2) {
                if (this.moduleInstances.isEmpty()) {
                    boolean bl = true;
                    Object var6_8 = null;
                    return bl;
                }
                moduleInstance = (ModuleInstance)this.moduleInstances.elementAt(0);
            }
            Object object = moduleInstance.getInstance();
            TopService.stop(object);
            topService2 = this;
            synchronized (topService2) {
                this.moduleInstances.removeElementAt(0);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean addToProtocol(ProtocolKey protocolKey, ModuleInstance moduleInstance) {
        String string = moduleInstance.getIdentifier();
        TopService topService = this;
        synchronized (topService) {
            Object v = this.protocolTable.get(protocolKey);
            if (v == null) {
                this.protocolTable.put(protocolKey, moduleInstance);
                return true;
            }
            if (v != moduleInstance) return false;
            return true;
        }
    }

    protected boolean inService(Object object) {
        int n = 0;
        while (n < this.moduleInstances.size()) {
            ModuleInstance moduleInstance = (ModuleInstance)this.moduleInstances.elementAt(n);
            if (moduleInstance.getInstance() == object) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public ProtocolKey getKey() {
        return this.key;
    }

    PersistentService getServiceType() {
        return this.serviceType;
    }

    private static void stop(Object object) {
        if (object instanceof ModuleControl) {
            ((ModuleControl)object).stop();
        }
    }

    TopService(BaseMonitor baseMonitor) {
        this.monitor = baseMonitor;
        this.protocolTable = new Hashtable();
        this.moduleInstances = new Vector(0, 5);
    }

    TopService(BaseMonitor baseMonitor, ProtocolKey protocolKey, PersistentService persistentService, Locale locale) {
        this(baseMonitor);
        this.key = protocolKey;
        this.serviceType = persistentService;
        this.serviceLocale = locale;
    }
}

