/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.util.Hashtable;
import java.util.Properties;
import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.BaseTypeIdImpl;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.catalog.types.TypeDescriptorImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.UniqueTupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;

public class SYSCOLUMNSRowFactory
extends CatalogRowFactory {
    static final String TABLENAME_STRING = "SYSCOLUMNS";
    public static final String OLD_REFERENCEID_NAME = "TABLEID";
    protected static final int SYSCOLUMNS_COLUMN_COUNT = 9;
    protected static final int SYSCOLUMNS_TABLEID = 1;
    protected static final int SYSCOLUMNS_REFERENCEID = 1;
    protected static final int SYSCOLUMNS_COLUMNNAME = 2;
    protected static final int SYSCOLUMNS_COLUMNNUMBER = 3;
    protected static final int SYSCOLUMNS_COLUMNDATATYPE = 4;
    protected static final int SYSCOLUMNS_COLUMNDEFAULT = 5;
    protected static final int SYSCOLUMNS_COLUMNDEFAULTID = 6;
    protected static final int SYSCOLUMNS_AUTOINCREMENTVALUE = 7;
    protected static final int SYSCOLUMNS_AUTOINCREMENTSTART = 8;
    protected static final int SYSCOLUMNS_AUTOINCREMENTINC = 9;
    protected static final int SYSCOLUMNS_INDEX1_ID = 0;
    protected static final int SYSCOLUMNS_INDEX2_ID = 1;
    protected static final String REFERENCEDID_STRING = "REFERENCEID";
    protected static final String COLUMNNAME_STRING = "COLUMNNAME";
    protected static final String COLUMNDEFAULTID_STRING = "COLUMNDEFAULTID";
    private static final boolean[] uniqueness = new boolean[]{true, false};
    private static final String[] uuids = new String[]{"8000001e-00d0-fd77-3ed8-000a0a0b1900", "80000029-00d0-fd77-3ed8-000a0a0b1900", "80000020-00d0-fd77-3ed8-000a0a0b1900", "6839c016-00d9-2829-dfcd-000a0a411400"};
    private static final int[][] indexColumnPositions = new int[][]{{1, 2}, {6}};
    private static final String[][] indexColumnNames = new String[][]{{"REFERENCEID", "COLUMNNAME"}, {"COLUMNDEFAULTID"}};
    private SystemColumn[] columnList;

    public ExecRow makeRow(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2) throws StandardException {
        String string = null;
        String string2 = null;
        String string3 = null;
        Integer n = null;
        TypeDescriptorImpl typeDescriptorImpl = null;
        Object object = null;
        long l = 0L;
        long l2 = 0L;
        if (tupleDescriptor != null) {
            ColumnDescriptor columnDescriptor = (ColumnDescriptor)tupleDescriptor;
            typeDescriptorImpl = columnDescriptor.getType().getCatalogType();
            string3 = columnDescriptor.getReferencingUUID().toString();
            string = columnDescriptor.getColumnName();
            n = new Integer(columnDescriptor.getPosition());
            l = columnDescriptor.getAutoincStart();
            l2 = columnDescriptor.getAutoincInc();
            object = columnDescriptor.getDefaultInfo() != null ? columnDescriptor.getDefaultInfo() : columnDescriptor.getDefaultValue();
            if (columnDescriptor.getDefaultUUID() != null) {
                string2 = columnDescriptor.getDefaultUUID().toString();
            }
        }
        ExecRow execRow = this.getExecutionFactory().getValueRow(9);
        execRow.setColumn(1, this.dvf.getCharDataValue(string3));
        execRow.setColumn(2, this.dvf.getVarcharDataValue(string));
        execRow.setColumn(3, this.dvf.getDataValue(n));
        execRow.setColumn(4, this.dvf.getDataValue(typeDescriptorImpl));
        execRow.setColumn(5, this.dvf.getDataValue(object));
        execRow.setColumn(6, this.dvf.getCharDataValue(string2));
        if (l2 != 0L) {
            execRow.setColumn(7, new SQLLongint(l));
            execRow.setColumn(8, new SQLLongint(l));
            execRow.setColumn(9, new SQLLongint(l2));
        } else {
            execRow.setColumn(7, new SQLLongint());
            execRow.setColumn(8, new SQLLongint());
            execRow.setColumn(9, new SQLLongint());
        }
        return execRow;
    }

    public Properties getCreateHeapProperties() {
        Properties properties = new Properties();
        ((Hashtable)properties).put("derby.storage.pageSize", "4096");
        ((Hashtable)properties).put("derby.storage.pageReservedSpace", "0");
        ((Hashtable)properties).put("derby.storage.minimumRecordSize", "1");
        return properties;
    }

    public Properties getCreateIndexProperties(int n) {
        Properties properties = new Properties();
        ((Hashtable)properties).put("derby.storage.pageSize", "4096");
        return properties;
    }

    public ExecIndexRow buildEmptyIndexRow(int n, RowLocation rowLocation) throws StandardException {
        int n2 = this.getIndexColumnCount(n);
        ExecIndexRow execIndexRow = this.getExecutionFactory().getIndexableRow(n2 + 1);
        execIndexRow.setColumn(n2 + 1, rowLocation);
        switch (n) {
            case 0: {
                execIndexRow.setColumn(1, this.getDataValueFactory().getCharDataValue(null));
                execIndexRow.setColumn(2, this.getDataValueFactory().getVarcharDataValue(null));
                break;
            }
            case 1: {
                execIndexRow.setColumn(1, this.getDataValueFactory().getCharDataValue(null));
                break;
            }
        }
        return execIndexRow;
    }

    public TupleDescriptor buildDescriptor(ExecRow execRow, TupleDescriptor tupleDescriptor, DataDictionary dataDictionary) throws StandardException {
        DefaultInfoImpl defaultInfoImpl = null;
        DataValueDescriptor dataValueDescriptor = null;
        UUID uUID = null;
        UUID uUID2 = null;
        UUIDFactory uUIDFactory = this.getUUIDFactory();
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        uUID2 = tupleDescriptor != null ? ((UniqueTupleDescriptor)((Object)tupleDescriptor)).getUUID() : uUIDFactory.recreateUUID(execRow.getColumn(1).getString());
        Object object = execRow.getColumn(5).getObject();
        if (object instanceof DataValueDescriptor) {
            dataValueDescriptor = (DataValueDescriptor)object;
        } else if (object instanceof DefaultInfoImpl) {
            defaultInfoImpl = (DefaultInfoImpl)object;
            dataValueDescriptor = defaultInfoImpl.getDefaultValue();
        }
        String string = execRow.getColumn(6).getString();
        if (string != null) {
            uUID = uUIDFactory.recreateUUID(string);
        }
        String string2 = execRow.getColumn(2).getString();
        int n = execRow.getColumn(3).getInt();
        TypeDescriptorImpl typeDescriptorImpl = (TypeDescriptorImpl)execRow.getColumn(4).getObject();
        BaseTypeIdImpl baseTypeIdImpl = typeDescriptorImpl.getTypeId();
        TypeId typeId = (TypeId)Monitor.newInstanceFromIdentifier(baseTypeIdImpl.wrapperTypeFormatId());
        typeId.setNestedTypeId(baseTypeIdImpl);
        DataTypeDescriptor dataTypeDescriptor = new DataTypeDescriptor(typeDescriptorImpl, typeId);
        long l = execRow.getColumn(8).getLong();
        long l2 = execRow.getColumn(9).getLong();
        boolean bl = l2 != 0L;
        DataValueDescriptor dataValueDescriptor2 = execRow.getColumn(8);
        l = dataValueDescriptor2.getLong();
        dataValueDescriptor2 = execRow.getColumn(9);
        l2 = dataValueDescriptor2.getLong();
        ColumnDescriptor columnDescriptor = new ColumnDescriptor(string2, n, dataTypeDescriptor, dataValueDescriptor, (DefaultInfo)defaultInfoImpl, uUID2, uUID, l, l2, bl);
        return columnDescriptor;
    }

    public int getPrimaryKeyIndexNumber() {
        return 0;
    }

    public SystemColumn[] buildColumnList() {
        if (this.columnList != null) {
            return this.columnList;
        }
        this.columnList = new SystemColumn[9];
        this.columnList[0] = new SystemColumnImpl(this.convertIdCase(REFERENCEDID_STRING), 1, 0, 0, false, "CHAR", true, 36);
        this.columnList[1] = new SystemColumnImpl(this.convertIdCase(COLUMNNAME_STRING), 2, false);
        this.columnList[2] = new SystemColumnImpl(this.convertIdCase("COLUMNNUMBER"), 3, 0, 0, false, "INTEGER", true, 4);
        this.columnList[3] = new SystemColumnImpl(this.convertIdCase("COLUMNDATATYPE"), 4, 0, 0, false, "org.apache.derby.catalog.TypeDescriptor", false, -1);
        this.columnList[4] = new SystemColumnImpl(this.convertIdCase("COLUMNDEFAULT"), 5, 0, 0, true, "java.io.Serializable", false, -1);
        this.columnList[5] = new SystemColumnImpl(this.convertIdCase(COLUMNDEFAULTID_STRING), 6, 0, 0, true, "CHAR", true, 36);
        this.columnList[6] = new SystemColumnImpl(this.convertIdCase("AUTOINCREMENTVALUE"), 7, 0, 0, true, "BIGINT", true, 8);
        this.columnList[7] = new SystemColumnImpl(this.convertIdCase("AUTOINCREMENTSTART"), 8, 0, 0, true, "BIGINT", true, 8);
        this.columnList[8] = new SystemColumnImpl(this.convertIdCase("AUTOINCREMENTINC"), 9, 0, 0, true, "BIGINT", true, 8);
        return this.columnList;
    }

    public SYSCOLUMNSRowFactory(UUIDFactory uUIDFactory, ExecutionFactory executionFactory, DataValueFactory dataValueFactory, boolean bl) {
        this(uUIDFactory, executionFactory, dataValueFactory, bl, TABLENAME_STRING);
    }

    public SYSCOLUMNSRowFactory(UUIDFactory uUIDFactory, ExecutionFactory executionFactory, DataValueFactory dataValueFactory, boolean bl, String string) {
        super(uUIDFactory, executionFactory, dataValueFactory, bl);
        this.initInfo(9, string, indexColumnPositions, indexColumnNames, uniqueness, uuids);
    }
}

