/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.TableElementList;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;

public class AlterTableNode
extends DDLStatementNode {
    public TableElementList tableElementList = null;
    public char lockGranularity;
    public boolean compressTable = false;
    public boolean sequential = false;
    public int behavior;
    public TableDescriptor baseTable;
    protected int numConstraints;
    private int changeType = 0;
    private boolean truncateTable = false;
    protected SchemaDescriptor schemaDescriptor = null;
    protected ColumnInfo[] colInfos = null;
    protected ConstraintConstantAction[] conActions = null;

    public void init(Object object) throws StandardException {
        throw StandardException.newException("0A000.S", "truncate table");
    }

    public void init(Object object, Object object2) throws StandardException {
        this.initAndCheck(object);
        this.sequential = (Boolean)object2;
        this.compressTable = true;
        this.schemaDescriptor = this.getSchemaDescriptor();
    }

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) throws StandardException {
        this.initAndCheck(object);
        this.tableElementList = (TableElementList)object2;
        this.lockGranularity = ((Character)object3).charValue();
        int[] nArray = (int[])object4;
        int[] nArray2 = (int[])object5;
        this.changeType = nArray[0];
        this.behavior = nArray2[0];
        boolean[] blArray = (boolean[])object6;
        this.sequential = blArray[0];
        switch (this.changeType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw StandardException.newException("0A000.S");
            }
        }
        this.schemaDescriptor = this.getSchemaDescriptor();
    }

    public String toString() {
        return "";
    }

    public String statementToString() {
        if (this.truncateTable) {
            return "TRUNCATE TABLE";
        }
        return "ALTER TABLE";
    }

    public int getChangeType() {
        return this.changeType;
    }

    public QueryTreeNode bind() throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        int n = 0;
        int n2 = 0;
        this.baseTable = this.getTableDescriptor();
        if (this.baseTable.getTableType() == 3) {
            throw StandardException.newException("42995");
        }
        this.getCompilerContext().createDependency(this.baseTable);
        if (this.tableElementList != null) {
            this.tableElementList.validate(this, dataDictionary, this.baseTable);
            if (this.tableElementList.countNumberOfColumns() + this.baseTable.getNumberOfColumns() > 1012) {
                throw StandardException.newException("54011", String.valueOf(this.tableElementList.countNumberOfColumns() + this.baseTable.getNumberOfColumns()), (Object)this.getRelativeName(), (Object)String.valueOf(1012));
            }
            n2 = this.tableElementList.countConstraints(2) + this.tableElementList.countConstraints(6) + this.tableElementList.countConstraints(3);
            n = this.tableElementList.countConstraints(4);
        }
        if (n2 + this.baseTable.getTotalNumberOfIndexes() > Short.MAX_VALUE) {
            throw StandardException.newException("42Z9F", String.valueOf(n2 + this.baseTable.getTotalNumberOfIndexes()), (Object)this.getRelativeName(), (Object)String.valueOf(Short.MAX_VALUE));
        }
        if (n > 0) {
            FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
            FromBaseTable fromBaseTable = (FromBaseTable)this.getNodeFactory().getNode(135, this.getObjectName(), null, null, null, this.getContextManager());
            fromList.addFromTable(fromBaseTable);
            fromList.bindTables(dataDictionary, (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()));
            this.tableElementList.appendNewColumnsToRCL(fromBaseTable);
            this.tableElementList.bindAndValidateCheckConstraints(fromList);
        }
        this.getCompilerContext().createDependency(this.baseTable);
        return this;
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.isSessionSchema(this.baseTable.getSchemaName());
    }

    public ConstantAction makeConstantAction() throws StandardException {
        this.prepConstantAction();
        return this.getGenericConstantActionFactory().getAlterTableConstantAction(this.schemaDescriptor, this.getRelativeName(), this.baseTable.getUUID(), this.baseTable.getHeapConglomerateId(), 0, this.colInfos, this.conActions, null, null, null, null, null, null, this.lockGranularity, this.compressTable, this.behavior, this.sequential, this.truncateTable);
    }

    public void prepConstantAction() throws StandardException {
        if (this.tableElementList != null) {
            this.genColumnInfo();
        }
        if (this.numConstraints > 0) {
            this.conActions = new ConstraintConstantAction[this.numConstraints];
            this.tableElementList.genConstraintActions(this.conActions, this.getRelativeName(), this.schemaDescriptor, this.getDataDictionary());
        }
    }

    public void genColumnInfo() {
        this.colInfos = new ColumnInfo[this.tableElementList.countNumberOfColumns()];
        this.numConstraints = this.tableElementList.genColumnInfos(this.colInfos);
    }
}

