/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.CreateStatementNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.TriggerReferencingStruct;

public class CreateTriggerNode
extends CreateStatementNode {
    private TableName triggerName;
    private TableName tableName;
    private int triggerEventMask;
    private ResultColumnList triggerCols;
    private boolean isBefore;
    private boolean isRow;
    private boolean isEnabled;
    private Vector refClause;
    private QueryTreeNode whenClause;
    private String whenText;
    private int whenOffset;
    private StatementNode actionNode;
    private String actionText;
    private String originalActionText;
    private int actionOffset;
    private SchemaDescriptor triggerSchemaDescriptor;
    private SchemaDescriptor compSchemaDescriptor;
    private int[] referencedColInts;
    private TableDescriptor triggerTableDescriptor;
    private UUID actionCompSchemaId;
    private String oldTableName;
    private String newTableName;
    private boolean oldTableInReferencingClause;
    private boolean newTableInReferencingClause;
    private static /* synthetic */ Class class$Lorg$apache$derby$impl$sql$compile$ColumnReference;
    private static /* synthetic */ Class class$Lorg$apache$derby$impl$sql$compile$FromBaseTable;

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13, Object object14) throws StandardException {
        this.initAndCheck(object);
        this.triggerName = (TableName)object;
        this.tableName = (TableName)object2;
        this.triggerEventMask = (Integer)object3;
        this.triggerCols = (ResultColumnList)object4;
        this.isBefore = (Boolean)object5;
        this.isRow = (Boolean)object6;
        this.isEnabled = (Boolean)object7;
        this.refClause = (Vector)object8;
        this.whenClause = (QueryTreeNode)object9;
        this.whenText = object10 == null ? null : ((String)object10).trim();
        this.whenOffset = (Integer)object11;
        this.actionNode = (StatementNode)object12;
        this.originalActionText = (String)object13;
        this.actionText = object13 == null ? null : ((String)object13).trim();
        this.actionOffset = (Integer)object14;
        this.implicitCreateSchema = true;
    }

    public String statementToString() {
        return "CREATE TRIGGER";
    }

    public void printSubNodes(int n) {
    }

    public QueryTreeNode bind() throws StandardException {
        LanguageConnectionContext languageConnectionContext;
        CompilerContext compilerContext;
        block9: {
            compilerContext = this.getCompilerContext();
            DataDictionary dataDictionary = this.getDataDictionary();
            languageConnectionContext = this.getLanguageConnectionContext();
            this.compSchemaDescriptor = languageConnectionContext.getDefaultSchema();
            this.triggerSchemaDescriptor = this.getSchemaDescriptor();
            this.triggerTableDescriptor = this.getTableDescriptor(this.tableName);
            if (this.isSessionSchema(this.triggerTableDescriptor.getSchemaDescriptor())) {
                throw StandardException.newException("XCL478.S");
            }
            boolean bl = this.bindReferencesClause(dataDictionary);
            languageConnectionContext.pushTriggerTable(this.triggerTableDescriptor);
            try {
                if (bl) {
                    compilerContext.setReliability(0);
                }
                this.actionNode.bind();
                if (this.whenClause == null) break block9;
                this.whenClause.bind();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                languageConnectionContext.popTriggerTable(this.triggerTableDescriptor);
                throw throwable;
            }
        }
        Object var6_5 = null;
        languageConnectionContext.popTriggerTable(this.triggerTableDescriptor);
        compilerContext.createDependency(this.triggerTableDescriptor);
        if (this.triggerCols != null && this.triggerCols.size() != 0) {
            this.referencedColInts = new int[this.triggerCols.size()];
            Hashtable<String, ResultColumn> hashtable = new Hashtable<String, ResultColumn>();
            int n = this.triggerCols.size();
            int n2 = 0;
            while (n2 < n) {
                ResultColumn resultColumn = (ResultColumn)this.triggerCols.elementAt(n2);
                if (hashtable.put(resultColumn.getName(), resultColumn) != null) {
                    throw StandardException.newException("42Y40", resultColumn.getName(), (Object)this.triggerName);
                }
                ColumnDescriptor columnDescriptor = this.triggerTableDescriptor.getColumnDescriptor(resultColumn.getName());
                if (columnDescriptor == null) {
                    throw StandardException.newException("42X14", resultColumn.getName(), (Object)this.tableName);
                }
                this.referencedColInts[n2] = columnDescriptor.getPosition();
                ++n2;
            }
            Arrays.sort(this.referencedColInts);
        }
        if (this.actionNode.referencesSessionSchema()) {
            throw StandardException.newException("XCL478.S");
        }
        return this;
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.isSessionSchema(this.triggerTableDescriptor.getSchemaName()) || this.actionNode.referencesSessionSchema();
    }

    private boolean bindReferencesClause(DataDictionary dataDictionary) throws StandardException {
        this.validateReferencesClause(dataDictionary);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = 0;
        if (this.isRow) {
            CollectNodesVisitor collectNodesVisitor = new CollectNodesVisitor(class$Lorg$apache$derby$impl$sql$compile$ColumnReference != null ? class$Lorg$apache$derby$impl$sql$compile$ColumnReference : (class$Lorg$apache$derby$impl$sql$compile$ColumnReference = CreateTriggerNode.class$("org.apache.derby.impl.sql.compile.ColumnReference")));
            this.actionNode.accept(collectNodesVisitor);
            Vector vector = collectNodesVisitor.getList();
            QueryTreeNode[] queryTreeNodeArray = this.sortRefs(vector, true);
            int n2 = 0;
            while (n2 < queryTreeNodeArray.length) {
                ColumnReference columnReference = (ColumnReference)queryTreeNodeArray[n2];
                TableName tableName = columnReference.getTableNameNode();
                if (tableName != null && (this.oldTableName != null && this.oldTableName.equals(tableName.getTableName()) || this.newTableName != null && this.newTableName.equals(tableName.getTableName()))) {
                    int n3 = tableName.getTokenBeginOffset();
                    int n4 = tableName.getTokenEndOffset();
                    if (n3 != -1) {
                        bl = true;
                        this.checkInvalidTriggerReference(tableName.getTableName());
                        String string = columnReference.getColumnName();
                        int n5 = columnReference.getTokenEndOffset() - columnReference.getTokenBeginOffset() + 1;
                        stringBuffer.append(this.originalActionText.substring(n, n3 - this.actionOffset));
                        stringBuffer.append(this.genColumnReferenceSQL(dataDictionary, string, tableName.getTableName(), tableName.getTableName().equals(this.oldTableName)));
                        n = n4 - this.actionOffset + n5 + 2;
                    }
                }
                ++n2;
            }
        } else {
            CollectNodesVisitor collectNodesVisitor = new CollectNodesVisitor(class$Lorg$apache$derby$impl$sql$compile$FromBaseTable != null ? class$Lorg$apache$derby$impl$sql$compile$FromBaseTable : (class$Lorg$apache$derby$impl$sql$compile$FromBaseTable = CreateTriggerNode.class$("org.apache.derby.impl.sql.compile.FromBaseTable")));
            this.actionNode.accept(collectNodesVisitor);
            Vector vector = collectNodesVisitor.getList();
            QueryTreeNode[] queryTreeNodeArray = this.sortRefs(vector, false);
            int n6 = 0;
            while (n6 < queryTreeNodeArray.length) {
                FromBaseTable fromBaseTable = (FromBaseTable)queryTreeNodeArray[n6];
                String string = fromBaseTable.getTableName().getTableName();
                String string2 = fromBaseTable.getBaseTableName();
                if (string2 != null && (this.oldTableName != null && this.oldTableName.equals(string2) || this.newTableName != null && this.newTableName.equals(string2))) {
                    int n7 = fromBaseTable.getTableNameField().getTokenBeginOffset();
                    int n8 = fromBaseTable.getTableNameField().getTokenEndOffset();
                    if (n7 != -1) {
                        this.checkInvalidTriggerReference(string2);
                        bl = true;
                        stringBuffer.append(this.originalActionText.substring(n, n7 - this.actionOffset));
                        stringBuffer.append(string2.equals(this.oldTableName) ? "new org.apache.derby.catalog.TriggerOldTransitionRows() " : "new org.apache.derby.catalog.TriggerNewTransitionRows() ");
                        if (string.equals(string2)) {
                            stringBuffer.append(string2).append(" ");
                        }
                        n = n8 - this.actionOffset + 1;
                    }
                }
                ++n6;
            }
        }
        if (bl) {
            if (n < this.originalActionText.length()) {
                stringBuffer.append(this.originalActionText.substring(n));
            }
            this.actionText = stringBuffer.toString();
            this.actionNode = (StatementNode)this.reparseTriggerText(this.actionText);
        }
        return bl;
    }

    private QueryTreeNode[] sortRefs(Vector vector, boolean bl) {
        int n = vector.size();
        QueryTreeNode[] queryTreeNodeArray = new QueryTreeNode[n];
        int n2 = 0;
        Object object = vector.elements();
        while (object.hasMoreElements()) {
            queryTreeNodeArray[n2++] = bl ? (ColumnReference)object.nextElement() : (FromBaseTable)object.nextElement();
        }
        n2 = 0;
        while (n2 < n - 1) {
            object = null;
            int n3 = 0;
            while (n3 < n - n2 - 1) {
                if (bl && ((ColumnReference)queryTreeNodeArray[n3]).getTokenBeginOffset() > ((ColumnReference)queryTreeNodeArray[n3 + 1]).getTokenBeginOffset() || !bl && ((FromBaseTable)queryTreeNodeArray[n3]).getTableNameField().getTokenBeginOffset() > ((FromBaseTable)queryTreeNodeArray[n3 + 1]).getTableNameField().getTokenBeginOffset()) {
                    object = queryTreeNodeArray[n3];
                    queryTreeNodeArray[n3] = queryTreeNodeArray[n3 + 1];
                    queryTreeNodeArray[n3 + 1] = object;
                }
                ++n3;
            }
            if (object == null) break;
            ++n2;
        }
        return queryTreeNodeArray;
    }

    private QueryTreeNode reparseTriggerText(String string) throws StandardException {
        LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
        CompilerContext compilerContext = languageConnectionContext.pushCompilerContext();
        compilerContext.setReliability(0);
        try {
            QueryTreeNode queryTreeNode = QueryTreeNode.parseQueryText(compilerContext, string, null, languageConnectionContext);
            Object var5_5 = null;
            languageConnectionContext.popCompilerContext(compilerContext);
            return queryTreeNode;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            languageConnectionContext.popCompilerContext(compilerContext);
            throw throwable;
        }
    }

    private String genColumnReferenceSQL(DataDictionary dataDictionary, String string, String string2, boolean bl) throws StandardException {
        ColumnDescriptor columnDescriptor = null;
        columnDescriptor = this.triggerTableDescriptor.getColumnDescriptor(string);
        if (columnDescriptor == null) {
            throw StandardException.newException("42X04", string2 + "." + string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("cast (org.apache.derby.iapi.db.Factory::getTriggerExecutionContext().");
        stringBuffer.append(bl ? "getOldRow()" : "getNewRow()");
        stringBuffer.append(".getObject('" + string + "') AS ");
        DataTypeDescriptor dataTypeDescriptor = columnDescriptor.getType();
        TypeId typeId = dataTypeDescriptor.getTypeId();
        stringBuffer.append((typeId.systemBuiltIn() ? dataTypeDescriptor.getSQLstring() : typeId.getSQLTypeName()) + ") ");
        return stringBuffer.toString();
    }

    private void checkInvalidTriggerReference(String string) throws StandardException {
        if (string.equals(this.oldTableName) && (this.triggerEventMask & 4) == 4) {
            throw StandardException.newException("42Y92", "INSERT", (Object)"new");
        }
        if (string.equals(this.newTableName) && (this.triggerEventMask & 2) == 2) {
            throw StandardException.newException("42Y92", "DELETE", (Object)"old");
        }
    }

    private void validateReferencesClause(DataDictionary dataDictionary) throws StandardException {
        if (this.refClause == null || this.refClause.size() == 0) {
            return;
        }
        Enumeration enumeration = this.refClause.elements();
        while (enumeration.hasMoreElements()) {
            TriggerReferencingStruct triggerReferencingStruct = (TriggerReferencingStruct)enumeration.nextElement();
            if (this.isRow && !triggerReferencingStruct.isRow) {
                throw StandardException.newException("42Y92", "ROW", (Object)"row");
            }
            if (!this.isRow && triggerReferencingStruct.isRow) {
                throw StandardException.newException("42Y92", "STATEMENT", (Object)"table");
            }
            if (triggerReferencingStruct.isNew) {
                if (this.newTableInReferencingClause) {
                    throw StandardException.newException("42Y93");
                }
                if ((this.triggerEventMask & 2) == 2) {
                    throw StandardException.newException("42Y92", "DELETE", (Object)"old");
                }
                this.newTableName = triggerReferencingStruct.identifier;
                this.newTableInReferencingClause = true;
            } else {
                if (this.oldTableInReferencingClause) {
                    throw StandardException.newException("42Y93");
                }
                if ((this.triggerEventMask & 4) == 4) {
                    throw StandardException.newException("42Y92", "INSERT", (Object)"new");
                }
                this.oldTableName = triggerReferencingStruct.identifier;
                this.oldTableInReferencingClause = true;
            }
            if (!this.isBefore || triggerReferencingStruct.isRow) continue;
            throw StandardException.newException("42Y92", "BEFORE", (Object)"row");
        }
    }

    public ConstantAction makeConstantAction() throws StandardException {
        String string = this.oldTableInReferencingClause ? this.oldTableName : null;
        String string2 = this.newTableInReferencingClause ? this.newTableName : null;
        return this.getGenericConstantActionFactory().getCreateTriggerConstantAction(this.triggerSchemaDescriptor.getSchemaName(), this.getRelativeName(), this.triggerEventMask, this.isBefore, this.isRow, this.isEnabled, this.triggerTableDescriptor, null, this.whenText, null, this.actionText, this.actionCompSchemaId == null ? this.compSchemaDescriptor.getUUID() : this.actionCompSchemaId, null, this.referencedColInts, this.originalActionText, this.oldTableInReferencingClause, this.newTableInReferencingClause, string, string2);
    }

    public String toString() {
        return "";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

