/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.lang.reflect.Member;
import java.util.Vector;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.JSQLType;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaToSQLValueNode;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.SQLToJavaValueNode;
import org.apache.derby.impl.sql.compile.SubqueryList;

public abstract class MethodCallNode
extends JavaValueNode {
    protected String methodName;
    protected String javaClassName;
    RoutineAliasInfo routineInfo;
    boolean internalCall;
    private String[] procedurePrimitiveArrayType;
    protected JSQLType[] signature;
    protected JavaValueNode[] methodParms;
    protected Member method;
    protected String actualMethodReturnType;
    String[] methodParameterTypes;

    public JSQLType[] getSignature() {
        return this.signature;
    }

    public void init(Object object) {
        this.methodName = (String)object;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public void setClause(int n) {
        super.setClause(n);
        if (this.methodParms != null) {
            int n2 = 0;
            while (n2 < this.methodParms.length) {
                if (this.methodParms[n2] != null) {
                    this.methodParms[n2].setClause(n);
                }
                ++n2;
            }
        }
    }

    public void addParms(JavaValueNode[] javaValueNodeArray) {
        this.methodParms = javaValueNodeArray;
    }

    public void addParms(Vector vector) throws StandardException {
        this.methodParms = new JavaValueNode[vector.size()];
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            QueryTreeNode queryTreeNode = (QueryTreeNode)vector.elementAt(n2);
            if (!(queryTreeNode instanceof JavaValueNode)) {
                queryTreeNode = queryTreeNode instanceof JavaToSQLValueNode ? ((JavaToSQLValueNode)queryTreeNode).getJavaValueNode() : (SQLToJavaValueNode)this.getNodeFactory().getNode(28, queryTreeNode, this.getContextManager());
            }
            this.methodParms[n2] = (JavaValueNode)queryTreeNode;
            ++n2;
        }
    }

    public void printSubNodes(int n) {
    }

    public String toString() {
        return "";
    }

    final void bindParameters(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        if (this.methodParms != null) {
            int n = this.methodParms.length;
            if (this.signature == null) {
                this.signature = new JSQLType[n];
            }
            int n2 = 0;
            while (n2 < n) {
                if (this.methodParms[n2] != null) {
                    String string;
                    this.methodParms[n2] = this.methodParms[n2].bindExpression(fromList, subqueryList, vector);
                    if (this.routineInfo == null) {
                        this.signature[n2] = this.methodParms[n2].getJSQLType();
                    }
                    if (this.signature[n2] != null && ((string = this.signature[n2].getSQLType().getTypeId().getSQLTypeName()).equals("BLOB") || string.equals("CLOB") || string.equals("NCLOB"))) {
                        throw StandardException.newException("XJ082.U");
                    }
                }
                ++n2;
            }
        }
    }

    protected boolean areParametersQueryInvariant() throws StandardException {
        return this.getVariantTypeOfParams() == 2;
    }

    void throwNoMethodFound(String string, String[] stringArray, String[] stringArray2) throws StandardException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[n].length() != 0 ? stringArray[n] : "UNTYPED");
            if (stringArray2 != null && !stringArray2[n].equals(stringArray[n])) {
                stringBuffer.append("(" + stringArray2[n] + ")");
            }
            ++n;
        }
        throw StandardException.newException("42X50", string, (Object)this.methodName, (Object)stringBuffer);
    }

    public void preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        if (this.methodParms != null) {
            int n2 = 0;
            while (n2 < this.methodParms.length) {
                if (this.methodParms[n2] != null) {
                    this.methodParms[n2].preprocess(n, fromList, subqueryList, predicateList);
                }
                ++n2;
            }
        }
    }

    public boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        if (bl) {
            return false;
        }
        boolean bl2 = true;
        if (this.methodParms != null) {
            int n = 0;
            while (n < this.methodParms.length) {
                if (this.methodParms[n] != null) {
                    bl2 = this.methodParms[n].categorize(jBitSet, bl) && bl2;
                }
                ++n;
            }
        }
        return bl2;
    }

    public JavaValueNode remapColumnReferencesToExpressions() throws StandardException {
        if (this.methodParms != null) {
            int n = 0;
            while (n < this.methodParms.length) {
                if (this.methodParms[n] != null) {
                    this.methodParms[n] = this.methodParms[n].remapColumnReferencesToExpressions();
                }
                ++n;
            }
        }
        return this;
    }

    public int generateParameters(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        String[] stringArray = this.methodParameterTypes;
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        int n = 0;
        while (n < this.methodParms.length) {
            this.generateOneParameter(expressionClassBuilder, methodBuilder, n);
            String string = MethodCallNode.getParameterTypeName(this.methodParms[n]);
            String string2 = stringArray[n];
            if (!string2.equals(string)) {
                if (ClassInspector.primitiveType(string2)) {
                    methodBuilder.cast(string2);
                } else if (this.routineInfo == null) {
                    methodBuilder.upCast(string2);
                }
            }
            ++n;
        }
        return this.methodParms.length;
    }

    public static String getParameterTypeName(JavaValueNode javaValueNode) throws StandardException {
        String string = javaValueNode.isPrimitiveType() ? javaValueNode.getPrimitiveTypeName() : javaValueNode.getJavaTypeName();
        return string;
    }

    public void generateOneParameter(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, int n) throws StandardException {
        this.methodParms[n].generateExpression(expressionClassBuilder, methodBuilder);
    }

    public void setNullParameterInfo(String[] stringArray) throws StandardException {
        int n = 0;
        while (n < this.methodParms.length) {
            if (this.methodParms[n].getJavaTypeName().equals("")) {
                DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getSQLDataTypeDescriptor(stringArray[n]);
                ((SQLToJavaValueNode)this.methodParms[n]).value.setDescriptor(dataTypeDescriptor);
                this.methodParms[n].setJavaTypeName(stringArray[n]);
                this.signature[n] = this.methodParms[n].getJSQLType();
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void resolveMethodCall(String string, boolean bl) throws StandardException {
        Object object;
        String string2;
        if (this.routineInfo == null && !this.internalCall && (this.getCompilerContext().getReliability() & 0x400) != 0) {
            String string3;
            StringBuffer stringBuffer = new StringBuffer().append(string);
            if (bl) {
                string3 = "::";
                throw StandardException.newException("42X01", stringBuffer.append(string3).append(this.methodName).toString());
            }
            string3 = ".";
            throw StandardException.newException("42X01", stringBuffer.append(string3).append(this.methodName).toString());
        }
        int n = this.signature.length;
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        String[] stringArray = this.getObjectSignature();
        String[] stringArray2 = null;
        boolean[] blArray = this.getIsParam();
        boolean bl2 = this.routineInfo != null && n != 0 && n != this.methodParms.length;
        try {
            this.method = classInspector.findPublicMethod(string, this.methodName, stringArray, null, blArray, bl, bl2);
            if (this.routineInfo == null && this.method == null) {
                stringArray2 = this.getPrimitiveSignature(false);
                this.method = classInspector.findPublicMethod(string, this.methodName, stringArray, stringArray2, blArray, bl, bl2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.method = null;
        }
        if (this.method == null) {
            this.throwNoMethodFound(string, stringArray, stringArray2);
        }
        this.actualMethodReturnType = string2 = classInspector.getType(this.method);
        if (this.routineInfo == null) {
            if (string2.equals("void") && !this.forCallStatement) {
                throw StandardException.newException("42Y09");
            }
        } else {
            String string4;
            String string5 = null;
            object = this.routineInfo.getReturnType();
            if (object == null) {
                string4 = "void";
            } else {
                TypeId typeId = TypeId.getBuiltInTypeId(object.getJDBCTypeId());
                switch (object.getJDBCTypeId()) {
                    case -5: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: {
                        TypeCompiler typeCompiler = this.getTypeCompiler(typeId);
                        string4 = typeCompiler.getCorrespondingPrimitiveTypeName();
                        if (this.routineInfo.calledOnNullInput() || this.routineInfo.getParameterCount() == 0) break;
                        string5 = typeId.getCorrespondingJavaTypeName();
                        break;
                    }
                    default: {
                        string4 = typeId.getCorrespondingJavaTypeName();
                        break;
                    }
                }
            }
            if (!string4.equals(string2)) {
                this.throwNoMethodFound(string4 + " " + string, stringArray, stringArray2);
            }
            if (string5 != null) {
                string2 = string5;
            }
        }
        this.setJavaTypeName(string2);
        this.methodParameterTypes = classInspector.getParameterTypes(this.method);
        int n2 = 0;
        while (n2 < this.methodParameterTypes.length) {
            block25: {
                block24: {
                    object = this.methodParameterTypes[n2];
                    if (this.routineInfo == null || n2 >= this.routineInfo.getParameterCount()) break block24;
                    int n3 = this.routineInfo.getParameterModes()[n2];
                    switch (n3) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            object = ((String)object).substring(0, ((String)object).length() - 2);
                            break;
                        }
                        case 4: {
                            break block25;
                        }
                    }
                }
                if (ClassInspector.primitiveType((String)object)) {
                    this.methodParms[n2].castToPrimitive(true);
                }
            }
            ++n2;
        }
        if (this.someParametersAreNull()) {
            this.setNullParameterInfo(this.methodParameterTypes);
        }
        DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getSQLDataTypeDescriptor(string2);
        if (!this.getCompilerContext().getReturnParameterFlag()) return;
        this.getCompilerContext().getParameterTypes()[0] = dataTypeDescriptor;
    }

    protected boolean someParametersAreNull() {
        int n = this.signature.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.signature[n2] == null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected String[] getObjectSignature() throws StandardException {
        int n = this.signature.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.getObjectTypeName(this.signature[n2]);
            ++n2;
        }
        return stringArray;
    }

    protected boolean[] getIsParam() {
        if (this.methodParms == null) {
            return new boolean[0];
        }
        boolean[] blArray = new boolean[this.methodParms.length];
        int n = 0;
        while (n < this.methodParms.length) {
            if (this.methodParms[n] instanceof SQLToJavaValueNode) {
                SQLToJavaValueNode sQLToJavaValueNode = (SQLToJavaValueNode)this.methodParms[n];
                if (sQLToJavaValueNode.value.isParameterNode()) {
                    blArray[n] = true;
                }
            }
            ++n;
        }
        return blArray;
    }

    private String getObjectTypeName(JSQLType jSQLType) throws StandardException {
        if (jSQLType != null) {
            switch (jSQLType.getCategory()) {
                case 0: {
                    TypeId typeId = this.mapToTypeID(jSQLType);
                    if (typeId == null) {
                        return null;
                    }
                    switch (typeId.getJDBCTypeId()) {
                        case -5: 
                        case 4: 
                        case 5: 
                        case 7: 
                        case 8: {
                            if (this.routineInfo == null) break;
                            TypeCompiler typeCompiler = this.getTypeCompiler(typeId);
                            return typeCompiler.getCorrespondingPrimitiveTypeName();
                        }
                    }
                    return typeId.getCorrespondingJavaTypeName();
                }
                case 1: {
                    return jSQLType.getJavaClassName();
                }
                case 2: {
                    return JSQLType.primitiveNames[jSQLType.getPrimitiveKind()];
                }
            }
        }
        return "";
    }

    String[] getPrimitiveSignature(boolean bl) throws StandardException {
        int n = this.signature.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            JSQLType jSQLType = this.signature[n2];
            if (jSQLType == null) {
                stringArray[n2] = "";
            } else {
                switch (jSQLType.getCategory()) {
                    case 0: {
                        if (this.procedurePrimitiveArrayType != null && n2 < this.procedurePrimitiveArrayType.length && this.procedurePrimitiveArrayType[n2] != null) {
                            stringArray[n2] = this.procedurePrimitiveArrayType[n2];
                            break;
                        }
                        TypeId typeId = this.mapToTypeID(jSQLType);
                        if (typeId.isNumericTypeId() || typeId.isBooleanTypeId()) {
                            TypeCompiler typeCompiler = this.getTypeCompiler(typeId);
                            stringArray[n2] = typeCompiler.getCorrespondingPrimitiveTypeName();
                            if (!bl) break;
                            this.methodParms[n2].castToPrimitive(true);
                            break;
                        }
                        stringArray[n2] = typeId.getCorrespondingJavaTypeName();
                        break;
                    }
                    case 1: {
                        stringArray[n2] = jSQLType.getJavaClassName();
                        break;
                    }
                    case 2: {
                        stringArray[n2] = JSQLType.primitiveNames[jSQLType.getPrimitiveKind()];
                        if (!bl) break;
                        this.methodParms[n2].castToPrimitive(true);
                        break;
                    }
                }
            }
            ++n2;
        }
        return stringArray;
    }

    protected int getOrderableVariantType() throws StandardException {
        return this.getVariantTypeOfParams();
    }

    private int getVariantTypeOfParams() throws StandardException {
        int n = 2;
        if (this.methodParms != null) {
            int n2 = 0;
            while (n2 < this.methodParms.length) {
                if (this.methodParms[n2] != null) {
                    int n3 = this.methodParms[n2].getOrderableVariantType();
                    if (n3 < n) {
                        n = n3;
                    }
                } else {
                    n = 0;
                }
                ++n2;
            }
        }
        return n;
    }

    public JavaValueNode[] getMethodParms() {
        return this.methodParms;
    }

    public Visitable accept(Visitor visitor) throws StandardException {
        Visitable visitable = visitor.visit(this);
        if (visitor.skipChildren(this)) {
            return visitable;
        }
        int n = 0;
        while (!visitor.stopTraversal() && n < this.methodParms.length) {
            if (this.methodParms[n] != null) {
                this.methodParms[n] = (JavaValueNode)this.methodParms[n].accept(visitor);
            }
            ++n;
        }
        return visitable;
    }
}

