/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.impl.sql.execute.DDLConstantAction;
import org.apache.derby.impl.sql.execute.GenericSPSConstantAction;

public class AlterSPSConstantAction
extends GenericSPSConstantAction {
    private SchemaDescriptor sd;
    private String spsName;
    private UUID schemaId;
    private String usingText;
    private boolean invalidOnly;

    public String toString() {
        String string = "???";
        if (this.sd != null) {
            string = this.sd.getSchemaName();
        }
        return "ALTER STATEMENT " + string + "." + this.spsName;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        ArrayList<SPSDescriptor> arrayList;
        SPSDescriptor sPSDescriptor;
        boolean bl = false;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        dataDictionary.startWriting(languageConnectionContext);
        if (this.spsName != null) {
            if (this.sd == null) {
                this.sd = DDLConstantAction.getAndCheckSchemaDescriptor(dataDictionary, this.schemaId, "ALTER STATEMENT");
            }
            if ((sPSDescriptor = dataDictionary.getSPSDescriptor(this.spsName, this.sd)) == null) {
                throw StandardException.newException("X0X81.S", "STATEMENT", (Object)(this.sd.getSchemaName() + "." + this.spsName));
            }
            if (this.usingText != null) {
                sPSDescriptor.setParameterDefaults(this.getUsingResults(this.usingText));
                sPSDescriptor.setUsingText(this.usingText);
            }
            arrayList = new ArrayList<SPSDescriptor>();
            arrayList.add(sPSDescriptor);
        } else {
            bl = this.invalidOnly;
            arrayList = dataDictionary.getAllSPSDescriptors();
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            sPSDescriptor = (SPSDescriptor)iterator.next();
            if ((!bl || sPSDescriptor.isValid()) && bl) continue;
            sPSDescriptor.revalidate(languageConnectionContext);
        }
    }

    AlterSPSConstantAction(SchemaDescriptor schemaDescriptor, String string, String string2, boolean bl) {
        this.sd = schemaDescriptor;
        this.spsName = string;
        this.usingText = string2;
        this.invalidOnly = bl;
    }
}

