/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.CreateConstraintConstantAction;
import org.apache.derby.impl.sql.execute.DDLConstantAction;
import org.apache.derby.impl.sql.execute.RowUtil;

class CreateTableConstantAction
extends DDLConstantAction {
    private char lockGranularity;
    private boolean onCommitDeleteRows;
    private boolean onRollbackDeleteRows;
    private String tableName;
    private String schemaName;
    private int tableType;
    private ColumnInfo[] columnInfo;
    private CreateConstraintConstantAction[] constraintActions;
    private Properties properties;

    public String toString() {
        if (this.tableType == 3) {
            return this.constructToString("DECLARE GLOBAL TEMPORARY TABLE ", this.tableName);
        }
        return this.constructToString("CREATE TABLE ", this.tableName);
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        Object object;
        TableDescriptor tableDescriptor;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        activation.setForCreateTable();
        ExecRow execRow = RowUtil.getEmptyValueRow(this.columnInfo.length, languageConnectionContext);
        int n = 0;
        while (n < this.columnInfo.length) {
            if (this.columnInfo[n].defaultValue != null) {
                execRow.setColumn(n + 1, this.columnInfo[n].defaultValue);
            } else {
                execRow.setColumn(n + 1, this.columnInfo[n].dataType.getNull());
            }
            ++n;
        }
        long l = transactionController.createConglomerate("heap", execRow.getRowArray(), null, this.properties, this.tableType == 3 ? 3 : 0);
        if (this.tableType != 3) {
            dataDictionary.startWriting(languageConnectionContext);
        }
        SchemaDescriptor schemaDescriptor = this.tableType == 3 ? dataDictionary.getSchemaDescriptor(this.schemaName, transactionController, true) : DDLConstantAction.getSchemaDescriptorForCreate(dataDictionary, activation, this.schemaName);
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        if (this.tableType != 3) {
            tableDescriptor = dataDescriptorGenerator.newTableDescriptor(this.tableName, schemaDescriptor, this.tableType, this.lockGranularity);
            dataDictionary.addDescriptor(tableDescriptor, schemaDescriptor, 1, false, transactionController);
        } else {
            tableDescriptor = dataDescriptorGenerator.newTableDescriptor(this.tableName, schemaDescriptor, this.tableType, this.onCommitDeleteRows, this.onRollbackDeleteRows);
            tableDescriptor.setUUID(dataDictionary.getUUIDFactory().createUUID());
        }
        UUID uUID = tableDescriptor.getUUID();
        activation.setDDLTableDescriptor(tableDescriptor);
        int n2 = 1;
        TupleDescriptor[] tupleDescriptorArray = new ColumnDescriptor[this.columnInfo.length];
        int n3 = 0;
        while (n3 < this.columnInfo.length) {
            UUID uUID2 = this.columnInfo[n3].newDefaultUUID;
            if (this.columnInfo[n3].defaultInfo != null && uUID2 == null) {
                uUID2 = dataDictionary.getUUIDFactory().createUUID();
            }
            ColumnDescriptor columnDescriptor = new ColumnDescriptor(this.columnInfo[n3].name, n2++, this.columnInfo[n3].dataType, this.columnInfo[n3].defaultValue, this.columnInfo[n3].defaultInfo, tableDescriptor, uUID2, this.columnInfo[n3].autoincStart, this.columnInfo[n3].autoincInc, this.columnInfo[n3].autoincInc != 0L);
            tupleDescriptorArray[n3] = columnDescriptor;
            if (this.columnInfo[n3].defaultInfo != null) {
                object = new DefaultDescriptor(dataDictionary, uUID2, tableDescriptor.getUUID(), n3 + 1);
                ProviderInfo[] providerInfoArray = ((DefaultInfoImpl)this.columnInfo[n3].defaultInfo).getProviderInfo();
                int n4 = providerInfoArray == null ? 0 : providerInfoArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    Provider provider = null;
                    try {
                        provider = (Provider)providerInfoArray[n5].getDependableFinder().getDependable(providerInfoArray[n5].getObjectId());
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    dependencyManager.addDependency((Dependent)object, provider, languageConnectionContext.getContextManager());
                    ++n5;
                }
            }
            ++n3;
        }
        if (this.tableType != 3) {
            dataDictionary.addDescriptorArray(tupleDescriptorArray, tableDescriptor, 2, false, transactionController);
        }
        ColumnDescriptorList columnDescriptorList = tableDescriptor.getColumnDescriptorList();
        int n6 = 0;
        while (n6 < tupleDescriptorArray.length) {
            columnDescriptorList.add(tupleDescriptorArray[n6]);
            ++n6;
        }
        ConglomerateDescriptor conglomerateDescriptor = dataDescriptorGenerator.newConglomerateDescriptor(l, null, false, null, false, null, uUID, schemaDescriptor.getUUID());
        if (this.tableType != 3) {
            dataDictionary.addDescriptor(conglomerateDescriptor, schemaDescriptor, 0, false, transactionController);
        }
        object = tableDescriptor.getConglomerateDescriptorList();
        ((ArrayList)object).add(conglomerateDescriptor);
        if (this.constraintActions != null) {
            int n7 = 0;
            while (n7 < this.constraintActions.length) {
                if (!this.constraintActions[n7].isForeignKeyConstraint()) {
                    this.constraintActions[n7].executeConstantAction(activation);
                }
                ++n7;
            }
            n7 = 0;
            while (n7 < this.constraintActions.length) {
                if (this.constraintActions[n7].isForeignKeyConstraint()) {
                    this.constraintActions[n7].executeConstantAction(activation);
                }
                ++n7;
            }
        }
        if (this.tableType == 3) {
            languageConnectionContext.addDeclaredGlobalTempTable(tableDescriptor);
        }
    }

    CreateTableConstantAction(String string, String string2, int n, ColumnInfo[] columnInfoArray, CreateConstraintConstantAction[] createConstraintConstantActionArray, Properties properties, char c, boolean bl, boolean bl2) {
        this.schemaName = string;
        this.tableName = string2;
        this.tableType = n;
        this.columnInfo = columnInfoArray;
        this.constraintActions = createConstraintConstantActionArray;
        this.properties = properties;
        this.lockGranularity = c;
        this.onCommitDeleteRows = bl;
        this.onRollbackDeleteRows = bl2;
    }
}

