/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.StatementUtil;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.GenericRIChecker;
import org.apache.derby.impl.sql.execute.RowUtil;

public class ForeignKeyRIChecker
extends GenericRIChecker {
    void doCheck(ExecRow execRow, boolean bl) throws StandardException {
        if (bl) {
            return;
        }
        if (this.isAnyFieldNull(execRow)) {
            return;
        }
        ScanController scanController = this.getScanController(this.fkInfo.refConglomNumber, this.refScoci, this.refDcoci, execRow);
        if (!scanController.next()) {
            this.close();
            StandardException standardException = StandardException.newException("23503", this.fkInfo.fkConstraintNames[0], (Object)this.fkInfo.tableName, (Object)StatementUtil.typeName(this.fkInfo.stmtType), (Object)RowUtil.toString(execRow, this.fkInfo.colArray));
            throw standardException;
        }
    }

    int getRICheckIsolationLevel() {
        return 2;
    }

    ForeignKeyRIChecker(TransactionController transactionController, FKInfo fKInfo) throws StandardException {
        super(transactionController, fKInfo);
    }
}

