/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.CacheFactory;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.cache.CacheableFactory;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.info.ProductVersionHolder;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.monitor.PersistentService;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.store.access.FileResource;
import org.apache.derby.iapi.store.access.RowSource;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.StreamContainerHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.iapi.store.raw.data.RawContainerHandle;
import org.apache.derby.iapi.store.raw.log.LogFactory;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.iapi.util.CheapDateFormatter;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.store.raw.data.AllocationActions;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.ContainerOperation;
import org.apache.derby.impl.store.raw.data.DirectActions;
import org.apache.derby.impl.store.raw.data.DirectAllocActions;
import org.apache.derby.impl.store.raw.data.FileContainer;
import org.apache.derby.impl.store.raw.data.InputStreamContainer;
import org.apache.derby.impl.store.raw.data.LoggableActions;
import org.apache.derby.impl.store.raw.data.LoggableAllocActions;
import org.apache.derby.impl.store.raw.data.PageActions;
import org.apache.derby.impl.store.raw.data.RAFContainer;
import org.apache.derby.impl.store.raw.data.RFResource;
import org.apache.derby.impl.store.raw.data.ReclaimSpace;
import org.apache.derby.impl.store.raw.data.ReclaimSpaceHelper;
import org.apache.derby.impl.store.raw.data.StoredPage;
import org.apache.derby.impl.store.raw.data.StreamFileContainer;
import org.apache.derby.impl.store.raw.data.StreamFileContainerHandle;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;
import org.apache.derby.io.WritableStorageFactory;

public class BaseDataFileFactory
implements DataFactory,
CacheableFactory,
ModuleControl,
ModuleSupportable,
PrivilegedExceptionAction {
    private static final String LINE = "----------------------------------------------------------------";
    private static final int GET_TEMP_DIRECTORY_ACTION = 1;
    private static final int REMOVE_TEMP_DIRECTORY_ACTION = 2;
    private static final int GET_CONTAINER_PATH_ACTION = 3;
    private static final int GET_ALTERNATE_CONTAINER_PATH_ACTION = 4;
    private static final int FIND_MAX_CONTAINER_ID_ACTION = 5;
    private static final int DELETE_IF_EXISTS_ACTION = 6;
    private static final int GET_PATH_ACTION = 7;
    private static final int POST_RECOVERY_REMOVE_ACTION = 8;
    private static final int REMOVE_STUBS_ACTION = 9;
    private static final int BOOT_ACTION = 10;
    private static final int GET_LOCK_ON_DB_ACTION = 11;
    private static final int RELEASE_LOCK_ON_DB_ACTION = 12;
    private static final int RESTORE_DATA_DIRECTORY_ACTION = 13;
    private String subSubProtocol;
    StorageFactory storageFactory;
    WritableStorageFactory writableStorageFactory;
    private long nextContainerId = System.currentTimeMillis();
    private boolean databaseEncrypted;
    private CacheManager pageCache;
    private CacheManager containerCache;
    private LogFactory logFactory;
    private ProductVersionHolder jbmsVersion;
    private RawStoreFactory rawStoreFactory;
    private String dataDirectory;
    private boolean throwDBlckException;
    private UUID identifier;
    private Object freezeSemaphore;
    private boolean isFrozen;
    private int writersInProgress;
    private boolean removeStubsOK;
    private boolean isCorrupt;
    private boolean inCreateNoLog;
    private StorageRandomAccessFile fileLockOnDB;
    private StorageFile exFileLock;
    private HeaderPrintWriter istream;
    boolean dataNotSyncedAtAllocation;
    boolean dataNotSyncedAtCheckpoint;
    private PageActions loggablePageActions;
    private AllocationActions loggableAllocActions;
    private boolean readOnly;
    private boolean supportsRandomAccess;
    private FileResource fileHandler;
    private Hashtable droppedTableStubInfo;
    private Hashtable postRecoveryRemovedFiles;
    private int actionCode;
    private ContainerKey containerId;
    private boolean stub;
    private StorageFile actionFile;
    private UUID myUUID;
    private UUIDFactory uuidFactory;
    private String databaseDirectory;
    private String backupPath;
    private File backupRoot;
    private String[] bfilelist;

    public boolean canSupport(Properties properties) {
        String string = properties.getProperty("derby.__rt.serviceType");
        if (string == null) {
            return false;
        }
        if (!this.handleServiceType(properties, string)) {
            return false;
        }
        return properties.getProperty("derby.__rt.serviceDirectory") != null;
    }

    public void boot(boolean bl, Properties properties) throws StandardException {
        this.jbmsVersion = Monitor.getMonitor().getEngineVersion();
        this.dataDirectory = properties.getProperty("derby.__rt.serviceDirectory");
        UUIDFactory uUIDFactory = Monitor.getMonitor().getUUIDFactory();
        this.identifier = uUIDFactory.createUUID();
        PersistentService persistentService = Monitor.getMonitor().getServiceType(this);
        try {
            this.storageFactory = persistentService.getStorageFactoryInstance(true, this.dataDirectory, properties.getProperty("derby.storage.tempDirectory", PropertyUtil.getSystemProperty("derby.storage.tempDirectory")), this.identifier.toANSIidentifier());
        }
        catch (IOException iOException) {
            if (bl) {
                throw StandardException.newException("XBM0H.D", this.dataDirectory, (Object)iOException);
            }
            throw StandardException.newException("XJ004.C", iOException, (Object)this.dataDirectory);
        }
        if (this.storageFactory instanceof WritableStorageFactory) {
            this.writableStorageFactory = (WritableStorageFactory)this.storageFactory;
        }
        this.actionCode = 10;
        try {
            AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        String string = properties.getProperty("derby.database.forceDatabaseLock", PropertyUtil.getSystemProperty("derby.database.forceDatabaseLock"));
        this.throwDBlckException = Boolean.valueOf(string != null ? string.trim() : string);
        if (!this.isReadOnly()) {
            this.getJBMSLockOnDB(this.identifier, uUIDFactory, this.dataDirectory);
        }
        String string2 = properties.getProperty("dataEncryption");
        this.databaseEncrypted = Boolean.valueOf(string2);
        String string3 = null;
        string3 = properties.getProperty("createFrom");
        if (string3 == null) {
            string3 = properties.getProperty("restoreFrom");
        }
        if (string3 == null) {
            string3 = properties.getProperty("rollForwardRecoveryFrom");
        }
        if (string3 != null) {
            try {
                this.restoreDataDirectory(string3);
            }
            catch (StandardException standardException) {
                this.releaseJBMSLockOnDB();
                throw standardException;
            }
        }
        this.logMsg(LINE);
        long l = System.currentTimeMillis();
        this.logMsg(CheapDateFormatter.formatDate(l) + MessageService.getTextMessage("D001", this.jbmsVersion, this.identifier, this.dataDirectory));
        uUIDFactory = null;
        CacheFactory cacheFactory = (CacheFactory)Monitor.startSystemModule("org.apache.derby.iapi.services.cache.CacheFactory");
        int n = this.getIntParameter("derby.storage.pageCacheSize", null, 1000, 40, Integer.MAX_VALUE);
        this.pageCache = cacheFactory.newCacheManager(this, "PageCache", n / 2, n);
        int n2 = this.getIntParameter("derby.storage.fileCacheSize", null, 100, 2, 100);
        this.containerCache = cacheFactory.newCacheManager(this, "ContainerCache", n2 / 2, n2);
        if (bl) {
            String string4 = properties.getProperty("derby.__rt.storage.createWithNoLog");
            this.inCreateNoLog = string4 != null && Boolean.valueOf(string4) != false;
        }
        this.freezeSemaphore = new Object();
        this.droppedTableStubInfo = new Hashtable();
        this.fileHandler = new RFResource(this);
    }

    public void stop() {
        DaemonService daemonService;
        boolean bl = false;
        if (this.rawStoreFactory != null && (daemonService = this.rawStoreFactory.getDaemon()) != null) {
            daemonService.stop();
        }
        long l = System.currentTimeMillis();
        this.logMsg("\n" + CheapDateFormatter.formatDate(l) + MessageService.getTextMessage("D002", this.getIdentifier()));
        this.istream.println(LINE);
        if (!this.isCorrupt) {
            try {
                if (this.pageCache != null && this.containerCache != null) {
                    this.pageCache.shutdown();
                    this.containerCache.shutdown();
                    bl = true;
                }
            }
            catch (StandardException standardException) {
                standardException.printStackTrace(this.istream.getPrintWriter());
            }
        }
        this.removeTempDirectory();
        if (this.isReadOnly()) {
            return;
        }
        if (this.removeStubsOK && bl) {
            this.removeStubs();
        }
        this.releaseJBMSLockOnDB();
    }

    public Cacheable newCacheable(CacheManager cacheManager) {
        if (cacheManager == this.pageCache) {
            StoredPage storedPage = new StoredPage();
            storedPage.setFactory(this);
            return storedPage;
        }
        return this.newContainerObject();
    }

    public void createFinished() throws StandardException {
        if (!this.inCreateNoLog) {
            throw StandardException.newException("XSDG5.D");
        }
        this.checkpoint();
        this.inCreateNoLog = false;
    }

    public ContainerHandle openContainer(RawTransaction rawTransaction, ContainerKey containerKey, LockingPolicy lockingPolicy, int n) throws StandardException {
        return this.openContainer(rawTransaction, containerKey, lockingPolicy, n, false);
    }

    public RawContainerHandle openDroppedContainer(RawTransaction rawTransaction, ContainerKey containerKey, LockingPolicy lockingPolicy, int n) throws StandardException {
        return this.openContainer(rawTransaction, containerKey, lockingPolicy, n |= 0x400, true);
    }

    private RawContainerHandle openContainer(RawTransaction rawTransaction, ContainerKey containerKey, LockingPolicy lockingPolicy, int n, boolean bl) throws StandardException {
        boolean bl2;
        boolean bl3 = bl2 = (n & 0x80) == 0;
        if ((n & 0x40) != 0) {
            BaseContainerHandle baseContainerHandle = new BaseContainerHandle(this.getIdentifier(), rawTransaction, containerKey, lockingPolicy, n);
            if (baseContainerHandle.useContainer(true, bl2)) {
                return baseContainerHandle;
            }
            return null;
        }
        FileContainer fileContainer = (FileContainer)this.containerCache.find(containerKey);
        if (fileContainer == null) {
            return null;
        }
        if (containerKey.getSegmentId() == -1L) {
            n = (n & 0x800) == 2048 ? (n |= 1) : (n |= 0x101);
            lockingPolicy = rawTransaction.newLockingPolicy(0, 0, true);
        } else {
            if (this.inCreateNoLog) {
                n |= 3;
            }
            if (!this.inCreateNoLog && this.logFactory.logArchived()) {
                n &= 0xFFFFFFFC;
            }
            if ((n & 1) == 1 && (n & 2) == 0) {
                n |= 0x200;
            }
        }
        PageActions pageActions = null;
        AllocationActions allocationActions = null;
        if ((n & 4) == 4) {
            if ((n & 1) == 0) {
                pageActions = this.getLoggablePageActions();
                allocationActions = this.getLoggableAllocationActions();
            } else {
                pageActions = new DirectActions();
                allocationActions = new DirectAllocActions();
            }
        }
        BaseContainerHandle baseContainerHandle = new BaseContainerHandle(this.getIdentifier(), rawTransaction, pageActions, allocationActions, lockingPolicy, fileContainer, n);
        try {
            if (!baseContainerHandle.useContainer(bl, bl2)) {
                this.containerCache.release(fileContainer);
                return null;
            }
        }
        catch (StandardException standardException) {
            this.containerCache.release(fileContainer);
            throw standardException;
        }
        return baseContainerHandle;
    }

    public long addContainer(RawTransaction rawTransaction, long l, long l2, int n, Properties properties, int n2) throws StandardException {
        long l3 = l2 != 0L ? l2 : this.getNextId();
        ContainerKey containerKey = new ContainerKey(l, l3);
        boolean bl = l == -1L;
        ContainerHandle containerHandle = null;
        LockingPolicy lockingPolicy = null;
        if (!bl) {
            if (this.isReadOnly()) {
                throw StandardException.newException("40XD1");
            }
            lockingPolicy = rawTransaction.newLockingPolicy(2, 5, true);
            containerHandle = rawTransaction.openContainer(containerKey, lockingPolicy, 68);
        }
        FileContainer fileContainer = (FileContainer)this.containerCache.create(containerKey, properties);
        ContainerHandle containerHandle2 = null;
        Page page = null;
        try {
            if (bl && (n2 & 2) == 2) {
                n |= 0x800;
            }
            containerHandle2 = rawTransaction.openContainer(containerKey, null, 4 | n);
            if (!bl) {
                RawContainerHandle rawContainerHandle = (RawContainerHandle)containerHandle2;
                ContainerOperation containerOperation = new ContainerOperation(rawContainerHandle, 1);
                rawContainerHandle.preDirty(true);
                try {
                    rawTransaction.logAndDo(containerOperation);
                    this.flush(rawTransaction.getLastLogInstant());
                }
                finally {
                    Object var25_17 = null;
                    rawContainerHandle.preDirty(false);
                }
            }
            page = containerHandle2.addPage();
        }
        finally {
            Object var19_20 = null;
            if (page != null) {
                page.unlatch();
                page = null;
            }
            this.containerCache.release(fileContainer);
            if (containerHandle2 != null) {
                containerHandle2.close();
                containerHandle2 = null;
            }
            if (!bl) {
                lockingPolicy.unlockContainer(rawTransaction, containerHandle);
            }
        }
        return l3;
    }

    public long addAndLoadStreamContainer(RawTransaction rawTransaction, long l, Properties properties, RowSource rowSource) throws StandardException {
        long l2 = this.getNextId();
        ContainerKey containerKey = new ContainerKey(l, l2);
        StreamFileContainer streamFileContainer = new StreamFileContainer(containerKey, this, properties);
        streamFileContainer.load(rowSource);
        return l2;
    }

    public StreamContainerHandle openStreamContainer(RawTransaction rawTransaction, long l, long l2, boolean bl) throws StandardException {
        ContainerKey containerKey = new ContainerKey(l, l2);
        StreamFileContainer streamFileContainer = new StreamFileContainer(containerKey, this);
        if ((streamFileContainer = streamFileContainer.open(false)) == null) {
            return null;
        }
        StreamFileContainerHandle streamFileContainerHandle = new StreamFileContainerHandle(this.getIdentifier(), rawTransaction, streamFileContainer, bl);
        if (streamFileContainerHandle.useContainer()) {
            return streamFileContainerHandle;
        }
        return null;
    }

    public void dropStreamContainer(RawTransaction rawTransaction, long l, long l2) throws StandardException {
        boolean bl = l == -1L;
        StreamContainerHandle streamContainerHandle = null;
        try {
            ContainerKey containerKey = new ContainerKey(l, l2);
            rawTransaction.notifyObservers(containerKey);
            streamContainerHandle = rawTransaction.openStreamContainer(l, l2, false);
            if (bl && streamContainerHandle != null) {
                streamContainerHandle.removeContainer();
                Object var9_7 = null;
                if (streamContainerHandle != null) {
                    streamContainerHandle.close();
                }
                return;
            }
            Object var9_8 = null;
            if (streamContainerHandle != null) {
                streamContainerHandle.close();
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (streamContainerHandle != null) {
                streamContainerHandle.close();
            }
            throw throwable;
        }
    }

    public void reCreateContainerForLoadTran(RawTransaction rawTransaction, long l, long l2, ByteArray byteArray) throws StandardException {
        ContainerKey containerKey = new ContainerKey(l, l2);
        FileContainer fileContainer = (FileContainer)this.containerCache.create(containerKey, byteArray);
        this.containerCache.release(fileContainer);
    }

    public void dropContainer(RawTransaction rawTransaction, ContainerKey containerKey) throws StandardException {
        RawContainerHandle rawContainerHandle;
        block14: {
            boolean bl = containerKey.getSegmentId() == -1L;
            LockingPolicy lockingPolicy = null;
            if (!bl) {
                if (this.isReadOnly()) {
                    throw StandardException.newException("40XD1");
                }
                lockingPolicy = rawTransaction.newLockingPolicy(2, 5, true);
            }
            rawTransaction.notifyObservers(containerKey);
            rawContainerHandle = (RawContainerHandle)rawTransaction.openContainer(containerKey, lockingPolicy, 4);
            try {
                if (rawContainerHandle == null || rawContainerHandle.getContainerStatus() != 1) {
                    if (bl) {
                        if (rawContainerHandle != null) {
                            rawContainerHandle.removeContainer(null);
                        }
                        Object var7_6 = null;
                        if (rawContainerHandle != null) {
                            rawContainerHandle.close();
                        }
                        return;
                    }
                    throw StandardException.newException("40XD2", containerKey);
                }
                if (bl) {
                    rawContainerHandle.dropContainer(null, true);
                    rawContainerHandle.removeContainer(null);
                    break block14;
                }
                ContainerOperation containerOperation = new ContainerOperation(rawContainerHandle, 2);
                rawContainerHandle.preDirty(true);
                try {
                    rawTransaction.logAndDo(containerOperation);
                }
                finally {
                    Object var10_10 = null;
                    rawContainerHandle.preDirty(false);
                }
                ReclaimSpace reclaimSpace = new ReclaimSpace(1, containerKey, (DataFactory)this, true);
                rawTransaction.addPostCommitWork(reclaimSpace);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (rawContainerHandle != null) {
                    rawContainerHandle.close();
                }
                throw throwable;
            }
        }
        Object var7_7 = null;
        if (rawContainerHandle != null) {
            rawContainerHandle.close();
        }
    }

    public void checkpoint() throws StandardException {
        this.pageCache.cleanAll();
        this.containerCache.cleanAll();
    }

    public void idle() throws StandardException {
        this.pageCache.ageOut();
        this.containerCache.ageOut();
    }

    public void setRawStoreFactory(RawStoreFactory rawStoreFactory, boolean bl, Properties properties) throws StandardException {
        this.rawStoreFactory = rawStoreFactory;
        this.bootLogFactory(bl, properties);
    }

    public UUID getIdentifier() {
        return this.identifier;
    }

    public int reclaimSpace(Serviceable serviceable, ContextManager contextManager) throws StandardException {
        if (serviceable == null) {
            return 1;
        }
        Transaction transaction = this.rawStoreFactory.findUserTransaction(contextManager, "SystemTransaction");
        return ReclaimSpaceHelper.reclaimSpace(this, (RawTransaction)transaction, (ReclaimSpace)serviceable);
    }

    public StandardException markCorrupt(StandardException standardException) {
        boolean bl = !this.isCorrupt;
        this.isCorrupt = true;
        if (this.getLogFactory() != null) {
            this.getLogFactory().markCorrupt(standardException);
        }
        if (bl) {
            if (this.pageCache != null) {
                this.pageCache.discard(null);
            }
            if (this.containerCache != null) {
                this.containerCache.discard(null);
            }
            this.pageCache = null;
            this.containerCache = null;
            this.releaseJBMSLockOnDB();
        }
        return standardException;
    }

    public FileResource getFileHandler() {
        return this.fileHandler;
    }

    public void removeStubsOK() {
        this.removeStubsOK = true;
    }

    public int getIntParameter(String string, Properties properties, int n, int n2, int n3) {
        String string2 = null;
        if (properties != null) {
            string2 = properties.getProperty(string);
        }
        if (string2 == null) {
            string2 = PropertyUtil.getSystemProperty(string);
        }
        if (string2 != null) {
            try {
                int n4 = Integer.parseInt(string2);
                if (n4 >= n2 && n4 <= n3) {
                    return n4;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    CacheManager getContainerCache() {
        return this.containerCache;
    }

    CacheManager getPageCache() {
        return this.pageCache;
    }

    public long[] getCacheStats(String string) {
        if (string == null) {
            return this.getPageCache().getCacheStats();
        }
        if (string.equals("pageCache")) {
            return this.getPageCache().getCacheStats();
        }
        return this.getPageCache().getCacheStats();
    }

    public void resetCacheStats(String string) {
        if (string == null) {
            this.getPageCache().resetCacheStats();
            return;
        }
        if (string.equals("pageCache")) {
            this.getPageCache().resetCacheStats();
        } else {
            this.getPageCache().resetCacheStats();
        }
    }

    void flush(LogInstant logInstant) throws StandardException {
        this.getLogFactory().flush(logInstant);
    }

    private void syncSideLog(long l) throws StandardException {
    }

    LogFactory getLogFactory() {
        return this.logFactory;
    }

    RawStoreFactory getRawStoreFactory() {
        return this.rawStoreFactory;
    }

    public String getRootDirectory() {
        return this.dataDirectory;
    }

    Cacheable newContainerObject() {
        if (this.supportsRandomAccess) {
            return new RAFContainer(this);
        }
        return new InputStreamContainer(this);
    }

    private void pageToDirty(RawTransaction rawTransaction, StoredPage storedPage) throws StandardException {
    }

    private PageActions getLoggablePageActions() throws StandardException {
        if (this.loggablePageActions == null) {
            this.loggablePageActions = new LoggableActions();
        }
        return this.loggablePageActions;
    }

    private AllocationActions getLoggableAllocationActions() {
        if (this.loggableAllocActions == null) {
            this.loggableAllocActions = new LoggableAllocActions();
        }
        return this.loggableAllocActions;
    }

    synchronized StorageFile getTempDirectory() {
        this.actionCode = 1;
        try {
            return (StorageFile)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
    }

    private synchronized void removeTempDirectory() {
        if (this.storageFactory != null) {
            this.actionCode = 2;
            try {
                AccessController.doPrivileged(this);
            }
            catch (PrivilegedActionException privilegedActionException) {
                // empty catch block
            }
        }
    }

    public StorageFile getContainerPath(ContainerKey containerKey, boolean bl) {
        return this.getContainerPath(containerKey, bl, 3);
    }

    private synchronized StorageFile getContainerPath(ContainerKey containerKey, boolean bl, int n) {
        this.actionCode = n;
        try {
            this.containerId = containerKey;
            this.stub = bl;
            try {
                StorageFile storageFile = (StorageFile)AccessController.doPrivileged(this);
                Object var5_6 = null;
                this.containerId = null;
                return storageFile;
            }
            catch (PrivilegedActionException privilegedActionException) {
                StorageFile storageFile = null;
                Object var5_7 = null;
                this.containerId = null;
                return storageFile;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.containerId = null;
            throw throwable;
        }
    }

    public StorageFile getAlternateContainerPath(ContainerKey containerKey, boolean bl) {
        return this.getContainerPath(containerKey, bl, 4);
    }

    private synchronized void removeStubs() {
        this.actionCode = 9;
        try {
            AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
    }

    public void stubFileToRemoveAfterCheckPoint(StorageFile storageFile, LogInstant logInstant, Object object) {
        if (this.droppedTableStubInfo != null) {
            Object[] objectArray = new Object[]{storageFile, object};
            this.droppedTableStubInfo.put(logInstant, objectArray);
        }
    }

    public void removeDroppedContainerFileStubs(LogInstant logInstant) throws StandardException {
        if (this.droppedTableStubInfo != null) {
            Hashtable hashtable = this.droppedTableStubInfo;
            synchronized (hashtable) {
                Enumeration enumeration = this.droppedTableStubInfo.keys();
                while (enumeration.hasMoreElements()) {
                    LogInstant logInstant2 = (LogInstant)enumeration.nextElement();
                    if (!logInstant2.lessThan(logInstant)) continue;
                    Object[] objectArray = (Object[])this.droppedTableStubInfo.get(logInstant2);
                    Object object = objectArray[1];
                    Cacheable cacheable = this.containerCache.findCached(object);
                    if (cacheable != null) {
                        this.containerCache.remove(cacheable);
                    }
                    BaseDataFileFactory baseDataFileFactory = this;
                    synchronized (baseDataFileFactory) {
                        this.actionFile = (StorageFile)objectArray[0];
                        this.actionCode = 6;
                        try {
                            if (AccessController.doPrivileged(this) != null) {
                                this.droppedTableStubInfo.remove(logInstant2);
                            }
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    private synchronized long findMaxContainerId() {
        this.actionCode = 5;
        try {
            return (Long)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            return 0L;
        }
    }

    private void bootLogFactory(boolean bl, Properties properties) throws StandardException {
        if (this.isReadOnly()) {
            ((Hashtable)properties).put("derby.__rt.storage.log", "readonly");
        }
        this.logFactory = (LogFactory)Monitor.bootServiceModule(bl, this, this.rawStoreFactory.getLogFactoryModule(), properties);
    }

    private boolean handleServiceType(Properties properties, String string) {
        try {
            PersistentService persistentService = Monitor.getMonitor().getServiceProvider(properties, string);
            return persistentService != null && persistentService.hasStorageFactory();
        }
        catch (StandardException standardException) {
            return false;
        }
    }

    private void getJBMSLockOnDB(UUID uUID, UUIDFactory uUIDFactory, String string) throws StandardException {
        if (this.fileLockOnDB != null) {
            return;
        }
        if (this.isReadOnly()) {
            return;
        }
        BaseDataFileFactory baseDataFileFactory = this;
        synchronized (baseDataFileFactory) {
            this.actionCode = 11;
            this.myUUID = uUID;
            this.uuidFactory = uUIDFactory;
            this.databaseDirectory = string;
            try {
                try {
                    AccessController.doPrivileged(this);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (StandardException)privilegedActionException.getException();
                }
                Object var7_5 = null;
                this.myUUID = null;
                this.uuidFactory = null;
                this.databaseDirectory = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                this.myUUID = null;
                this.uuidFactory = null;
                this.databaseDirectory = null;
                throw throwable;
            }
        }
    }

    private void privGetJBMSLockOnDB() throws StandardException {
        Object[] objectArray;
        boolean bl = false;
        String string = null;
        StorageFile storageFile = this.storageFactory.newStorageFile("db.lck");
        try {
            if (storageFile.exists()) {
                bl = true;
                this.fileLockOnDB = storageFile.getRandomAccessFile("rw");
                try {
                    string = this.fileLockOnDB.readUTF();
                }
                catch (IOException iOException) {
                    bl = false;
                }
                this.fileLockOnDB.close();
                this.fileLockOnDB = null;
                if (!storageFile.delete()) {
                    throw StandardException.newException("XSDB6.D", this.databaseDirectory);
                }
            }
            this.fileLockOnDB = storageFile.getRandomAccessFile("rw");
            this.fileLockOnDB.writeUTF(this.myUUID.toString());
            this.fileLockOnDB.sync(false);
            this.fileLockOnDB.seek(0L);
            objectArray = this.uuidFactory.recreateUUID(this.fileLockOnDB.readUTF());
            if (!objectArray.equals(this.myUUID)) {
                throw StandardException.newException("XSDB6.D", this.databaseDirectory);
            }
        }
        catch (IOException iOException) {
            this.readOnly = true;
            try {
                if (this.fileLockOnDB != null) {
                    this.fileLockOnDB.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            this.fileLockOnDB = null;
            return;
        }
        if (storageFile.delete()) {
            String string2;
            objectArray = new Object[]{this.myUUID, this.databaseDirectory, string};
            int n = 0;
            if (!this.throwDBlckException) {
                this.exFileLock = this.storageFactory.newStorageFile("dbex.lck");
                n = this.exFileLock.getExclusiveFileLock();
            }
            if (n == 0 && bl && !this.throwDBlckException) {
                StandardException standardException = StandardException.newException("XSDB7.D", objectArray);
                string2 = MessageService.getCompleteMessage("XSDB7.D", objectArray);
                this.logMsg(string2);
                System.err.println(string2);
            }
            try {
                try {
                    if (this.fileLockOnDB != null) {
                        this.fileLockOnDB.close();
                    }
                    this.fileLockOnDB = storageFile.getRandomAccessFile("rw");
                    this.fileLockOnDB.writeUTF(this.myUUID.toString());
                    this.fileLockOnDB.sync(false);
                    this.fileLockOnDB.close();
                }
                catch (IOException iOException) {
                    try {
                        this.fileLockOnDB.close();
                    }
                    catch (IOException iOException3) {
                    }
                    string2 = null;
                    this.fileLockOnDB = null;
                }
                string2 = null;
                this.fileLockOnDB = null;
            }
            catch (Throwable throwable) {
                string2 = null;
                this.fileLockOnDB = null;
                throw throwable;
            }
            if (bl && this.throwDBlckException) {
                throw StandardException.newException("XSDB8.D", objectArray);
            }
            if (n == 2) {
                throw StandardException.newException("XSDB6.D", this.databaseDirectory);
            }
        }
    }

    private void releaseJBMSLockOnDB() {
        if (this.isReadOnly()) {
            return;
        }
        BaseDataFileFactory baseDataFileFactory = this;
        synchronized (baseDataFileFactory) {
            this.actionCode = 12;
            try {
                try {
                    AccessController.doPrivileged(this);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Object var4_3 = null;
                    this.fileLockOnDB = null;
                }
                Object var4_2 = null;
                this.fileLockOnDB = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.fileLockOnDB = null;
                throw throwable;
            }
        }
    }

    private void privReleaseJBMSLockOnDB() throws IOException {
        if (this.fileLockOnDB != null) {
            this.fileLockOnDB.close();
        }
        if (this.storageFactory != null) {
            StorageFile storageFile = this.storageFactory.newStorageFile("db.lck");
            storageFile.delete();
        }
        if (this.exFileLock != null) {
            this.exFileLock.releaseExclusiveFileLock();
        }
    }

    private void logMsg(String string) {
        if (this.istream == null) {
            this.istream = Monitor.getStream();
        }
        this.istream.println(string);
    }

    public final boolean databaseEncrypted() {
        return this.databaseEncrypted;
    }

    public int encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws StandardException {
        return this.rawStoreFactory.encrypt(byArray, n, n2, byArray2, n3);
    }

    public int decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws StandardException {
        return this.rawStoreFactory.decrypt(byArray, n, n2, byArray2, n3);
    }

    public int getEncryptionBlockSize() {
        return this.rawStoreFactory.getEncryptionBlockSize();
    }

    public String getVersionedName(String string, long l) {
        return string.concat(".G".concat(Long.toString(l)));
    }

    public long getMaxContainerId() throws StandardException {
        return this.findMaxContainerId();
    }

    synchronized long getNextId() {
        return this.nextContainerId++;
    }

    int random() {
        return this.databaseEncrypted ? this.rawStoreFactory.random() : 0;
    }

    void fileToRemove(StorageFile storageFile, boolean bl) {
        if (this.postRecoveryRemovedFiles == null) {
            this.postRecoveryRemovedFiles = new Hashtable();
        }
        String string = null;
        BaseDataFileFactory baseDataFileFactory = this;
        synchronized (baseDataFileFactory) {
            this.actionCode = 7;
            this.actionFile = storageFile;
            try {
                try {
                    string = (String)AccessController.doPrivileged(this);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Object var7_6 = null;
                    this.actionFile = null;
                }
                Object var7_5 = null;
                this.actionFile = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.actionFile = null;
                throw throwable;
            }
        }
        if (bl) {
            this.postRecoveryRemovedFiles.put(string, storageFile);
        } else {
            this.postRecoveryRemovedFiles.remove(string);
        }
    }

    public void postRecovery() throws StandardException {
        DaemonService daemonService = this.rawStoreFactory.getDaemon();
        if (daemonService == null) {
            return;
        }
        this.containerCache.useDaemonService(daemonService);
        this.pageCache.useDaemonService(daemonService);
        if (this.postRecoveryRemovedFiles != null) {
            BaseDataFileFactory baseDataFileFactory = this;
            synchronized (baseDataFileFactory) {
                this.actionCode = 8;
                try {
                    AccessController.doPrivileged(this);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    // empty catch block
                }
            }
            this.postRecoveryRemovedFiles = null;
        }
    }

    public void freezePersistentStore() throws StandardException {
        Object object = this.freezeSemaphore;
        synchronized (object) {
            if (this.isFrozen) {
                throw StandardException.newException("XSRS0.S");
            }
            this.isFrozen = true;
            try {
                while (this.writersInProgress > 0) {
                    try {
                        this.freezeSemaphore.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        this.isFrozen = false;
                        this.freezeSemaphore.notifyAll();
                        throw StandardException.interrupt(interruptedException);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                this.isFrozen = false;
                this.freezeSemaphore.notifyAll();
                throw runtimeException;
            }
        }
    }

    public void unfreezePersistentStore() {
        Object object = this.freezeSemaphore;
        synchronized (object) {
            this.isFrozen = false;
            this.freezeSemaphore.notifyAll();
        }
    }

    public void writeInProgress() throws StandardException {
        Object object = this.freezeSemaphore;
        synchronized (object) {
            while (this.isFrozen) {
                try {
                    this.freezeSemaphore.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw StandardException.interrupt(interruptedException);
                }
            }
            ++this.writersInProgress;
        }
    }

    public void writeFinished() {
        Object object = this.freezeSemaphore;
        synchronized (object) {
            --this.writersInProgress;
            this.freezeSemaphore.notifyAll();
        }
    }

    private void restoreDataDirectory(String string) throws StandardException {
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray != null) {
            boolean bl = false;
            int n = 0;
            while (n < stringArray.length) {
                File file2;
                if (stringArray[n].startsWith("seg") && (file2 = new File(file, stringArray[n])).exists() && file2.isDirectory()) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                throw StandardException.newException("XSDG6.D", file);
            }
        } else {
            throw StandardException.newException("XSDG6.D", file);
        }
        BaseDataFileFactory baseDataFileFactory = this;
        synchronized (baseDataFileFactory) {
            this.actionCode = 13;
            this.backupPath = string;
            this.backupRoot = file;
            this.bfilelist = stringArray;
            try {
                try {
                    AccessController.doPrivileged(this);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (StandardException)privilegedActionException.getException();
                }
                Object var8_8 = null;
                this.backupPath = null;
                this.backupRoot = null;
                this.bfilelist = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.backupPath = null;
                this.backupRoot = null;
                this.bfilelist = null;
                throw throwable;
            }
        }
    }

    private void privRestoreDataDirectory() throws StandardException {
        StorageFile storageFile;
        int n;
        StorageFile storageFile2 = this.storageFactory.newStorageFile(null);
        String[] stringArray = storageFile2.list();
        if (stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].startsWith("seg") && !(storageFile = this.storageFactory.newStorageFile(stringArray[n])).deleteAll()) {
                    throw StandardException.newException("XSDG7.D", storageFile);
                }
                ++n;
            }
        }
        n = 0;
        while (n < this.bfilelist.length) {
            StorageFile storageFile3;
            File file;
            if (this.bfilelist[n].startsWith("seg")) {
                file = new File(this.backupRoot, this.bfilelist[n]);
                storageFile = this.storageFactory.newStorageFile(this.bfilelist[n]);
                if (!FileUtil.copyDirectory(this.writableStorageFactory, file, storageFile)) {
                    throw StandardException.newException("XSDG8.D", file, (Object)storageFile);
                }
            } else if (this.databaseEncrypted && this.bfilelist[n].startsWith("verifyKey.dat") && !FileUtil.copyFile(this.writableStorageFactory, file = new File(this.backupRoot, this.bfilelist[n]), storageFile3 = this.storageFactory.newStorageFile(this.bfilelist[n]))) {
                throw StandardException.newException("XSDG8.D", this.bfilelist[n], (Object)storageFile3);
            }
            ++n;
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public StorageFactory getStorageFactory() {
        return this.storageFactory;
    }

    public Object run() throws Exception {
        switch (this.actionCode) {
            case 10: {
                this.readOnly = this.storageFactory.isReadOnlyDatabase();
                this.supportsRandomAccess = this.storageFactory.supportsRandomAccess();
                return null;
            }
            case 1: {
                return this.storageFactory.getTempDir();
            }
            case 2: {
                StorageFile storageFile = this.storageFactory.getTempDir();
                if (storageFile != null) {
                    storageFile.deleteAll();
                }
                return null;
            }
            case 3: 
            case 4: {
                StringBuffer stringBuffer = new StringBuffer("seg");
                stringBuffer.append(this.containerId.getSegmentId());
                stringBuffer.append(this.storageFactory.getSeparator());
                if (this.actionCode == 3) {
                    stringBuffer.append(this.stub ? (char)'d' : 'c');
                    stringBuffer.append(Long.toHexString(this.containerId.getContainerId()));
                    stringBuffer.append(".dat");
                } else {
                    stringBuffer.append(this.stub ? (char)'D' : 'C');
                    stringBuffer.append(this.containerId.getContainerId());
                    stringBuffer.append(".DAT");
                }
                return this.storageFactory.newStorageFile(stringBuffer.toString());
            }
            case 9: {
                char c = this.storageFactory.getSeparator();
                StorageFile storageFile = this.storageFactory.newStorageFile(null);
                String[] stringArray = storageFile.list();
                int n = stringArray.length - 1;
                while (n >= 0) {
                    StorageFile storageFile2;
                    if (stringArray[n].startsWith("seg") && (storageFile2 = this.storageFactory.newStorageFile(storageFile, stringArray[n])).exists() && storageFile2.isDirectory()) {
                        String[] stringArray2 = storageFile2.list();
                        int n2 = stringArray2.length - 1;
                        while (n2 >= 0) {
                            if (stringArray2[n2].startsWith("D") || stringArray2[n2].startsWith("d")) {
                                StorageFile storageFile3 = this.storageFactory.newStorageFile(storageFile, stringArray[n] + c + stringArray2[n2]);
                                storageFile3.delete();
                            }
                            --n2;
                        }
                    }
                    --n;
                }
                break;
            }
            case 5: {
                long l = 1L;
                StorageFile storageFile = this.storageFactory.newStorageFile("seg0");
                if (storageFile.exists() && storageFile.isDirectory()) {
                    String[] stringArray = storageFile.list();
                    int n = stringArray.length - 1;
                    while (n >= 0) {
                        try {
                            long l2 = Long.parseLong(stringArray[n].substring(1, stringArray[n].length() - 4), 16);
                            if (l2 > l) {
                                l = l2;
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        --n;
                    }
                }
                return ReuseFactory.getLong(l);
            }
            case 6: {
                boolean bl = this.actionFile.exists() && this.actionFile.delete();
                this.actionFile = null;
                return bl ? this : null;
            }
            case 7: {
                String string = this.actionFile.getPath();
                this.actionFile = null;
                return string;
            }
            case 8: {
                Enumeration enumeration = this.postRecoveryRemovedFiles.elements();
                while (enumeration.hasMoreElements()) {
                    StorageFile storageFile = (StorageFile)enumeration.nextElement();
                    if (!storageFile.exists()) continue;
                    storageFile.delete();
                }
                return null;
            }
            case 11: {
                this.privGetJBMSLockOnDB();
                return null;
            }
            case 12: {
                this.privReleaseJBMSLockOnDB();
                return null;
            }
            case 13: {
                this.privRestoreDataDirectory();
                return null;
            }
        }
        return null;
    }
}

