/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.impl.store.raw.data.AllocPage;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.PhysicalPageOperation;

public final class ChainAllocPageOperation
extends PhysicalPageOperation {
    protected long newAllocPageNum;
    protected long newAllocPageOffset;

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        CompressedNumber.writeLong(objectOutput, this.newAllocPageNum);
        CompressedNumber.writeLong(objectOutput, this.newAllocPageOffset);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.newAllocPageNum = CompressedNumber.readLong(objectInput);
        this.newAllocPageOffset = CompressedNumber.readLong(objectInput);
    }

    public int getTypeFormatId() {
        return 97;
    }

    public final void doMe(Transaction transaction, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException {
        ((AllocPage)this.page).chainNextAllocPage(logInstant, this.newAllocPageNum, this.newAllocPageOffset);
    }

    public void undoMe(Transaction transaction, BasePage basePage, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException {
        ((AllocPage)basePage).chainNextAllocPage(logInstant, -1L, 0L);
    }

    public void restoreMe(Transaction transaction, BasePage basePage, LogInstant logInstant, LimitObjectInput limitObjectInput) {
    }

    public String toString() {
        return null;
    }

    public ChainAllocPageOperation(AllocPage allocPage, long l, long l2) throws StandardException {
        super(allocPage);
        this.newAllocPageNum = l;
        this.newAllocPageOffset = l2;
    }

    public ChainAllocPageOperation() {
    }
}

