/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.OutputStream;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.impl.store.raw.data.RecordId;

public final class StoredRecordHeader {
    public static final int RECORD_INITIAL = 0;
    public static final int RECORD_DELETED = 1;
    public static final int RECORD_OVERFLOW = 2;
    public static final int RECORD_HAS_FIRST_FIELD = 4;
    public static final int RECORD_VALID_MASK = 15;
    protected int id;
    protected int status;
    protected int numberFields;
    protected RecordHandle handle;
    protected int overflowId;
    protected long overflowPage;
    protected int firstField;

    protected RecordHandle getHandle(PageKey pageKey, int n) {
        if (this.handle == null) {
            this.handle = new RecordId(pageKey, this.id, n);
        }
        return this.handle;
    }

    public final int getId() {
        return this.id;
    }

    public int getNumberFields() {
        return this.numberFields;
    }

    public long getOverflowPage() {
        return this.overflowPage;
    }

    public int getOverflowId() {
        return this.overflowId;
    }

    public int getFirstField() {
        return this.firstField;
    }

    public final boolean hasOverflow() {
        return (this.status & 2) == 2;
    }

    protected final boolean hasFirstField() {
        return (this.status & 4) == 4;
    }

    public final boolean isDeleted() {
        return (this.status & 1) == 1;
    }

    public int size() {
        int n;
        int n2 = this.id <= 63 ? 2 : (n = this.id <= 16383 ? 3 : 5);
        if ((this.status & 6) == 0) {
            n += this.numberFields <= 63 ? 1 : (this.numberFields <= 16383 ? 2 : 4);
        } else if ((this.status & 2) == 0) {
            n += (this.numberFields <= 63 ? 1 : (this.numberFields <= 16383 ? 2 : 4)) + (this.firstField <= 63 ? 1 : (this.firstField <= 16383 ? 2 : 4));
        } else {
            n += CompressedNumber.sizeLong(this.overflowPage);
            n += CompressedNumber.sizeInt(this.overflowId);
            if (this.hasFirstField()) {
                n += CompressedNumber.sizeInt(this.firstField);
                n += CompressedNumber.sizeInt(this.numberFields);
            }
        }
        return n;
    }

    public int setDeleted(boolean bl) {
        int n = 0;
        if (bl) {
            if (!this.isDeleted()) {
                n = 1;
                this.status |= 1;
            }
        } else if (this.isDeleted()) {
            n = -1;
            this.status &= 0xFFFFFFFE;
        }
        return n;
    }

    public void setFirstField(int n) {
        this.firstField = n;
        this.status |= 4;
    }

    public final void setId(int n) {
        this.id = n;
    }

    public void setOverflowDetails(RecordHandle recordHandle) {
        this.overflowPage = recordHandle.getPageNumber();
        this.overflowId = recordHandle.getId();
    }

    public void setOverflowFields(StoredRecordHeader storedRecordHeader) {
        this.status = storedRecordHeader.status | 2;
        this.id = storedRecordHeader.id;
        this.numberFields = storedRecordHeader.numberFields;
        this.firstField = storedRecordHeader.firstField;
        this.handle = null;
    }

    public final void setNumberFields(int n) {
        this.numberFields = n;
    }

    public int write(OutputStream outputStream) throws IOException {
        int n = 1;
        outputStream.write(this.status);
        n += CompressedNumber.writeInt(outputStream, this.id);
        if (this.hasOverflow()) {
            n += CompressedNumber.writeLong(outputStream, this.overflowPage);
            n += CompressedNumber.writeInt(outputStream, this.overflowId);
        }
        if (this.hasFirstField()) {
            n += CompressedNumber.writeInt(outputStream, this.firstField);
        }
        if (!this.hasOverflow() || this.hasFirstField()) {
            n += CompressedNumber.writeInt(outputStream, this.numberFields);
        }
        return n;
    }

    public void read(ObjectInput objectInput) throws IOException {
        this.status = objectInput.read();
        if (this.status < 0) {
            throw new EOFException();
        }
        this.id = CompressedNumber.readInt(objectInput);
        if (this.hasOverflow()) {
            this.overflowPage = CompressedNumber.readLong(objectInput);
            this.overflowId = CompressedNumber.readInt(objectInput);
        } else {
            this.overflowPage = 0L;
            this.overflowId = 0;
        }
        this.firstField = this.hasFirstField() ? CompressedNumber.readInt(objectInput) : 0;
        this.numberFields = !this.hasOverflow() || this.hasFirstField() ? CompressedNumber.readInt(objectInput) : 0;
        this.handle = null;
    }

    private int readId(byte[] byArray, int n) {
        int n2;
        if (((n2 = byArray[n++]) & 0xFFFFFFC0) == 0) {
            this.id = n2;
            return 1;
        }
        if ((n2 & 0x80) == 0) {
            this.id = (n2 & 0x3F) << 8 | byArray[n] & 0xFF;
            return 2;
        }
        this.id = (n2 & 0x7F) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF;
        return 4;
    }

    private int readOverFlowPage(byte[] byArray, int n) {
        byte by;
        if (((by = byArray[n++]) & 0xFFFFFFC0) == 0) {
            this.overflowPage = by << 8 | byArray[n] & 0xFF;
            return 2;
        }
        if ((by & 0x80) == 0) {
            this.overflowPage = (by & 0x3F) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF;
            return 4;
        }
        this.overflowPage = (long)(by & 0x7F) << 56 | (long)(byArray[n++] & 0xFF) << 48 | (long)(byArray[n++] & 0xFF) << 40 | (long)(byArray[n++] & 0xFF) << 32 | (long)(byArray[n++] & 0xFF) << 24 | (long)(byArray[n++] & 0xFF) << 16 | (long)(byArray[n++] & 0xFF) << 8 | (long)(byArray[n] & 0xFF);
        return 8;
    }

    private int readOverFlowId(byte[] byArray, int n) {
        int n2;
        if (((n2 = byArray[n++]) & 0xFFFFFFC0) == 0) {
            this.overflowId = n2;
            return 1;
        }
        if ((n2 & 0x80) == 0) {
            this.overflowId = (n2 & 0x3F) << 8 | byArray[n] & 0xFF;
            return 2;
        }
        this.overflowId = (n2 & 0x7F) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF;
        return 4;
    }

    private int readFirstField(byte[] byArray, int n) {
        int n2;
        if (((n2 = byArray[n++]) & 0xFFFFFFC0) == 0) {
            this.firstField = n2;
            return 1;
        }
        if ((n2 & 0x80) == 0) {
            this.firstField = (n2 & 0x3F) << 8 | byArray[n] & 0xFF;
            return 2;
        }
        this.firstField = (n2 & 0x7F) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF;
        return 4;
    }

    private void readNumberFields(byte[] byArray, int n) {
        int n2;
        this.numberFields = ((n2 = byArray[n++]) & 0xFFFFFFC0) == 0 ? n2 : ((n2 & 0x80) == 0 ? (n2 & 0x3F) << 8 | byArray[n] & 0xFF : (n2 & 0x7F) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF);
    }

    private void read(byte[] byArray, int n) {
        int n2;
        this.status = byArray[n++];
        this.id = ((n2 = byArray[n++]) & 0xFFFFFFC0) == 0 ? n2 : ((n2 & 0x80) == 0 ? (n2 & 0x3F) << 8 | byArray[n++] & 0xFF : (n2 & 0x7F) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF);
        if ((this.status & 6) == 0) {
            this.overflowPage = 0L;
            this.overflowId = 0;
            this.firstField = 0;
            this.readNumberFields(byArray, n);
        } else if ((this.status & 2) == 0) {
            this.overflowPage = 0L;
            this.overflowId = 0;
            n += this.readFirstField(byArray, n);
            this.readNumberFields(byArray, n);
        } else {
            n += this.readOverFlowPage(byArray, n);
            n += this.readOverFlowId(byArray, n);
            if (this.hasFirstField()) {
                n += this.readFirstField(byArray, n);
                this.readNumberFields(byArray, n);
            } else {
                this.firstField = 0;
                this.numberFields = 0;
            }
        }
        this.handle = null;
    }

    public String toString() {
        return null;
    }

    public StoredRecordHeader() {
    }

    public StoredRecordHeader(int n, int n2) {
        this.setId(n);
        this.setNumberFields(n2);
    }

    public StoredRecordHeader(byte[] byArray, int n) {
        this.read(byArray, n);
    }

    public StoredRecordHeader(StoredRecordHeader storedRecordHeader) {
        this.status = storedRecordHeader.status;
        this.id = storedRecordHeader.id;
        this.numberFields = storedRecordHeader.numberFields;
        this.handle = null;
        this.overflowId = storedRecordHeader.overflowId;
        this.overflowPage = storedRecordHeader.overflowPage;
        this.firstField = storedRecordHeader.firstField;
    }
}

