/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.util.Observable;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.ContainerHandleActionOnCommit;

public class TruncateOnCommit
extends ContainerHandleActionOnCommit {
    private boolean commitAsWell;

    public void update(Observable observable, Object object) {
        if (object.equals(RawTransaction.ABORT) || object.equals(RawTransaction.SAVEPOINT_ROLLBACK) || this.commitAsWell && object.equals(RawTransaction.COMMIT)) {
            this.openContainerAndDoIt((RawTransaction)observable);
        }
        if (object.equals(RawTransaction.COMMIT) || object.equals(RawTransaction.ABORT) || object.equals(this.identity)) {
            observable.deleteObserver(this);
        }
    }

    protected void doIt(BaseContainerHandle baseContainerHandle) throws StandardException {
        baseContainerHandle.container.truncate(baseContainerHandle);
    }

    public boolean equals(Object object) {
        if (object instanceof TruncateOnCommit) {
            if (((TruncateOnCommit)object).commitAsWell != this.commitAsWell) {
                return false;
            }
            return super.equals(object);
        }
        return false;
    }

    public TruncateOnCommit(ContainerKey containerKey, boolean bl) {
        super(containerKey);
        this.commitAsWell = bl;
    }
}

