/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.log;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatIdOutputStream;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.Compensation;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.RePreparable;
import org.apache.derby.iapi.store.raw.Undoable;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.log.Logger;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.store.raw.xact.TransactionFactory;
import org.apache.derby.iapi.store.raw.xact.TransactionId;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.log.LogCounter;
import org.apache.derby.impl.store.raw.log.LogRecord;
import org.apache.derby.impl.store.raw.log.LogToFile;
import org.apache.derby.impl.store.raw.log.StreamLogScan;

public class FileLogger
implements Logger {
    private LogRecord logRecord;
    protected byte[] encryptionBuffer;
    private DynamicByteArrayOutputStream logOutputBuffer;
    private FormatIdOutputStream logicalOut;
    private ArrayInputStream logIn;
    private LogToFile logFactory;

    public void close() throws IOException {
        if (this.logOutputBuffer != null) {
            this.logOutputBuffer.close();
            this.logOutputBuffer = null;
        }
        this.logIn = null;
        this.logFactory = null;
        this.logicalOut = null;
        this.logRecord = null;
    }

    public synchronized LogInstant logAndDo(RawTransaction rawTransaction, Loggable loggable) throws StandardException {
        boolean bl = false;
        boolean bl2 = false;
        try {
            byte[] byArray;
            this.logOutputBuffer.reset();
            TransactionId transactionId = rawTransaction.getId();
            this.logRecord.setValue(transactionId, loggable);
            bl2 = true;
            this.logicalOut.writeObject(this.logRecord);
            bl2 = false;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            ByteArray byteArray = loggable.getPreparedLog();
            if (byteArray != null) {
                byArray = byteArray.getArray();
                n = byteArray.getLength();
                n2 = byteArray.getOffset();
                this.logIn.setData(byArray);
                this.logIn.setPosition(n2);
                this.logIn.setLimit(n);
            } else {
                byArray = null;
                n = 0;
            }
            this.logicalOut.writeInt(n);
            n3 = this.logOutputBuffer.getPosition() + n;
            LogCounter logCounter = null;
            int n4 = 0;
            try {
                block18: {
                    try {
                        if (this.logFactory.databaseEncrypted()) {
                            n4 = n3;
                            if (n4 % this.logFactory.getEncryptionBlockSize() != 0) {
                                n4 = n4 + this.logFactory.getEncryptionBlockSize() - n4 % this.logFactory.getEncryptionBlockSize();
                            }
                            if (this.encryptionBuffer == null || this.encryptionBuffer.length < n4) {
                                this.encryptionBuffer = new byte[n4];
                            }
                            System.arraycopy(this.logOutputBuffer.getByteArray(), 0, this.encryptionBuffer, 0, n3 - n);
                            if (n > 0) {
                                System.arraycopy(byArray, n2, this.encryptionBuffer, n3 - n, n);
                            }
                            int n5 = this.logFactory.encrypt(this.encryptionBuffer, 0, n4, this.encryptionBuffer, 0);
                        }
                        if ((loggable.group() & 3) != 0) {
                            LogToFile logToFile = this.logFactory;
                            synchronized (logToFile) {
                                long l = 0L;
                                l = this.logFactory.databaseEncrypted() ? this.logFactory.appendLogRecord(this.encryptionBuffer, 0, n4, null, -1, 0) : this.logFactory.appendLogRecord(this.logOutputBuffer.getByteArray(), 0, n3, byArray, n2, n);
                                logCounter = new LogCounter(l);
                                loggable.doMe(rawTransaction, logCounter, this.logIn);
                                break block18;
                            }
                        }
                        long l = 0L;
                        l = this.logFactory.databaseEncrypted() ? this.logFactory.appendLogRecord(this.encryptionBuffer, 0, n4, null, -1, 0) : this.logFactory.appendLogRecord(this.logOutputBuffer.getByteArray(), 0, n3, byArray, n2, n);
                        logCounter = new LogCounter(l);
                        loggable.doMe(rawTransaction, logCounter, this.logIn);
                    }
                    catch (StandardException standardException) {
                        throw this.logFactory.markCorrupt(StandardException.newException("XSLA1.D", standardException, (Object)loggable));
                    }
                    catch (IOException iOException) {
                        throw this.logFactory.markCorrupt(StandardException.newException("XSLA1.D", iOException, (Object)loggable));
                    }
                }
                Object var14_20 = null;
                this.logIn.clearLimit();
            }
            catch (Throwable throwable) {
                Object var14_21 = null;
                this.logIn.clearLimit();
                throw throwable;
            }
            return logCounter;
        }
        catch (IOException iOException) {
            if (bl2) {
                throw StandardException.newException("XSLB1.S", iOException, (Object)loggable);
            }
            throw StandardException.newException("XSLB2.S", iOException, (Object)loggable);
        }
    }

    public LogInstant logAndUndo(RawTransaction rawTransaction, Compensation compensation, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException {
        boolean bl = false;
        try {
            this.logOutputBuffer.reset();
            TransactionId transactionId = rawTransaction.getId();
            this.logRecord.setValue(transactionId, compensation);
            bl = true;
            this.logicalOut.writeObject(this.logRecord);
            bl = false;
            this.logicalOut.writeLong(((LogCounter)logInstant).getValueAsLong());
            int n = this.logOutputBuffer.getPosition();
            long l = 0L;
            if (this.logFactory.databaseEncrypted()) {
                int n2 = n;
                if (n2 % this.logFactory.getEncryptionBlockSize() != 0) {
                    n2 = n2 + this.logFactory.getEncryptionBlockSize() - n2 % this.logFactory.getEncryptionBlockSize();
                }
                if (this.encryptionBuffer == null || this.encryptionBuffer.length < n2) {
                    this.encryptionBuffer = new byte[n2];
                }
                System.arraycopy(this.logOutputBuffer.getByteArray(), 0, this.encryptionBuffer, 0, n);
                int n3 = this.logFactory.encrypt(this.encryptionBuffer, 0, n2, this.encryptionBuffer, 0);
                l = this.logFactory.appendLogRecord(this.encryptionBuffer, 0, n2, null, 0, 0);
            } else {
                l = this.logFactory.appendLogRecord(this.logOutputBuffer.getByteArray(), 0, n, null, 0, 0);
            }
            LogCounter logCounter = new LogCounter(l);
            try {
                compensation.doMe(rawTransaction, logCounter, limitObjectInput);
            }
            catch (StandardException standardException) {
                throw this.logFactory.markCorrupt(StandardException.newException("XSLA1.D", standardException, (Object)compensation));
            }
            catch (IOException iOException) {
                throw this.logFactory.markCorrupt(StandardException.newException("XSLA1.D", iOException, (Object)compensation));
            }
            return logCounter;
        }
        catch (IOException iOException) {
            if (bl) {
                throw StandardException.newException("XSLB1.S", iOException, (Object)compensation);
            }
            throw StandardException.newException("XSLB2.S", iOException, (Object)compensation);
        }
    }

    public void flush(LogInstant logInstant) throws StandardException {
        this.logFactory.flush(logInstant);
    }

    public void flushAll() throws StandardException {
        this.logFactory.flushAll();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reprepare(RawTransaction rawTransaction, TransactionId transactionId, LogInstant logInstant, LogInstant logInstant2) throws StandardException {
        Object object2;
        InputStream inputStream;
        block16: {
            block15: {
                int n = 0;
                int n2 = 0;
                RePreparable rePreparable = null;
                inputStream = null;
                try {
                    try {
                        LogRecord logRecord;
                        if (logInstant2 == null) {
                            object2 = (StreamLogScan)this.logFactory.openBackwardsScan(logInstant);
                        } else {
                            if (logInstant2.lessThan(logInstant)) {
                                Object var10_15 = null;
                                if (inputStream == null) return;
                                break block15;
                            }
                            object2 = (StreamLogScan)this.logFactory.openBackwardsScan(((LogCounter)logInstant2).getValueAsLong(), logInstant);
                        }
                        inputStream = new ArrayInputStream(new byte[4096]);
                        while ((logRecord = object2.getNextRecord((ArrayInputStream)inputStream, transactionId, 0)) != null) {
                            ++n2;
                            if (logRecord.isCLR()) {
                                ++n;
                                logRecord.skipLoggable();
                                long l = ((ArrayInputStream)inputStream).readLong();
                                object2.resetPosition(new LogCounter(l));
                                continue;
                            }
                            if (!logRecord.requiresPrepareLocks() || (rePreparable = logRecord.getRePreparable()) == null) continue;
                            rePreparable.reclaimPrepareLocks(rawTransaction, rawTransaction.newLockingPolicy(1, 4, true));
                        }
                        break block16;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw this.logFactory.markCorrupt(StandardException.newException("XSLA3.D", classNotFoundException));
                    }
                    catch (IOException iOException) {
                        throw this.logFactory.markCorrupt(StandardException.newException("XSLA5.D", iOException));
                    }
                    catch (StandardException standardException) {
                        throw this.logFactory.markCorrupt(StandardException.newException("XSLA8.D", standardException, (Object)transactionId, rePreparable, null));
                    }
                }
                catch (Throwable throwable) {
                    Object var10_17 = null;
                    if (inputStream == null) throw throwable;
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        throw this.logFactory.markCorrupt(StandardException.newException("XSLA5.D", iOException, (Object)transactionId));
                    }
                }
            }
            try {}
            catch (IOException iOException) {
                throw this.logFactory.markCorrupt(StandardException.newException("XSLA5.D", iOException, (Object)transactionId));
            }
            inputStream.close();
            return;
        }
        Object var10_16 = null;
        if (inputStream == null) return;
        try {}
        catch (IOException object2) {
            throw this.logFactory.markCorrupt(StandardException.newException("XSLA5.D", (Throwable)object2, (Object)transactionId));
        }
        inputStream.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void undo(RawTransaction rawTransaction, TransactionId transactionId, LogInstant logInstant, LogInstant logInstant2) throws StandardException {
        Serializable serializable2;
        InputStream inputStream;
        Loggable loggable;
        block19: {
            block18: {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                loggable = null;
                Undoable undoable = null;
                inputStream = null;
                try {
                    try {
                        StreamLogScan streamLogScan;
                        if (logInstant2 == null) {
                            streamLogScan = (StreamLogScan)this.logFactory.openBackwardsScan(logInstant);
                        } else {
                            if (logInstant2.lessThan(logInstant)) {
                                Object var13_12 = null;
                                if (loggable != null) {
                                    loggable.releaseResource(rawTransaction);
                                }
                                if (inputStream == null) return;
                                break block18;
                            }
                            long l = ((LogCounter)logInstant2).getValueAsLong();
                            streamLogScan = (StreamLogScan)this.logFactory.openBackwardsScan(l, logInstant);
                        }
                        inputStream = new ArrayInputStream(new byte[4096]);
                        while ((serializable2 = streamLogScan.getNextRecord((ArrayInputStream)inputStream, transactionId, 0)) != null) {
                            ++n3;
                            if (serializable2.isCLR()) {
                                ++n2;
                                serializable2.skipLoggable();
                                long l = ((ArrayInputStream)inputStream).readLong();
                                streamLogScan.resetPosition(new LogCounter(l));
                                continue;
                            }
                            undoable = serializable2.getUndoable();
                            if (undoable == null) continue;
                            int n4 = ((ArrayInputStream)inputStream).readInt();
                            int n5 = ((ArrayInputStream)inputStream).getPosition();
                            ((ArrayInputStream)inputStream).setLimit(n5, n4);
                            loggable = undoable.generateUndo(rawTransaction, (LimitObjectInput)((Object)inputStream));
                            ++n;
                            if (loggable == null) continue;
                            ((ArrayInputStream)inputStream).setLimit(n5, n4);
                            rawTransaction.logAndUndo((Compensation)loggable, new LogCounter(streamLogScan.getInstant()), (LimitObjectInput)((Object)inputStream));
                            loggable.releaseResource(rawTransaction);
                            loggable = null;
                        }
                        break block19;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw this.logFactory.markCorrupt(StandardException.newException("XSLA3.D", classNotFoundException));
                    }
                    catch (IOException iOException) {
                        throw this.logFactory.markCorrupt(StandardException.newException("XSLA5.D", iOException));
                    }
                    catch (StandardException standardException) {
                        throw this.logFactory.markCorrupt(StandardException.newException("XSLA8.D", standardException, (Object)transactionId, undoable, (Object)loggable));
                    }
                }
                catch (Throwable throwable) {
                    Object var13_14 = null;
                    if (loggable != null) {
                        loggable.releaseResource(rawTransaction);
                    }
                    if (inputStream == null) throw throwable;
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        throw this.logFactory.markCorrupt(StandardException.newException("XSLA5.D", iOException, (Object)transactionId));
                    }
                }
            }
            try {}
            catch (IOException iOException) {
                throw this.logFactory.markCorrupt(StandardException.newException("XSLA5.D", iOException, (Object)transactionId));
            }
            inputStream.close();
            return;
        }
        Object var13_13 = null;
        if (loggable != null) {
            loggable.releaseResource(rawTransaction);
        }
        if (inputStream == null) return;
        try {}
        catch (IOException serializable2) {
            throw this.logFactory.markCorrupt(StandardException.newException("XSLA5.D", (Throwable)serializable2, (Object)transactionId));
        }
        inputStream.close();
    }

    protected long redo(RawTransaction rawTransaction, TransactionFactory transactionFactory, StreamLogScan streamLogScan, long l, long l2) throws IOException, StandardException, ClassNotFoundException {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        TransactionId transactionId = null;
        long l3 = 0L;
        this.logIn.setData(this.logOutputBuffer.getByteArray());
        StreamLogScan streamLogScan2 = null;
        Loggable loggable = null;
        long l4 = 0L;
        try {
            try {
                LogRecord logRecord;
                while ((logRecord = streamLogScan.getNextRecord(this.logIn, null, 0)) != null) {
                    ++n;
                    long l5 = 0L;
                    l3 = streamLogScan.getInstant();
                    l4 = streamLogScan.getLogRecordEnd();
                    if (l != 0L && l3 < l && !logRecord.isFirst() && !logRecord.isComplete() && !logRecord.isPrepare()) continue;
                    transactionId = logRecord.getTransactionId();
                    if (!transactionFactory.findTransaction(transactionId, rawTransaction)) {
                        if (l != 0L && l3 < l && (logRecord.isPrepare() || logRecord.isComplete())) {
                            ++n5;
                            continue;
                        }
                        if (l2 == 0L && !logRecord.isFirst()) {
                            throw StandardException.newException("XSLAO.D", MessageService.getTextMessage("L012", transactionId));
                        }
                        ++n4;
                        rawTransaction.setTransactionId(logRecord.getLoggable(), transactionId);
                    } else {
                        if (l2 == 0L && logRecord.isFirst()) {
                            throw StandardException.newException("XSLAO.D", MessageService.getTextMessage("L013", transactionId));
                        }
                        if (logRecord.isFirst()) {
                            ++n4;
                            continue;
                        }
                    }
                    loggable = logRecord.getLoggable();
                    if (loggable.needsRedo(rawTransaction)) {
                        ++n2;
                        if (logRecord.isCLR()) {
                            ++n3;
                            if (l5 == 0L) {
                                l5 = this.logIn.readLong();
                            }
                            if (streamLogScan2 == null) {
                                streamLogScan2 = (StreamLogScan)this.logFactory.openForwardsScan(l5, null);
                            } else {
                                streamLogScan2.resetPosition(new LogCounter(l5));
                            }
                            this.logIn.clearLimit();
                            LogRecord logRecord2 = streamLogScan2.getNextRecord(this.logIn, null, 0);
                            Undoable undoable = logRecord2.getUndoable();
                            ((Compensation)loggable).setUndoOp(undoable);
                        }
                        int n6 = this.logIn.readInt();
                        this.logIn.setLimit(this.logIn.getPosition(), n6);
                        loggable.doMe(rawTransaction, new LogCounter(l3), this.logIn);
                        loggable.releaseResource(rawTransaction);
                        loggable = null;
                    }
                    if (!logRecord.isComplete()) continue;
                    ++n5;
                    rawTransaction.commit();
                }
            }
            catch (StandardException standardException) {
                throw StandardException.newException("XSLA7.D", standardException, loggable);
            }
            Object var22_23 = null;
            streamLogScan.close();
            streamLogScan = null;
            if (streamLogScan2 != null) {
                streamLogScan2.close();
                streamLogScan2 = null;
            }
            if (loggable != null) {
                loggable.releaseResource(rawTransaction);
            }
        }
        catch (Throwable throwable) {
            Object var22_24 = null;
            streamLogScan.close();
            streamLogScan = null;
            if (streamLogScan2 != null) {
                streamLogScan2.close();
                streamLogScan2 = null;
            }
            if (loggable != null) {
                loggable.releaseResource(rawTransaction);
            }
            throw throwable;
        }
        return l4;
    }

    protected Loggable readLogRecord(StreamLogScan streamLogScan, int n) throws IOException, StandardException, ClassNotFoundException {
        Loggable loggable = null;
        ArrayInputStream arrayInputStream = new ArrayInputStream(new byte[n]);
        LogRecord logRecord = streamLogScan.getNextRecord(arrayInputStream, null, 0);
        if (logRecord != null) {
            loggable = logRecord.getLoggable();
        }
        return loggable;
    }

    public FileLogger(LogToFile logToFile) {
        this.logFactory = logToFile;
        this.logOutputBuffer = new DynamicByteArrayOutputStream(1024);
        this.logicalOut = new FormatIdOutputStream(this.logOutputBuffer);
        this.logIn = new ArrayInputStream();
        this.logRecord = new LogRecord();
    }
}

