/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.clib;

import com.sun.media.imageioimpl.plugins.clib.I18N;
import com.sun.media.imageioimpl.plugins.clib.InputStreamAdapter;
import com.sun.medialib.codec.jiio.mediaLibImage;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public abstract class CLibImageReader
extends ImageReader {
    protected mediaLibImage mlibImage = null;

    private static boolean subBandsMatch(int[] sourceBands, int[] destinationBands) {
        if (sourceBands == null && destinationBands == null) {
            return true;
        }
        if (sourceBands != null && destinationBands != null) {
            if (sourceBands.length != destinationBands.length) {
                return false;
            }
            int i = 0;
            while (i < sourceBands.length) {
                if (sourceBands[i] != destinationBands[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected CLibImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    protected abstract mediaLibImage decode(InputStream var1) throws IOException;

    protected static final ImageTypeSpecifier createImageType(mediaLibImage mlImage, int bitDepth, byte[] redPalette, byte[] greenPalette, byte[] bluePalette, byte[] alphaPalette) throws IOException {
        int dataType;
        int mlibType = mlImage.getType();
        int mlibWidth = mlImage.getWidth();
        int mlibHeight = mlImage.getHeight();
        int mlibBands = mlImage.getChannels();
        int mlibStride = mlImage.getStride();
        switch (mlibType) {
            case 0: 
            case 1: {
                dataType = 0;
                break;
            }
            case 2: 
            case 6: {
                dataType = 1;
                break;
            }
            default: {
                throw new UnsupportedOperationException(I18N.getString("Generic0") + " " + mlibType);
            }
        }
        SampleModel sampleModel = null;
        if (mlibType == 0) {
            sampleModel = new MultiPixelPackedSampleModel(dataType, mlibWidth, mlibHeight, 1, mlibStride, mlImage.getBitOffset());
        } else {
            int[] bandOffsets = new int[mlibBands];
            int i = 0;
            while (i < mlibBands) {
                bandOffsets[i] = i;
                ++i;
            }
            sampleModel = new PixelInterleavedSampleModel(dataType, mlibWidth, mlibHeight, mlibBands, mlibStride, bandOffsets);
        }
        ColorModel colorModel = null;
        if (mlibBands == 1 && redPalette != null && greenPalette != null && bluePalette != null && redPalette.length == greenPalette.length && redPalette.length == bluePalette.length) {
            int paletteLength = redPalette.length;
            if (alphaPalette != null) {
                if (alphaPalette.length != paletteLength) {
                    byte[] alphaTmp = new byte[paletteLength];
                    if (alphaPalette.length > paletteLength) {
                        System.arraycopy(alphaPalette, 0, alphaTmp, 0, paletteLength);
                    } else {
                        System.arraycopy(alphaPalette, 0, alphaTmp, 0, alphaPalette.length);
                        int i = alphaPalette.length;
                        while (i < paletteLength) {
                            alphaTmp[i] = -1;
                            ++i;
                        }
                    }
                    alphaPalette = alphaTmp;
                }
                colorModel = new IndexColorModel(8, paletteLength, redPalette, greenPalette, bluePalette, alphaPalette);
            } else {
                colorModel = new IndexColorModel(8, paletteLength, redPalette, greenPalette, bluePalette);
            }
        } else if (mlibType == 0) {
            byte[] cmap = new byte[]{0, -1};
            colorModel = new IndexColorModel(1, 2, cmap, cmap, cmap);
        } else {
            ColorSpace colorSpace = ColorSpace.getInstance(mlibBands < 3 ? 1003 : 1000);
            int[] bits = new int[mlibBands];
            int i = 0;
            while (i < mlibBands) {
                bits[i] = bitDepth;
                ++i;
            }
            boolean hasAlpha = mlibBands % 2 == 0;
            colorModel = new ComponentColorModel(colorSpace, bits, hasAlpha, false, hasAlpha ? 3 : 1, dataType);
        }
        return new ImageTypeSpecifier(colorModel, sampleModel);
    }

    private static final void subsample(Raster src, int subX, int subY, WritableRaster dst) {
        int sx0 = src.getMinX();
        int sy0 = src.getMinY();
        int sw = src.getWidth();
        int syUB = sy0 + src.getHeight();
        int dx0 = dst.getMinX();
        int dy0 = dst.getMinY();
        int dw = dst.getWidth();
        int b = src.getSampleModel().getNumBands();
        int t = src.getSampleModel().getDataType();
        if (t == 4 || t == 5) {
            float[] fsamples = new float[sw];
            float[] fsubsamples = new float[sw / subX];
            int k = 0;
            while (k < b) {
                int sy = sy0;
                int dy = dy0;
                while (sy < syUB) {
                    src.getSamples(sx0, sy, sw, 1, k, fsamples);
                    int i = 0;
                    int s = 0;
                    while (i < sw) {
                        fsubsamples[s] = fsamples[i];
                        ++s;
                        i += subX;
                    }
                    dst.setSamples(dx0, dy, dw, 1, k, fsubsamples);
                    sy += subY;
                    ++dy;
                }
                ++k;
            }
        } else {
            int[] samples = new int[sw];
            int[] subsamples = new int[sw / subX];
            int k = 0;
            while (k < b) {
                int sy = sy0;
                int dy = dy0;
                while (sy < syUB) {
                    src.getSamples(sx0, sy, sw, 1, k, samples);
                    int i = 0;
                    int s = 0;
                    while (i < sw) {
                        subsamples[s] = samples[i];
                        ++s;
                        i += subX;
                    }
                    dst.setSamples(dx0, dy, dw, 1, k, subsamples);
                    sy += subY;
                    ++dy;
                }
                ++k;
            }
        }
    }

    protected synchronized mediaLibImage getImage() throws IOException {
        if (this.mlibImage == null) {
            if (this.input == null) {
                throw new IllegalStateException("input == null");
            }
            InputStreamAdapter stream = null;
            if (!(this.input instanceof ImageInputStream)) {
                throw new IllegalArgumentException("!(input instanceof ImageInputStream)");
            }
            stream = new InputStreamAdapter((ImageInputStream)this.input);
            this.mlibImage = this.decode(stream);
        }
        return this.mlibImage;
    }

    public int getNumImages(boolean allowSearch) throws IOException {
        return 1;
    }

    public int getWidth(int imageIndex) throws IOException {
        if (imageIndex != 0) {
            throw new IllegalArgumentException("imageIndex != 0");
        }
        return this.getImage().getWidth();
    }

    public int getHeight(int imageIndex) throws IOException {
        if (imageIndex != 0) {
            throw new IllegalArgumentException("imageIndex != 0");
        }
        return this.getImage().getHeight();
    }

    public Iterator getImageTypes(int imageIndex) throws IOException {
        if (imageIndex != 0) {
            throw new IllegalArgumentException("imageIndex != 0");
        }
        ImageTypeSpecifier type = this.getRawImageType(imageIndex);
        return type != null ? new SoloIterator(type) : null;
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        if (imageIndex != 0) {
            throw new IllegalArgumentException("imageIndex != 0");
        }
        return null;
    }

    public abstract ImageTypeSpecifier getRawImageType(int var1) throws IOException;

    public synchronized BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        DataBuffer db;
        this.processImageStarted(imageIndex);
        this.processImageProgress(0.0f);
        this.processImageProgress(0.5f);
        ImageTypeSpecifier imageType = this.getRawImageType(imageIndex);
        this.processImageProgress(0.95f);
        mediaLibImage mlImage = this.getImage();
        int dataOffset = mlImage.getOffset();
        SampleModel sampleModel = imageType.getSampleModel();
        int smType = sampleModel.getDataType();
        switch (smType) {
            case 0: {
                byte[] byteData = mlImage.getType() == 0 ? mlImage.getBitData() : mlImage.getByteData();
                db = new DataBufferByte(byteData, byteData.length - dataOffset, dataOffset);
                break;
            }
            case 1: {
                short[] shortData = mlImage.getShortData();
                if (shortData == null) {
                    shortData = mlImage.getUShortData();
                }
                db = new DataBufferUShort(shortData, shortData.length - dataOffset, dataOffset);
                break;
            }
            default: {
                throw new UnsupportedOperationException(I18N.getString("Generic0") + " " + smType);
            }
        }
        WritableRaster raster = Raster.createWritableRaster(sampleModel, db, null);
        ColorModel colorModel = imageType.getColorModel();
        BufferedImage image = new BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), null);
        Rectangle destRegion = new Rectangle(image.getWidth(), image.getHeight());
        int[] destinationBands = null;
        int subX = 1;
        int subY = 1;
        if (param != null) {
            boolean isNominal;
            BufferedImage destination = param.getDestination();
            destinationBands = param.getDestinationBands();
            Point destinationOffset = param.getDestinationOffset();
            int[] sourceBands = param.getSourceBands();
            Rectangle sourceRegion = param.getSourceRegion();
            subX = param.getSourceXSubsampling();
            subY = param.getSourceYSubsampling();
            boolean bl = destination == null && destinationBands == null & destinationOffset.x == 0 && destinationOffset.y == 0 && sourceBands == null && sourceRegion == null && subX == 1 && subY == 1 ? true : (isNominal = false);
            if (!isNominal) {
                int srcWidth = image.getWidth();
                int srcHeight = image.getHeight();
                if (destination == null) {
                    destination = ImageReader.getDestination(param, this.getImageTypes(imageIndex), srcWidth, srcHeight);
                }
                ImageReader.checkReadParamBandSettings(param, image.getSampleModel().getNumBands(), destination.getSampleModel().getNumBands());
                Rectangle srcRegion = new Rectangle();
                ImageReader.computeRegions(param, srcWidth, srcHeight, destination, srcRegion, destRegion);
                WritableRaster dst = destination.getWritableTile(0, 0).createWritableChild(destRegion.x, destRegion.y, destRegion.width, destRegion.height, destRegion.x, destRegion.y, destinationBands);
                if (subX != 1 || subY != 1) {
                    WritableRaster src = image.getWritableTile(0, 0).createWritableChild(srcRegion.x, srcRegion.y, srcRegion.width, srcRegion.height, srcRegion.x, srcRegion.y, sourceBands);
                    CLibImageReader.subsample(src, subX, subY, dst);
                } else {
                    WritableRaster src = image.getWritableTile(0, 0).createWritableChild(srcRegion.x, srcRegion.y, srcRegion.width, srcRegion.height, destRegion.x, destRegion.y, sourceBands);
                    dst.setRect(src);
                }
                image = destination;
            }
        }
        this.processImageUpdate(image, destRegion.x, destRegion.y, destRegion.width, destRegion.height, subX, subY, destinationBands);
        this.processImageProgress(1.0f);
        this.processImageComplete();
        return image;
    }

    public void reset() {
        this.resetLocal();
        super.reset();
    }

    protected void resetLocal() {
        this.mlibImage = null;
    }

    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        if (input != null && !(input instanceof ImageInputStream)) {
            throw new IllegalArgumentException("!(input instanceof ImageInputStream)");
        }
        this.resetLocal();
    }

    private class SoloIterator
    implements Iterator {
        Object theObject;

        SoloIterator(Object o) {
            if (o == null) {
                new IllegalArgumentException(I18N.getString("CLibImageReader0"));
            }
            this.theObject = o;
        }

        public boolean hasNext() {
            return this.theObject != null;
        }

        public Object next() {
            if (this.theObject == null) {
                throw new NoSuchElementException();
            }
            Object theNextObject = this.theObject;
            this.theObject = null;
            return theNextObject;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

