/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.Interceptors;

import com.sun.corba.se.internal.Interceptors.PIORB;
import com.sun.corba.se.internal.Interceptors.SlotTable;
import java.util.ArrayList;
import java.util.List;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;

public class SlotTableStack {
    private List tableContainer;
    private int currentIndex;
    private SlotTablePool tablePool;
    private PIORB piOrb;

    void popSlotTable() {
        if (this.currentIndex <= 1) {
            throw new INTERNAL("Cannot pop the only PICurrent in the stack", 1398080300, CompletionStatus.COMPLETED_NO);
        }
        --this.currentIndex;
        SlotTable slotTable = (SlotTable)this.tableContainer.get(this.currentIndex);
        this.tableContainer.set(this.currentIndex, null);
        slotTable.resetSlots();
        this.tablePool.putSlotTable(slotTable);
    }

    void pushSlotTable() {
        SlotTable slotTable = this.tablePool.getSlotTable();
        if (slotTable == null) {
            SlotTable slotTable2 = this.peekSlotTable();
            slotTable = new SlotTable(this.piOrb, slotTable2.getSize());
        }
        if (this.currentIndex == this.tableContainer.size()) {
            this.tableContainer.add(this.currentIndex, slotTable);
        } else {
            if (this.currentIndex > this.tableContainer.size()) {
                throw new INTERNAL("currentIndex > tableContainer.size(): " + this.currentIndex + " > " + this.tableContainer.size());
            }
            this.tableContainer.set(this.currentIndex, slotTable);
        }
        ++this.currentIndex;
    }

    SlotTable peekSlotTable() {
        return (SlotTable)this.tableContainer.get(this.currentIndex - 1);
    }

    SlotTableStack(PIORB pIORB, SlotTable slotTable) {
        this.piOrb = pIORB;
        this.currentIndex = 0;
        this.tableContainer = new ArrayList();
        this.tablePool = new SlotTablePool(this);
        this.tableContainer.add(this.currentIndex, slotTable);
        ++this.currentIndex;
    }

    private class SlotTablePool {
        private SlotTable[] pool;
        private final int HIGH_WATER_MARK = 5;
        private int currentIndex;
        private final SlotTableStack this$0;

        SlotTable getSlotTable() {
            if (this.currentIndex == 0) {
                return null;
            }
            --this.currentIndex;
            return this.pool[this.currentIndex];
        }

        void putSlotTable(SlotTable slotTable) {
            if (this.currentIndex >= 5) {
                return;
            }
            this.pool[this.currentIndex] = slotTable;
            ++this.currentIndex;
        }

        SlotTablePool(SlotTableStack slotTableStack) {
            this.this$0 = slotTableStack;
            this.HIGH_WATER_MARK = 5;
            this.pool = new SlotTable[5];
            this.currentIndex = 0;
        }
    }
}

