/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsDesktopManager;
import com.sun.java.swing.plaf.windows.WindowsInternalFrameTitlePane;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class WindowsInternalFrameUI
extends BasicInternalFrameUI {
    XPStyle xp = XPStyle.getXP();

    public void installDefaults() {
        super.installDefaults();
        if (this.xp != null) {
            this.frame.setBorder(new XPBorder(this, null));
        } else {
            this.frame.setBorder(UIManager.getBorder("InternalFrame.border"));
        }
    }

    public void uninstallDefaults() {
        this.frame.setBorder(null);
        super.uninstallDefaults();
    }

    protected LayoutManager createLayoutManager() {
        if (XPStyle.getXP() != null) {
            return new BasicInternalFrameUI.InternalFrameLayout(this){
                private final WindowsInternalFrameUI this$0;
                {
                    this.this$0 = windowsInternalFrameUI;
                    super(windowsInternalFrameUI);
                }

                public void layoutContainer(Container container) {
                    Dimension dimension;
                    Insets insets = WindowsInternalFrameUI.access$100(this.this$0).getInsets();
                    int n2 = insets.left;
                    int n3 = 0;
                    int n4 = WindowsInternalFrameUI.access$200(this.this$0).getWidth() - insets.left - insets.right;
                    int n5 = WindowsInternalFrameUI.access$300(this.this$0).getHeight() - insets.bottom;
                    if (this.this$0.getNorthPane() != null) {
                        dimension = this.this$0.getNorthPane().getPreferredSize();
                        this.this$0.getNorthPane().setBounds(0, 0, WindowsInternalFrameUI.access$400(this.this$0).getWidth(), dimension.height);
                        n3 += dimension.height;
                        n5 -= dimension.height;
                    }
                    if (this.this$0.getSouthPane() != null) {
                        dimension = this.this$0.getSouthPane().getPreferredSize();
                        this.this$0.getSouthPane().setBounds(n2, WindowsInternalFrameUI.access$500(this.this$0).getHeight() - insets.bottom - dimension.height, n4, dimension.height);
                        n5 -= dimension.height;
                    }
                    if (this.this$0.getWestPane() != null) {
                        dimension = this.this$0.getWestPane().getPreferredSize();
                        this.this$0.getWestPane().setBounds(n2, n3, dimension.width, n5);
                        n4 -= dimension.width;
                        n2 += dimension.width;
                    }
                    if (this.this$0.getEastPane() != null) {
                        dimension = this.this$0.getEastPane().getPreferredSize();
                        this.this$0.getEastPane().setBounds(n4 - dimension.width, n3, dimension.width, n5);
                        n4 -= dimension.width;
                    }
                    if (WindowsInternalFrameUI.access$600(this.this$0).getRootPane() != null) {
                        WindowsInternalFrameUI.access$700(this.this$0).getRootPane().setBounds(n2, n3, n4, n5);
                    }
                }
            };
        }
        return super.createLayoutManager();
    }

    protected DesktopManager createDesktopManager() {
        return new WindowsDesktopManager();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setOpaque(this.xp == null);
    }

    public WindowsInternalFrameUI(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    protected JComponent createNorthPane(JInternalFrame jInternalFrame) {
        this.titlePane = new WindowsInternalFrameTitlePane(jInternalFrame);
        return this.titlePane;
    }

    static JInternalFrame access$100(WindowsInternalFrameUI windowsInternalFrameUI) {
        return windowsInternalFrameUI.frame;
    }

    static JInternalFrame access$200(WindowsInternalFrameUI windowsInternalFrameUI) {
        return windowsInternalFrameUI.frame;
    }

    static JInternalFrame access$300(WindowsInternalFrameUI windowsInternalFrameUI) {
        return windowsInternalFrameUI.frame;
    }

    static JInternalFrame access$400(WindowsInternalFrameUI windowsInternalFrameUI) {
        return windowsInternalFrameUI.frame;
    }

    static JInternalFrame access$500(WindowsInternalFrameUI windowsInternalFrameUI) {
        return windowsInternalFrameUI.frame;
    }

    static JInternalFrame access$600(WindowsInternalFrameUI windowsInternalFrameUI) {
        return windowsInternalFrameUI.frame;
    }

    static JInternalFrame access$700(WindowsInternalFrameUI windowsInternalFrameUI) {
        return windowsInternalFrameUI.frame;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsInternalFrameUI((JInternalFrame)jComponent);
    }

    static BasicInternalFrameTitlePane access$800(WindowsInternalFrameUI windowsInternalFrameUI) {
        return windowsInternalFrameUI.titlePane;
    }

    static BasicInternalFrameTitlePane access$900(WindowsInternalFrameUI windowsInternalFrameUI) {
        return windowsInternalFrameUI.titlePane;
    }

    private class XPBorder
    extends AbstractBorder {
        private XPStyle.Skin leftSkin;
        private XPStyle.Skin rightSkin;
        private XPStyle.Skin bottomSkin;
        private final WindowsInternalFrameUI this$0;

        public boolean isBorderOpaque() {
            return true;
        }

        private XPBorder(WindowsInternalFrameUI windowsInternalFrameUI) {
            this.this$0 = windowsInternalFrameUI;
            this.leftSkin = this.this$0.xp.getSkin("window.frameleft");
            this.rightSkin = this.this$0.xp.getSkin("window.frameright");
            this.bottomSkin = this.this$0.xp.getSkin("window.framebottom");
        }

        XPBorder(WindowsInternalFrameUI windowsInternalFrameUI, 1 var2_2) {
            this(windowsInternalFrameUI);
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            boolean bl2 = ((JInternalFrame)component).isSelected();
            int n6 = WindowsInternalFrameUI.access$800(this.this$0) != null ? WindowsInternalFrameUI.access$900((WindowsInternalFrameUI)this.this$0).getSize().height : 0;
            this.bottomSkin.paintSkin(graphics, 0, n5 - this.bottomSkin.getHeight(), n4, this.bottomSkin.getHeight(), bl2 ? 0 : 1);
            this.leftSkin.paintSkin(graphics, 0, n6 - 1, this.leftSkin.getWidth(), n5 - n6 - this.bottomSkin.getHeight() + 2, bl2 ? 0 : 1);
            this.rightSkin.paintSkin(graphics, n4 - this.rightSkin.getWidth(), n6 - 1, this.rightSkin.getWidth(), n5 - n6 - this.bottomSkin.getHeight() + 2, bl2 ? 0 : 1);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = 4;
            insets.left = this.leftSkin.getWidth();
            insets.right = this.rightSkin.getWidth();
            insets.bottom = this.bottomSkin.getHeight();
            return insets;
        }
    }
}

