/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public class WindowsPopupMenuUI
extends BasicPopupMenuUI {
    static MnemonicListener mnemonicListener = null;

    public void installListeners() {
        super.installListeners();
        if (!UIManager.getBoolean("Button.showMnemonics") && mnemonicListener == null) {
            mnemonicListener = new MnemonicListener();
            MenuSelectionManager.defaultManager().addChangeListener(mnemonicListener);
        }
    }

    public Popup getPopup(JPopupMenu jPopupMenu, int n2, int n3) {
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        return popupFactory.getPopup(jPopupMenu.getInvoker(), jPopupMenu, n2, n3);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsPopupMenuUI();
    }

    static class MnemonicListener
    implements ChangeListener {
        JRootPane repaintRoot = null;

        MnemonicListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            MenuSelectionManager menuSelectionManager = (MenuSelectionManager)changeEvent.getSource();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray.length == 0) {
                WindowsLookAndFeel.setMnemonicHidden(true);
                if (this.repaintRoot != null) {
                    this.repaintRoot.repaint();
                }
            } else {
                Component component = (Component)((Object)menuElementArray[0]);
                if (component instanceof JPopupMenu) {
                    component = ((JPopupMenu)component).getInvoker();
                }
                this.repaintRoot = SwingUtilities.getRootPane(component);
            }
        }
    }
}

