/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.BerDecoder;
import java.io.IOException;
import java.util.Vector;
import javax.naming.CommunicationException;

final class LdapRequest {
    LdapRequest next;
    int msgId;
    private int gotten = 0;
    private Vector replies = new Vector(3);
    private boolean cancelled = false;
    private boolean pauseAfterReceipt = false;
    private boolean completed = false;

    synchronized void cancel() {
        this.cancelled = true;
        this.notify();
    }

    synchronized boolean hasSearchCompleted() {
        return this.completed;
    }

    LdapRequest(int n2, boolean bl2) {
        this.msgId = n2;
        this.pauseAfterReceipt = bl2;
    }

    synchronized BerDecoder getReplyBer() throws CommunicationException {
        if (this.cancelled) {
            throw new CommunicationException("Request: " + this.msgId + " cancelled");
        }
        if (this.gotten < this.replies.size()) {
            BerDecoder berDecoder = (BerDecoder)this.replies.elementAt(this.gotten);
            this.replies.setElementAt(null, this.gotten);
            ++this.gotten;
            return berDecoder;
        }
        return null;
    }

    synchronized boolean addReplyBer(BerDecoder berDecoder) {
        if (this.cancelled) {
            return false;
        }
        this.replies.addElement(berDecoder);
        try {
            berDecoder.parseSeq(null);
            berDecoder.parseInt();
            this.completed = berDecoder.peekByte() == 101;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        berDecoder.reset();
        this.notify();
        return this.pauseAfterReceipt;
    }
}

