/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.geom.Dimension2D;
import java.io.Serializable;

public class Dimension
extends Dimension2D
implements Serializable {
    public int width;
    public int height;
    private static final long serialVersionUID = 4723952579491349524L;

    public double getHeight() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public int hashCode() {
        int n2 = this.width + this.height;
        return n2 * (n2 + 1) / 2 + this.width;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Dimension.initIDs();
        }
    }

    public Dimension() {
        this(0, 0);
    }

    private static native void initIDs();

    public void setSize(double d2, double d3) {
        this.width = (int)Math.ceil(d2);
        this.height = (int)Math.ceil(d3);
    }

    public Dimension(int n2, int n3) {
        this.width = n2;
        this.height = n3;
    }

    public void setSize(int n2, int n3) {
        this.width = n2;
        this.height = n3;
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension(Dimension dimension) {
        this(dimension.width, dimension.height);
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public boolean equals(Object object) {
        if (object instanceof Dimension) {
            Dimension dimension = (Dimension)object;
            return this.width == dimension.width && this.height == dimension.height;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + "[width=" + this.width + ",height=" + this.height + "]";
    }
}

