/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.HeadlessException;
import java.awt.Menu;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.Toolkit;
import java.awt.peer.PopupMenuPeer;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

public class PopupMenu
extends Menu {
    private static final String base = "popup";
    static int nameCounter = 0;
    private static final long serialVersionUID = -4620452533522760060L;

    public PopupMenu() throws HeadlessException {
        this("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.parent != null && !(this.parent instanceof Component)) {
                super.addNotify();
            } else {
                if (this.peer == null) {
                    this.peer = Toolkit.getDefaultToolkit().createPopupMenu(this);
                }
                int n2 = this.getItemCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    MenuItem menuItem = this.getItem(i2);
                    menuItem.parent = this;
                    menuItem.addNotify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show(Component component, int n2, int n3) {
        MenuContainer menuContainer = this.parent;
        if (menuContainer == null) {
            throw new NullPointerException("parent is null");
        }
        if (!(menuContainer instanceof Component)) {
            throw new IllegalArgumentException("PopupMenus with non-Component parents cannot be shown");
        }
        Component component2 = (Component)menuContainer;
        if (component2 != component && component2 instanceof Container && !((Container)component2).isAncestorOf(component)) {
            throw new IllegalArgumentException("origin not in parent's hierarchy");
        }
        if (component2.getPeer() == null || !component2.isShowing()) {
            throw new RuntimeException("parent not showing on screen");
        }
        if (this.peer == null) {
            this.addNotify();
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer != null) {
                ((PopupMenuPeer)this.peer).show(new Event(component, 0L, 501, n2, n3, 0, 0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            return base + nameCounter++;
        }
    }

    public PopupMenu(String string) throws HeadlessException {
        super(string);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTPopupMenu(this);
        }
        return this.accessibleContext;
    }

    protected class AccessibleAWTPopupMenu
    extends Menu.AccessibleAWTMenu {
        private final PopupMenu this$0;

        protected AccessibleAWTPopupMenu(PopupMenu popupMenu) {
            this.this$0 = popupMenu;
            super(popupMenu);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.POPUP_MENU;
        }
    }
}

