/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectIterator;

public abstract class RoundRectangle2D
extends RectangularShape {
    public abstract double getArcHeight();

    public abstract double getArcWidth();

    protected RoundRectangle2D() {
    }

    public boolean contains(double d2, double d3) {
        double d4;
        double d5;
        if (this.isEmpty()) {
            return false;
        }
        double d6 = this.getX();
        double d7 = this.getY();
        double d8 = d6 + this.getWidth();
        double d9 = d7 + this.getHeight();
        if (d2 < d6 || d3 < d7 || d2 >= d8 || d3 >= d9) {
            return false;
        }
        double d10 = Math.min(this.getWidth(), Math.abs(this.getArcWidth())) / 2.0;
        double d11 = Math.min(this.getHeight(), Math.abs(this.getArcHeight())) / 2.0;
        d6 += d10;
        if (d2 >= d5) {
            double d12;
            d6 = d8 - d10;
            if (d2 < d12) {
                return true;
            }
        }
        d7 += d11;
        if (d3 >= d4) {
            double d13;
            d7 = d9 - d11;
            if (d3 < d13) {
                return true;
            }
        }
        return (d2 = (d2 - d6) / d10) * d2 + (d3 = (d3 - d7) / d11) * d3 <= 1.0;
    }

    private int classify(double d2, double d3, double d4, double d5) {
        if (d2 < d3) {
            return 0;
        }
        if (d2 < d3 + d5) {
            return 1;
        }
        if (d2 < d4 - d5) {
            return 2;
        }
        if (d2 < d4) {
            return 3;
        }
        return 4;
    }

    public void setFrame(double d2, double d3, double d4, double d5) {
        this.setRoundRect(d2, d3, d4, d5, this.getArcWidth(), this.getArcHeight());
    }

    public boolean contains(double d2, double d3, double d4, double d5) {
        if (this.isEmpty() || d4 <= 0.0 || d5 <= 0.0) {
            return false;
        }
        return this.contains(d2, d3) && this.contains(d2 + d4, d3) && this.contains(d2, d3 + d5) && this.contains(d2 + d4, d3 + d5);
    }

    public boolean intersects(double d2, double d3, double d4, double d5) {
        if (this.isEmpty() || d4 <= 0.0 || d5 <= 0.0) {
            return false;
        }
        double d6 = this.getX();
        double d7 = this.getY();
        double d8 = d6 + this.getWidth();
        double d9 = d7 + this.getHeight();
        if (d2 + d4 <= d6 || d2 >= d8 || d3 + d5 <= d7 || d3 >= d9) {
            return false;
        }
        double d10 = Math.min(this.getWidth(), Math.abs(this.getArcWidth())) / 2.0;
        double d11 = Math.min(this.getHeight(), Math.abs(this.getArcHeight())) / 2.0;
        int n2 = this.classify(d2, d6, d8, d10);
        int n3 = this.classify(d2 + d4, d6, d8, d10);
        int n4 = this.classify(d3, d7, d9, d11);
        int n5 = this.classify(d3 + d5, d7, d9, d11);
        if (n2 == 2 || n3 == 2 || n4 == 2 || n5 == 2) {
            return true;
        }
        if (n2 < 2 && n3 > 2 || n4 < 2 && n5 > 2) {
            return true;
        }
        d2 = n3 == 1 ? (d2 = d2 + d4 - (d6 + d10)) : (d2 = d2 - (d8 - d10));
        d3 = n5 == 1 ? (d3 = d3 + d5 - (d7 + d11)) : (d3 = d3 - (d9 - d11));
        return (d2 /= d10) * d2 + (d3 /= d11) * d3 <= 1.0;
    }

    public abstract void setRoundRect(double var1, double var3, double var5, double var7, double var9, double var11);

    public void setRoundRect(RoundRectangle2D roundRectangle2D) {
        this.setRoundRect(roundRectangle2D.getX(), roundRectangle2D.getY(), roundRectangle2D.getWidth(), roundRectangle2D.getHeight(), roundRectangle2D.getArcWidth(), roundRectangle2D.getArcHeight());
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new RoundRectIterator(this, affineTransform);
    }

    public static class Double
    extends RoundRectangle2D {
        public double x;
        public double y;
        public double width;
        public double height;
        public double arcwidth;
        public double archeight;

        public double getArcHeight() {
            return this.archeight;
        }

        public double getArcWidth() {
            return this.arcwidth;
        }

        public double getHeight() {
            return this.height;
        }

        public double getWidth() {
            return this.width;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public Double() {
        }

        public boolean isEmpty() {
            return this.width <= 0.0 || this.height <= 0.0;
        }

        public Double(double d2, double d3, double d4, double d5, double d6, double d7) {
            this.setRoundRect(d2, d3, d4, d5, d6, d7);
        }

        public void setRoundRect(double d2, double d3, double d4, double d5, double d6, double d7) {
            this.x = d2;
            this.y = d3;
            this.width = d4;
            this.height = d5;
            this.arcwidth = d6;
            this.archeight = d7;
        }

        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
        }

        public void setRoundRect(RoundRectangle2D roundRectangle2D) {
            this.x = roundRectangle2D.getX();
            this.y = roundRectangle2D.getY();
            this.width = roundRectangle2D.getWidth();
            this.height = roundRectangle2D.getHeight();
            this.arcwidth = roundRectangle2D.getArcWidth();
            this.archeight = roundRectangle2D.getArcHeight();
        }
    }

    public static class Float
    extends RoundRectangle2D {
        public float x;
        public float y;
        public float width;
        public float height;
        public float arcwidth;
        public float archeight;

        public double getArcHeight() {
            return this.archeight;
        }

        public double getArcWidth() {
            return this.arcwidth;
        }

        public double getHeight() {
            return this.height;
        }

        public double getWidth() {
            return this.width;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public Float() {
        }

        public boolean isEmpty() {
            return this.width <= 0.0f || this.height <= 0.0f;
        }

        public void setRoundRect(double d2, double d3, double d4, double d5, double d6, double d7) {
            this.x = (float)d2;
            this.y = (float)d3;
            this.width = (float)d4;
            this.height = (float)d5;
            this.arcwidth = (float)d6;
            this.archeight = (float)d7;
        }

        public Float(float f2, float f3, float f4, float f5, float f6, float f7) {
            this.setRoundRect(f2, f3, f4, f5, f6, f7);
        }

        public void setRoundRect(float f2, float f3, float f4, float f5, float f6, float f7) {
            this.x = f2;
            this.y = f3;
            this.width = f4;
            this.height = f5;
            this.arcwidth = f6;
            this.archeight = f7;
        }

        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Float(this.x, this.y, this.width, this.height);
        }

        public void setRoundRect(RoundRectangle2D roundRectangle2D) {
            this.x = (float)roundRectangle2D.getX();
            this.y = (float)roundRectangle2D.getY();
            this.width = (float)roundRectangle2D.getWidth();
            this.height = (float)roundRectangle2D.getHeight();
            this.arcwidth = (float)roundRectangle2D.getArcWidth();
            this.archeight = (float)roundRectangle2D.getArcHeight();
        }
    }
}

