/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.Date;

public abstract class HttpURLConnection
extends URLConnection {
    protected String method = "GET";
    protected int responseCode = -1;
    protected String responseMessage = null;
    private static boolean followRedirects = true;
    protected boolean instanceFollowRedirects = followRedirects;
    private static final String[] methods = new String[]{"GET", "POST", "HEAD", "OPTIONS", "PUT", "DELETE", "TRACE"};
    public static final int HTTP_OK = 200;
    public static final int HTTP_CREATED = 201;
    public static final int HTTP_ACCEPTED = 202;
    public static final int HTTP_NOT_AUTHORITATIVE = 203;
    public static final int HTTP_NO_CONTENT = 204;
    public static final int HTTP_RESET = 205;
    public static final int HTTP_PARTIAL = 206;
    public static final int HTTP_MULT_CHOICE = 300;
    public static final int HTTP_MOVED_PERM = 301;
    public static final int HTTP_MOVED_TEMP = 302;
    public static final int HTTP_SEE_OTHER = 303;
    public static final int HTTP_NOT_MODIFIED = 304;
    public static final int HTTP_USE_PROXY = 305;
    public static final int HTTP_BAD_REQUEST = 400;
    public static final int HTTP_UNAUTHORIZED = 401;
    public static final int HTTP_PAYMENT_REQUIRED = 402;
    public static final int HTTP_FORBIDDEN = 403;
    public static final int HTTP_NOT_FOUND = 404;
    public static final int HTTP_BAD_METHOD = 405;
    public static final int HTTP_NOT_ACCEPTABLE = 406;
    public static final int HTTP_PROXY_AUTH = 407;
    public static final int HTTP_CLIENT_TIMEOUT = 408;
    public static final int HTTP_CONFLICT = 409;
    public static final int HTTP_GONE = 410;
    public static final int HTTP_LENGTH_REQUIRED = 411;
    public static final int HTTP_PRECON_FAILED = 412;
    public static final int HTTP_ENTITY_TOO_LARGE = 413;
    public static final int HTTP_REQ_TOO_LONG = 414;
    public static final int HTTP_UNSUPPORTED_TYPE = 415;
    public static final int HTTP_SERVER_ERROR = 500;
    public static final int HTTP_INTERNAL_ERROR = 500;
    public static final int HTTP_NOT_IMPLEMENTED = 501;
    public static final int HTTP_BAD_GATEWAY = 502;
    public static final int HTTP_UNAVAILABLE = 503;
    public static final int HTTP_GATEWAY_TIMEOUT = 504;
    public static final int HTTP_VERSION = 505;

    public int getResponseCode() throws IOException {
        int n2;
        if (this.responseCode != -1) {
            return this.responseCode;
        }
        Exception exception = null;
        try {
            this.getInputStream();
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        String string = this.getHeaderField(0);
        if (string == null) {
            if (exception != null) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw (IOException)exception;
            }
            return -1;
        }
        if (string.startsWith("HTTP/1.") && (n2 = string.indexOf(32)) > 0) {
            int n3 = string.indexOf(32, n2 + 1);
            if (n3 > 0 && n3 < string.length()) {
                this.responseMessage = string.substring(n3 + 1);
            }
            if (n3 < 0) {
                n3 = string.length();
            }
            try {
                this.responseCode = Integer.parseInt(string.substring(n2 + 1, n3));
                return this.responseCode;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public abstract void disconnect();

    public static boolean getFollowRedirects() {
        return followRedirects;
    }

    public boolean getInstanceFollowRedirects() {
        return this.instanceFollowRedirects;
    }

    public abstract boolean usingProxy();

    public static void setFollowRedirects(boolean bl2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        followRedirects = bl2;
    }

    public void setInstanceFollowRedirects(boolean bl2) {
        this.instanceFollowRedirects = bl2;
    }

    public InputStream getErrorStream() {
        return null;
    }

    public String getRequestMethod() {
        return this.method;
    }

    public String getResponseMessage() throws IOException {
        this.getResponseCode();
        return this.responseMessage;
    }

    public String getHeaderField(int n2) {
        return null;
    }

    public String getHeaderFieldKey(int n2) {
        return null;
    }

    public void setRequestMethod(String string) throws ProtocolException {
        if (this.connected) {
            throw new ProtocolException("Can't reset method: already connected");
        }
        for (int i2 = 0; i2 < methods.length; ++i2) {
            if (!methods[i2].equals(string)) continue;
            this.method = string;
            return;
        }
        throw new ProtocolException("Invalid HTTP method: " + string);
    }

    public long getHeaderFieldDate(String string, long l2) {
        String string2 = this.getHeaderField(string);
        try {
            string2.trim();
            if (string2.indexOf("GMT") == -1) {
                string2 = string2 + " GMT";
            }
            return Date.parse(string2);
        }
        catch (Exception exception) {
            return l2;
        }
    }

    protected HttpURLConnection(URL uRL) {
        super(uRL);
    }

    public Permission getPermission() throws IOException {
        int n2 = this.url.getPort();
        n2 = n2 < 0 ? 80 : n2;
        String string = this.url.getHost() + ":" + n2;
        SocketPermission socketPermission = new SocketPermission(string, "connect");
        return socketPermission;
    }
}

