/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;

public class DigestInputStream
extends FilterInputStream {
    private boolean on = true;
    protected MessageDigest digest;

    public int read() throws IOException {
        int n2 = this.in.read();
        if (this.on && n2 != -1) {
            this.digest.update((byte)n2);
        }
        return n2;
    }

    public void on(boolean bl2) {
        this.on = bl2;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.in.read(byArray, n2, n3);
        if (this.on && n4 != -1) {
            this.digest.update(byArray, n2, n4);
        }
        return n4;
    }

    public String toString() {
        return "[Digest Input Stream] " + this.digest.toString();
    }

    public MessageDigest getMessageDigest() {
        return this.digest;
    }

    public void setMessageDigest(MessageDigest messageDigest) {
        this.digest = messageDigest;
    }

    public DigestInputStream(InputStream inputStream, MessageDigest messageDigest) {
        super(inputStream);
        this.setMessageDigest(messageDigest);
    }
}

