/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.metadata;

import com.sun.imageio.plugins.common.StandardMetadataFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadataFormat;

public abstract class IIOMetadataFormatImpl
implements IIOMetadataFormat {
    public static final String standardMetadataFormatName = "javax_imageio_1.0";
    private static IIOMetadataFormat standardFormat = null;
    private String resourceBaseName = this.getClass().getName() + "Resources";
    private String rootName;
    private HashMap elementMap = new HashMap();

    private static synchronized void createStandardFormat() {
        if (standardFormat == null) {
            standardFormat = new StandardMetadataFormat();
        }
    }

    protected String getResourceBaseName() {
        return this.resourceBaseName;
    }

    public String getRootName() {
        return this.rootName;
    }

    public int getChildPolicy(String string) {
        Element element = this.getElement(string);
        return element.childPolicy;
    }

    public int getElementMaxChildren(String string) {
        Element element = this.getElement(string);
        if (element.childPolicy != 5) {
            throw new IllegalArgumentException("Child policy not CHILD_POLICY_REPEAT!");
        }
        return element.maxChildren;
    }

    public int getElementMinChildren(String string) {
        Element element = this.getElement(string);
        if (element.childPolicy != 5) {
            throw new IllegalArgumentException("Child policy not CHILD_POLICY_REPEAT!");
        }
        return element.minChildren;
    }

    public int getObjectArrayMaxLength(String string) {
        ObjectValue objectValue = this.getObjectValue(string);
        if (objectValue.valueType != 32) {
            throw new IllegalArgumentException("Not a list!");
        }
        return objectValue.arrayMaxLength;
    }

    public int getObjectArrayMinLength(String string) {
        ObjectValue objectValue = this.getObjectValue(string);
        if (objectValue.valueType != 32) {
            throw new IllegalArgumentException("Not a list!");
        }
        return objectValue.arrayMinLength;
    }

    public int getObjectValueType(String string) {
        Element element = this.getElement(string);
        ObjectValue objectValue = element.objectValue;
        if (objectValue == null) {
            return 0;
        }
        return objectValue.valueType;
    }

    protected void removeElement(String string) {
        Element element = this.getElement(string, false);
        if (element != null) {
            Iterator iterator = element.parentList.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Element element2 = this.getElement(string2, false);
                if (element2 == null) continue;
                element2.childList.remove(string);
            }
            this.elementMap.remove(string);
        }
    }

    protected void removeObjectValue(String string) {
        Element element = this.getElement(string);
        element.objectValue = null;
    }

    protected void setResourceBaseName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("resourceBaseName == null!");
        }
        this.resourceBaseName = string;
    }

    public IIOMetadataFormatImpl(String string, int n2) {
        if (string == null) {
            throw new IllegalArgumentException("rootName == null!");
        }
        if (n2 < 0 || n2 > 5 || n2 == 5) {
            throw new IllegalArgumentException("Invalid value for childPolicy!");
        }
        this.rootName = string;
        Element element = new Element(this);
        element.elementName = string;
        element.childPolicy = n2;
        this.elementMap.put(string, element);
    }

    public IIOMetadataFormatImpl(String string, int n2, int n3) {
        if (string == null) {
            throw new IllegalArgumentException("rootName == null!");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("minChildren < 0!");
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("minChildren > maxChildren!");
        }
        Element element = new Element(this);
        element.elementName = string;
        element.childPolicy = 5;
        element.minChildren = n2;
        element.maxChildren = n3;
        this.rootName = string;
        this.elementMap.put(string, element);
    }

    public static IIOMetadataFormat getStandardFormatInstance() {
        IIOMetadataFormatImpl.createStandardFormat();
        return standardFormat;
    }

    public Class getObjectClass(String string) {
        ObjectValue objectValue = this.getObjectValue(string);
        return objectValue.classType;
    }

    protected void addObjectValue(String string, Class clazz, int n2, int n3) {
        Element element = this.getElement(string);
        ObjectValue objectValue = new ObjectValue(this);
        objectValue.valueType = 32;
        objectValue.classType = clazz;
        objectValue.arrayMinLength = n2;
        objectValue.arrayMaxLength = n3;
        element.objectValue = objectValue;
    }

    public Comparable getObjectMaxValue(String string) {
        ObjectValue objectValue = this.getObjectValue(string);
        if ((objectValue.valueType & 2) != 2) {
            throw new IllegalArgumentException("Not a range!");
        }
        return objectValue.maxValue;
    }

    public Comparable getObjectMinValue(String string) {
        ObjectValue objectValue = this.getObjectValue(string);
        if ((objectValue.valueType & 2) != 2) {
            throw new IllegalArgumentException("Not a range!");
        }
        return objectValue.minValue;
    }

    public Object getObjectDefaultValue(String string) {
        ObjectValue objectValue = this.getObjectValue(string);
        return objectValue.defaultValue;
    }

    public Object[] getObjectEnumerations(String string) {
        ObjectValue objectValue = this.getObjectValue(string);
        if (objectValue.valueType != 16) {
            throw new IllegalArgumentException("Not an enumeration!");
        }
        List list = objectValue.enumeratedValues;
        Object[] objectArray = new Object[list.size()];
        return list.toArray(objectArray);
    }

    public String[] getAttributeNames(String string) {
        Element element = this.getElement(string);
        List list = element.attrList;
        Object[] objectArray = new String[list.size()];
        return (String[])list.toArray(objectArray);
    }

    public String[] getChildNames(String string) {
        Element element = this.getElement(string);
        if (element.childPolicy == 0) {
            return null;
        }
        return (String[])element.childList.toArray(new String[0]);
    }

    public int getAttributeDataType(String string, String string2) {
        Attribute attribute = this.getAttribute(string, string2);
        return attribute.dataType;
    }

    public int getAttributeListMaxLength(String string, String string2) {
        Attribute attribute = this.getAttribute(string, string2);
        if (attribute.valueType != 32) {
            throw new IllegalArgumentException("Attribute not a list!");
        }
        return attribute.listMaxLength;
    }

    public int getAttributeListMinLength(String string, String string2) {
        Attribute attribute = this.getAttribute(string, string2);
        if (attribute.valueType != 32) {
            throw new IllegalArgumentException("Attribute not a list!");
        }
        return attribute.listMinLength;
    }

    public int getAttributeValueType(String string, String string2) {
        Attribute attribute = this.getAttribute(string, string2);
        return attribute.valueType;
    }

    protected void addChildElement(String string, String string2) {
        Element element = this.getElement(string2);
        Element element2 = this.getElement(string);
        element.childList.add(string);
        element2.parentList.add(string2);
    }

    protected void removeAttribute(String string, String string2) {
        Element element = this.getElement(string);
        element.attrList.remove(string2);
        element.attrMap.remove(string2);
    }

    public boolean isAttributeRequired(String string, String string2) {
        Attribute attribute = this.getAttribute(string, string2);
        return attribute.required;
    }

    protected void addElement(String string, String string2, int n2) {
        Element element = this.getElement(string2);
        if (n2 < 0 || n2 > 5 || n2 == 5) {
            throw new IllegalArgumentException("Invalid value for childPolicy!");
        }
        Element element2 = new Element(this);
        element2.elementName = string;
        element2.childPolicy = n2;
        element.childList.add(string);
        element2.parentList.add(string2);
        this.elementMap.put(string, element2);
    }

    protected void addElement(String string, String string2, int n2, int n3) {
        Element element = this.getElement(string2);
        if (n2 < 0) {
            throw new IllegalArgumentException("minChildren < 0!");
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("minChildren > maxChildren!");
        }
        Element element2 = new Element(this);
        element2.elementName = string;
        element2.childPolicy = 5;
        element2.minChildren = n2;
        element2.maxChildren = n3;
        element.childList.add(string);
        element2.parentList.add(string2);
        this.elementMap.put(string, element2);
    }

    protected void addAttribute(String string, String string2, int n2, boolean bl2, int n3, int n4) {
        Element element = this.getElement(string);
        if (string2 == null) {
            throw new IllegalArgumentException("attrName == null!");
        }
        if (n2 < 0 || n2 > 4) {
            throw new IllegalArgumentException("Invalid value for dataType!");
        }
        if (n3 < 0 || n3 > n4) {
            throw new IllegalArgumentException("Invalid list bounds!");
        }
        Attribute attribute = new Attribute(this);
        attribute.attrName = string2;
        attribute.valueType = 32;
        attribute.dataType = n2;
        attribute.required = bl2;
        attribute.listMinLength = n3;
        attribute.listMaxLength = n4;
        element.attrList.add(string2);
        element.attrMap.put(string2, attribute);
    }

    protected void addBooleanAttribute(String string, String string2, boolean bl2, boolean bl3) {
        ArrayList arrayList = new ArrayList();
        arrayList.add("TRUE");
        arrayList.add("FALSE");
        String string3 = null;
        if (bl2) {
            string3 = bl3 ? "TRUE" : "FALSE";
        }
        this.addAttribute(string, string2, 1, true, string3, arrayList);
    }

    public abstract boolean canNodeAppear(String var1, ImageTypeSpecifier var2);

    private Element getElement(String string) {
        return this.getElement(string, true);
    }

    private Element getElement(String string, boolean bl2) {
        if (bl2 && string == null) {
            throw new IllegalArgumentException("element name is null!");
        }
        Element element = (Element)this.elementMap.get(string);
        if (bl2 && element == null) {
            throw new IllegalArgumentException("No such element: " + string);
        }
        return element;
    }

    private ObjectValue getObjectValue(String string) {
        Element element = this.getElement(string);
        ObjectValue objectValue = element.objectValue;
        if (objectValue == null) {
            throw new IllegalArgumentException("No object within element " + string + "!");
        }
        return objectValue;
    }

    protected void addObjectValue(String string, Class clazz, boolean bl2, Object object) {
        Element element = this.getElement(string);
        ObjectValue objectValue = new ObjectValue(this);
        objectValue.valueType = 1;
        objectValue.classType = clazz;
        objectValue.defaultValue = object;
        element.objectValue = objectValue;
    }

    public String getAttributeDefaultValue(String string, String string2) {
        Attribute attribute = this.getAttribute(string, string2);
        return attribute.defaultValue;
    }

    public String getAttributeMaxValue(String string, String string2) {
        Attribute attribute = this.getAttribute(string, string2);
        if (attribute.valueType != 2 && attribute.valueType != 6 && attribute.valueType != 10 && attribute.valueType != 14) {
            throw new IllegalArgumentException("Attribute not a range!");
        }
        return attribute.maxValue;
    }

    public String getAttributeMinValue(String string, String string2) {
        Attribute attribute = this.getAttribute(string, string2);
        if (attribute.valueType != 2 && attribute.valueType != 6 && attribute.valueType != 10 && attribute.valueType != 14) {
            throw new IllegalArgumentException("Attribute not a range!");
        }
        return attribute.minValue;
    }

    public String[] getAttributeEnumerations(String string, String string2) {
        Attribute attribute = this.getAttribute(string, string2);
        if (attribute.valueType != 16) {
            throw new IllegalArgumentException("Attribute not an enumeration!");
        }
        List list = attribute.enumeratedValues;
        Iterator iterator = list.iterator();
        Object[] objectArray = new String[list.size()];
        return (String[])list.toArray(objectArray);
    }

    protected void addAttribute(String string, String string2, int n2, boolean bl2, String string3) {
        Element element = this.getElement(string);
        if (string2 == null) {
            throw new IllegalArgumentException("attrName == null!");
        }
        if (n2 < 0 || n2 > 4) {
            throw new IllegalArgumentException("Invalid value for dataType!");
        }
        Attribute attribute = new Attribute(this);
        attribute.attrName = string2;
        attribute.valueType = 1;
        attribute.dataType = n2;
        attribute.required = bl2;
        attribute.defaultValue = string3;
        element.attrList.add(string2);
        element.attrMap.put(string2, attribute);
    }

    public String getElementDescription(String string, Locale locale) {
        Element element = this.getElement(string);
        return this.getResource(string, locale);
    }

    private String getResource(String string, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(this.resourceBaseName, locale);
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private Attribute getAttribute(String string, String string2) {
        Element element = this.getElement(string);
        Attribute attribute = (Attribute)element.attrMap.get(string2);
        if (attribute == null) {
            throw new IllegalArgumentException("No such attribute \"" + string2 + "\"!");
        }
        return attribute;
    }

    public String getAttributeDescription(String string, String string2, Locale locale) {
        Element element = this.getElement(string);
        if (string2 == null) {
            throw new IllegalArgumentException("attrName == null!");
        }
        Attribute attribute = (Attribute)element.attrMap.get(string2);
        if (attribute == null) {
            throw new IllegalArgumentException("No such attribute!");
        }
        String string3 = string + "/" + string2;
        return this.getResource(string3, locale);
    }

    protected void addObjectValue(String string, Class clazz, boolean bl2, Object object, List list) {
        Object object2;
        Element element = this.getElement(string);
        if (list == null) {
            throw new IllegalArgumentException("enumeratedValues == null!");
        }
        if (list.size() == 0) {
            throw new IllegalArgumentException("enumeratedValues is empty!");
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (object2 == null) {
                throw new IllegalArgumentException("enumeratedValues contains a null!");
            }
            if (clazz.isInstance(object2)) continue;
            throw new IllegalArgumentException("enumeratedValues contains a value not of class classType!");
        }
        object2 = new ObjectValue(this);
        ((ObjectValue)object2).valueType = 16;
        ((ObjectValue)object2).classType = clazz;
        ((ObjectValue)object2).defaultValue = object;
        ((ObjectValue)object2).enumeratedValues = list;
        element.objectValue = object2;
    }

    protected void addAttribute(String string, String string2, int n2, boolean bl2, String string3, List list) {
        Object object;
        Element element = this.getElement(string);
        if (string2 == null) {
            throw new IllegalArgumentException("attrName == null!");
        }
        if (n2 < 0 || n2 > 4) {
            throw new IllegalArgumentException("Invalid value for dataType!");
        }
        if (list == null) {
            throw new IllegalArgumentException("enumeratedValues == null!");
        }
        if (list.size() == 0) {
            throw new IllegalArgumentException("enumeratedValues is empty!");
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object == null) {
                throw new IllegalArgumentException("enumeratedValues contains a null!");
            }
            if (object instanceof String) continue;
            throw new IllegalArgumentException("enumeratedValues contains a non-String value!");
        }
        object = new Attribute(this);
        ((Attribute)object).attrName = string2;
        ((Attribute)object).valueType = 16;
        ((Attribute)object).dataType = n2;
        ((Attribute)object).required = bl2;
        ((Attribute)object).defaultValue = string3;
        ((Attribute)object).enumeratedValues = list;
        element.attrList.add(string2);
        element.attrMap.put(string2, object);
    }

    protected void addObjectValue(String string, Class clazz, Object object, Comparable comparable, Comparable comparable2, boolean bl2, boolean bl3) {
        Element element = this.getElement(string);
        ObjectValue objectValue = new ObjectValue(this);
        objectValue.valueType = 2;
        if (bl2) {
            objectValue.valueType |= 4;
        }
        if (bl3) {
            objectValue.valueType |= 8;
        }
        objectValue.classType = clazz;
        objectValue.defaultValue = object;
        objectValue.minValue = comparable;
        objectValue.maxValue = comparable2;
        element.objectValue = objectValue;
    }

    protected void addAttribute(String string, String string2, int n2, boolean bl2, String string3, String string4, String string5, boolean bl3, boolean bl4) {
        Element element = this.getElement(string);
        if (string2 == null) {
            throw new IllegalArgumentException("attrName == null!");
        }
        if (n2 < 0 || n2 > 4) {
            throw new IllegalArgumentException("Invalid value for dataType!");
        }
        Attribute attribute = new Attribute(this);
        attribute.attrName = string2;
        attribute.valueType = 2;
        if (bl3) {
            attribute.valueType |= 4;
        }
        if (bl4) {
            attribute.valueType |= 8;
        }
        attribute.dataType = n2;
        attribute.required = bl2;
        attribute.defaultValue = string3;
        attribute.minValue = string4;
        attribute.maxValue = string5;
        element.attrList.add(string2);
        element.attrMap.put(string2, attribute);
    }

    class Attribute {
        String attrName;
        int valueType;
        int dataType;
        boolean required;
        String defaultValue;
        List enumeratedValues;
        String minValue;
        String maxValue;
        int listMinLength;
        int listMaxLength;
        private final IIOMetadataFormatImpl this$0;

        Attribute(IIOMetadataFormatImpl iIOMetadataFormatImpl) {
            this.this$0 = iIOMetadataFormatImpl;
            this.valueType = 1;
            this.defaultValue = null;
        }
    }

    class Element {
        String elementName;
        int childPolicy;
        int minChildren;
        int maxChildren;
        List childList;
        List parentList;
        List attrList;
        Map attrMap;
        ObjectValue objectValue;
        private final IIOMetadataFormatImpl this$0;

        Element(IIOMetadataFormatImpl iIOMetadataFormatImpl) {
            this.this$0 = iIOMetadataFormatImpl;
            this.minChildren = 0;
            this.maxChildren = 0;
            this.childList = new ArrayList();
            this.parentList = new ArrayList();
            this.attrList = new ArrayList();
            this.attrMap = new HashMap();
        }
    }

    class ObjectValue {
        int valueType;
        Class classType;
        Object defaultValue;
        List enumeratedValues;
        Comparable minValue;
        Comparable maxValue;
        int arrayMinLength;
        int arrayMaxLength;
        private final IIOMetadataFormatImpl this$0;

        ObjectValue(IIOMetadataFormatImpl iIOMetadataFormatImpl) {
            this.this$0 = iIOMetadataFormatImpl;
            this.valueType = 0;
            this.classType = null;
            this.defaultValue = null;
            this.enumeratedValues = null;
            this.minValue = null;
            this.maxValue = null;
            this.arrayMinLength = 0;
            this.arrayMaxLength = 0;
        }
    }
}

