/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractActionPropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.plaf.MenuItemUI;

public class JMenuItem
extends AbstractButton
implements Accessible,
MenuElement {
    private static final String uiClassID = "MenuItemUI";
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    private boolean isMouseDragged = false;
    private KeyStroke accelerator;
    static Class class$javax$swing$JInternalFrame;
    static Class class$javax$swing$event$MenuDragMouseListener;
    static Class class$javax$swing$event$MenuKeyListener;

    public JMenuItem() {
        this(null, null);
    }

    void initFocusability() {
        this.setFocusable(false);
    }

    public void updateUI() {
        this.setUI((MenuItemUI)UIManager.getUI(this));
    }

    boolean alwaysOnTop() {
        return SwingUtilities.getAncestorOfClass(class$javax$swing$JInternalFrame == null ? (class$javax$swing$JInternalFrame = JMenuItem.class$("javax.swing.JInternalFrame")) : class$javax$swing$JInternalFrame, this) == null;
    }

    public boolean isArmed() {
        ButtonModel buttonModel = this.getModel();
        return buttonModel.isArmed();
    }

    public void menuSelectionChanged(boolean bl2) {
        this.setArmed(bl2);
    }

    public void setArmed(boolean bl2) {
        ButtonModel buttonModel = this.getModel();
        boolean bl3 = buttonModel.isArmed();
        if (this.accessibleContext != null && bl3 != bl2) {
            if (bl2) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.ARMED);
            } else {
                this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.ARMED, null);
            }
        }
        if (buttonModel.isArmed() != bl2) {
            buttonModel.setArmed(bl2);
        }
    }

    public void setEnabled(boolean bl2) {
        if (!bl2) {
            this.setArmed(false);
        }
        super.setEnabled(bl2);
    }

    public Component getComponent() {
        return this;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.getUIClassID().equals(uiClassID)) {
            this.updateUI();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected String paramString() {
        return super.paramString();
    }

    public JMenuItem(String string) {
        this(string, null);
    }

    public JMenuItem(String string, int n2) {
        this.setModel(new DefaultButtonModel());
        this.init(string, null);
        this.setMnemonic(n2);
        this.initFocusability();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJMenuItem(this);
        }
        return this.accessibleContext;
    }

    public JMenuItem(Action action) {
        this();
        this.setAction(action);
    }

    protected void configurePropertiesFromAction(Action action) {
        super.configurePropertiesFromAction(action);
        KeyStroke keyStroke = action == null ? null : (KeyStroke)action.getValue("AcceleratorKey");
        this.setAccelerator(keyStroke == null ? null : keyStroke);
    }

    public JMenuItem(Icon icon) {
        this(null, icon);
    }

    public KeyStroke getAccelerator() {
        return this.accelerator;
    }

    public void setAccelerator(KeyStroke keyStroke) {
        KeyStroke keyStroke2 = this.accelerator;
        this.accelerator = keyStroke;
        this.firePropertyChange("accelerator", keyStroke2, this.accelerator);
    }

    public MenuElement[] getSubElements() {
        return new MenuElement[0];
    }

    protected void fireMenuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (class$javax$swing$event$MenuDragMouseListener == null ? JMenuItem.class$("javax.swing.event.MenuDragMouseListener") : class$javax$swing$event$MenuDragMouseListener)) continue;
            ((MenuDragMouseListener)objectArray[i2 + 1]).menuDragMouseDragged(menuDragMouseEvent);
        }
    }

    protected void fireMenuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (class$javax$swing$event$MenuDragMouseListener == null ? JMenuItem.class$("javax.swing.event.MenuDragMouseListener") : class$javax$swing$event$MenuDragMouseListener)) continue;
            ((MenuDragMouseListener)objectArray[i2 + 1]).menuDragMouseEntered(menuDragMouseEvent);
        }
    }

    protected void fireMenuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (class$javax$swing$event$MenuDragMouseListener == null ? JMenuItem.class$("javax.swing.event.MenuDragMouseListener") : class$javax$swing$event$MenuDragMouseListener)) continue;
            ((MenuDragMouseListener)objectArray[i2 + 1]).menuDragMouseExited(menuDragMouseEvent);
        }
    }

    protected void fireMenuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (class$javax$swing$event$MenuDragMouseListener == null ? JMenuItem.class$("javax.swing.event.MenuDragMouseListener") : class$javax$swing$event$MenuDragMouseListener)) continue;
            ((MenuDragMouseListener)objectArray[i2 + 1]).menuDragMouseReleased(menuDragMouseEvent);
        }
    }

    public void processMenuDragMouseEvent(MenuDragMouseEvent menuDragMouseEvent) {
        switch (menuDragMouseEvent.getID()) {
            case 504: {
                this.isMouseDragged = false;
                this.fireMenuDragMouseEntered(menuDragMouseEvent);
                break;
            }
            case 505: {
                this.isMouseDragged = false;
                this.fireMenuDragMouseExited(menuDragMouseEvent);
                break;
            }
            case 506: {
                this.isMouseDragged = true;
                this.fireMenuDragMouseDragged(menuDragMouseEvent);
                break;
            }
            case 502: {
                if (!this.isMouseDragged) break;
                this.fireMenuDragMouseReleased(menuDragMouseEvent);
                break;
            }
        }
    }

    public MenuDragMouseListener[] getMenuDragMouseListeners() {
        return (MenuDragMouseListener[])this.listenerList.getListeners(class$javax$swing$event$MenuDragMouseListener == null ? (class$javax$swing$event$MenuDragMouseListener = JMenuItem.class$("javax.swing.event.MenuDragMouseListener")) : class$javax$swing$event$MenuDragMouseListener);
    }

    public void addMenuDragMouseListener(MenuDragMouseListener menuDragMouseListener) {
        this.listenerList.add(class$javax$swing$event$MenuDragMouseListener == null ? (class$javax$swing$event$MenuDragMouseListener = JMenuItem.class$("javax.swing.event.MenuDragMouseListener")) : class$javax$swing$event$MenuDragMouseListener, menuDragMouseListener);
    }

    public void removeMenuDragMouseListener(MenuDragMouseListener menuDragMouseListener) {
        this.listenerList.remove(class$javax$swing$event$MenuDragMouseListener == null ? (class$javax$swing$event$MenuDragMouseListener = JMenuItem.class$("javax.swing.event.MenuDragMouseListener")) : class$javax$swing$event$MenuDragMouseListener, menuDragMouseListener);
    }

    protected void fireMenuKeyPressed(MenuKeyEvent menuKeyEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (class$javax$swing$event$MenuKeyListener == null ? JMenuItem.class$("javax.swing.event.MenuKeyListener") : class$javax$swing$event$MenuKeyListener)) continue;
            ((MenuKeyListener)objectArray[i2 + 1]).menuKeyPressed(menuKeyEvent);
        }
    }

    protected void fireMenuKeyReleased(MenuKeyEvent menuKeyEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (class$javax$swing$event$MenuKeyListener == null ? JMenuItem.class$("javax.swing.event.MenuKeyListener") : class$javax$swing$event$MenuKeyListener)) continue;
            ((MenuKeyListener)objectArray[i2 + 1]).menuKeyReleased(menuKeyEvent);
        }
    }

    protected void fireMenuKeyTyped(MenuKeyEvent menuKeyEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (class$javax$swing$event$MenuKeyListener == null ? JMenuItem.class$("javax.swing.event.MenuKeyListener") : class$javax$swing$event$MenuKeyListener)) continue;
            ((MenuKeyListener)objectArray[i2 + 1]).menuKeyTyped(menuKeyEvent);
        }
    }

    public void processMenuKeyEvent(MenuKeyEvent menuKeyEvent) {
        switch (menuKeyEvent.getID()) {
            case 401: {
                this.fireMenuKeyPressed(menuKeyEvent);
                break;
            }
            case 402: {
                this.fireMenuKeyReleased(menuKeyEvent);
                break;
            }
            case 400: {
                this.fireMenuKeyTyped(menuKeyEvent);
                break;
            }
        }
    }

    public MenuKeyListener[] getMenuKeyListeners() {
        return (MenuKeyListener[])this.listenerList.getListeners(class$javax$swing$event$MenuKeyListener == null ? (class$javax$swing$event$MenuKeyListener = JMenuItem.class$("javax.swing.event.MenuKeyListener")) : class$javax$swing$event$MenuKeyListener);
    }

    public void addMenuKeyListener(MenuKeyListener menuKeyListener) {
        this.listenerList.add(class$javax$swing$event$MenuKeyListener == null ? (class$javax$swing$event$MenuKeyListener = JMenuItem.class$("javax.swing.event.MenuKeyListener")) : class$javax$swing$event$MenuKeyListener, menuKeyListener);
    }

    public void removeMenuKeyListener(MenuKeyListener menuKeyListener) {
        this.listenerList.remove(class$javax$swing$event$MenuKeyListener == null ? (class$javax$swing$event$MenuKeyListener = JMenuItem.class$("javax.swing.event.MenuKeyListener")) : class$javax$swing$event$MenuKeyListener, menuKeyListener);
    }

    public void setUI(MenuItemUI menuItemUI) {
        super.setUI(menuItemUI);
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
        return new AbstractActionPropertyChangeListener(this, this, action){
            private final JMenuItem this$0;

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                JMenuItem jMenuItem = (JMenuItem)this.getTarget();
                if (jMenuItem == null) {
                    Action action = (Action)propertyChangeEvent.getSource();
                    action.removePropertyChangeListener(this);
                } else if (propertyChangeEvent.getPropertyName().equals("Name")) {
                    String string2 = (String)propertyChangeEvent.getNewValue();
                    jMenuItem.setText(string2);
                    jMenuItem.repaint();
                } else if (string.equals("enabled")) {
                    Boolean bl2 = (Boolean)propertyChangeEvent.getNewValue();
                    jMenuItem.setEnabled(bl2);
                    jMenuItem.repaint();
                } else if (propertyChangeEvent.getPropertyName().equals("SmallIcon")) {
                    Icon icon = (Icon)propertyChangeEvent.getNewValue();
                    jMenuItem.setIcon(icon);
                    jMenuItem.invalidate();
                    jMenuItem.repaint();
                } else if (propertyChangeEvent.getPropertyName().equals("MnemonicKey")) {
                    Integer n2 = (Integer)propertyChangeEvent.getNewValue();
                    jMenuItem.setMnemonic(n2);
                    jMenuItem.invalidate();
                    jMenuItem.repaint();
                }
            }
            {
                this.this$0 = jMenuItem;
                super(jComponent, action);
            }
        };
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public JMenuItem(String string, Icon icon) {
        this.setModel(new DefaultButtonModel());
        this.init(string, icon);
        this.initFocusability();
    }

    protected void init(String string, Icon icon) {
        if (string != null) {
            this.setText(string);
        }
        if (icon != null) {
            this.setIcon(icon);
        }
        this.addFocusListener(new MenuItemFocusListener(null));
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setHorizontalTextPosition(11);
        this.setHorizontalAlignment(10);
        this.updateUI();
    }

    public void processKeyEvent(KeyEvent keyEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
        MenuKeyEvent menuKeyEvent = new MenuKeyEvent(keyEvent.getComponent(), keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar(), menuElementArray, menuSelectionManager);
        this.processMenuKeyEvent(menuKeyEvent);
        if (menuKeyEvent.isConsumed()) {
            keyEvent.consume();
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
        this.processMenuDragMouseEvent(new MenuDragMouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), menuElementArray, menuSelectionManager));
    }

    protected class AccessibleJMenuItem
    extends AbstractButton.AccessibleAbstractButton
    implements ChangeListener {
        private boolean isArmed;
        private boolean hasFocus;
        private boolean isPressed;
        private boolean isSelected;
        private final JMenuItem this$0;

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_ITEM;
        }

        AccessibleJMenuItem(JMenuItem jMenuItem) {
            this.this$0 = jMenuItem;
            super(jMenuItem);
            this.isArmed = false;
            this.hasFocus = false;
            this.isPressed = false;
            this.isSelected = false;
            jMenuItem.addChangeListener(this);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.firePropertyChange("AccessibleVisibleData", false, true);
            if (this.this$0.getModel().isArmed()) {
                if (!this.isArmed) {
                    this.isArmed = true;
                    this.firePropertyChange("AccessibleState", null, AccessibleState.ARMED);
                }
            } else if (this.isArmed) {
                this.isArmed = false;
                this.firePropertyChange("AccessibleState", AccessibleState.ARMED, null);
            }
            if (this.this$0.isFocusOwner()) {
                if (!this.hasFocus) {
                    this.hasFocus = true;
                    this.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
                }
            } else if (this.hasFocus) {
                this.hasFocus = false;
                this.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
            }
            if (this.this$0.getModel().isPressed()) {
                if (!this.isPressed) {
                    this.isPressed = true;
                    this.firePropertyChange("AccessibleState", null, AccessibleState.PRESSED);
                }
            } else if (this.isPressed) {
                this.isPressed = false;
                this.firePropertyChange("AccessibleState", AccessibleState.PRESSED, null);
            }
            if (this.this$0.getModel().isSelected()) {
                if (!this.isSelected) {
                    this.isSelected = true;
                    this.firePropertyChange("AccessibleState", null, AccessibleState.CHECKED);
                }
            } else if (this.isSelected) {
                this.isSelected = false;
                this.firePropertyChange("AccessibleState", AccessibleState.CHECKED, null);
            }
        }
    }

    private static class MenuItemFocusListener
    implements FocusListener,
    Serializable {
        private MenuItemFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            JMenuItem jMenuItem = (JMenuItem)focusEvent.getSource();
            if (jMenuItem.isFocusPainted()) {
                jMenuItem.repaint();
            }
        }

        MenuItemFocusListener(1 var1_1) {
            this();
        }
    }
}

