/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDesktopIconUI;
import javax.swing.plaf.metal.MetalBumps;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class MetalDesktopIconUI
extends BasicDesktopIconUI {
    JButton button;
    JLabel label;
    TitleListener titleListener;
    private int width;

    protected void installComponents() {
        this.frame = this.desktopIcon.getInternalFrame();
        Icon icon = this.frame.getFrameIcon();
        String string = this.frame.getTitle();
        this.button = new JButton(string, icon);
        this.button.addActionListener(new ActionListener(this){
            private final MetalDesktopIconUI this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.deiconize();
            }
            {
                this.this$0 = metalDesktopIconUI;
            }
        });
        this.button.setFont(this.desktopIcon.getFont());
        this.button.setBackground(this.desktopIcon.getBackground());
        this.button.setForeground(this.desktopIcon.getForeground());
        int n2 = this.button.getPreferredSize().height;
        MetalBumps metalBumps = new MetalBumps(n2 / 3, n2, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlDarkShadow(), MetalLookAndFeel.getControl());
        this.label = new JLabel(metalBumps);
        this.label.setBorder(new MatteBorder(0, 2, 0, 1, this.desktopIcon.getBackground()));
        this.desktopIcon.setLayout(new BorderLayout(2, 0));
        this.desktopIcon.add((Component)this.button, "Center");
        this.desktopIcon.add((Component)this.label, "West");
    }

    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installColorsAndFont(this.desktopIcon, "DesktopIcon.background", "DesktopIcon.foreground", "DesktopIcon.font");
        this.desktopIcon.setOpaque(true);
        this.width = UIManager.getInt("DesktopIcon.width");
    }

    protected void installListeners() {
        super.installListeners();
        this.titleListener = new TitleListener(this);
        this.desktopIcon.getInternalFrame().addPropertyChangeListener(this.titleListener);
    }

    protected void uninstallComponents() {
        this.desktopIcon.setLayout(null);
        this.desktopIcon.remove(this.label);
        this.desktopIcon.remove(this.button);
        this.button = null;
        this.frame = null;
    }

    protected void uninstallListeners() {
        this.desktopIcon.getInternalFrame().removePropertyChangeListener(this.titleListener);
        this.titleListener = null;
        super.uninstallListeners();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getMinimumSize(jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return new Dimension(this.width, this.desktopIcon.getLayout().minimumLayoutSize((Container)this.desktopIcon).height);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getMinimumSize(jComponent);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalDesktopIconUI();
    }

    class TitleListener
    implements PropertyChangeListener {
        private final MetalDesktopIconUI this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("title")) {
                this.this$0.button.setText((String)propertyChangeEvent.getNewValue());
            }
            if (propertyChangeEvent.getPropertyName().equals("frameIcon")) {
                this.this$0.button.setIcon((Icon)propertyChangeEvent.getNewValue());
            }
        }

        TitleListener(MetalDesktopIconUI metalDesktopIconUI) {
            this.this$0 = metalDesktopIconUI;
        }
    }
}

