/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.FlowView;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StateInvariantError;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabExpander;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import javax.swing.text.TabableView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class ParagraphView
extends FlowView
implements TabExpander {
    private int justification;
    private float lineSpacing;
    protected int firstLineIndent = 0;
    private int tabBase;
    static Class i18nStrategy;
    static char[] tabChars;
    static char[] tabDecimalChars;

    protected float getTabBase() {
        return this.tabBase;
    }

    protected int getLayoutViewCount() {
        return this.layoutPool.getViewCount();
    }

    static {
        tabChars = new char[1];
        ParagraphView.tabChars[0] = 9;
        tabDecimalChars = new char[2];
        ParagraphView.tabDecimalChars[0] = 9;
        ParagraphView.tabDecimalChars[1] = 46;
    }

    protected void setPropertiesFromAttributes() {
        AttributeSet attributeSet = this.getAttributes();
        if (attributeSet != null) {
            Document document;
            Object object;
            this.setParagraphInsets(attributeSet);
            Integer n2 = (Integer)attributeSet.getAttribute(StyleConstants.Alignment);
            int n3 = n2 == null ? ((object = (document = this.getElement().getDocument()).getProperty(TextAttribute.RUN_DIRECTION)) != null && object.equals(TextAttribute.RUN_DIRECTION_RTL) ? 2 : 0) : n2;
            this.setJustification(n3);
            this.setLineSpacing(StyleConstants.getLineSpacing(attributeSet));
            this.setFirstLineIndent(StyleConstants.getFirstLineIndent(attributeSet));
        }
    }

    protected void setFirstLineIndent(float f2) {
        this.firstLineIndent = (int)f2;
    }

    protected void setLineSpacing(float f2) {
        this.lineSpacing = f2;
    }

    public float nextTabStop(float f2, int n2) {
        int n3;
        if (this.justification != 0) {
            return f2 + 10.0f;
        }
        f2 -= (float)this.tabBase;
        TabSet tabSet = this.getTabSet();
        if (tabSet == null) {
            return this.tabBase + ((int)f2 / 72 + 1) * 72;
        }
        TabStop tabStop = tabSet.getTabAfter(f2 + 0.01f);
        if (tabStop == null) {
            return (float)this.tabBase + f2 + 5.0f;
        }
        int n4 = tabStop.getAlignment();
        switch (n4) {
            default: {
                return (float)this.tabBase + tabStop.getPosition();
            }
            case 5: {
                return (float)this.tabBase + tabStop.getPosition();
            }
            case 1: 
            case 2: {
                n3 = this.findOffsetToCharactersInString(tabChars, n2 + 1);
                break;
            }
            case 4: {
                n3 = this.findOffsetToCharactersInString(tabDecimalChars, n2 + 1);
            }
        }
        if (n3 == -1) {
            n3 = this.getEndOffset();
        }
        float f3 = this.getPartialSize(n2 + 1, n3);
        switch (n4) {
            case 1: 
            case 4: {
                return (float)this.tabBase + Math.max(f2, tabStop.getPosition() - f3);
            }
            case 2: {
                return (float)this.tabBase + Math.max(f2, tabStop.getPosition() - f3 / 2.0f);
            }
        }
        return f2;
    }

    public float getAlignment(int n2) {
        switch (n2) {
            case 1: {
                float f2 = 0.5f;
                if (this.getViewCount() != 0) {
                    int n3 = (int)this.getPreferredSpan(1);
                    View view = this.getView(0);
                    int n4 = (int)view.getPreferredSpan(1);
                    f2 = n3 != 0 ? (float)(n4 / 2) / (float)n3 : 0.0f;
                }
                return f2;
            }
            case 0: {
                return 0.5f;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n2);
    }

    public int getFlowSpan(int n2) {
        View view = this.getView(n2);
        int n3 = 0;
        if (view instanceof Row) {
            Row row = (Row)view;
            n3 = row.getLeftInset() + row.getRightInset();
        }
        int n4 = this.layoutSpan - n3;
        return n4;
    }

    public int getFlowStart(int n2) {
        View view = this.getView(n2);
        int n3 = 0;
        if (view instanceof Row) {
            Row row = (Row)view;
            n3 = row.getLeftInset();
        }
        return this.tabBase + n3;
    }

    protected void setJustification(int n2) {
        this.justification = n2;
    }

    public int getBreakWeight(int n2, float f2) {
        if (n2 == 1) {
            return 0;
        }
        return 0;
    }

    protected float getPartialSize(int n2, int n3) {
        float f2 = 0.0f;
        int n4 = this.getViewCount();
        int n5 = this.getElement().getElementIndex(n2);
        n4 = this.layoutPool.getViewCount();
        while (n2 < n3 && n5 < n4) {
            View view = this.layoutPool.getView(n5++);
            int n6 = view.getEndOffset();
            int n7 = Math.min(n3, n6);
            if (view instanceof TabableView) {
                f2 += ((TabableView)((Object)view)).getPartialSpan(n2, n7);
            } else if (n2 == view.getStartOffset() && n7 == view.getEndOffset()) {
                f2 += view.getPreferredSpan(0);
            } else {
                return 0.0f;
            }
            n2 = n6;
        }
        return f2;
    }

    protected int findOffsetToCharactersInString(char[] cArray, int n2) {
        int n3 = cArray.length;
        int n4 = this.getEndOffset();
        Segment segment = new Segment();
        try {
            this.getDocument().getText(n2, n4 - n2, segment);
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
        int n5 = segment.offset + segment.count;
        for (int i2 = segment.offset; i2 < n5; ++i2) {
            char c2 = segment.array[i2];
            for (int i3 = 0; i3 < n3; ++i3) {
                if (c2 != cArray[i3]) continue;
                return i2 - segment.offset + n2;
            }
        }
        return -1;
    }

    public ParagraphView(Element element) {
        super(element, 1);
        this.setPropertiesFromAttributes();
        Document document = element.getDocument();
        Object object = document.getProperty("i18n");
        if (object != null && object.equals(Boolean.TRUE)) {
            try {
                Object object2;
                if (i18nStrategy == null) {
                    object2 = "javax.swing.text.TextLayoutStrategy";
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    i18nStrategy = classLoader != null ? classLoader.loadClass((String)object2) : Class.forName((String)object2);
                }
                if ((object2 = i18nStrategy.newInstance()) instanceof FlowView.FlowStrategy) {
                    this.strategy = (FlowView.FlowStrategy)object2;
                }
            }
            catch (Throwable throwable) {
                throw new StateInvariantError("ParagraphView: Can't create i18n strategy: " + throwable.getMessage());
            }
        }
    }

    static float access$100(ParagraphView paragraphView) {
        return paragraphView.lineSpacing;
    }

    static int access$000(ParagraphView paragraphView) {
        return paragraphView.justification;
    }

    protected void adjustRow(Row row, int n2, int n3) {
    }

    protected boolean flipEastAndWestAtEnds(int n2, Position.Bias bias) {
        Document document = this.getDocument();
        return document instanceof AbstractDocument && !((AbstractDocument)document).isLeftToRight(this.getStartOffset(), this.getStartOffset() + 1);
    }

    protected TabSet getTabSet() {
        return StyleConstants.getTabSet(this.getElement().getAttributes());
    }

    protected View createRow() {
        return new Row(this, this.getElement());
    }

    protected View getLayoutView(int n2) {
        return this.layoutPool.getView(n2);
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        this.tabBase = rectangle.x + this.getLeftInset();
        super.paint(graphics, shape);
    }

    public View breakView(int n2, float f2, Shape shape) {
        if (n2 == 1) {
            if (shape != null) {
                Rectangle rectangle = shape.getBounds();
                this.setSize(rectangle.width, rectangle.height);
            }
            return this;
        }
        return this;
    }

    protected int getNextNorthSouthVisualPositionFrom(int n2, Position.Bias bias, Shape shape, int n3, Position.Bias[] biasArray) throws BadLocationException {
        Rectangle rectangle;
        Point point;
        int n4;
        if (n2 == -1) {
            n4 = n3 == 1 ? this.getViewCount() - 1 : 0;
        } else {
            n4 = bias == Position.Bias.Backward && n2 > 0 ? this.getViewIndexAtPosition(n2 - 1) : this.getViewIndexAtPosition(n2);
            if (n3 == 1) {
                if (n4 == 0) {
                    return -1;
                }
                --n4;
            } else if (++n4 >= this.getViewCount()) {
                return -1;
            }
        }
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        Caret caret = jTextComponent.getCaret();
        Point point2 = point = caret != null ? caret.getMagicCaretPosition() : null;
        int n5 = point == null ? ((rectangle = jTextComponent.getUI().modelToView(jTextComponent, n2, bias)) == null ? 0 : rectangle.getBounds().x) : point.x;
        return this.getClosestPositionTo(n2, bias, shape, n3, biasArray, n4, n5);
    }

    protected int getClosestPositionTo(int n2, Position.Bias bias, Shape shape, int n3, Position.Bias[] biasArray, int n4, int n5) throws BadLocationException {
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        Document document = this.getDocument();
        AbstractDocument abstractDocument = document instanceof AbstractDocument ? (AbstractDocument)document : null;
        View view = this.getView(n4);
        int n6 = -1;
        biasArray[0] = Position.Bias.Forward;
        int n7 = view.getViewCount();
        for (int i2 = 0; i2 < n7; ++i2) {
            boolean bl2;
            View view2 = view.getView(i2);
            int n8 = view2.getStartOffset();
            boolean bl3 = bl2 = abstractDocument != null ? abstractDocument.isLeftToRight(n8, n8 + 1) : true;
            if (bl2) {
                int n9 = view2.getEndOffset();
                for (n6 = n8; n6 < n9; ++n6) {
                    if (jTextComponent.modelToView((int)n6).getBounds().x < n5) continue;
                    return n6;
                }
                --n6;
                continue;
            }
            for (n6 = view2.getEndOffset() - 1; n6 >= n8; --n6) {
                if (jTextComponent.modelToView((int)n6).getBounds().x < n5) continue;
                return n6;
            }
            ++n6;
        }
        if (n6 == -1) {
            return this.getStartOffset();
        }
        return n6;
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.setPropertiesFromAttributes();
        this.layoutChanged(0);
        this.layoutChanged(1);
        super.changedUpdate(documentEvent, shape, viewFactory);
    }

    class Row
    extends BoxView {
        private final ParagraphView this$0;

        public int getEndOffset() {
            int n2 = 0;
            int n3 = this.getViewCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                View view = this.getView(i2);
                n2 = Math.max(n2, view.getEndOffset());
            }
            return n2;
        }

        public int getStartOffset() {
            int n2 = Integer.MAX_VALUE;
            int n3 = this.getViewCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                View view = this.getView(i2);
                n2 = Math.min(n2, view.getStartOffset());
            }
            return n2;
        }

        protected short getBottomInset() {
            return (short)((float)super.getBottomInset() + (float)(this.minorRequest != null ? this.minorRequest.preferred : 0) * ParagraphView.access$100(this.this$0));
        }

        protected short getLeftInset() {
            int n2 = 0;
            View view = this.getParent();
            if (view != null && this == view.getView(0)) {
                n2 = this.this$0.firstLineIndent;
            }
            return (short)(super.getLeftInset() + n2);
        }

        public float getAlignment(int n2) {
            if (n2 == 0) {
                switch (ParagraphView.access$000(this.this$0)) {
                    case 0: {
                        return 0.0f;
                    }
                    case 2: {
                        return 1.0f;
                    }
                    case 1: 
                    case 3: {
                        return 0.5f;
                    }
                }
            }
            return super.getAlignment(n2);
        }

        protected int getViewIndexAtPosition(int n2) {
            if (n2 < this.getStartOffset() || n2 >= this.getEndOffset()) {
                return -1;
            }
            for (int i2 = this.getViewCount() - 1; i2 >= 0; --i2) {
                View view = this.getView(i2);
                if (n2 < view.getStartOffset() || n2 >= view.getEndOffset()) continue;
                return i2;
            }
            return -1;
        }

        protected void layoutMinorAxis(int n2, int n3, int[] nArray, int[] nArray2) {
            this.baselineLayout(n2, n3, nArray, nArray2);
        }

        public AttributeSet getAttributes() {
            View view = this.getParent();
            return view != null ? view.getAttributes() : null;
        }

        protected void loadChildren(ViewFactory viewFactory) {
        }

        protected SizeRequirements calculateMinorAxisRequirements(int n2, SizeRequirements sizeRequirements) {
            return this.baselineRequirements(n2, sizeRequirements);
        }

        Row(ParagraphView paragraphView, Element element) {
            this.this$0 = paragraphView;
            super(element, 0);
        }

        public Shape modelToView(int n2, Shape shape, Position.Bias bias) throws BadLocationException {
            Rectangle rectangle = shape.getBounds();
            View view = this.getViewAtPosition(n2, rectangle);
            if (view != null && !view.getElement().isLeaf()) {
                return super.modelToView(n2, shape, bias);
            }
            rectangle = shape.getBounds();
            int n3 = rectangle.height;
            int n4 = rectangle.y;
            Shape shape2 = super.modelToView(n2, shape, bias);
            rectangle = shape2.getBounds();
            rectangle.height = n3;
            rectangle.y = n4;
            return rectangle;
        }
    }
}

