/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.util.StringTokenizer;
import javax.swing.SizeRequirements;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.html.FrameView;
import javax.swing.text.html.HTML;

class FrameSetView
extends BoxView {
    String[] children;
    int[] percentChildren;
    int[] absoluteChildren;
    int[] relativeChildren;
    int percentTotals;
    int absoluteTotals;
    int relativeTotals;

    private void init() {
        int n2;
        this.percentChildren = new int[this.children.length];
        this.relativeChildren = new int[this.children.length];
        this.absoluteChildren = new int[this.children.length];
        for (n2 = 0; n2 < this.children.length; ++n2) {
            this.percentChildren[n2] = -1;
            this.relativeChildren[n2] = -1;
            this.absoluteChildren[n2] = -1;
            if (this.children[n2].endsWith("*")) {
                if (this.children[n2].length() > 1) {
                    this.relativeChildren[n2] = Integer.parseInt(this.children[n2].substring(0, this.children[n2].length() - 1));
                    this.relativeTotals += this.relativeChildren[n2];
                    continue;
                }
                this.relativeChildren[n2] = 1;
                ++this.relativeTotals;
                continue;
            }
            if (this.children[n2].indexOf(37) != -1) {
                this.percentChildren[n2] = this.parseDigits(this.children[n2]);
                this.percentTotals += this.percentChildren[n2];
                continue;
            }
            this.absoluteChildren[n2] = Integer.parseInt(this.children[n2]);
        }
        if (this.percentTotals > 100) {
            for (n2 = 0; n2 < this.percentChildren.length; ++n2) {
                if (this.percentChildren[n2] <= 0) continue;
                this.percentChildren[n2] = this.percentChildren[n2] * 100 / this.percentTotals;
            }
            this.percentTotals = 100;
        }
    }

    protected void layoutMajorAxis(int n2, int n3, int[] nArray, int[] nArray2) {
        SizeRequirements.calculateTiledPositions(n2, null, this.getChildRequests(n2, n3), nArray, nArray2);
    }

    private void spread(int n2, int[] nArray) {
        block10: {
            int n3;
            int n4;
            block9: {
                int n5;
                if (n2 == 0) {
                    return;
                }
                int n6 = 0;
                n4 = n2;
                for (n5 = 0; n5 < nArray.length; ++n5) {
                    if (this.absoluteChildren[n5] <= 0) continue;
                    nArray[n5] = this.absoluteChildren[n5];
                    n4 -= nArray[n5];
                }
                n6 = n4;
                for (n5 = 0; n5 < nArray.length; ++n5) {
                    if (this.percentChildren[n5] > 0 && n6 > 0) {
                        nArray[n5] = this.percentChildren[n5] * n6 / 100;
                        n4 -= nArray[n5];
                        continue;
                    }
                    if (this.percentChildren[n5] <= 0 || n6 > 0) continue;
                    nArray[n5] = n2 / nArray.length;
                    n4 -= nArray[n5];
                }
                if (n4 <= 0 || this.relativeTotals <= 0) break block9;
                for (n5 = 0; n5 < nArray.length; ++n5) {
                    if (this.relativeChildren[n5] <= 0) continue;
                    nArray[n5] = n4 * this.relativeChildren[n5] / this.relativeTotals;
                }
                break block10;
            }
            if (n4 <= 0) break block10;
            float f2 = n2 - n4;
            float[] fArray = new float[nArray.length];
            n4 = n2;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                fArray[n3] = (float)nArray[n3] / f2 * 100.0f;
                nArray[n3] = (int)((float)n2 * fArray[n3] / 100.0f);
                n4 -= nArray[n3];
            }
            n3 = 0;
            while (n4 != 0) {
                if (n4 < 0) {
                    int n7 = n3++;
                    nArray[n7] = nArray[n7] - 1;
                    ++n4;
                } else {
                    int n8 = n3++;
                    nArray[n8] = nArray[n8] + 1;
                    --n4;
                }
                if (n3 != nArray.length) continue;
                n3 = 0;
            }
        }
    }

    private int parseDigits(String string) {
        int n2 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (!Character.isDigit(c2)) continue;
            n2 = n2 * 10 + Character.digit(c2, 10);
        }
        return n2;
    }

    protected SizeRequirements[] getChildRequests(int n2, int n3) {
        int[] nArray = new int[this.children.length];
        this.spread(n2, nArray);
        int n4 = this.getViewCount();
        SizeRequirements[] sizeRequirementsArray = new SizeRequirements[n4];
        int n5 = 0;
        for (int i2 = 0; i2 < n4; ++i2) {
            View view = this.getView(i2);
            if (view instanceof FrameView || view instanceof FrameSetView) {
                sizeRequirementsArray[i2] = new SizeRequirements((int)view.getMinimumSpan(n3), nArray[n5], (int)view.getMaximumSpan(n3), 0.5f);
                ++n5;
                continue;
            }
            int n6 = (int)view.getMinimumSpan(n3);
            int n7 = (int)view.getPreferredSpan(n3);
            int n8 = (int)view.getMaximumSpan(n3);
            float f2 = view.getAlignment(n3);
            sizeRequirementsArray[i2] = new SizeRequirements(n6, n7, n8, f2);
        }
        return sizeRequirementsArray;
    }

    public FrameSetView(Element element, int n2) {
        super(element, n2);
        this.children = n2 == 1 ? this.parseRowColSpec(HTML.Attribute.ROWS) : this.parseRowColSpec(HTML.Attribute.COLS);
        this.init();
    }

    private String[] parseRowColSpec(HTML.Attribute attribute) {
        AttributeSet attributeSet = this.getElement().getAttributes();
        String string = "*";
        if (attributeSet != null && attributeSet.getAttribute(attribute) != null) {
            string = (String)attributeSet.getAttribute(attribute);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n2 = stringTokenizer.countTokens();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = stringTokenizer.nextToken().trim();
            if (!stringArray[i2].equals("100%")) continue;
            stringArray[i2] = "*";
        }
        return stringArray;
    }
}

