/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.rtf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.rtf.RTFGenerator;
import javax.swing.text.rtf.RTFReader;

public class RTFEditorKit
extends StyledEditorKit {
    public String getContentType() {
        return "text/rtf";
    }

    public void read(InputStream inputStream, Document document, int n2) throws IOException, BadLocationException {
        if (document instanceof StyledDocument) {
            RTFReader rTFReader = new RTFReader((StyledDocument)document);
            rTFReader.readFromStream(inputStream);
            rTFReader.close();
        } else {
            super.read(inputStream, document, n2);
        }
    }

    public void write(OutputStream outputStream, Document document, int n2, int n3) throws IOException, BadLocationException {
        RTFGenerator.writeDocument(document, outputStream);
    }

    public void read(Reader reader, Document document, int n2) throws IOException, BadLocationException {
        if (document instanceof StyledDocument) {
            RTFReader rTFReader = new RTFReader((StyledDocument)document);
            rTFReader.readFromReader(reader);
            rTFReader.close();
        } else {
            super.read(reader, document, n2);
        }
    }

    public void write(Writer writer, Document document, int n2, int n3) throws IOException, BadLocationException {
        throw new IOException("RTF is an 8-bit format");
    }
}

