/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.functions;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionNode;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.ExtensionsProvider;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.functions.Function;
import org.apache.xpath.functions.WrongNumberArgsException;
import org.apache.xpath.objects.XNull;
import org.apache.xpath.objects.XObject;

public class FuncExtFunction
extends Function {
    String m_namespace;
    String m_extensionName;
    Object m_methodKey;
    Vector m_argVec = new Vector();

    public int getArgCount() {
        return this.m_argVec.size();
    }

    protected void reportWrongNumberArgs() throws WrongNumberArgsException {
        String string = XSLMessages.createXPATHMessage("ER_INCORRECT_PROGRAMMER_ASSERTION", new Object[]{"Programmer's assertion:  the method FunctionMultiArgs.reportWrongNumberArgs() should never be called."});
        throw new RuntimeException(string);
    }

    public void checkNumberArgs(int n2) throws WrongNumberArgsException {
    }

    public String getFunctionName() {
        return this.m_extensionName;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public void fixupVariables(Vector vector, int n2) {
        if (null != this.m_argVec) {
            int n3 = this.m_argVec.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                Expression expression = (Expression)this.m_argVec.elementAt(i2);
                expression.fixupVariables(vector, n2);
            }
        }
    }

    public Expression getArg(int n2) {
        if (n2 >= 0 && n2 < this.m_argVec.size()) {
            return (Expression)this.m_argVec.elementAt(n2);
        }
        return null;
    }

    public void setArg(Expression expression, int n2) throws WrongNumberArgsException {
        this.m_argVec.addElement(expression);
    }

    public void exprSetParent(ExpressionNode expressionNode) {
        super.exprSetParent(expressionNode);
        int n2 = this.m_argVec.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Expression expression = (Expression)this.m_argVec.elementAt(i2);
            expression.exprSetParent(expressionNode);
        }
    }

    public void callArgVisitors(XPathVisitor xPathVisitor) {
        for (int i2 = 0; i2 < this.m_argVec.size(); ++i2) {
            Expression expression = (Expression)this.m_argVec.elementAt(i2);
            expression.callVisitors(new ArgExtOwner(this, expression), xPathVisitor);
        }
    }

    public XObject execute(XPathContext xPathContext) throws TransformerException {
        Object object;
        Vector vector = new Vector();
        int n2 = this.m_argVec.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            object = (Expression)this.m_argVec.elementAt(i2);
            XObject xObject = ((Expression)object).execute(xPathContext);
            vector.addElement(xObject);
        }
        ExtensionsProvider extensionsProvider = (ExtensionsProvider)xPathContext.getOwnerObject();
        object = extensionsProvider.extFunction(this.m_namespace, this.m_extensionName, vector, this.m_methodKey);
        XObject xObject = null != object ? XObject.create(object, xPathContext) : new XNull();
        return xObject;
    }

    public FuncExtFunction(String string, String string2, Object object) {
        this.m_namespace = string;
        this.m_extensionName = string2;
        this.m_methodKey = object;
    }

    class ArgExtOwner
    implements ExpressionOwner {
        Expression m_exp;
        private final FuncExtFunction this$0;

        public Expression getExpression() {
            return this.m_exp;
        }

        public void setExpression(Expression expression) {
            expression.exprSetParent(this.this$0);
            this.m_exp = expression;
        }

        ArgExtOwner(FuncExtFunction funcExtFunction, Expression expression) {
            this.this$0 = funcExtFunction;
            this.m_exp = expression;
        }
    }
}

