/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.GraphicsEnvironment;
import java.awt.peer.FontPeer;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import sun.awt.CharsetString;
import sun.awt.FontDescriptor;
import sun.awt.FontProperties;
import sun.awt.NativeLibLoader;
import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.java2d.FontSupport;

public abstract class PlatformFont
implements FontPeer {
    protected FontDescriptor[] componentFonts;
    protected char defaultChar;
    protected FontProperties props;
    protected FontDescriptor defaultFont;
    protected static Hashtable charsetRegistry;
    protected String familyName;
    protected String styleString;
    private Object[] fontCache;
    protected static int FONTCACHESIZE;
    protected static int FONTCACHEMASK;
    protected static String osVersion;
    protected static FontProperties fprops;

    static {
        NativeLibLoader.loadLibraries();
        PlatformFont.initIDs();
        charsetRegistry = new Hashtable(5);
        FONTCACHESIZE = 256;
        FONTCACHEMASK = FONTCACHESIZE - 1;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (graphicsEnvironment instanceof FontSupport) {
            fprops = ((FontSupport)((Object)graphicsEnvironment)).getFontProperties();
        }
    }

    private static native void initIDs();

    public boolean mightHaveMultiFontMetrics() {
        return this.props != null;
    }

    protected final Object[] getFontCache() {
        if (this.fontCache == null) {
            this.fontCache = new Object[FONTCACHESIZE];
        }
        return this.fontCache;
    }

    public Object[] makeConvertedMultiFontChars(char[] cArray, int n2, int n3) throws MalformedInputException, ConversionBufferFullException {
        int n4;
        Object[] objectArray = new Object[2];
        byte[] byArray = null;
        int n5 = 0;
        int n6 = 0;
        FontDescriptor fontDescriptor = null;
        FontDescriptor fontDescriptor2 = null;
        int n7 = n2 + n3;
        if (n2 < 0 || n7 > cArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n4 >= n7) {
            return null;
        }
        for (n4 = n2; n4 < n7; ++n4) {
            char c2 = cArray[n4];
            int n8 = c2 & FONTCACHEMASK;
            PlatformFontCache platformFontCache = (PlatformFontCache)this.getFontCache()[n8];
            if (platformFontCache == null || platformFontCache.uniChar != c2) {
                fontDescriptor = this.defaultFont;
                c2 = this.defaultChar;
                char c3 = cArray[n4];
                int n9 = this.componentFonts.length;
                for (int i2 = 0; i2 < n9; ++i2) {
                    FontDescriptor fontDescriptor3 = this.componentFonts[i2];
                    fontDescriptor3.fontCharset.reset();
                    fontDescriptor3.fontCharset.setSubstitutionMode(false);
                    if (fontDescriptor3.isExcluded(c3) || !fontDescriptor3.fontCharset.canConvert(c3)) continue;
                    fontDescriptor = fontDescriptor3;
                    c2 = c3;
                    break;
                }
                try {
                    char[] cArray2 = new char[]{c2};
                    platformFontCache = new PlatformFontCache(this);
                    platformFontCache.encodingSize = fontDescriptor.useUnicode() ? (byte)fontDescriptor.unicodeCharset.convert(cArray2, 0, 1, platformFontCache.encoding, 0, 4) : (byte)fontDescriptor.fontCharset.convert(cArray2, 0, 1, platformFontCache.encoding, 0, 4);
                    platformFontCache.fontDescriptor = fontDescriptor;
                    platformFontCache.uniChar = cArray[n4];
                    this.getFontCache()[n8] = platformFontCache;
                }
                catch (Exception exception) {
                    System.err.println(exception);
                    exception.printStackTrace();
                    return null;
                }
            }
            if (fontDescriptor2 != platformFontCache.fontDescriptor) {
                if (fontDescriptor2 != null) {
                    objectArray[n6++] = fontDescriptor2;
                    objectArray[n6++] = byArray;
                    if (byArray != null) {
                        byArray[0] = (byte)((n5 -= 4) >> 24);
                        byArray[1] = (byte)(n5 >> 16);
                        byArray[2] = (byte)(n5 >> 8);
                        byArray[3] = (byte)n5;
                    }
                    if (n6 >= objectArray.length) {
                        Object[] objectArray2 = new Object[objectArray.length * 2];
                        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                        objectArray = objectArray2;
                    }
                }
                byArray = platformFontCache.fontDescriptor.useUnicode() ? new byte[(n7 - n4 + 1) * platformFontCache.fontDescriptor.unicodeCharset.getMaxBytesPerChar() + 4] : new byte[(n7 - n4 + 1) * platformFontCache.fontDescriptor.fontCharset.getMaxBytesPerChar() + 4];
                n5 = 4;
                fontDescriptor2 = platformFontCache.fontDescriptor;
            }
            if (platformFontCache.encodingSize == 1) {
                byArray[n5++] = platformFontCache.encoding[0];
                continue;
            }
            if (platformFontCache.encodingSize == 2) {
                byArray[n5++] = platformFontCache.encoding[0];
                byArray[n5++] = platformFontCache.encoding[1];
                continue;
            }
            if (platformFontCache.encodingSize == 3) {
                byArray[n5++] = platformFontCache.encoding[0];
                byArray[n5++] = platformFontCache.encoding[1];
                byArray[n5++] = platformFontCache.encoding[2];
                continue;
            }
            if (platformFontCache.encodingSize != 4) continue;
            byArray[n5++] = platformFontCache.encoding[0];
            byArray[n5++] = platformFontCache.encoding[1];
            byArray[n5++] = platformFontCache.encoding[2];
            byArray[n5++] = platformFontCache.encoding[3];
        }
        objectArray[n6++] = fontDescriptor2;
        objectArray[n6++] = byArray;
        if (byArray != null) {
            byArray[0] = (byte)((n5 -= 4) >> 24);
            byArray[1] = (byte)(n5 >> 16);
            byArray[2] = (byte)(n5 >> 8);
            byArray[3] = (byte)n5;
        }
        return objectArray;
    }

    public static String styleStr(int n2) {
        switch (n2) {
            case 1: {
                return "bold";
            }
            case 2: {
                return "italic";
            }
            case 3: {
                return "bolditalic";
            }
        }
        return "plain";
    }

    public PlatformFont(String string, int n2) {
        int n3;
        Object object;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (graphicsEnvironment instanceof FontSupport) {
            this.props = ((FontSupport)((Object)graphicsEnvironment)).getFontProperties();
        }
        if (this.props == null && (this.props = fprops) == null) {
            return;
        }
        this.familyName = string.toLowerCase(Locale.ENGLISH);
        if (!FontProperties.isLogicalFontFamilyName(this.familyName)) {
            object = this.props.getAliasedFamilyName(this.familyName);
            this.familyName = object != null ? object : this.props.getFallbackFamilyName(this.familyName, "sansserif");
        }
        this.styleString = PlatformFont.styleStr(n2);
        object = new Vector(5);
        int n4 = 0;
        while (true) {
            int[] nArray;
            String string2 = String.valueOf(n4);
            String string3 = this.props.getProperty(this.familyName + "." + this.styleString + "." + string2);
            if (string3 == null && (string3 = this.props.getProperty(this.familyName + "." + string2)) == null) break;
            String string4 = this.props.getProperty("fontcharset." + this.familyName + "." + this.styleString + "." + string2);
            if (string4 == null && (string4 = this.props.getProperty("fontcharset." + this.familyName + "." + string2)) == null) {
                string4 = "default";
            }
            CharToByteConverter charToByteConverter = this.getFontCharset(string4.trim(), string3);
            String string5 = this.props.getProperty("exclusion." + this.familyName + "." + this.styleString + "." + string2);
            if (string5 == null && (string5 = this.props.getProperty("exclusion." + this.familyName + "." + string2)) == null) {
                string5 = "none";
            }
            if (string5.equals("none")) {
                nArray = new int[]{};
            } else {
                int n5 = 1;
                int n6 = 0;
                while ((n6 = string5.indexOf(44, n6)) != -1) {
                    ++n6;
                    ++n5;
                }
                nArray = new int[n5];
                for (int i2 = 0; i2 < n5; ++i2) {
                    String string6;
                    String string7;
                    int n7 = 0;
                    int n8 = 0;
                    try {
                        string7 = string5.substring(i2 * 10, i2 * 10 + 4);
                        string6 = string5.substring(i2 * 10 + 5, i2 * 10 + 9);
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        nArray = new int[]{};
                        break;
                    }
                    try {
                        n7 = Integer.parseInt(string7, 16);
                        n8 = Integer.parseInt(string6, 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        nArray = new int[]{};
                        break;
                    }
                    nArray[i2] = n7 << 16 | n8;
                }
            }
            ((Vector)object).addElement(new FontDescriptor(string3, charToByteConverter, nArray));
            ++n4;
        }
        this.componentFonts = new FontDescriptor[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            this.componentFonts[n3] = (FontDescriptor)((Vector)object).elementAt(n3);
        }
        try {
            n3 = Integer.parseInt(this.props.getProperty("default.char", "003f"), 16);
        }
        catch (NumberFormatException numberFormatException) {
            n3 = 63;
        }
        this.defaultChar = (char)63;
        if (this.componentFonts.length > 0) {
            this.defaultFont = this.componentFonts[0];
        }
        for (int i3 = 0; i3 < this.componentFonts.length; ++i3) {
            if (this.componentFonts[i3].isExcluded((char)n3) || !this.componentFonts[i3].fontCharset.canConvert((char)n3)) continue;
            this.defaultFont = this.componentFonts[i3];
            this.defaultChar = (char)n3;
            break;
        }
    }

    public CharsetString[] makeMultiCharsetString(char[] cArray, int n2, int n3) {
        return this.makeMultiCharsetString(cArray, n2, n3, true);
    }

    public CharsetString[] makeMultiCharsetString(char[] cArray, int n2, int n3, boolean bl2) {
        CharsetString[] charsetStringArray;
        int n4;
        if (n3 < 1) {
            return new CharsetString[0];
        }
        Vector vector = null;
        char[] cArray2 = new char[n3];
        char c2 = this.defaultChar;
        FontDescriptor fontDescriptor = this.defaultFont;
        for (n4 = 0; n4 < this.componentFonts.length; ++n4) {
            if (this.componentFonts[n4].isExcluded(cArray[n2]) || !this.componentFonts[n4].fontCharset.canConvert(cArray[n2])) continue;
            fontDescriptor = this.componentFonts[n4];
            c2 = cArray[n2];
            break;
        }
        if (!bl2 && c2 == this.defaultChar) {
            return null;
        }
        cArray2[0] = c2;
        n4 = 0;
        for (int i2 = 1; i2 < n3; ++i2) {
            char c3 = cArray[n2 + i2];
            FontDescriptor fontDescriptor2 = this.defaultFont;
            c2 = this.defaultChar;
            for (int i3 = 0; i3 < this.componentFonts.length; ++i3) {
                if (this.componentFonts[i3].isExcluded(c3) || !this.componentFonts[i3].fontCharset.canConvert(c3)) continue;
                fontDescriptor2 = this.componentFonts[i3];
                c2 = c3;
                break;
            }
            if (!bl2 && c2 == this.defaultChar) {
                return null;
            }
            cArray2[i2] = c2;
            if (fontDescriptor == fontDescriptor2) continue;
            if (vector == null) {
                vector = new Vector(3);
            }
            vector.addElement(new CharsetString(cArray2, n4, i2 - n4, fontDescriptor));
            fontDescriptor = fontDescriptor2;
            fontDescriptor2 = this.defaultFont;
            n4 = i2;
        }
        CharsetString charsetString = new CharsetString(cArray2, n4, n3 - n4, fontDescriptor);
        if (vector == null) {
            charsetStringArray = new CharsetString[]{charsetString};
        } else {
            vector.addElement(charsetString);
            charsetStringArray = new CharsetString[vector.size()];
            for (int i4 = 0; i4 < vector.size(); ++i4) {
                charsetStringArray[i4] = (CharsetString)vector.elementAt(i4);
            }
        }
        return charsetStringArray;
    }

    public Object[] makeConvertedMultiFontString(String string) throws MalformedInputException, ConversionBufferFullException {
        return this.makeConvertedMultiFontChars(string.toCharArray(), 0, string.length());
    }

    public CharsetString[] makeMultiCharsetString(String string) {
        return this.makeMultiCharsetString(string.toCharArray(), 0, string.length(), true);
    }

    public CharsetString[] makeMultiCharsetString(String string, boolean bl2) {
        return this.makeMultiCharsetString(string.toCharArray(), 0, string.length(), bl2);
    }

    protected abstract CharToByteConverter getFontCharset(String var1, String var2);

    class PlatformFontCache {
        char uniChar;
        FontDescriptor fontDescriptor;
        byte encodingSize;
        byte[] encoding;
        private final PlatformFont this$0;

        PlatformFontCache(PlatformFont platformFont) {
            this.this$0 = platformFont;
            this.encoding = new byte[4];
        }
    }
}

