/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.Rectangle;
import sun.java2d.pipe.RegionClipSpanIterator;
import sun.java2d.pipe.RegionIterator;
import sun.java2d.pipe.RegionSpanIterator;
import sun.java2d.pipe.SpanIterator;

public class Region {
    public static final int INIT_SIZE = 50;
    public static final int GROW_SIZE = 50;
    int lox;
    int loy;
    int hix;
    int hiy;
    int endIndex;
    int[] bands;

    public final int getHeight() {
        if (this.hiy < this.loy) {
            return 0;
        }
        int n2 = this.hiy - this.loy;
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        }
        return n2;
    }

    public final int getHiX() {
        return this.hix;
    }

    public final int getHiY() {
        return this.hiy;
    }

    public final int getLoX() {
        return this.lox;
    }

    public final int getLoY() {
        return this.loy;
    }

    public final int getWidth() {
        if (this.hix < this.lox) {
            return 0;
        }
        int n2 = this.hix - this.lox;
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        }
        return n2;
    }

    static {
        Region.initIDs();
    }

    private void calcBBox() {
        int[] nArray = this.bands;
        if (this.endIndex <= 5) {
            if (this.endIndex == 0) {
                this.hiy = 0;
                this.hix = 0;
                this.loy = 0;
                this.lox = 0;
            } else {
                this.loy = nArray[0];
                this.hiy = nArray[1];
                this.lox = nArray[3];
                this.hix = nArray[4];
                this.endIndex = 0;
            }
            this.bands = null;
            return;
        }
        int n2 = this.hix;
        int n3 = this.lox;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.endIndex) {
            n4 = n5;
            int n6 = nArray[n5 + 2];
            if (n2 > nArray[n5 += 3]) {
                n2 = nArray[n5];
            }
            if (n3 >= nArray[(n5 += n6 * 2) - 1]) continue;
            n3 = nArray[n5 - 1];
        }
        this.lox = n2;
        this.loy = nArray[0];
        this.hix = n3;
        this.hiy = nArray[n4 + 1];
    }

    private static native void initIDs();

    public boolean isEmpty() {
        return this.hix <= this.lox || this.hiy <= this.loy;
    }

    public boolean isRectangular() {
        return this.bands == null;
    }

    private void needSpace(int n2) {
        if (this.endIndex + n2 >= this.bands.length) {
            int[] nArray = new int[this.bands.length + 50];
            System.arraycopy(this.bands, 0, nArray, 0, this.endIndex);
            this.bands = nArray;
        }
    }

    public static int dimAdd(int n2, int n3) {
        if (n3 <= 0) {
            return n2;
        }
        if ((n3 += n2) < n2) {
            return Integer.MAX_VALUE;
        }
        return n3;
    }

    private Region(int n2, int n3, int n4, int n5) {
        this.lox = n2;
        this.loy = n3;
        this.hix = n4;
        this.hiy = n5;
    }

    public void setOutputAreaXYWH(int n2, int n3, int n4, int n5) {
        this.setOutputAreaXYXY(n2, n3, Region.dimAdd(n2, n4), Region.dimAdd(n3, n5));
    }

    public void setOutputAreaXYXY(int n2, int n3, int n4, int n5) {
        this.lox = n2;
        this.loy = n3;
        this.hix = n4;
        this.hiy = n5;
    }

    public boolean encompassesXYWH(int n2, int n3, int n4, int n5) {
        return this.encompassesXYXY(n2, n3, Region.dimAdd(n2, n4), Region.dimAdd(n3, n5));
    }

    public boolean encompassesXYXY(int n2, int n3, int n4, int n5) {
        return this.bands == null && this.lox <= n2 && this.loy <= n3 && this.hix >= n4 && this.hiy >= n5;
    }

    public boolean intersectsQuickCheckXYXY(int n2, int n3, int n4, int n5) {
        return n4 > this.lox && n2 < this.hix && n5 > this.loy && n3 < this.hiy;
    }

    public boolean isInsideXYWH(int n2, int n3, int n4, int n5) {
        return this.isInsideXYXY(n2, n3, Region.dimAdd(n2, n4), Region.dimAdd(n3, n5));
    }

    public boolean isInsideXYXY(int n2, int n3, int n4, int n5) {
        return this.lox >= n2 && this.loy >= n3 && this.hix <= n4 && this.hiy <= n5;
    }

    private void appendSpan(int[] nArray) {
        int n2;
        int n3;
        int n4;
        int n5 = nArray[0];
        if (n5 < this.lox) {
            n5 = this.lox;
        }
        if ((n4 = nArray[1]) < this.loy) {
            n4 = this.loy;
        }
        if ((n3 = nArray[2]) > this.hix) {
            n3 = this.hix;
        }
        if ((n2 = nArray[3]) > this.hiy) {
            n2 = this.hiy;
        }
        if (n3 <= n5 || n2 <= n4) {
            return;
        }
        int n6 = nArray[4];
        if (this.endIndex == 0 || n4 >= this.bands[n6 + 1]) {
            if (this.bands == null) {
                this.bands = new int[50];
            } else {
                this.needSpace(5);
                this.endRow(nArray);
                n6 = nArray[4];
            }
            this.bands[this.endIndex++] = n4;
            this.bands[this.endIndex++] = n2;
            this.bands[this.endIndex++] = 0;
        } else if (n4 == this.bands[n6] && n2 == this.bands[n6 + 1] && n5 >= this.bands[this.endIndex - 1]) {
            if (n5 == this.bands[this.endIndex - 1]) {
                this.bands[this.endIndex - 1] = n3;
                return;
            }
            this.needSpace(2);
        } else {
            throw new InternalError("bad span");
        }
        this.bands[this.endIndex++] = n5;
        this.bands[this.endIndex++] = n3;
        int n7 = n6 + 2;
        this.bands[n7] = this.bands[n7] + 1;
    }

    public void clipBoxToBounds(int[] nArray) {
        if (nArray[0] < this.lox) {
            nArray[0] = this.lox;
        }
        if (nArray[1] < this.loy) {
            nArray[1] = this.loy;
        }
        if (nArray[2] > this.hix) {
            nArray[2] = this.hix;
        }
        if (nArray[3] > this.hiy) {
            nArray[3] = this.hiy;
        }
    }

    private void endRow(int[] nArray) {
        int[] nArray2;
        int n2 = nArray[4];
        int n3 = nArray[5];
        if (n2 > n3 && (nArray2 = this.bands)[n3 + 1] == nArray2[n2] && nArray2[n3 + 2] == nArray2[n2 + 2]) {
            int n4 = nArray2[n2 + 2] * 2;
            n2 += 3;
            n3 += 3;
            while (n4 > 0 && nArray2[n2++] == nArray2[n3++]) {
                --n4;
            }
            if (n4 == 0) {
                nArray2[nArray[5] + 1] = nArray2[n3 + 1];
                this.endIndex = n3;
                return;
            }
        }
        nArray[5] = nArray[4];
        nArray[4] = this.endIndex;
    }

    public void getBounds(int[] nArray) {
        nArray[0] = this.lox;
        nArray[1] = this.loy;
        nArray[2] = this.hix;
        nArray[3] = this.hiy;
    }

    public void setOutputArea(int[] nArray) {
        this.lox = nArray[0];
        this.loy = nArray[1];
        this.hix = nArray[2];
        this.hiy = nArray[3];
    }

    public void setOutputArea(Rectangle rectangle) {
        this.setOutputAreaXYWH(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Region getBoundsIntersectionXYWH(int n2, int n3, int n4, int n5) {
        return this.getBoundsIntersectionXYXY(n2, n3, Region.dimAdd(n2, n4), Region.dimAdd(n3, n5));
    }

    public Region getBoundsIntersectionXYXY(int n2, int n3, int n4, int n5) {
        if (this.bands == null && this.lox >= n2 && this.loy >= n3 && this.hix <= n4 && this.hiy <= n5) {
            return this;
        }
        return new Region(n2 < this.lox ? this.lox : n2, n3 < this.loy ? this.loy : n3, n4 > this.hix ? this.hix : n4, n5 > this.hiy ? this.hiy : n5);
    }

    public static Region getInstanceXYWH(int n2, int n3, int n4, int n5) {
        return Region.getInstanceXYXY(n2, n3, Region.dimAdd(n2, n4), Region.dimAdd(n3, n5));
    }

    public static Region getInstanceXYXY(int n2, int n3, int n4, int n5) {
        return new Region(n2, n3, n4, n5);
    }

    public Region getIntersectionXYWH(int n2, int n3, int n4, int n5) {
        return this.getIntersectionXYXY(n2, n3, Region.dimAdd(n2, n4), Region.dimAdd(n3, n5));
    }

    public Region getIntersectionXYXY(int n2, int n3, int n4, int n5) {
        if (this.isInsideXYXY(n2, n3, n4, n5)) {
            return this;
        }
        Region region = new Region(n2 < this.lox ? this.lox : n2, n3 < this.loy ? this.loy : n3, n4 > this.hix ? this.hix : n4, n5 > this.hiy ? this.hiy : n5);
        if (this.bands != null) {
            region.appendSpans(this.getSpanIterator());
        }
        return region;
    }

    public boolean encompasses(Region region) {
        return this.bands == null && this.lox <= region.lox && this.loy <= region.loy && this.hix >= region.hix && this.hiy >= region.hiy;
    }

    public boolean isInsideQuickCheck(Region region) {
        return region.bands == null && region.lox <= this.lox && region.loy <= this.loy && region.hix >= this.hix && region.hiy >= this.hiy;
    }

    public static Region getInstance(int[] nArray) {
        return new Region(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public RegionIterator getIterator() {
        return new RegionIterator(this);
    }

    public SpanIterator getSpanIterator() {
        return new RegionSpanIterator(this);
    }

    public void appendSpans(SpanIterator spanIterator) {
        int[] nArray = new int[6];
        while (spanIterator.nextSpan(nArray)) {
            this.appendSpan(nArray);
        }
        this.endRow(nArray);
        this.calcBBox();
    }

    public SpanIterator getSpanIterator(int[] nArray) {
        SpanIterator spanIterator = this.getSpanIterator();
        spanIterator.intersectClipBox(nArray[0], nArray[1], nArray[2], nArray[3]);
        return spanIterator;
    }

    public Region getBoundsIntersection(Rectangle rectangle) {
        return this.getBoundsIntersectionXYWH(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static Region getInstance(Rectangle rectangle) {
        return Region.getInstanceXYWH(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Region getIntersection(Rectangle rectangle) {
        return this.getIntersectionXYWH(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Region getBoundsIntersection(Region region) {
        if (this.encompasses(region)) {
            return region;
        }
        if (region.encompasses(this)) {
            return this;
        }
        return new Region(region.lox < this.lox ? this.lox : region.lox, region.loy < this.loy ? this.loy : region.loy, region.hix > this.hix ? this.hix : region.hix, region.hiy > this.hiy ? this.hiy : region.hiy);
    }

    public Region getIntersection(Region region) {
        if (this.isInsideQuickCheck(region)) {
            return this;
        }
        if (region.isInsideQuickCheck(this)) {
            return region;
        }
        Region region2 = new Region(region.lox < this.lox ? this.lox : region.lox, region.loy < this.loy ? this.loy : region.loy, region.hix > this.hix ? this.hix : region.hix, region.hiy > this.hiy ? this.hiy : region.hiy);
        SpanIterator spanIterator = null;
        if (this.bands != null) {
            spanIterator = this.getSpanIterator();
        }
        if (region.bands != null) {
            SpanIterator spanIterator2 = spanIterator = spanIterator == null ? region.getSpanIterator() : region.filter(spanIterator);
        }
        if (spanIterator != null) {
            region2.appendSpans(spanIterator);
        }
        return region2;
    }

    public SpanIterator filter(SpanIterator spanIterator) {
        if (this.bands == null) {
            spanIterator.intersectClipBox(this.lox, this.loy, this.hix, this.hiy);
        } else {
            spanIterator = new RegionClipSpanIterator(this, spanIterator);
        }
        return spanIterator;
    }
}

