/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.Pipe;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SocketChannelImpl;
import sun.nio.ch.Util;

class SourceChannelImpl
extends Pipe.SourceChannel
implements SelChImpl {
    SocketChannel sc;

    public int getFDVal() {
        return ((SocketChannelImpl)this.sc).getFDVal();
    }

    protected void implCloseSelectableChannel() throws IOException {
        if (!this.isRegistered()) {
            this.kill();
        }
    }

    public void kill() throws IOException {
        this.sc.close();
    }

    protected void implConfigureBlocking(boolean bl2) throws IOException {
        this.sc.configureBlocking(bl2);
    }

    public FileDescriptor getFD() {
        return ((SocketChannelImpl)this.sc).getFD();
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        try {
            return this.sc.read(byteBuffer);
        }
        catch (AsynchronousCloseException asynchronousCloseException) {
            this.close();
            throw asynchronousCloseException;
        }
    }

    public long read(ByteBuffer[] byteBufferArray) throws IOException {
        try {
            return this.sc.read(byteBufferArray);
        }
        catch (AsynchronousCloseException asynchronousCloseException) {
            this.close();
            throw asynchronousCloseException;
        }
    }

    public long read(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        try {
            return this.read(Util.subsequence(byteBufferArray, n2, n3));
        }
        catch (AsynchronousCloseException asynchronousCloseException) {
            this.close();
            throw asynchronousCloseException;
        }
    }

    public boolean translateReadyOps(int n2, int n3, SelectionKeyImpl selectionKeyImpl) {
        int n4 = selectionKeyImpl.interestOps();
        int n5 = selectionKeyImpl.readyOps();
        int n6 = n3;
        if ((n2 & 0x20) != 0) {
            throw new Error("POLLNVAL detected");
        }
        if ((n2 & 0x18) != 0) {
            n6 = n4;
            selectionKeyImpl.readyOps(n6);
            return (n6 & ~n5) != 0;
        }
        if ((n2 & 1) != 0 && (n4 & 1) != 0) {
            n6 |= 1;
        }
        selectionKeyImpl.readyOps(n6);
        return (n6 & ~n5) != 0;
    }

    public void translateAndSetInterestOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        if ((n2 & 1) != 0) {
            n2 = 1;
        }
        selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n2);
    }

    public boolean translateAndSetReadyOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n2, 0, selectionKeyImpl);
    }

    public boolean translateAndUpdateReadyOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n2, selectionKeyImpl.readyOps(), selectionKeyImpl);
    }

    SourceChannelImpl(SelectorProvider selectorProvider, SocketChannel socketChannel) {
        super(selectorProvider);
        this.sc = socketChannel;
    }
}

