/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterIOException;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.CharConversionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import javax.print.StreamPrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Sides;
import sun.awt.CharToByteSymbol;
import sun.awt.CharsetString;
import sun.awt.PlatformFont;
import sun.awt.SunToolkit;
import sun.io.CharToByteConverter;
import sun.print.PSPathGraphics;
import sun.print.PSStreamPrintService;
import sun.print.PeekGraphics;
import sun.print.PeekMetrics;
import sun.print.RasterPrinterJob;
import sun.security.action.GetPropertyAction;

public class PSPrinterJob
extends RasterPrinterJob {
    protected static final int FILL_EVEN_ODD = 1;
    protected static final int FILL_WINDING = 2;
    private static final int MAX_PSSTR = 65535;
    private static final int RED_MASK = 0xFF0000;
    private static final int GREEN_MASK = 65280;
    private static final int BLUE_MASK = 255;
    private static final int RED_SHIFT = 16;
    private static final int GREEN_SHIFT = 8;
    private static final int BLUE_SHIFT = 0;
    private static final int LOWNIBBLE_MASK = 15;
    private static final int HINIBBLE_MASK = 240;
    private static final int HINIBBLE_SHIFT = 4;
    private static final byte[] hexDigits;
    private static final int PS_XRES = 300;
    private static final int PS_YRES = 300;
    private static final String FORCE_PIPE_PROP = "sun.java2d.print.pipeline";
    private static final String FORCE_RASTER = "raster";
    private static final String FORCE_PDL = "pdl";
    private static final String SHAPE_TEXT_PROP = "sun.java2d.print.shapetext";
    private static final String ADOBE_PS_STR = "%!PS-Adobe-3.0";
    private static final String EOF_COMMENT = "%%EOF";
    private static final String PAGE_COMMENT = "%%Page: ";
    private static final String READIMAGEPROC = "/imStr 0 def /imageSrc {currentfile /ASCII85Decode filter /RunLengthDecode filter  imStr readstring pop } def";
    private static final String COPIES = "/#copies exch def";
    private static final String PAGE_SAVE = "/pgSave save def";
    private static final String PAGE_RESTORE = "pgSave restore";
    private static final String SHOWPAGE = "showpage";
    private static final String IMAGE_SAVE = "/imSave save def";
    private static final String IMAGE_STR = " string /imStr exch def";
    private static final String IMAGE_RESTORE = "imSave restore";
    private static final String COORD_PREP = " 0 exch translate 1 -1 scale[72 300 div 0 0 72 300 div 0 0]concat";
    private static final String SetFontName = "SF";
    private static final String DrawStringName = "DS";
    private static final String EVEN_ODD_FILL_STR = "eofill";
    private static final String WINDING_FILL_STR = "fill";
    private static final String EVEN_ODD_CLIP_STR = "eoclip";
    private static final String WINDING_CLIP_STR = "clip";
    private static final String MOVETO_STR = " moveto";
    private static final String LINETO_STR = " lineto";
    private static final String CURVETO_STR = " curveto";
    private static final String GRESTORE_STR = "grestore";
    private static final String GSAVE_STR = "gsave";
    private static final String NEWPATH_STR = "newpath";
    private static final String CLOSEPATH_STR = "closepath";
    private static final String SETRGBCOLOR_STR = " setrgbcolor";
    private static final String SETGRAY_STR = " setgray";
    private static final String testString = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ 1234567890";
    private static boolean forcePDL;
    private static boolean forceRaster;
    static boolean shapeTextProp;
    private int mDestType;
    private String mDestination = "lp";
    private boolean mNoJobSheet = false;
    private String mOptions;
    private Font mLastFont;
    private Color mLastColor;
    private Shape mLastClip;
    private AffineTransform mLastTransform;
    private EPSPrinter epsPrinter = null;
    FontMetrics mCurMetrics;
    PrintStream mPSStream;
    File spoolFile;
    private String mFillOpStr = "fill";
    private String mClipOpStr = "clip";
    ArrayList mGStateStack = new ArrayList();
    private float mPenX;
    private float mPenY;
    private float mStartPathX;
    private float mStartPathY;
    private static Properties mFontProps;
    static Class class$javax$print$attribute$standard$JobName;
    static Class class$javax$print$attribute$standard$Copies;
    static Class class$javax$print$attribute$standard$Destination;

    protected double getXRes() {
        return 300.0;
    }

    protected double getYRes() {
        return 300.0;
    }

    protected float getPenX() {
        return this.mPenX;
    }

    protected float getPenY() {
        return this.mPenY;
    }

    protected int getCollatedCopies() {
        return 1;
    }

    protected int getNoncollatedCopies() {
        return 1;
    }

    static {
        String string;
        hexDigits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
        forcePDL = false;
        forceRaster = false;
        shapeTextProp = false;
        mFontProps = null;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PSPrinterJob.access$002(PSPrinterJob.access$100());
                return null;
            }
        });
        forcePDL = false;
        forceRaster = false;
        shapeTextProp = false;
        String string2 = (String)AccessController.doPrivileged(new GetPropertyAction(FORCE_PIPE_PROP));
        if (string2 != null) {
            if (string2.equalsIgnoreCase(FORCE_PDL)) {
                forcePDL = true;
            } else if (string2.equalsIgnoreCase(FORCE_RASTER)) {
                forceRaster = true;
            }
        }
        if ((string = (String)AccessController.doPrivileged(new GetPropertyAction(SHAPE_TEXT_PROP))) != null) {
            shapeTextProp = true;
        }
    }

    protected void abortDoc() {
        if (this.mPSStream != null && this.mDestType != 2) {
            this.mPSStream.close();
        }
        AccessController.doPrivileged(new PrivilegedAction(this){
            private final PSPrinterJob this$0;

            public Object run() {
                if (this.this$0.spoolFile != null && this.this$0.spoolFile.exists()) {
                    this.this$0.spoolFile.delete();
                }
                return null;
            }
            {
                this.this$0 = pSPrinterJob;
            }
        });
    }

    protected void beginPath() {
        this.prepDrawing(null);
        this.mPSStream.println(NEWPATH_STR);
        this.mPenX = 0.0f;
        this.mPenY = 0.0f;
    }

    protected void closeSubpath() {
        this.mPSStream.println(CLOSEPATH_STR);
        this.mPenX = this.mStartPathX;
        this.mPenY = this.mStartPathY;
    }

    protected void endDoc() throws PrinterException {
        if (this.mPSStream != null) {
            this.mPSStream.println(EOF_COMMENT);
            this.mPSStream.flush();
            if (this.mDestType != 2) {
                this.mPSStream.close();
            }
        }
        if (this.mDestType == 0) {
            if (this.getPrintService() != null) {
                this.mDestination = this.getPrintService().getName();
            }
            PrinterSpooler printerSpooler = new PrinterSpooler(this, null);
            AccessController.doPrivileged(printerSpooler);
            if (printerSpooler.pex != null) {
                throw printerSpooler.pex;
            }
        }
    }

    protected void fillPath() {
        this.mPSStream.println(this.mFillOpStr);
    }

    private void grestore() {
        int n2 = this.mGStateStack.size();
        this.mGStateStack.remove(n2 - 1);
        this.mPSStream.println(GRESTORE_STR);
    }

    private void gsave() {
        GState gState = this.getGState();
        this.mGStateStack.add(new GState(this, gState));
        this.mPSStream.println(GSAVE_STR);
    }

    protected void selectClipPath() {
        this.mPSStream.println(this.mClipOpStr);
    }

    protected void startDoc() throws PrinterException {
        if (this.epsPrinter == null) {
            OutputStream outputStream;
            Object object;
            if (this.getPrintService() instanceof PSStreamPrintService) {
                object = (StreamPrintService)this.getPrintService();
                this.mDestType = 2;
                if (((StreamPrintService)object).isDisposed()) {
                    throw new PrinterException("service is disposed");
                }
                outputStream = ((StreamPrintService)object).getOutputStream();
                if (outputStream == null) {
                    throw new PrinterException("Null output stream");
                }
            } else {
                this.mNoJobSheet = this.noJobSheet;
                if (this.destinationAttr != null) {
                    this.mDestType = 1;
                    this.mDestination = this.destinationAttr;
                }
                if (this.mDestType == 1) {
                    try {
                        this.spoolFile = new File(this.mDestination);
                        outputStream = new FileOutputStream(this.spoolFile);
                    }
                    catch (IOException iOException) {
                        throw new PrinterIOException(iOException);
                    }
                } else {
                    object = new PrinterOpener(this, null);
                    AccessController.doPrivileged((PrivilegedAction)object);
                    if (((PrinterOpener)object).pex != null) {
                        throw ((PrinterOpener)object).pex;
                    }
                    outputStream = ((PrinterOpener)object).result;
                }
            }
            this.mPSStream = new PrintStream(new BufferedOutputStream(outputStream));
            this.mPSStream.println(ADOBE_PS_STR);
        }
        this.mPSStream.println("%%BeginProlog");
        this.mPSStream.println(READIMAGEPROC);
        this.mPSStream.println("/BD {bind def} bind def");
        this.mPSStream.println("/D {def} BD");
        this.mPSStream.println("/ISOF {");
        this.mPSStream.println("     dup findfont dup length 1 add dict begin {");
        this.mPSStream.println("             1 index /FID eq {pop pop} {D} ifelse");
        this.mPSStream.println("     } forall /Encoding ISOLatin1Encoding D");
        this.mPSStream.println("     currentdict end definefont");
        this.mPSStream.println("} BD");
        this.mPSStream.println("/NZ {dup 1 lt {pop 1} if} BD");
        this.mPSStream.println("/DS {");
        this.mPSStream.println("     moveto 1 index stringwidth pop NZ sub");
        this.mPSStream.println("     1 index length 1 sub NZ div 0");
        this.mPSStream.println("     3 2 roll ashow newpath} BD");
        this.mPSStream.println("/F [");
        if (mFontProps == null) {
            this.mPSStream.println(" /Helvetica ISOF");
            this.mPSStream.println(" /Helvetica-Bold ISOF");
            this.mPSStream.println(" /Helvetica-Oblique ISOF");
            this.mPSStream.println(" /Helvetica-BoldOblique ISOF");
            this.mPSStream.println(" /Times-Roman ISOF");
            this.mPSStream.println(" /Times-Bold ISOF");
            this.mPSStream.println(" /Times-Italic ISOF");
            this.mPSStream.println(" /Times-BoldItalic ISOF");
            this.mPSStream.println(" /Courier ISOF");
            this.mPSStream.println(" /Courier-Bold ISOF");
            this.mPSStream.println(" /Courier-Oblique ISOF");
            this.mPSStream.println(" /Courier-BoldOblique ISOF");
        } else {
            int n2 = Integer.parseInt(mFontProps.getProperty("font.num", "9"));
            for (int i2 = 0; i2 < n2; ++i2) {
                this.mPSStream.println("    /" + mFontProps.getProperty("font." + String.valueOf(i2), "Courier ISOF"));
            }
        }
        this.mPSStream.println("] D");
        this.mPSStream.println("/SF {");
        this.mPSStream.println("     F exch get exch scalefont setfont");
        if (mFontProps == null) {
            this.mPSStream.println(" (abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ 1234567890) stringwidth pop div");
        } else {
            this.mPSStream.println(" testString stringwidth pop div");
        }
        this.mPSStream.println("     currentfont [1 0 0 -1 0 0]makefont exch scalefont setfont} BD");
        this.mPSStream.println("%%EndProlog");
        this.mPSStream.println("%%BeginSetup");
        if (this.epsPrinter == null) {
            this.mPSStream.println("<< " + (this.isCollated() ? "/Collate true " : "") + "/NumCopies " + this.getCopiesInt() + " >> setpagedevice ");
            if (this.sidesAttr != Sides.ONE_SIDED) {
                this.mPSStream.print("<< ");
                if (this.sidesAttr == Sides.TWO_SIDED_LONG_EDGE) {
                    this.mPSStream.print(" /Duplex true ");
                } else if (this.sidesAttr == Sides.TWO_SIDED_SHORT_EDGE) {
                    this.mPSStream.print(" /Duplex true /Tumble true ");
                }
                this.mPSStream.println(">> setpagedevice ");
            }
        }
        this.mPSStream.println("%%EndSetup");
    }

    private boolean isOuterGState() {
        return this.mGStateStack.size() == 1;
    }

    public boolean printDialog() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (this.attributes == null) {
            this.attributes = new HashPrintRequestAttributeSet();
        }
        this.attributes.add(new Copies(this.getCopies()));
        this.attributes.add(new JobName(this.getJobName(), null));
        boolean bl2 = this.printDialog(this.attributes);
        if (bl2) {
            Destination destination;
            Copies copies;
            JobName jobName = (JobName)this.attributes.get(class$javax$print$attribute$standard$JobName == null ? (class$javax$print$attribute$standard$JobName = PSPrinterJob.class$("javax.print.attribute.standard.JobName")) : class$javax$print$attribute$standard$JobName);
            if (jobName != null) {
                this.setJobName(jobName.getValue());
            }
            if ((copies = (Copies)this.attributes.get(class$javax$print$attribute$standard$Copies == null ? (class$javax$print$attribute$standard$Copies = PSPrinterJob.class$("javax.print.attribute.standard.Copies")) : class$javax$print$attribute$standard$Copies)) != null) {
                this.setCopies(copies.getValue());
            }
            if ((destination = (Destination)this.attributes.get(class$javax$print$attribute$standard$Destination == null ? (class$javax$print$attribute$standard$Destination = PSPrinterJob.class$("javax.print.attribute.standard.Destination")) : class$javax$print$attribute$standard$Destination)) != null) {
                try {
                    this.mDestType = 1;
                    this.mDestination = new File(destination.getURI()).getPath();
                }
                catch (Exception exception) {
                    this.mDestination = "out.ps";
                }
            } else {
                this.mDestType = 0;
                this.mDestination = this.getPrintService().getName();
            }
        }
        return bl2;
    }

    protected void lineTo(float f2, float f3) {
        this.mPSStream.println(f2 + " " + f3 + LINETO_STR);
        this.mPenX = f2;
        this.mPenY = f3;
    }

    protected void moveTo(float f2, float f3) {
        this.mPSStream.println(f2 + " " + f3 + MOVETO_STR);
        this.mStartPathX = f2;
        this.mStartPathY = f3;
        this.mPenX = f2;
        this.mPenY = f3;
    }

    protected void bezierTo(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.mPSStream.println(f2 + " " + f3 + " " + f4 + " " + f5 + " " + f6 + " " + f7 + CURVETO_STR);
        this.mPenX = f6;
        this.mPenY = f7;
    }

    protected void setFillMode(int n2) {
        switch (n2) {
            case 1: {
                this.mFillOpStr = EVEN_ODD_FILL_STR;
                this.mClipOpStr = EVEN_ODD_CLIP_STR;
                break;
            }
            case 2: {
                this.mFillOpStr = WINDING_FILL_STR;
                this.mClipOpStr = WINDING_CLIP_STR;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private byte[] ascii85Encode(byte[] byArray) {
        long l2;
        long l3;
        byte[] byArray2 = new byte[(byArray.length + 4) * 5 / 4 + 2];
        long l4 = 85L;
        long l5 = l4 * l4;
        long l6 = l4 * l5;
        long l7 = l4 * l6;
        int n2 = 33;
        int n3 = 0;
        int n4 = 0;
        while (n3 + 3 < byArray.length) {
            if ((l3 = ((long)(byArray[n3++] & 0xFF) << 24) + ((long)(byArray[n3++] & 0xFF) << 16) + ((long)(byArray[n3++] & 0xFF) << 8) + (long)(byArray[n3++] & 0xFF)) == 0L) {
                byArray2[n4++] = 122;
                continue;
            }
            l2 = l3;
            byArray2[n4++] = (byte)(l2 / l7 + (long)n2);
            byArray2[n4++] = (byte)((l2 %= l7) / l6 + (long)n2);
            byArray2[n4++] = (byte)((l2 %= l6) / l5 + (long)n2);
            byArray2[n4++] = (byte)((l2 %= l5) / l4 + (long)n2);
            byArray2[n4++] = (byte)((l2 %= l4) + (long)n2);
        }
        if (n3 < byArray.length) {
            int n5 = byArray.length - n3;
            l3 = 0L;
            while (n3 < byArray.length) {
                l3 = (l3 << 8) + (long)(byArray[n3++] & 0xFF);
            }
            int n6 = 4 - n5;
            while (n6-- > 0) {
                l3 <<= 8;
            }
            byte[] byArray3 = new byte[5];
            l2 = l3;
            byArray3[0] = (byte)(l2 / l7 + (long)n2);
            byArray3[1] = (byte)((l2 %= l7) / l6 + (long)n2);
            byArray3[2] = (byte)((l2 %= l6) / l5 + (long)n2);
            byArray3[3] = (byte)((l2 %= l5) / l4 + (long)n2);
            byArray3[4] = (byte)((l2 %= l4) + (long)n2);
            for (int i2 = 0; i2 < n5 + 1; ++i2) {
                byArray2[n4++] = byArray3[i2];
            }
        }
        byArray2[n4++] = 126;
        byArray2[n4++] = 62;
        byte[] byArray4 = new byte[n4];
        System.arraycopy(byArray2, 0, byArray4, 0, n4);
        return byArray4;
    }

    private byte[] rlEncode(byte[] byArray) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        byte[] byArray2 = new byte[byArray.length * 2 + 2];
        while (n2 < byArray.length) {
            if (n5 == 0) {
                n4 = n2++;
                n5 = 1;
            }
            while (n5 < 128 && n2 < byArray.length && byArray[n2] == byArray[n4]) {
                ++n5;
                ++n2;
            }
            if (n5 > 1) {
                byArray2[n3++] = (byte)(257 - n5);
                byArray2[n3++] = byArray[n4];
                n5 = 0;
                continue;
            }
            while (n5 < 128 && n2 < byArray.length && byArray[n2] != byArray[n2 - 1]) {
                ++n5;
                ++n2;
            }
            byArray2[n3++] = (byte)(n5 - 1);
            for (int i2 = n4; i2 < n4 + n5; ++i2) {
                byArray2[n3++] = byArray[i2];
            }
            n5 = 0;
        }
        byArray2[n3++] = -128;
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray2, 0, byArray3, 0, n3);
        return byArray3;
    }

    protected void drawImageBGR(byte[] byArray, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, int n2, int n3) {
        int n4;
        this.setTransform(new AffineTransform());
        this.prepDrawing(null);
        int n5 = (int)f8;
        int n6 = (int)f9;
        this.mPSStream.println(IMAGE_SAVE);
        for (n4 = 3 * n5; n4 > 65535; n4 /= 2) {
        }
        this.mPSStream.println(n4 + IMAGE_STR);
        this.mPSStream.println("[" + f4 + " 0 " + "0 " + f5 + " " + f2 + " " + f3 + "]concat");
        this.mPSStream.println(n5 + " " + n6 + " " + 8 + "[" + n5 + " 0 " + "0 " + n6 + " 0 " + 0 + "]" + "/imageSrc load false 3 colorimage");
        int n7 = 0;
        byte[] byArray2 = new byte[n5 * 3];
        try {
            n7 = (int)f7 * n2;
            for (int i2 = 0; i2 < n6; ++i2) {
                n7 += (int)f6;
                n7 = PSPrinterJob.swapBGRtoRGB(byArray, n7, byArray2);
                byte[] byArray3 = this.rlEncode(byArray2);
                byte[] byArray4 = this.ascii85Encode(byArray3);
                this.mPSStream.write(byArray4);
                this.mPSStream.println("");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mPSStream.println(IMAGE_RESTORE);
    }

    protected void printBand(byte[] byArray, int n2, int n3, int n4, int n5) throws PrinterException {
        int n6;
        this.mPSStream.println(IMAGE_SAVE);
        for (n6 = 3 * n4; n6 > 65535; n6 /= 2) {
        }
        this.mPSStream.println(n6 + IMAGE_STR);
        this.mPSStream.println("[" + n4 + " 0 " + "0 " + n5 + " " + n2 + " " + n3 + "]concat");
        this.mPSStream.println(n4 + " " + n5 + " " + 8 + "[" + n4 + " 0 " + "0 " + -n5 + " 0 " + n5 + "]" + "/imageSrc load false 3 colorimage");
        int n7 = 0;
        byte[] byArray2 = new byte[n4 * 3];
        try {
            for (int i2 = 0; i2 < n5; ++i2) {
                n7 = PSPrinterJob.swapBGRtoRGB(byArray, n7, byArray2);
                byte[] byArray3 = this.rlEncode(byArray2);
                byte[] byArray4 = this.ascii85Encode(byArray3);
                this.mPSStream.write(byArray4);
                this.mPSStream.println("");
            }
        }
        catch (IOException iOException) {
            throw new PrinterIOException(iOException);
        }
        this.mPSStream.println(IMAGE_RESTORE);
    }

    private static int swapBGRtoRGB(byte[] byArray, int n2, byte[] byArray2) {
        int n3 = 0;
        while (n2 < byArray.length - 2 && n3 < byArray2.length - 2) {
            byArray2[n3++] = byArray[n2 + 2];
            byArray2[n3++] = byArray[n2 + 1];
            byArray2[n3++] = byArray[n2 + 0];
            n2 += 3;
        }
        return n2;
    }

    protected void setColor(Color color) {
        this.mLastColor = color;
    }

    protected boolean setFont(Font font) {
        this.mLastFont = font;
        return true;
    }

    private void prepDrawing(Graphics graphics) {
        while (!(this.isOuterGState() || this.getGState().canSetClip(this.mLastClip) && this.getGState().mTransform.equals(this.mLastTransform))) {
            this.grestore();
        }
        this.getGState().emitPSColor(this.mLastColor);
        if (this.isOuterGState()) {
            this.gsave();
            this.getGState().emitTransform(this.mLastTransform);
            this.getGState().emitPSClip(this.mLastClip);
        }
        if (graphics != null) {
            this.getGState().emitPSFont(graphics, this.mLastFont);
        }
    }

    protected void setClip(Shape shape) {
        this.mLastClip = shape;
    }

    protected void setTransform(AffineTransform affineTransform) {
        this.mLastTransform = affineTransform;
    }

    protected double getPhysicalPageHeight(Paper paper) {
        return paper.getHeight();
    }

    protected double getPhysicalPageWidth(Paper paper) {
        return paper.getWidth();
    }

    protected double getPhysicalPrintableHeight(Paper paper) {
        return paper.getImageableHeight();
    }

    protected double getPhysicalPrintableWidth(Paper paper) {
        return paper.getImageableWidth();
    }

    protected double getPhysicalPrintableX(Paper paper) {
        return 0.0;
    }

    protected double getPhysicalPrintableY(Paper paper) {
        return 0.0;
    }

    static Properties access$100() {
        return PSPrinterJob.initProps();
    }

    private static Properties initProps() {
        String string = System.getProperty("java.home");
        if (string != null) {
            String string2 = SunToolkit.getStartupLocale().getLanguage();
            try {
                File file = new File(string + File.separator + "lib" + File.separator + "psfontj2d.properties." + string2);
                if (!(file.canRead() || (file = new File(string + File.separator + "lib" + File.separator + "psfont.properties." + string2)).canRead() || (file = new File(string + File.separator + "lib" + File.separator + "psfontj2d.properties")).canRead() || (file = new File(string + File.separator + "lib" + File.separator + "psfont.properties")).canRead())) {
                    return null;
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file.getPath()));
                Properties properties = new Properties();
                properties.load(bufferedInputStream);
                ((InputStream)bufferedInputStream).close();
                return properties;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    static boolean access$500(PSPrinterJob pSPrinterJob) {
        return pSPrinterJob.mNoJobSheet;
    }

    static int access$1002(PSPrinterJob pSPrinterJob, int n2) {
        pSPrinterJob.mDestType = n2;
        return pSPrinterJob.mDestType;
    }

    private GState getGState() {
        int n2 = this.mGStateStack.size();
        return (GState)this.mGStateStack.get(n2 - 1);
    }

    protected void endPage(PageFormat pageFormat, Printable printable, int n2) throws PrinterException {
        this.mPSStream.println(PAGE_RESTORE);
        this.mPSStream.println(SHOWPAGE);
    }

    protected void startPage(PageFormat pageFormat, Printable printable, int n2) throws PrinterException {
        double d2 = pageFormat.getPaper().getHeight();
        double d3 = pageFormat.getPaper().getWidth();
        int n3 = n2 + 1;
        this.mGStateStack = new ArrayList();
        this.mGStateStack.add(new GState(this));
        this.mPSStream.println(PAGE_COMMENT + n3 + " " + n3);
        this.mPSStream.println("<< /PageSize [" + d3 + " " + d2 + "] /ImagingBBox null /ManualFeed false  >> setpagedevice");
        this.mPSStream.println(PAGE_SAVE);
        this.mPSStream.println(d2 + COORD_PREP);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    protected boolean textOut(Graphics graphics, String string, float f2, float f3) {
        boolean bl2 = true;
        if (mFontProps == null) {
            this.prepDrawing(graphics);
            this.mPSStream.println(f2 + " " + f3 + " moveto(" + PSPrinterJob.escapeParens(string) + ")show");
        } else {
            this.prepDrawing(null);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            CharsetString[] charsetStringArray = ((PlatformFont)this.mLastFont.getPeer()).makeMultiCharsetString(string, false);
            if (charsetStringArray == null) {
                return false;
            }
            int[] nArray = this.getPSFontIndexArray(this.mLastFont, charsetStringArray);
            if (nArray != null) {
                for (int i2 = 0; i2 < charsetStringArray.length; ++i2) {
                    int n2;
                    CharsetString charsetString = charsetStringArray[i2];
                    CharToByteConverter charToByteConverter = charsetString.fontDescriptor.fontCharset;
                    StringBuffer stringBuffer = new StringBuffer();
                    byte[] byArray = new byte[charsetString.length * 2];
                    try {
                        n2 = charToByteConverter.convert(charsetString.charsetChars, charsetString.offset, charsetString.offset + charsetString.length, byArray, 0, byArray.length);
                    }
                    catch (CharConversionException charConversionException) {
                        continue;
                    }
                    Rectangle2D rectangle2D = fontMetrics.getStringBounds(charsetString.charsetChars, charsetString.offset, charsetString.offset + charsetString.length, graphics);
                    float f4 = (float)rectangle2D.getWidth();
                    stringBuffer.append('<');
                    for (int i3 = 0; i3 < n2; ++i3) {
                        byte by = byArray[i3];
                        String string2 = Integer.toHexString(by);
                        int n3 = string2.length();
                        if (n3 > 2) {
                            string2 = string2.substring(n3 - 2, n3);
                        } else if (n3 == 1) {
                            string2 = "0" + string2;
                        } else if (n3 == 0) {
                            string2 = "00";
                        }
                        stringBuffer.append(string2);
                    }
                    stringBuffer.append('>');
                    this.mPSStream.println("/testString " + stringBuffer.toString() + " D");
                    this.mPSStream.println("% Font[" + this.mLastFont.getName() + ", " + PlatformFont.styleStr(this.mLastFont.getStyle()) + ", " + this.mLastFont.getSize2D() + "]");
                    this.getGState().emitPSFont(nArray[i2], this.mLastFont.getSize2D(), f4);
                    this.mPSStream.println(stringBuffer.toString());
                    this.mPSStream.println(" " + f4 + " " + f2 + " " + f3);
                    this.mPSStream.println(DrawStringName);
                    f2 += f4;
                }
            } else {
                bl2 = false;
            }
        }
        return bl2;
    }

    private static String escapeParens(String string) {
        if (string.indexOf(40) == -1 && string.indexOf(41) == -1) {
            return string;
        }
        int n2 = 0;
        int n3 = 0;
        while ((n3 = string.indexOf(40, n3)) != -1) {
            ++n2;
            ++n3;
        }
        n3 = 0;
        while ((n3 = string.indexOf(41, n3)) != -1) {
            ++n2;
            ++n3;
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length + n2];
        n3 = 0;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] == '(' || cArray[i2] == ')') {
                cArray2[n3++] = 92;
            }
            cArray2[n3++] = cArray[i2];
        }
        return new String(cArray2);
    }

    private String makeCharsetName(String string, char[] cArray) {
        if (string.equals("Cp1252") || string.equals("ISO8859_1")) {
            return "latin1";
        }
        if (string.equals("UTF8")) {
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                if (cArray[i2] <= '\u00ff') continue;
                return string.toLowerCase();
            }
            return "latin1";
        }
        if (string.startsWith("ISO8859")) {
            for (int i3 = 0; i3 < cArray.length; ++i3) {
                if (cArray[i3] <= '\u007f') continue;
                return string.toLowerCase();
            }
            return "latin1";
        }
        return string.toLowerCase();
    }

    static String access$300(PSPrinterJob pSPrinterJob) {
        return pSPrinterJob.mDestination;
    }

    static String access$400(PSPrinterJob pSPrinterJob) {
        return pSPrinterJob.mOptions;
    }

    static Properties access$002(Properties properties) {
        mFontProps = properties;
        return mFontProps;
    }

    private int[] getPSFontIndexArray(Font font, CharsetString[] charsetStringArray) {
        int[] nArray = null;
        if (mFontProps != null) {
            nArray = new int[charsetStringArray.length];
        }
        for (int i2 = 0; i2 < charsetStringArray.length && nArray != null; ++i2) {
            CharsetString charsetString = charsetStringArray[i2];
            CharToByteConverter charToByteConverter = charsetString.fontDescriptor.fontCharset;
            String string = charToByteConverter instanceof CharToByteSymbol ? "symbol" : (charToByteConverter.toString().equals("WingDingsFontCharset") || charToByteConverter.toString().equals("X11Dingbats") ? "dingbats" : this.makeCharsetName(charToByteConverter.getCharacterEncoding(), charsetString.charsetChars));
            String string2 = PlatformFont.styleStr(font.getStyle());
            String string3 = font.getFamily().toLowerCase(Locale.ENGLISH);
            String string4 = mFontProps.getProperty(string3 = string3.replace(' ', '_'), "");
            String string5 = mFontProps.getProperty(string4 + "." + string + "." + string2, null);
            if (string5 != null) {
                try {
                    nArray[i2] = Integer.parseInt(mFontProps.getProperty(string5));
                }
                catch (NumberFormatException numberFormatException) {
                    nArray = null;
                }
                continue;
            }
            nArray = null;
        }
        return nArray;
    }

    static GState access$800(PSPrinterJob pSPrinterJob) {
        return pSPrinterJob.getGState();
    }

    static EPSPrinter access$902(PSPrinterJob pSPrinterJob, EPSPrinter ePSPrinter) {
        pSPrinterJob.epsPrinter = ePSPrinter;
        return pSPrinterJob.epsPrinter;
    }

    protected Graphics2D createPathGraphics(PeekGraphics peekGraphics, PrinterJob printerJob, Printable printable, PageFormat pageFormat, int n2) {
        PSPathGraphics pSPathGraphics;
        PeekMetrics peekMetrics = peekGraphics.getMetrics();
        if (!forcePDL && (forceRaster || peekMetrics.hasNonSolidColors() || peekMetrics.hasCompositing())) {
            pSPathGraphics = null;
        } else {
            BufferedImage bufferedImage = new BufferedImage(8, 8, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            boolean bl2 = !peekGraphics.getAWTDrawingOnly();
            pSPathGraphics = new PSPathGraphics(graphics2D, printerJob, printable, pageFormat, n2, bl2);
        }
        return pSPathGraphics;
    }

    private String[] printExecCmd(String string, String string2, boolean bl2, String string3, int n2, String string4) {
        String[] stringArray;
        int n3 = 1;
        int n4 = 2;
        int n5 = 4;
        int n6 = 8;
        int n7 = 16;
        int n8 = 0;
        int n9 = 2;
        int n10 = 0;
        if (string != null && !string.equals("") && !string.equals("lp")) {
            n8 |= n3;
            ++n9;
        }
        if (string2 != null && !string2.equals("")) {
            n8 |= n4;
            ++n9;
        }
        if (string3 != null && !string3.equals("")) {
            n8 |= n5;
            ++n9;
        }
        if (n2 > 1) {
            n8 |= n6;
            ++n9;
        }
        if (bl2) {
            n8 |= n7;
            ++n9;
        }
        if (System.getProperty("os.name").equals("Linux")) {
            stringArray = new String[n9];
            stringArray[n10++] = "/usr/bin/lpr";
            if ((n8 & n3) != 0) {
                stringArray[n10++] = new String("-P" + string);
            }
            if ((n8 & n5) != 0) {
                stringArray[n10++] = new String("-J" + string3);
            }
            if ((n8 & n6) != 0) {
                stringArray[n10++] = new String("-#" + new Integer(n2).toString());
            }
            if ((n8 & n7) != 0) {
                stringArray[n10++] = new String("-h");
            }
            if ((n8 & n4) != 0) {
                stringArray[n10++] = new String(string2);
            }
        } else {
            stringArray = new String[++n9];
            stringArray[n10++] = "/usr/bin/lp";
            stringArray[n10++] = "-c";
            if ((n8 & n3) != 0) {
                stringArray[n10++] = new String("-d" + string);
            }
            if ((n8 & n5) != 0) {
                stringArray[n10++] = new String("-t" + string3);
            }
            if ((n8 & n6) != 0) {
                stringArray[n10++] = new String("-n" + new Integer(n2).toString());
            }
            if ((n8 & n7) != 0) {
                stringArray[n10++] = new String("-o nobanner");
            }
            if ((n8 & n4) != 0) {
                stringArray[n10++] = new String("-o" + string2);
            }
        }
        stringArray[n10++] = string4;
        return stringArray;
    }

    static String[] access$600(PSPrinterJob pSPrinterJob, String string, String string2, boolean bl2, String string3, int n2, String string4) {
        return pSPrinterJob.printExecCmd(string, string2, bl2, string3, n2, string4);
    }

    public static class EPSPrinter
    implements Pageable {
        private PageFormat pf;
        private PSPrinterJob job;
        private int llx;
        private int lly;
        private int urx;
        private int ury;
        private Printable printable;
        private PrintStream stream;
        private String epsTitle;

        public int getNumberOfPages() {
            return 1;
        }

        public void print() throws PrinterException {
            this.stream.println("%!PS-Adobe-3.0 EPSF-3.0");
            this.stream.println("%%BoundingBox: " + this.llx + " " + this.lly + " " + this.urx + " " + this.ury);
            this.stream.println("%%Title: " + this.epsTitle);
            this.stream.println("%%Creator: Java Printing");
            this.stream.println("%%CreationDate: " + new Date());
            this.stream.println("%%EndComments");
            this.job = new PSPrinterJob();
            PSPrinterJob.access$902(this.job, this);
            this.job.mPSStream = this.stream;
            PSPrinterJob.access$1002(this.job, 2);
            this.job.startDoc();
            try {
                this.job.printPage(this, 0);
            }
            catch (Throwable throwable) {
                if (throwable instanceof PrinterException) {
                    throw (PrinterException)throwable;
                }
                throw new PrinterException(throwable.toString());
            }
            finally {
                this.job.endDoc();
            }
            this.stream.flush();
        }

        public PageFormat getPageFormat(int n2) {
            if (n2 > 0) {
                throw new IndexOutOfBoundsException("pgIndex");
            }
            return this.pf;
        }

        public Printable getPrintable(int n2) {
            if (n2 > 0) {
                throw new IndexOutOfBoundsException("pgIndex");
            }
            return this.printable;
        }

        public EPSPrinter(Printable printable, String string, PrintStream printStream, int n2, int n3, int n4, int n5) {
            this.printable = printable;
            this.epsTitle = string;
            this.stream = printStream;
            this.llx = n2;
            this.lly = n3;
            this.urx = this.llx + n4;
            this.ury = this.lly + n5;
            Paper paper = new Paper();
            paper.setSize(n4, n5);
            paper.setImageableArea(0.0, 0.0, n4, n5);
            this.pf = new PageFormat();
            this.pf.setPaper(paper);
        }
    }

    private class GState {
        Color mColor;
        Shape mClip;
        Font mFont;
        AffineTransform mTransform;
        private final PSPrinterJob this$0;

        void emitPSFont(int n2, float f2, float f3) {
            this.this$0.mPSStream.println(f3 + " " + f2 + " " + n2 + " " + PSPrinterJob.SetFontName);
        }

        void emitPSColor(Color color) {
            if (color != null && !color.equals(this.mColor)) {
                float[] fArray = color.getColorComponents(null);
                if (fArray[0] == fArray[1] && fArray[1] == fArray[2]) {
                    this.this$0.mPSStream.println(fArray[0] + PSPrinterJob.SETGRAY_STR);
                } else {
                    this.this$0.mPSStream.println(fArray[0] + " " + fArray[1] + " " + fArray[2] + " " + PSPrinterJob.SETRGBCOLOR_STR);
                }
                this.mColor = color;
            }
        }

        void emitPSClip(Shape shape) {
            if (!(shape == null || this.mClip != null && this.mClip.equals(shape))) {
                this.convertToPSPath(shape.getPathIterator(new AffineTransform()));
                this.this$0.selectClipPath();
                this.mClip = shape;
            }
        }

        boolean canSetClip(Shape shape) {
            return this.mClip == null || this.mClip.equals(shape);
        }

        void emitTransform(AffineTransform affineTransform) {
            if (affineTransform != null && !affineTransform.equals(this.mTransform)) {
                double[] dArray = new double[6];
                affineTransform.getMatrix(dArray);
                this.this$0.mPSStream.println("[" + dArray[0] + " " + dArray[1] + " " + dArray[2] + " " + dArray[3] + " " + dArray[4] + " " + dArray[5] + "] concat");
                this.mTransform = affineTransform;
            }
        }

        private void convertToPSPath(PathIterator pathIterator) {
            float[] fArray = new float[6];
            int n2 = pathIterator.getWindingRule() == 0 ? 1 : 2;
            this.this$0.setFillMode(n2);
            this.this$0.beginPath();
            while (!pathIterator.isDone()) {
                int n3 = pathIterator.currentSegment(fArray);
                switch (n3) {
                    case 0: {
                        this.this$0.moveTo(fArray[0], fArray[1]);
                        break;
                    }
                    case 1: {
                        this.this$0.lineTo(fArray[0], fArray[1]);
                        break;
                    }
                    case 2: {
                        float f2 = this.this$0.getPenX();
                        float f3 = this.this$0.getPenY();
                        float f4 = f2 + (fArray[0] - f2) * 2.0f / 3.0f;
                        float f5 = f3 + (fArray[1] - f3) * 2.0f / 3.0f;
                        float f6 = fArray[2] - (fArray[2] - fArray[0]) * 2.0f / 3.0f;
                        float f7 = fArray[3] - (fArray[3] - fArray[1]) * 2.0f / 3.0f;
                        this.this$0.bezierTo(f4, f5, f6, f7, fArray[2], fArray[3]);
                        break;
                    }
                    case 3: {
                        this.this$0.bezierTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                        break;
                    }
                    case 4: {
                        this.this$0.closeSubpath();
                    }
                }
                pathIterator.next();
            }
        }

        GState(PSPrinterJob pSPrinterJob) {
            this.this$0 = pSPrinterJob;
            this.mColor = Color.black;
            this.mClip = null;
            this.mFont = null;
            this.mTransform = new AffineTransform();
        }

        void emitPSFont(Graphics graphics, Font font) {
            if (this.mFont == null && font != null || !this.mFont.equals(font)) {
                this.this$0.mCurMetrics = graphics.getFontMetrics();
                Rectangle2D rectangle2D = this.this$0.mCurMetrics.getStringBounds(PSPrinterJob.testString, graphics);
                float f2 = (float)rectangle2D.getWidth();
                int n2 = font.getStyle();
                n2 = font.getFamily().toLowerCase().startsWith("helvetica") || font.getFamily().toLowerCase().startsWith("sansserif") ? 0 : (font.getFamily().toLowerCase().startsWith("dialog") ? 0 : (font.getFamily().toLowerCase().startsWith("times") || font.getFamily().toLowerCase().startsWith("serif") ? 4 : 8));
                if (font.isBold()) {
                    ++n2;
                }
                if (font.isItalic()) {
                    n2 += 2;
                }
                this.this$0.mPSStream.println("% Font[" + font.getFamily() + ", " + font.getStyle() + ", " + font.getSize2D() + "]");
                PSPrinterJob.access$800(this.this$0).emitPSFont(n2, font.getSize2D(), f2);
            }
            this.mFont = font;
        }

        GState(PSPrinterJob pSPrinterJob, GState gState) {
            this.this$0 = pSPrinterJob;
            this.mColor = gState.mColor;
            this.mClip = gState.mClip;
            this.mFont = gState.mFont;
            this.mTransform = gState.mTransform;
        }
    }

    public static class PluginPrinter
    implements Printable {
        private EPSPrinter epsPrinter;
        private Component applet;
        private PrintStream stream;
        private String epsTitle;
        private int bx;
        private int by;
        private int bw;
        private int bh;
        private int width;
        private int height;

        public void printAll() {
            this.printPluginPSHeader();
            this.printPluginApplet();
            this.printPluginPSTrailer();
        }

        public void printPluginApplet() {
            try {
                this.epsPrinter.print();
            }
            catch (PrinterException printerException) {
                // empty catch block
            }
        }

        public void printPluginPSHeader() {
            this.stream.println("BeginEPSF");
            this.stream.println("%%BeginDocument: JavaPluginApplet");
            this.stream.println("clippath pathbbox");
            this.stream.println("/ury exch def /urx exch def");
            this.stream.println("/lly exch def /llx exch def");
            this.stream.println("/imHgt ury lly sub def");
            this.stream.println("/ypos ury " + (this.by + this.bh) + " imHgt cvi mod sub def");
            this.stream.println("llx ypos translate");
            float f2 = (float)this.bw / (float)this.width;
            float f3 = (float)this.bh / (float)this.height;
            this.stream.println(f2 + " " + f3 + " scale");
        }

        public void printPluginPSTrailer() {
            this.stream.println("EndEPSF");
            this.stream.println("%%EndDocument: JavaPluginApplet");
            this.stream.flush();
        }

        public int print(Graphics graphics, PageFormat pageFormat, int n2) {
            if (n2 > 0) {
                return 1;
            }
            this.applet.printAll(graphics);
            return 0;
        }

        public PluginPrinter(Component component, PrintStream printStream, int n2, int n3, int n4, int n5) {
            this.applet = component;
            this.epsTitle = "Java Plugin Applet";
            this.stream = printStream;
            this.bx = n2;
            this.by = n3;
            this.bw = n4;
            this.bh = n5;
            this.width = component.size().width;
            this.height = component.size().height;
            this.epsPrinter = new EPSPrinter(this, this.epsTitle, printStream, 0, 0, this.width, this.height);
        }
    }

    private class PrinterOpener
    implements PrivilegedAction {
        PrinterException pex;
        OutputStream result;
        private final PSPrinterJob this$0;

        public Object run() {
            try {
                this.this$0.spoolFile = File.createTempFile("javaprint", ".ps", null);
                this.this$0.spoolFile.deleteOnExit();
                this.result = new FileOutputStream(this.this$0.spoolFile);
                return this.result;
            }
            catch (IOException iOException) {
                this.pex = new PrinterIOException(iOException);
                return null;
            }
        }

        private PrinterOpener(PSPrinterJob pSPrinterJob) {
            this.this$0 = pSPrinterJob;
        }

        PrinterOpener(PSPrinterJob pSPrinterJob, 1 var2_2) {
            this(pSPrinterJob);
        }
    }

    private class PrinterSpooler
    implements PrivilegedAction {
        PrinterException pex;
        private final PSPrinterJob this$0;

        public Object run() {
            try {
                if (this.this$0.spoolFile == null || !this.this$0.spoolFile.exists()) {
                    this.pex = new PrinterException("No spool file");
                    return null;
                }
                String string = this.this$0.spoolFile.getAbsolutePath();
                String[] stringArray = PSPrinterJob.access$600(this.this$0, PSPrinterJob.access$300(this.this$0), PSPrinterJob.access$400(this.this$0), PSPrinterJob.access$500(this.this$0), this.this$0.getJobNameInt(), 1, string);
                Process process = Runtime.getRuntime().exec(stringArray);
                process.waitFor();
                this.this$0.spoolFile.delete();
            }
            catch (IOException iOException) {
                this.pex = new PrinterIOException(iOException);
            }
            catch (InterruptedException interruptedException) {
                this.pex = new PrinterException(interruptedException.toString());
            }
            return null;
        }

        private PrinterSpooler(PSPrinterJob pSPrinterJob) {
            this.this$0 = pSPrinterJob;
        }

        PrinterSpooler(PSPrinterJob pSPrinterJob, 1 var2_2) {
            this(pSPrinterJob);
        }
    }
}

