/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.server.Operation;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteRef;
import java.security.AccessController;
import sun.rmi.runtime.Log;
import sun.rmi.server.RemoteProxy;
import sun.rmi.transport.Connection;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.StreamRemoteCall;
import sun.security.action.GetBooleanAction;

public class UnicastRef
implements RemoteRef {
    public static final Log clientRefLog = Log.getLog("sun.rmi.client.ref", "transport", RemoteProxy.logLevel);
    public static final Log clientCallLog;
    protected LiveRef ref;

    public int remoteHashCode() {
        return this.ref.hashCode();
    }

    static {
        Boolean bl2 = (Boolean)AccessController.doPrivileged(new GetBooleanAction("sun.rmi.client.logCalls"));
        boolean bl3 = bl2;
        clientCallLog = Log.getLog("sun.rmi.client.call", "RMI", bl3);
    }

    public UnicastRef() {
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.ref = LiveRef.read(objectInput, false);
    }

    protected void marshalCustomCallData(ObjectOutput objectOutput) throws IOException {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.ref.write(objectOutput, false);
    }

    public String remoteToString() {
        return "RemoteStub [ref: " + this.ref + "]";
    }

    public void done(RemoteCall remoteCall) throws RemoteException {
        clientRefLog.log(Log.BRIEF, "free connection (reuse = true)");
        this.free(remoteCall, true);
        try {
            remoteCall.done();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void invoke(RemoteCall remoteCall) throws Exception {
        try {
            clientRefLog.log(Log.VERBOSE, "execute call");
            remoteCall.executeCall();
        }
        catch (RemoteException remoteException) {
            clientRefLog.log(Log.BRIEF, "exception: ", remoteException);
            this.free(remoteCall, false);
            throw remoteException;
        }
        catch (Error error) {
            clientRefLog.log(Log.BRIEF, "error: ", error);
            this.free(remoteCall, false);
            throw error;
        }
        catch (RuntimeException runtimeException) {
            clientRefLog.log(Log.BRIEF, "exception: ", runtimeException);
            this.free(remoteCall, false);
            throw runtimeException;
        }
        catch (Exception exception) {
            clientRefLog.log(Log.BRIEF, "exception: ", exception);
            this.free(remoteCall, true);
            throw exception;
        }
    }

    private void free(RemoteCall remoteCall, boolean bl2) throws RemoteException {
        Connection connection = ((StreamRemoteCall)remoteCall).getConnection();
        this.ref.getChannel().free(connection, bl2);
    }

    public boolean remoteEquals(RemoteRef remoteRef) {
        if (remoteRef instanceof UnicastRef) {
            return this.ref.remoteEquals(((UnicastRef)remoteRef).ref);
        }
        return false;
    }

    public UnicastRef(LiveRef liveRef) {
        this.ref = liveRef;
    }

    void logClientCall(Object object, Object object2) {
        clientCallLog.log(Log.VERBOSE, "outbound call: " + this.ref + " : " + object.getClass().getName() + this.ref.getObjID().toString() + ": " + object2);
    }

    public String getRefClass(ObjectOutput objectOutput) {
        return "UnicastRef";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void marshalValue(Class clazz, Object object, ObjectOutput objectOutput) throws IOException {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                objectOutput.writeInt((Integer)object);
                return;
            } else if (clazz == Boolean.TYPE) {
                objectOutput.writeBoolean((Boolean)object);
                return;
            } else if (clazz == Byte.TYPE) {
                objectOutput.writeByte(((Byte)object).byteValue());
                return;
            } else if (clazz == Character.TYPE) {
                objectOutput.writeChar(((Character)object).charValue());
                return;
            } else if (clazz == Short.TYPE) {
                objectOutput.writeShort(((Short)object).shortValue());
                return;
            } else if (clazz == Long.TYPE) {
                objectOutput.writeLong((Long)object);
                return;
            } else if (clazz == Float.TYPE) {
                objectOutput.writeFloat(((Float)object).floatValue());
                return;
            } else {
                if (clazz != Double.TYPE) throw new Error("Unrecognized primitive type: " + clazz);
                objectOutput.writeDouble((Double)object);
            }
            return;
        } else {
            objectOutput.writeObject(object);
        }
    }

    protected static Object unmarshalValue(Class clazz, ObjectInput objectInput) throws IOException, ClassNotFoundException {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return new Integer(objectInput.readInt());
            }
            if (clazz == Boolean.TYPE) {
                return new Boolean(objectInput.readBoolean());
            }
            if (clazz == Byte.TYPE) {
                return new Byte(objectInput.readByte());
            }
            if (clazz == Character.TYPE) {
                return new Character(objectInput.readChar());
            }
            if (clazz == Short.TYPE) {
                return new Short(objectInput.readShort());
            }
            if (clazz == Long.TYPE) {
                return new Long(objectInput.readLong());
            }
            if (clazz == Float.TYPE) {
                return new Float(objectInput.readFloat());
            }
            if (clazz == Double.TYPE) {
                return new Double(objectInput.readDouble());
            }
            throw new Error("Unrecognized primitive type: " + clazz);
        }
        return objectInput.readObject();
    }

    public RemoteCall newCall(RemoteObject remoteObject, Operation[] operationArray, int n2, long l2) throws RemoteException {
        clientRefLog.log(Log.BRIEF, "get connection");
        Connection connection = this.ref.getChannel().newConnection();
        try {
            clientRefLog.log(Log.VERBOSE, "create call context");
            if (clientCallLog.isLoggable(Log.VERBOSE)) {
                this.logClientCall(remoteObject, operationArray[n2]);
            }
            StreamRemoteCall streamRemoteCall = new StreamRemoteCall(connection, this.ref.getObjID(), n2, l2);
            try {
                this.marshalCustomCallData(streamRemoteCall.getOutputStream());
            }
            catch (IOException iOException) {
                throw new MarshalException("error marshaling custom call data");
            }
            return streamRemoteCall;
        }
        catch (RemoteException remoteException) {
            this.ref.getChannel().free(connection, false);
            throw remoteException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Remote remote, Method method, Object[] objectArray, long l2) throws Exception {
        Object object;
        boolean bl2;
        boolean bl3;
        Connection connection;
        block33: {
            Object object2;
            if (clientRefLog.isLoggable(Log.VERBOSE)) {
                clientRefLog.log(Log.VERBOSE, "method: " + method);
            }
            if (clientCallLog.isLoggable(Log.VERBOSE)) {
                this.logClientCall(remote, method);
            }
            connection = this.ref.getChannel().newConnection();
            StreamRemoteCall streamRemoteCall = null;
            bl3 = true;
            bl2 = false;
            try {
                block32: {
                    try {
                        Object object3;
                        if (clientRefLog.isLoggable(Log.VERBOSE)) {
                            clientRefLog.log(Log.VERBOSE, "opnum = " + l2);
                        }
                        streamRemoteCall = new StreamRemoteCall(connection, this.ref.getObjID(), -1, l2);
                        try {
                            object3 = streamRemoteCall.getOutputStream();
                            this.marshalCustomCallData((ObjectOutput)object3);
                            object2 = method.getParameterTypes();
                            for (int i2 = 0; i2 < ((Class[])object2).length; ++i2) {
                                UnicastRef.marshalValue(object2[i2], objectArray[i2], (ObjectOutput)object3);
                            }
                        }
                        catch (IOException iOException) {
                            clientRefLog.log(Log.BRIEF, "IOException marshalling arguments: ", iOException);
                            throw new MarshalException("error marshalling arguments", iOException);
                        }
                        streamRemoteCall.executeCall();
                        try {
                            object3 = method.getReturnType();
                            if (object3 == Void.TYPE) {
                                object2 = null;
                                Object var18_20 = null;
                                if (bl2) return object2;
                                break block32;
                            }
                            object2 = streamRemoteCall.getInputStream();
                            Object object4 = UnicastRef.unmarshalValue((Class)object3, (ObjectInput)object2);
                            bl2 = true;
                            clientRefLog.log(Log.BRIEF, "free connection (reuse = true)");
                            this.ref.getChannel().free(connection, true);
                            object = object4;
                            break block33;
                        }
                        catch (IOException iOException) {
                            clientRefLog.log(Log.BRIEF, "IOException unmarshalling return: ", iOException);
                            throw new UnmarshalException("error unmarshalling return", iOException);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            clientRefLog.log(Log.BRIEF, "ClassNotFoundException unmarshalling return: ", classNotFoundException);
                            throw new UnmarshalException("error unmarshalling return", classNotFoundException);
                        }
                        finally {
                            try {
                                streamRemoteCall.done();
                            }
                            catch (IOException iOException) {
                                bl3 = false;
                            }
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        if (streamRemoteCall != null) {
                            if (((StreamRemoteCall)streamRemoteCall).getServerException() == runtimeException) throw runtimeException;
                        }
                        bl3 = false;
                        throw runtimeException;
                    }
                    catch (RemoteException remoteException) {
                        bl3 = false;
                        throw remoteException;
                    }
                    catch (Error error) {
                        bl3 = false;
                        throw error;
                    }
                }
                if (clientRefLog.isLoggable(Log.BRIEF)) {
                    clientRefLog.log(Log.BRIEF, "free connection (reuse = " + bl3 + ")");
                }
            }
            catch (Throwable throwable) {
                Object var18_22 = null;
                if (bl2) throw throwable;
                if (clientRefLog.isLoggable(Log.BRIEF)) {
                    clientRefLog.log(Log.BRIEF, "free connection (reuse = " + bl3 + ")");
                }
                this.ref.getChannel().free(connection, bl3);
                throw throwable;
            }
            this.ref.getChannel().free(connection, bl3);
            return object2;
        }
        Object var18_21 = null;
        if (bl2) return object;
        if (clientRefLog.isLoggable(Log.BRIEF)) {
            clientRefLog.log(Log.BRIEF, "free connection (reuse = " + bl3 + ")");
        }
        this.ref.getChannel().free(connection, bl3);
        return object;
    }
}

