/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Vector;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.ParsingException;
import sun.security.pkcs.SignerInfo;
import sun.security.util.Debug;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;
import sun.security.x509.X509CRLImpl;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class PKCS7 {
    private ObjectIdentifier contentType;
    private BigInteger version = null;
    private AlgorithmId[] digestAlgorithmIds = null;
    private ContentInfo contentInfo = null;
    private X509Certificate[] certificates = null;
    private X509CRL[] crls = null;
    private SignerInfo[] signerInfos = null;
    private boolean oldStyle = false;
    private Principal[] certIssuerNames;

    private void populateCertIssuerNames() {
        if (this.certificates == null) {
            return;
        }
        this.certIssuerNames = new Principal[this.certificates.length];
        for (int i2 = 0; i2 < this.certificates.length; ++i2) {
            X509Certificate x509Certificate = this.certificates[i2];
            Principal principal = x509Certificate.getIssuerDN();
            if (!(principal instanceof X500Name)) {
                try {
                    X509CertInfo x509CertInfo = new X509CertInfo(x509Certificate.getTBSCertificate());
                    principal = (Principal)x509CertInfo.get("issuer.dname");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.certIssuerNames[i2] = principal;
        }
    }

    public boolean isOldStyle() {
        return this.oldStyle;
    }

    public PKCS7(byte[] byArray) throws ParsingException {
        try {
            DerInputStream derInputStream = new DerInputStream(byArray);
            this.parse(derInputStream);
        }
        catch (IOException iOException) {
            ParsingException parsingException = new ParsingException("Unable to parse the encoded bytes");
            parsingException.initCause(iOException);
            throw parsingException;
        }
    }

    public PKCS7(InputStream inputStream) throws ParsingException, IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[dataInputStream.available()];
        dataInputStream.readFully(byArray);
        this.parse(new DerInputStream(byArray));
    }

    public void encodeSignedData(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        this.encodeSignedData(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public String toString() {
        int n2;
        String string = "";
        string = string + this.contentInfo + "\n";
        if (this.version != null) {
            string = string + "PKCS7 :: version: " + Debug.toHexString(this.version) + "\n";
        }
        if (this.digestAlgorithmIds != null) {
            string = string + "PKCS7 :: digest AlgorithmIds: \n";
            for (n2 = 0; n2 < this.digestAlgorithmIds.length; ++n2) {
                string = string + "\t" + this.digestAlgorithmIds[n2] + "\n";
            }
        }
        if (this.certificates != null) {
            string = string + "PKCS7 :: certificates: \n";
            for (n2 = 0; n2 < this.certificates.length; ++n2) {
                string = string + "\t" + n2 + ".   " + this.certificates[n2] + "\n";
            }
        }
        if (this.crls != null) {
            string = string + "PKCS7 :: crls: \n";
            for (n2 = 0; n2 < this.crls.length; ++n2) {
                string = string + "\t" + n2 + ".   " + this.crls[n2] + "\n";
            }
        }
        if (this.signerInfos != null) {
            string = string + "PKCS7 :: signer infos: \n";
            for (n2 = 0; n2 < this.signerInfos.length; ++n2) {
                string = string + "\t" + n2 + ".  " + this.signerInfos[n2] + "\n";
            }
        }
        return string;
    }

    public BigInteger getVersion() {
        return this.version;
    }

    public X509CRL[] getCRLs() {
        if (this.crls != null) {
            return (X509CRL[])this.crls.clone();
        }
        return null;
    }

    public X509Certificate[] getCertificates() {
        if (this.certificates != null) {
            return (X509Certificate[])this.certificates.clone();
        }
        return null;
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public SignerInfo[] getSignerInfos() {
        return this.signerInfos;
    }

    public SignerInfo[] verify() throws NoSuchAlgorithmException, SignatureException {
        return this.verify(null);
    }

    public SignerInfo[] verify(byte[] byArray) throws NoSuchAlgorithmException, SignatureException {
        Vector vector = new Vector();
        for (int i2 = 0; i2 < this.signerInfos.length; ++i2) {
            SignerInfo signerInfo = this.verify(this.signerInfos[i2], byArray);
            if (signerInfo == null) continue;
            vector.addElement(signerInfo);
        }
        if (vector.size() != 0) {
            Object[] objectArray = new SignerInfo[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public PKCS7(DerInputStream derInputStream) throws ParsingException {
        this.parse(derInputStream);
    }

    private void parse(DerInputStream derInputStream) throws ParsingException {
        try {
            derInputStream.mark(derInputStream.available());
            this.parse(derInputStream, false);
        }
        catch (IOException iOException) {
            try {
                derInputStream.reset();
                this.parse(derInputStream, true);
                this.oldStyle = true;
            }
            catch (IOException iOException2) {
                ParsingException parsingException = new ParsingException(iOException2.getMessage());
                parsingException.initCause(iOException2);
                throw parsingException;
            }
        }
    }

    private void parse(DerInputStream derInputStream, boolean bl2) throws IOException {
        this.contentInfo = new ContentInfo(derInputStream, bl2);
        this.contentType = this.contentInfo.contentType;
        DerValue derValue = this.contentInfo.getContent();
        if (this.contentType.equals(ContentInfo.SIGNED_DATA_OID)) {
            this.parseSignedData(derValue);
        } else if (this.contentType.equals(ContentInfo.OLD_SIGNED_DATA_OID)) {
            this.parseOldSignedData(derValue);
        } else if (this.contentType.equals(ContentInfo.NETSCAPE_CERT_SEQUENCE_OID)) {
            this.parseNetscapeCertChain(derValue);
        } else {
            throw new ParsingException("content type " + this.contentType + " not supported.");
        }
    }

    public void encodeSignedData(DerOutputStream derOutputStream) throws IOException {
        DerEncoder[] derEncoderArray;
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.version);
        derOutputStream2.putOrderedSetOf((byte)49, this.digestAlgorithmIds);
        this.contentInfo.encode(derOutputStream2);
        if (this.certificates != null && this.certificates.length != 0) {
            derEncoderArray = new X509CertImpl[this.certificates.length];
            for (int i2 = 0; i2 < this.certificates.length; ++i2) {
                if (this.certificates[i2] instanceof X509CertImpl) {
                    derEncoderArray[i2] = (X509CertImpl)this.certificates[i2];
                    continue;
                }
                try {
                    byte[] byArray = this.certificates[i2].getEncoded();
                    derEncoderArray[i2] = new X509CertImpl(byArray);
                    continue;
                }
                catch (CertificateException certificateException) {
                    IOException iOException = new IOException(certificateException.getMessage());
                    iOException.initCause(certificateException);
                    throw iOException;
                }
            }
            derOutputStream2.putOrderedSetOf((byte)-96, derEncoderArray);
        }
        derOutputStream2.putOrderedSetOf((byte)49, this.signerInfos);
        derEncoderArray = new DerValue(48, derOutputStream2.toByteArray());
        ContentInfo contentInfo = new ContentInfo(ContentInfo.SIGNED_DATA_OID, (DerValue)derEncoderArray);
        contentInfo.encode(derOutputStream);
    }

    private void parseNetscapeCertChain(DerValue derValue) throws ParsingException, IOException {
        DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
        DerValue[] derValueArray = derInputStream.getSequence(2);
        this.certificates = new X509Certificate[derValueArray.length];
        CertificateFactory certificateFactory = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        for (int i2 = 0; i2 < derValueArray.length; ++i2) {
            ByteArrayInputStream byteArrayInputStream = null;
            try {
                if (certificateFactory == null) {
                    this.certificates[i2] = new X509CertImpl(derValueArray[i2]);
                    continue;
                }
                byte[] byArray = derValueArray[i2].toByteArray();
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                this.certificates[i2] = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                byteArrayInputStream.close();
                byteArrayInputStream = null;
                continue;
            }
            catch (CertificateException certificateException) {
                ParsingException parsingException = new ParsingException(certificateException.getMessage());
                parsingException.initCause(certificateException);
                throw parsingException;
            }
            catch (IOException iOException) {
                ParsingException parsingException = new ParsingException(iOException.getMessage());
                parsingException.initCause(iOException);
                throw parsingException;
            }
            finally {
                if (byteArrayInputStream != null) {
                    byteArrayInputStream.close();
                }
            }
        }
    }

    private void parseOldSignedData(DerValue derValue) throws ParsingException, IOException {
        Object object;
        DerValue[] derValueArray;
        DerInputStream derInputStream = derValue.toDerInputStream();
        this.version = derInputStream.getBigInteger();
        DerValue[] derValueArray2 = derInputStream.getSet(1);
        int n2 = derValueArray2.length;
        this.digestAlgorithmIds = new AlgorithmId[n2];
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                derValueArray = derValueArray2[i2];
                this.digestAlgorithmIds[i2] = AlgorithmId.parse((DerValue)derValueArray);
            }
        }
        catch (IOException iOException) {
            throw new ParsingException("Error parsing digest AlgorithmId IDs");
        }
        this.contentInfo = new ContentInfo(derInputStream, true);
        CertificateFactory certificateFactory = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        derValueArray = derInputStream.getSet(2);
        n2 = derValueArray.length;
        this.certificates = new X509Certificate[n2];
        for (int i3 = 0; i3 < n2; ++i3) {
            ByteArrayInputStream byteArrayInputStream = null;
            try {
                if (certificateFactory == null) {
                    this.certificates[i3] = new X509CertImpl(derValueArray[i3]);
                    continue;
                }
                object = derValueArray[i3].toByteArray();
                byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                this.certificates[i3] = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                byteArrayInputStream.close();
                byteArrayInputStream = null;
                continue;
            }
            catch (CertificateException certificateException) {
                ParsingException parsingException = new ParsingException(certificateException.getMessage());
                parsingException.initCause(certificateException);
                throw parsingException;
            }
            catch (IOException iOException) {
                ParsingException parsingException = new ParsingException(iOException.getMessage());
                parsingException.initCause(iOException);
                throw parsingException;
            }
            finally {
                if (byteArrayInputStream != null) {
                    byteArrayInputStream.close();
                }
            }
        }
        derInputStream.getSet(0);
        DerValue[] derValueArray3 = derInputStream.getSet(1);
        n2 = derValueArray3.length;
        this.signerInfos = new SignerInfo[n2];
        for (int i4 = 0; i4 < n2; ++i4) {
            object = derValueArray3[i4].toDerInputStream();
            this.signerInfos[i4] = new SignerInfo((DerInputStream)object, true);
        }
    }

    private void parseSignedData(DerValue derValue) throws ParsingException, IOException {
        byte[] byArray;
        Object object;
        int n2;
        DerValue[] derValueArray;
        DerInputStream derInputStream = derValue.toDerInputStream();
        this.version = derInputStream.getBigInteger();
        DerValue[] derValueArray2 = derInputStream.getSet(1);
        int n3 = derValueArray2.length;
        this.digestAlgorithmIds = new AlgorithmId[n3];
        try {
            for (int i2 = 0; i2 < n3; ++i2) {
                derValueArray = derValueArray2[i2];
                this.digestAlgorithmIds[i2] = AlgorithmId.parse((DerValue)derValueArray);
            }
        }
        catch (IOException iOException) {
            ParsingException parsingException = new ParsingException("Error parsing digest AlgorithmId IDs: " + iOException.getMessage());
            parsingException.initCause(iOException);
            throw parsingException;
        }
        this.contentInfo = new ContentInfo(derInputStream);
        CertificateFactory certificateFactory = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        if ((byte)derInputStream.peekByte() == -96) {
            derValueArray = derInputStream.getSet(2, true);
            n3 = derValueArray.length;
            this.certificates = new X509Certificate[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                object = null;
                try {
                    if (certificateFactory == null) {
                        this.certificates[n2] = new X509CertImpl(derValueArray[n2]);
                        continue;
                    }
                    byArray = derValueArray[n2].toByteArray();
                    object = new ByteArrayInputStream(byArray);
                    this.certificates[n2] = (X509Certificate)certificateFactory.generateCertificate((InputStream)object);
                    ((ByteArrayInputStream)object).close();
                    object = null;
                    continue;
                }
                catch (CertificateException certificateException) {
                    ParsingException parsingException = new ParsingException(certificateException.getMessage());
                    parsingException.initCause(certificateException);
                    throw parsingException;
                }
                catch (IOException iOException) {
                    ParsingException parsingException = new ParsingException(iOException.getMessage());
                    parsingException.initCause(iOException);
                    throw parsingException;
                }
                finally {
                    if (object != null) {
                        ((ByteArrayInputStream)object).close();
                    }
                }
            }
        }
        if ((byte)derInputStream.peekByte() == -95) {
            derValueArray = derInputStream.getSet(1, true);
            n3 = derValueArray.length;
            this.crls = new X509CRL[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                object = null;
                try {
                    if (certificateFactory == null) {
                        this.crls[n2] = new X509CRLImpl(derValueArray[n2]);
                        continue;
                    }
                    byArray = derValueArray[n2].toByteArray();
                    object = new ByteArrayInputStream(byArray);
                    this.crls[n2] = (X509CRL)certificateFactory.generateCRL((InputStream)object);
                    ((ByteArrayInputStream)object).close();
                    object = null;
                    continue;
                }
                catch (CRLException cRLException) {
                    ParsingException parsingException = new ParsingException(cRLException.getMessage());
                    parsingException.initCause(cRLException);
                    throw parsingException;
                }
                finally {
                    if (object != null) {
                        ((ByteArrayInputStream)object).close();
                    }
                }
            }
        }
        derValueArray = derInputStream.getSet(1);
        n3 = derValueArray.length;
        this.signerInfos = new SignerInfo[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            object = derValueArray[n2].toDerInputStream();
            this.signerInfos[n2] = new SignerInfo((DerInputStream)object);
        }
    }

    public AlgorithmId[] getDigestAlgorithmIds() {
        return this.digestAlgorithmIds;
    }

    public SignerInfo verify(SignerInfo signerInfo, byte[] byArray) throws NoSuchAlgorithmException, SignatureException {
        return signerInfo.verify(this, byArray);
    }

    public X509Certificate getCertificate(BigInteger bigInteger, X500Name x500Name) {
        if (this.certificates != null) {
            if (this.certIssuerNames == null) {
                this.populateCertIssuerNames();
            }
            for (int i2 = 0; i2 < this.certificates.length; ++i2) {
                X509Certificate x509Certificate = this.certificates[i2];
                BigInteger bigInteger2 = x509Certificate.getSerialNumber();
                if (!bigInteger.equals(bigInteger2) || !x500Name.equals(this.certIssuerNames[i2])) continue;
                return x509Certificate;
            }
        }
        return null;
    }

    public PKCS7(AlgorithmId[] algorithmIdArray, ContentInfo contentInfo, X509Certificate[] x509CertificateArray, SignerInfo[] signerInfoArray) {
        this.version = BigInteger.ONE;
        this.digestAlgorithmIds = algorithmIdArray;
        this.contentInfo = contentInfo;
        this.certificates = x509CertificateArray;
        this.signerInfos = signerInfoArray;
    }
}

