/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.util.Enumeration;
import sun.security.util.BitArray;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;

public class ReasonFlags {
    public static final String UNUSED = "unused";
    public static final String KEY_COMPROMISE = "key_compromise";
    public static final String CA_COMPROMISE = "ca_compromise";
    public static final String AFFILIATION_CHANGED = "affiliation_changed";
    public static final String SUPERSEDED = "superseded";
    public static final String CESSATION_OF_OPERATION = "cessation_of_operation";
    public static final String CERTIFICATE_HOLD = "certificate_hold";
    public static final String PRIVILEGE_WITHDRAWN = "privilege_withdrawn";
    public static final String AA_COMPROMISE = "aa_compromise";
    private static final String[] NAMES = new String[]{"unused", "key_compromise", "ca_compromise", "affiliation_changed", "superseded", "cessation_of_operation", "certificate_hold", "privilege_withdrawn", "aa_compromise"};
    private boolean[] bitString;

    private boolean isSet(int n2) {
        return this.bitString[n2];
    }

    private void set(int n2, boolean bl2) {
        if (n2 >= this.bitString.length) {
            boolean[] blArray = new boolean[n2 + 1];
            System.arraycopy(this.bitString, 0, blArray, 0, this.bitString.length);
            this.bitString = blArray;
        }
        this.bitString[n2] = bl2;
    }

    public ReasonFlags(byte[] byArray) {
        this.bitString = new BitArray(byArray.length * 8, byArray).toBooleanArray();
    }

    public ReasonFlags(boolean[] blArray) {
        this.bitString = blArray;
    }

    public String toString() {
        String string = "Reason Flags [\n";
        try {
            if (this.isSet(0)) {
                string = string + "  Unused\n";
            }
            if (this.isSet(1)) {
                string = string + "  Key Compromise\n";
            }
            if (this.isSet(2)) {
                string = string + "  CA Compromise\n";
            }
            if (this.isSet(3)) {
                string = string + "  Affiliation_Changed\n";
            }
            if (this.isSet(4)) {
                string = string + "  Superseded\n";
            }
            if (this.isSet(5)) {
                string = string + "  Cessation Of Operation\n";
            }
            if (this.isSet(6)) {
                string = string + "  Certificate Hold\n";
            }
            if (this.isSet(7)) {
                string = string + "  Privilege Withdrawn\n";
            }
            if (this.isSet(8)) {
                string = string + "  AA Compromise\n";
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        string = string + "]\n";
        return string;
    }

    private static int name2Index(String string) throws IOException {
        for (int i2 = 0; i2 < NAMES.length; ++i2) {
            if (!NAMES[i2].equalsIgnoreCase(string)) continue;
            return i2;
        }
        throw new IOException("Name not recognized by ReasonFlags");
    }

    public void delete(String string) throws IOException {
        this.set(string, Boolean.FALSE);
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        for (int i2 = 0; i2 < NAMES.length; ++i2) {
            attributeNameEnumeration.addElement(NAMES[i2]);
        }
        return attributeNameEnumeration.elements();
    }

    public ReasonFlags(BitArray bitArray) {
        this.bitString = bitArray.toBooleanArray();
    }

    public ReasonFlags(DerInputStream derInputStream) throws IOException {
        DerValue derValue = derInputStream.getDerValue();
        this.bitString = derValue.getUnalignedBitString(true).toBooleanArray();
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.putUnalignedBitString(new BitArray(this.bitString));
    }

    public ReasonFlags(DerValue derValue) throws IOException {
        this.bitString = derValue.getUnalignedBitString(true).toBooleanArray();
    }

    public Object get(String string) throws IOException {
        return this.isSet(ReasonFlags.name2Index(string));
    }

    public void set(String string, Object object) throws IOException {
        if (!(object instanceof Boolean)) {
            throw new IOException("Attribute must be of type Boolean.");
        }
        boolean bl2 = (Boolean)object;
        this.set(ReasonFlags.name2Index(string), bl2);
    }
}

