/*
 * Decompiled with CFR 0.152.
 */
package sun.util.calendar;

public class CalendarDate {
    public static final int UNKNOWN = Integer.MIN_VALUE;
    private int year;
    private int month;
    private int mday;
    private int dow = Integer.MIN_VALUE;
    private int millis;

    public int getDate() {
        return this.mday;
    }

    public int getDayOfWeek() {
        return this.dow;
    }

    public int getMonth() {
        return this.month;
    }

    public int getTimeOfDay() {
        return this.millis;
    }

    public int getYear() {
        return this.year;
    }

    public int hashCode() {
        return this.year << 20 | this.month << 16 | this.mday << 11 | this.millis >> 10 & 0x3FF;
    }

    public CalendarDate() {
    }

    public void setDate(int n2) {
        this.mday = n2;
    }

    public void setDayOfWeek(int n2) {
        this.dow = n2;
    }

    public void setMonth(int n2) {
        this.month = n2;
    }

    public void setTimeOfDay(int n2) {
        this.millis = n2;
    }

    public void setYear(int n2) {
        this.year = n2;
    }

    public CalendarDate(int n2, int n3, int n4) {
        this.year = n2;
        this.month = n3;
        this.mday = n4;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof CalendarDate)) {
            return false;
        }
        CalendarDate calendarDate = (CalendarDate)object;
        return this.year == calendarDate.year && this.month == calendarDate.month && this.mday == calendarDate.mday && this.millis == calendarDate.millis;
    }

    public String toString() {
        String string;
        String string2;
        int n2 = this.millis / 3600000;
        int n3 = this.millis % 3600000;
        int n4 = n3 / 60000;
        if ((n3 %= 60000) == 0) {
            string2 = "";
            string = "";
        } else {
            string2 = ":" + CalendarDate.sprintf02d(n3 / 1000);
            if ((n3 %= 1000) == 0) {
                string = "";
            } else {
                string = ".";
                if (n3 < 100) {
                    string = string + "0";
                }
                string = string + CalendarDate.sprintf02d(n3);
            }
        }
        return this.year + "/" + CalendarDate.sprintf02d(this.month + 1) + "/" + CalendarDate.sprintf02d(this.mday) + " " + CalendarDate.sprintf02d(n2) + ":" + CalendarDate.sprintf02d(n4) + string2 + string;
    }

    private static final String sprintf02d(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(Integer.toString(n2));
        return stringBuffer.toString();
    }
}

